/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.disruption;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.coordination.DeterministicTaskQueue;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Nullable;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.transport.BoundTransportAddress;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.telemetry.tracing.Tracer;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.transport.MockTransport;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.CloseableConnection;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.ConnectionProfile;
import org.opensearch.transport.RequestHandlerRegistry;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportService;

public abstract class DisruptableMockTransport
extends MockTransport {
    private final DiscoveryNode localNode;
    private final Logger logger;
    private final DeterministicTaskQueue deterministicTaskQueue;

    public DisruptableMockTransport(DiscoveryNode localNode, Logger logger, DeterministicTaskQueue deterministicTaskQueue) {
        this.localNode = localNode;
        this.logger = logger;
        this.deterministicTaskQueue = deterministicTaskQueue;
    }

    protected abstract ConnectionStatus getConnectionStatus(DiscoveryNode var1);

    protected abstract Optional<DisruptableMockTransport> getDisruptableMockTransport(TransportAddress var1);

    protected abstract void execute(Runnable var1);

    public DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    @Override
    public TransportService createTransportService(Settings settings, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders, Tracer tracer) {
        return new TransportService(settings, (Transport)this, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders, tracer);
    }

    @Override
    public void openConnection(final DiscoveryNode node, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        Optional<DisruptableMockTransport> optionalMatchingTransport = this.getDisruptableMockTransport(node.getAddress());
        if (optionalMatchingTransport.isPresent()) {
            final DisruptableMockTransport matchingTransport = optionalMatchingTransport.get();
            ConnectionStatus connectionStatus = this.getConnectionStatus(matchingTransport.getLocalNode());
            if (connectionStatus != ConnectionStatus.CONNECTED) {
                listener.onFailure((Exception)new ConnectTransportException(node, "node [" + String.valueOf(node) + "] is [" + String.valueOf((Object)connectionStatus) + "] not [CONNECTED]"));
            } else {
                listener.onResponse((Object)new CloseableConnection(this){
                    final /* synthetic */ DisruptableMockTransport this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public DiscoveryNode getNode() {
                        return node;
                    }

                    public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws TransportException {
                        this.this$0.onSendRequest(requestId, action, request, matchingTransport);
                    }
                });
            }
        } else {
            listener.onFailure((Exception)new ConnectTransportException(node, "node " + String.valueOf(node) + " does not exist"));
        }
    }

    protected void onSendRequest(final long requestId, final String action, final TransportRequest request, final DisruptableMockTransport destinationTransport) {
        assert (!destinationTransport.getLocalNode().equals((Object)this.getLocalNode())) : "non-local message from " + String.valueOf(this.getLocalNode()) + " to itself";
        destinationTransport.execute(new Runnable(){
            final /* synthetic */ DisruptableMockTransport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                ConnectionStatus connectionStatus = this.this$0.getConnectionStatus(destinationTransport.getLocalNode());
                switch (connectionStatus.ordinal()) {
                    case 2: 
                    case 3: {
                        this.this$0.onBlackholedDuringSend(requestId, action, destinationTransport);
                        break;
                    }
                    case 1: {
                        this.this$0.onDisconnectedDuringSend(requestId, action, destinationTransport);
                        break;
                    }
                    case 0: {
                        this.this$0.onConnectedDuringSend(requestId, action, request, destinationTransport);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unexpected status: " + String.valueOf((Object)connectionStatus)));
                    }
                }
            }

            public String toString() {
                return this.this$0.getRequestDescription(requestId, action, destinationTransport.getLocalNode());
            }
        });
    }

    protected Runnable getDisconnectException(final long requestId, final String action, final DiscoveryNode destination) {
        return new Runnable(){
            final /* synthetic */ DisruptableMockTransport this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                this.this$0.handleError(requestId, (TransportException)new ConnectTransportException(destination, "disconnected"));
            }

            public String toString() {
                return "disconnection response to " + this.this$0.getRequestDescription(requestId, action, destination);
            }
        };
    }

    protected String getRequestDescription(long requestId, String action, DiscoveryNode destination) {
        return new ParameterizedMessage("[{}][{}] from {} to {}", new Object[]{requestId, action, this.getLocalNode(), destination}).getFormattedMessage();
    }

    protected void onBlackholedDuringSend(long requestId, String action, DisruptableMockTransport destinationTransport) {
        this.logger.trace("dropping {}", (Object)this.getRequestDescription(requestId, action, destinationTransport.getLocalNode()));
        this.deterministicTaskQueue.scheduleAt(this.deterministicTaskQueue.getCurrentTimeMillis() + TimeUnit.DAYS.toMillis(1L), () -> this.onDisconnectedDuringSend(requestId, action, destinationTransport));
    }

    protected void onDisconnectedDuringSend(long requestId, String action, DisruptableMockTransport destinationTransport) {
        destinationTransport.execute(this.getDisconnectException(requestId, action, destinationTransport.getLocalNode()));
    }

    protected void onConnectedDuringSend(final long requestId, final String action, TransportRequest request, final DisruptableMockTransport destinationTransport) {
        TransportRequest copiedRequest;
        RequestHandlerRegistry requestHandler = destinationTransport.getRequestHandlers().getHandler(action);
        DiscoveryNode destination = destinationTransport.getLocalNode();
        final String requestDescription = this.getRequestDescription(requestId, action, destination);
        TransportChannel transportChannel = new TransportChannel(){
            final /* synthetic */ DisruptableMockTransport this$0;
            {
                this.this$0 = this$0;
            }

            public String getProfileName() {
                return "default";
            }

            public String getChannelType() {
                return "disruptable-mock-transport-channel";
            }

            public void sendResponse(final TransportResponse response) {
                this.this$0.execute(new Runnable(){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        ConnectionStatus connectionStatus = destinationTransport.getConnectionStatus(this.this$1.this$0.getLocalNode());
                        switch (connectionStatus.ordinal()) {
                            case 0: 
                            case 3: {
                                this.this$1.this$0.handleResponse(requestId, response);
                                break;
                            }
                            case 1: 
                            case 2: {
                                TransportChannel.logger.trace("delaying response to {}: channel is {}", (Object)requestDescription, (Object)connectionStatus);
                                this.this$1.this$0.onBlackholedDuringSend(requestId, action, destinationTransport);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("unexpected status: " + String.valueOf((Object)connectionStatus)));
                            }
                        }
                    }

                    public String toString() {
                        return "response to " + requestDescription;
                    }
                });
            }

            public void sendResponse(final Exception exception) {
                this.this$0.execute(new Runnable(){
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        ConnectionStatus connectionStatus = destinationTransport.getConnectionStatus(this.this$1.this$0.getLocalNode());
                        switch (connectionStatus.ordinal()) {
                            case 0: 
                            case 3: {
                                this.this$1.this$0.handleRemoteError(requestId, exception);
                                break;
                            }
                            case 1: 
                            case 2: {
                                TransportChannel.logger.trace("delaying exception response to {}: channel is {}", (Object)requestDescription, (Object)connectionStatus);
                                this.this$1.this$0.onBlackholedDuringSend(requestId, action, destinationTransport);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("unexpected status: " + String.valueOf((Object)connectionStatus)));
                            }
                        }
                    }

                    public String toString() {
                        return "error response to " + requestDescription;
                    }
                });
            }
        };
        try {
            copiedRequest = OpenSearchTestCase.copyWriteable(request, this.writeableRegistry(), arg_0 -> ((RequestHandlerRegistry)requestHandler).newRequest(arg_0));
        }
        catch (IOException e) {
            throw new AssertionError("exception de/serializing request", e);
        }
        try {
            requestHandler.processMessageReceived(copiedRequest, transportChannel);
        }
        catch (Exception e) {
            try {
                transportChannel.sendResponse(e);
            }
            catch (Exception ee) {
                this.logger.warn("failed to send failure", (Throwable)e);
            }
        }
    }

    public static enum ConnectionStatus {
        CONNECTED,
        DISCONNECTED,
        BLACK_HOLE,
        BLACK_HOLE_REQUESTS_ONLY;

    }
}

