/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.common.Nullable;
import org.opensearch.common.collect.Tuple;

public class VersionUtils {
    @Deprecated
    public static Version V_1_0_0 = Version.fromId((int)135217827);
    private static final List<Version> RELEASED_VERSIONS;
    private static final List<Version> UNRELEASED_VERSIONS;
    private static final List<Version> ALL_VERSIONS;
    private static final List<Version> ALL_OPENSEARCH_VERSIONS;
    private static final List<Version> ALL_LEGACY_VERSIONS;

    static Tuple<List<Version>, List<Version>> resolveReleasedVersions(Version current, Class<?> versionClass) {
        Version lastMinor;
        List<Version> lastMinorLine;
        List<List<Version>> stableVersions;
        Map<Integer, List<Version>> majorVersions = Version.getDeclaredVersions(versionClass).stream().collect(Collectors.groupingBy(v -> v.major));
        ArrayList<List<Version>> oldVersions = new ArrayList<List<Version>>(0);
        ArrayList<List<Version>> previousMajor = new ArrayList<List<Version>>(0);
        if (current.major == 2) {
            oldVersions.addAll(VersionUtils.splitByMinor(majorVersions.getOrDefault(6, Collections.emptyList())));
            previousMajor.addAll(VersionUtils.splitByMinor(majorVersions.getOrDefault(7, Collections.emptyList())));
        }
        int previousMajorID = current.major == 1 ? 7 : current.major - 1;
        oldVersions.addAll(VersionUtils.splitByMinor(majorVersions.getOrDefault(previousMajorID - 1, Collections.emptyList())));
        previousMajor.addAll(VersionUtils.splitByMinor(majorVersions.getOrDefault(previousMajorID, Collections.emptyList())));
        List<List<Version>> currentMajor = VersionUtils.splitByMinor(majorVersions.get(current.major));
        ArrayList<Version> unreleasedVersions = new ArrayList<Version>();
        if (currentMajor.size() == 1) {
            stableVersions = previousMajor;
            VersionUtils.moveLastToUnreleased(currentMajor, unreleasedVersions);
        } else if (current.major != 1) {
            stableVersions = currentMajor;
            Version prevMajorLastMinor = VersionUtils.moveLastToUnreleased(previousMajor, unreleasedVersions);
            if (prevMajorLastMinor.revision == 0 && !previousMajor.isEmpty()) {
                VersionUtils.moveLastToUnreleased(previousMajor, unreleasedVersions);
            }
        } else {
            stableVersions = currentMajor;
        }
        if (!(current.equals((Object)V_1_0_0) || (lastMinorLine = stableVersions.get(stableVersions.size() - 1)).get(lastMinorLine.size() - 1) instanceof LegacyESVersion || (lastMinor = VersionUtils.moveLastToUnreleased(stableVersions, unreleasedVersions)) instanceof LegacyESVersion || lastMinor.revision != 0)) {
            if (stableVersions.get(stableVersions.size() - 1).size() == 1) {
                VersionUtils.moveLastToUnreleased(stableVersions, unreleasedVersions);
            }
            if (!stableVersions.isEmpty()) {
                VersionUtils.moveLastToUnreleased(stableVersions, unreleasedVersions);
            }
        }
        if (previousMajor.isEmpty()) {
            assert (currentMajor.isEmpty()) : currentMajor;
            VersionUtils.moveLastToUnreleased(oldVersions, unreleasedVersions);
            VersionUtils.moveLastToUnreleased(oldVersions, unreleasedVersions);
        }
        List releasedVersions = Stream.of(oldVersions, previousMajor, currentMajor).flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toList());
        Collections.sort(unreleasedVersions);
        return new Tuple(Collections.unmodifiableList(releasedVersions), Collections.unmodifiableList(unreleasedVersions));
    }

    private static List<List<Version>> splitByMinor(List<Version> versions) {
        Map<Integer, List<Version>> byMinor = versions.stream().collect(Collectors.groupingBy(v -> v.minor));
        return byMinor.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private static Version moveLastToUnreleased(List<List<Version>> versions, List<Version> unreleasedVersions) {
        ArrayList lastMinor = new ArrayList(versions.get(versions.size() - 1));
        Version lastVersion = (Version)lastMinor.remove(lastMinor.size() - 1);
        if (lastMinor.isEmpty()) {
            versions.remove(versions.size() - 1);
        } else {
            versions.set(versions.size() - 1, lastMinor);
        }
        unreleasedVersions.add(lastVersion);
        return lastVersion;
    }

    public static List<Version> allReleasedVersions() {
        return RELEASED_VERSIONS;
    }

    public static List<Version> allUnreleasedVersions() {
        return UNRELEASED_VERSIONS;
    }

    public static List<Version> allVersions() {
        return ALL_VERSIONS;
    }

    public static List<Version> allOpenSearchVersions() {
        return ALL_OPENSEARCH_VERSIONS;
    }

    public static List<Version> allLegacyVersions() {
        return ALL_LEGACY_VERSIONS;
    }

    public static Version getPreviousVersion(Version version) {
        for (int i = ALL_VERSIONS.size() - 1; i >= 0; --i) {
            Version v = ALL_VERSIONS.get(i);
            if (!v.before(version)) continue;
            return v;
        }
        throw new IllegalArgumentException("couldn't find any released versions before [" + String.valueOf(version) + "]");
    }

    public static Version getPreviousVersion() {
        Version version = VersionUtils.getPreviousVersion(Version.CURRENT);
        assert (version.before(Version.CURRENT));
        return version;
    }

    public static Version getPreviousMinorVersion() {
        for (int i = RELEASED_VERSIONS.size() - 1; i >= 0; --i) {
            Version v = RELEASED_VERSIONS.get(i);
            if (v.minor >= Version.CURRENT.minor && v.major >= Version.CURRENT.major) continue;
            return v;
        }
        throw new IllegalArgumentException("couldn't find any released versions of the minor before [" + String.valueOf(Version.CURRENT) + "]");
    }

    public static Version getFirstVersion() {
        return RELEASED_VERSIONS.get(0);
    }

    public static Version getFirstVersionOfMajor(List<Version> versions, int major) {
        Map<Integer, List<Version>> majorVersions = versions.stream().collect(Collectors.groupingBy(v -> v.major));
        return majorVersions.get(major).get(0);
    }

    public static Version randomVersion(Random random) {
        return ALL_VERSIONS.get(random.nextInt(ALL_VERSIONS.size()));
    }

    public static Version randomOpenSearchVersion(Random random) {
        return ALL_OPENSEARCH_VERSIONS.get(random.nextInt(ALL_OPENSEARCH_VERSIONS.size()));
    }

    public static LegacyESVersion randomLegacyVersion(Random random) {
        return (LegacyESVersion)ALL_LEGACY_VERSIONS.get(random.nextInt(ALL_LEGACY_VERSIONS.size()));
    }

    public static Version lastFirstReleasedMinorFromMajor(List<Version> allVersions, int major) {
        Map<Integer, List<Version>> majorVersions = allVersions.stream().collect(Collectors.groupingBy(v -> v.major));
        Map<Integer, List<Version>> groupedByMinor = majorVersions.get(major).stream().collect(Collectors.groupingBy(v -> v.minor));
        List candidates = (List)Collections.max(groupedByMinor.entrySet(), Comparator.comparing(Map.Entry::getKey)).getValue();
        return (Version)candidates.get(0);
    }

    public static Version randomCompatibleVersion(Random random, Version version) {
        List compatible = ALL_VERSIONS.stream().filter(arg_0 -> ((Version)version).isCompatible(arg_0)).collect(Collectors.toList());
        return (Version)compatible.get(random.nextInt(compatible.size()));
    }

    public static Version randomVersionBetween(Random random, @Nullable Version minVersion, @Nullable Version maxVersion) {
        int minVersionIndex = 0;
        if (minVersion != null) {
            minVersionIndex = ALL_VERSIONS.indexOf(minVersion);
        }
        int maxVersionIndex = ALL_VERSIONS.size() - 1;
        if (maxVersion != null) {
            maxVersionIndex = ALL_VERSIONS.indexOf(maxVersion);
        }
        if (minVersionIndex == -1) {
            throw new IllegalArgumentException("minVersion [" + String.valueOf(minVersion) + "] does not exist.");
        }
        if (maxVersionIndex == -1) {
            throw new IllegalArgumentException("maxVersion [" + String.valueOf(maxVersion) + "] does not exist.");
        }
        if (minVersionIndex > maxVersionIndex) {
            throw new IllegalArgumentException("maxVersion [" + String.valueOf(maxVersion) + "] cannot be less than minVersion [" + String.valueOf(minVersion) + "]");
        }
        int range = maxVersionIndex + 1 - minVersionIndex;
        return ALL_VERSIONS.get(minVersionIndex + random.nextInt(range));
    }

    public static Version incompatibleFutureVersion(Version version) {
        Optional<Version> opt = ALL_VERSIONS.stream().filter(arg_0 -> ((Version)version).before(arg_0)).filter(v -> !v.isCompatible(version)).findAny();
        assert (opt.isPresent()) : "no future incompatible version for " + String.valueOf(version);
        return opt.get();
    }

    public static Version compatibleFutureVersion(Version version) {
        Optional<Version> opt = ALL_VERSIONS.stream().filter(arg_0 -> ((Version)version).before(arg_0)).filter(v -> v.isCompatible(version)).findAny();
        assert (opt.isPresent()) : "no future compatible version for " + String.valueOf(version);
        return opt.get();
    }

    public static Version maxCompatibleVersion(Version version) {
        List compatible = ALL_VERSIONS.stream().filter(arg_0 -> ((Version)version).isCompatible(arg_0)).filter(arg_0 -> ((Version)version).onOrBefore(arg_0)).collect(Collectors.toList());
        assert (compatible.size() > 0);
        return (Version)compatible.get(compatible.size() - 1);
    }

    public static Version randomIndexCompatibleVersion(Random random) {
        return VersionUtils.randomVersionBetween(random, Version.CURRENT.minimumIndexCompatibilityVersion(), Version.CURRENT);
    }

    public static Version randomPreviousCompatibleVersion(Random random, Version version) {
        return VersionUtils.randomVersionBetween(random, version.minimumIndexCompatibilityVersion(), VersionUtils.getPreviousVersion(version));
    }

    public static Version getVersion(byte major, byte minor, byte revision) {
        StringBuilder sb = new StringBuilder();
        sb.append(major).append('.').append(minor).append('.').append(revision);
        return Version.fromString((String)sb.toString());
    }

    static {
        Tuple<List<Version>, List<Version>> versions = VersionUtils.resolveReleasedVersions(Version.CURRENT, LegacyESVersion.class);
        RELEASED_VERSIONS = (List)versions.v1();
        UNRELEASED_VERSIONS = (List)versions.v2();
        ArrayList<Version> allVersions = new ArrayList<Version>(RELEASED_VERSIONS.size() + UNRELEASED_VERSIONS.size());
        allVersions.addAll(RELEASED_VERSIONS);
        allVersions.addAll(UNRELEASED_VERSIONS);
        Collections.sort(allVersions);
        ALL_VERSIONS = Collections.unmodifiableList(allVersions);
        ALL_OPENSEARCH_VERSIONS = ALL_VERSIONS.stream().filter(v -> v.major < 6).collect(Collectors.toList());
        ALL_LEGACY_VERSIONS = ALL_VERSIONS.stream().filter(v -> v.major >= 6).collect(Collectors.toList());
    }
}

