/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.common.settings.Settings;
import org.opensearch.node.NodeRoleSettings;

public class NodeRoles {
    public static Settings onlyRole(DiscoveryNodeRole role) {
        return NodeRoles.onlyRole(Settings.EMPTY, role);
    }

    public static Settings onlyRole(Settings settings, DiscoveryNodeRole role) {
        return NodeRoles.onlyRoles(settings, Collections.singleton(role));
    }

    public static Settings onlyRoles(Set<DiscoveryNodeRole> roles) {
        return NodeRoles.onlyRoles(Settings.EMPTY, roles);
    }

    public static Settings onlyRoles(Settings settings, Set<DiscoveryNodeRole> roles) {
        return Settings.builder().put(settings).putList(NodeRoleSettings.NODE_ROLES_SETTING.getKey(), Collections.unmodifiableList(roles.stream().map(DiscoveryNodeRole::roleName).collect(Collectors.toList()))).build();
    }

    public static Settings removeRoles(Set<DiscoveryNodeRole> roles) {
        return NodeRoles.removeRoles(Settings.EMPTY, roles);
    }

    public static Settings removeRoles(Settings settings, Set<DiscoveryNodeRole> roles) {
        Settings.Builder builder = Settings.builder().put(settings);
        builder.putList(NodeRoleSettings.NODE_ROLES_SETTING.getKey(), Collections.unmodifiableList(((List)NodeRoleSettings.NODE_ROLES_SETTING.get(settings)).stream().filter(r -> !roles.contains(r)).filter(roles.contains(DiscoveryNodeRole.CLUSTER_MANAGER_ROLE) || roles.contains(DiscoveryNodeRole.MASTER_ROLE) ? r -> !r.isClusterManager() : r -> true).map(DiscoveryNodeRole::roleName).collect(Collectors.toList())));
        return builder.build();
    }

    public static Settings addRoles(Set<DiscoveryNodeRole> roles) {
        return NodeRoles.addRoles(Settings.EMPTY, roles);
    }

    public static Settings addRoles(Settings settings, Set<DiscoveryNodeRole> roles) {
        Settings.Builder builder = Settings.builder().put(settings);
        builder.putList(NodeRoleSettings.NODE_ROLES_SETTING.getKey(), Collections.unmodifiableList(Stream.concat(((List)NodeRoleSettings.NODE_ROLES_SETTING.get(settings)).stream(), roles.stream()).map(DiscoveryNodeRole::roleName).distinct().collect(Collectors.toList())));
        return builder.build();
    }

    public static Settings noRoles() {
        return NodeRoles.noRoles(Settings.EMPTY);
    }

    public static Settings noRoles(Settings settings) {
        return Settings.builder().put(settings).putList(NodeRoleSettings.NODE_ROLES_SETTING.getKey(), Collections.emptyList()).build();
    }

    public static Settings dataNode() {
        return NodeRoles.dataNode(Settings.EMPTY);
    }

    public static Settings dataNode(Settings settings) {
        return NodeRoles.addRoles(settings, Collections.singleton(DiscoveryNodeRole.DATA_ROLE));
    }

    public static Settings dataOnlyNode() {
        return NodeRoles.dataOnlyNode(Settings.EMPTY);
    }

    public static Settings dataOnlyNode(Settings settings) {
        return NodeRoles.onlyRole(settings, DiscoveryNodeRole.DATA_ROLE);
    }

    public static Settings nonDataNode() {
        return NodeRoles.nonDataNode(Settings.EMPTY);
    }

    public static Settings nonDataNode(Settings settings) {
        return NodeRoles.removeRoles(settings, Collections.singleton(DiscoveryNodeRole.DATA_ROLE));
    }

    public static Settings ingestNode() {
        return NodeRoles.ingestNode(Settings.EMPTY);
    }

    public static Settings ingestNode(Settings settings) {
        return NodeRoles.addRoles(settings, Collections.singleton(DiscoveryNodeRole.INGEST_ROLE));
    }

    public static Settings ingestOnlyNode() {
        return NodeRoles.ingestOnlyNode(Settings.EMPTY);
    }

    public static Settings ingestOnlyNode(Settings settings) {
        return NodeRoles.onlyRole(settings, DiscoveryNodeRole.INGEST_ROLE);
    }

    public static Settings nonIngestNode() {
        return NodeRoles.nonIngestNode(Settings.EMPTY);
    }

    public static Settings nonIngestNode(Settings settings) {
        return NodeRoles.removeRoles(settings, Collections.singleton(DiscoveryNodeRole.INGEST_ROLE));
    }

    public static Settings clusterManagerNode() {
        return NodeRoles.clusterManagerNode(Settings.EMPTY);
    }

    public static Settings clusterManagerNode(Settings settings) {
        return NodeRoles.addRoles(settings, Collections.singleton(DiscoveryNodeRole.CLUSTER_MANAGER_ROLE));
    }

    public static Settings clusterManagerOnlyNode() {
        return NodeRoles.clusterManagerOnlyNode(Settings.EMPTY);
    }

    public static Settings clusterManagerOnlyNode(Settings settings) {
        return NodeRoles.onlyRole(settings, DiscoveryNodeRole.CLUSTER_MANAGER_ROLE);
    }

    public static Settings nonClusterManagerNode() {
        return NodeRoles.nonClusterManagerNode(Settings.EMPTY);
    }

    public static Settings nonClusterManagerNode(Settings settings) {
        return NodeRoles.removeRoles(settings, Collections.singleton(DiscoveryNodeRole.CLUSTER_MANAGER_ROLE));
    }

    public static Settings remoteClusterClientNode() {
        return NodeRoles.remoteClusterClientNode(Settings.EMPTY);
    }

    public static Settings remoteClusterClientNode(Settings settings) {
        return NodeRoles.addRoles(settings, Collections.singleton(DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE));
    }

    public static Settings nonRemoteClusterClientNode() {
        return NodeRoles.nonRemoteClusterClientNode(Settings.EMPTY);
    }

    public static Settings nonRemoteClusterClientNode(Settings settings) {
        return NodeRoles.removeRoles(settings, Collections.singleton(DiscoveryNodeRole.REMOTE_CLUSTER_CLIENT_ROLE));
    }

    public static Settings warmNode() {
        return NodeRoles.warmNode(Settings.EMPTY);
    }

    public static Settings warmNode(Settings settings) {
        return NodeRoles.addRoles(settings, Collections.singleton(DiscoveryNodeRole.WARM_ROLE));
    }

    public static Settings nonWarmNode() {
        return NodeRoles.nonWarmNode(Settings.EMPTY);
    }

    public static Settings nonWarmNode(Settings settings) {
        return NodeRoles.removeRoles(settings, Collections.singleton(DiscoveryNodeRole.WARM_ROLE));
    }

    public static Settings searchOnlyNode() {
        return NodeRoles.searchOnlyNode(Settings.EMPTY);
    }

    public static Settings searchOnlyNode(Settings settings) {
        return NodeRoles.onlyRole(settings, DiscoveryNodeRole.SEARCH_ROLE);
    }

    public static Settings nonSearchNode() {
        return NodeRoles.nonSearchNode(Settings.EMPTY);
    }

    public static Settings nonSearchNode(Settings settings) {
        return NodeRoles.removeRoles(settings, Collections.singleton(DiscoveryNodeRole.SEARCH_ROLE));
    }
}

