/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.AssertingDirectoryReader;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.search.AssertingIndexSearcher;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mockito;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.TriConsumer;
import org.opensearch.common.TriFunction;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.MockBigArrays;
import org.opensearch.common.util.MockPageCacheRecycler;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AnalyzerScope;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.cache.bitset.BitsetFilterCache;
import org.opensearch.index.cache.query.DisabledQueryCache;
import org.opensearch.index.codec.composite.CompositeIndexFieldInfo;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.Metric;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.mapper.BinaryFieldMapper;
import org.opensearch.index.mapper.CompositeDataCubeFieldType;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.GeoPointFieldMapper;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.mapper.RangeFieldMapper;
import org.opensearch.index.mapper.RangeType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.SearchOperationListener;
import org.opensearch.indices.IndicesModule;
import org.opensearch.indices.mapper.MapperRegistry;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.script.ScriptService;
import org.opensearch.search.SearchModule;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.BucketCollectorProcessor;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.opensearch.search.aggregations.SearchContextAggregations;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregator;
import org.opensearch.search.aggregations.metrics.MetricsAggregator;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.fetch.subphase.FetchDocValuesPhase;
import org.opensearch.search.fetch.subphase.FetchSourcePhase;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.search.startree.StarTreeQueryContext;
import org.opensearch.test.InternalAggregationTestCase;
import org.opensearch.test.OpenSearchTestCase;

public abstract class AggregatorTestCase
extends OpenSearchTestCase {
    private static final String NESTEDFIELD_PREFIX = "nested_";
    private List<Releasable> releasables = new ArrayList<Releasable>();
    private static final String TYPE_NAME = "type";
    protected ValuesSourceRegistry valuesSourceRegistry;
    private static List<String> TYPE_TEST_DENYLIST;
    protected static final TriConsumer<Document, String, String> ADD_SORTED_SET_FIELD_NOT_INDEXED;
    protected static final TriConsumer<Document, String, String> ADD_SORTED_SET_FIELD_INDEXED;

    protected Map<String, MappedFieldType> getFieldAliases(MappedFieldType ... fieldTypes) {
        return Collections.emptyMap();
    }

    private static void registerFieldTypes(SearchContext searchContext, MapperService mapperService, Map<String, MappedFieldType> fieldNameToType) {
        for (Map.Entry<String, MappedFieldType> entry : fieldNameToType.entrySet()) {
            String fieldName = entry.getKey();
            MappedFieldType fieldType = entry.getValue();
            Mockito.when((Object)mapperService.fieldType(fieldName)).thenReturn((Object)fieldType);
            Mockito.when((Object)searchContext.fieldType(fieldName)).thenReturn((Object)fieldType);
        }
    }

    @Before
    public void initValuesSourceRegistry() {
        ArrayList<SearchPlugin> plugins = new ArrayList<SearchPlugin>(this.getSearchPlugins());
        plugins.add(new AggCardinalityPlugin());
        SearchModule searchModule = new SearchModule(Settings.EMPTY, plugins);
        this.valuesSourceRegistry = searchModule.getValuesSourceRegistry();
    }

    protected List<SearchPlugin> getSearchPlugins() {
        return Collections.emptyList();
    }

    protected <A extends Aggregator> A createAggregator(AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(aggregationBuilder, indexSearcher, this.createIndexSettings(), new MultiBucketConsumerService.MultiBucketConsumer(100000, new NoneCircuitBreakerService().getBreaker("request")), fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(query, aggregationBuilder, indexSearcher, indexSettings, new MultiBucketConsumerService.MultiBucketConsumer(100000, new NoneCircuitBreakerService().getBreaker("request")), fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(query, aggregationBuilder, indexSearcher, this.createIndexSettings(), bucketConsumer, fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(null, aggregationBuilder, indexSearcher, indexSettings, bucketConsumer, fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        SearchContext searchContext = this.createSearchContext(indexSearcher, indexSettings, query, bucketConsumer, fieldTypes);
        return this.createAggregator(aggregationBuilder, searchContext);
    }

    protected <A extends Aggregator> A createStreamAggregator(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        SearchContext searchContext = this.createSearchContext(indexSearcher, indexSettings, query, bucketConsumer, fieldTypes);
        Mockito.when((Object)searchContext.isStreamSearch()).thenReturn((Object)true);
        return this.createAggregator(aggregationBuilder, searchContext);
    }

    protected <A extends Aggregator> A createAggregatorWithCustomizableSearchContext(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, Consumer<SearchContext> customizeSearchContext, MappedFieldType ... fieldTypes) throws IOException {
        SearchContext searchContext = this.createSearchContext(indexSearcher, indexSettings, query, bucketConsumer, fieldTypes);
        customizeSearchContext.accept(searchContext);
        return this.createAggregator(aggregationBuilder, searchContext);
    }

    protected <A extends Aggregator> A createAggregator(AggregationBuilder aggregationBuilder, SearchContext searchContext) throws IOException {
        Aggregator aggregator = aggregationBuilder.rewrite((QueryRewriteContext)searchContext.getQueryShardContext()).build(searchContext.getQueryShardContext(), null).create(searchContext, null, CardinalityUpperBound.ONE);
        return (A)aggregator;
    }

    protected CountingAggregator createCountingAggregator(Query query, QueryBuilder queryBuilder, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, CompositeIndexFieldInfo starTree, LinkedHashMap<Dimension, MappedFieldType> supportedDimensions, List<Metric> supportedMetrics, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, AggregatorFactory aggregatorFactory, MappedFieldType ... fieldTypes) throws IOException {
        SearchContext searchContext = starTree != null ? this.createSearchContextWithStarTreeContext(indexSearcher, indexSettings, query, queryBuilder, starTree, supportedDimensions, supportedMetrics, bucketConsumer, aggregatorFactory, fieldTypes) : this.createSearchContext(indexSearcher, indexSettings, query, bucketConsumer, fieldTypes);
        return new CountingAggregator(new AtomicInteger(), (Aggregator)this.createAggregator(aggregationBuilder, searchContext));
    }

    protected SearchContext createSearchContext(IndexSearcher indexSearcher, IndexSettings indexSettings, Query query, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        return this.createSearchContext(indexSearcher, indexSettings, query, bucketConsumer, (CircuitBreakerService)new NoneCircuitBreakerService(), fieldTypes);
    }

    protected SearchContext createSearchContextWithStarTreeContext(IndexSearcher indexSearcher, IndexSettings indexSettings, Query query, QueryBuilder queryBuilder, CompositeIndexFieldInfo starTree, LinkedHashMap<Dimension, MappedFieldType> supportedDimensions, List<Metric> supportedMetrics, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, AggregatorFactory aggregatorFactory, MappedFieldType ... fieldTypes) throws IOException {
        SearchContext searchContext = this.createSearchContext(indexSearcher, indexSettings, query, bucketConsumer, (CircuitBreakerService)new NoneCircuitBreakerService(), fieldTypes);
        SearchContextAggregations searchContextAggregations = (SearchContextAggregations)Mockito.mock(SearchContextAggregations.class);
        AggregatorFactories aggregatorFactories = (AggregatorFactories)Mockito.mock(AggregatorFactories.class);
        Mockito.when((Object)searchContext.aggregations()).thenReturn((Object)new SearchContextAggregations(AggregatorFactories.EMPTY, bucketConsumer));
        Mockito.when((Object)searchContextAggregations.factories()).thenReturn((Object)aggregatorFactories);
        if (aggregatorFactory != null) {
            Mockito.when((Object)aggregatorFactories.getFactories()).thenReturn((Object)new AggregatorFactory[]{aggregatorFactory});
        } else {
            Mockito.when((Object)aggregatorFactories.getFactories()).thenReturn((Object)new AggregatorFactory[0]);
        }
        CompositeDataCubeFieldType compositeMappedFieldType = (CompositeDataCubeFieldType)Mockito.mock(CompositeDataCubeFieldType.class);
        Mockito.when((Object)compositeMappedFieldType.name()).thenReturn((Object)starTree.getField());
        Mockito.when((Object)compositeMappedFieldType.getCompositeIndexType()).thenReturn((Object)starTree.getType());
        Set<CompositeDataCubeFieldType> compositeFieldTypes = Set.of(compositeMappedFieldType);
        Mockito.when((Object)compositeMappedFieldType.getDimensions()).thenReturn(new ArrayList<Dimension>(supportedDimensions.keySet()));
        Mockito.when((Object)compositeMappedFieldType.getMetrics()).thenReturn(supportedMetrics);
        MapperService mapperService = (MapperService)Mockito.mock(MapperService.class);
        Mockito.when((Object)mapperService.getCompositeFieldTypes()).thenReturn(compositeFieldTypes);
        Mockito.when((Object)searchContext.mapperService()).thenReturn((Object)mapperService);
        for (Dimension dimension : supportedDimensions.keySet()) {
            Mockito.when((Object)mapperService.fieldType(dimension.getField())).thenReturn((Object)supportedDimensions.get(dimension));
            Mockito.when((Object)searchContext.getQueryShardContext().fieldMapper(dimension.getField())).thenReturn((Object)supportedDimensions.get(dimension));
        }
        StarTreeQueryContext starTreeQueryContext = new StarTreeQueryContext(searchContext, queryBuilder);
        boolean consolidated = starTreeQueryContext.consolidateAllFilters(searchContext);
        if (consolidated) {
            searchContext.getQueryShardContext().setStarTreeQueryContext(starTreeQueryContext);
        }
        Stream.of(fieldTypes).forEach(fieldType -> Mockito.when((Object)mapperService.fieldType(fieldType.name())).thenReturn(fieldType));
        return searchContext;
    }

    protected SearchContext createSearchContext(IndexSearcher indexSearcher, IndexSettings indexSettings, Query query, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, CircuitBreakerService circuitBreakerService, MappedFieldType ... fieldTypes) throws IOException {
        DisabledQueryCache queryCache = new DisabledQueryCache(indexSettings);
        QueryCachingPolicy queryCachingPolicy = new QueryCachingPolicy(this){

            public void onUse(Query query) {
            }

            public boolean shouldCache(Query query) {
                return false;
            }
        };
        SearchContext searchContext = (SearchContext)Mockito.mock(SearchContext.class);
        ContextIndexSearcher contextIndexSearcher = new ContextIndexSearcher(indexSearcher.getIndexReader(), indexSearcher.getSimilarity(), (QueryCache)queryCache, queryCachingPolicy, false, null, searchContext);
        Mockito.when((Object)searchContext.numberOfShards()).thenReturn((Object)1);
        Mockito.when((Object)searchContext.searcher()).thenReturn((Object)contextIndexSearcher);
        Mockito.when((Object)searchContext.fetchPhase()).thenReturn((Object)new FetchPhase(Arrays.asList(new FetchSourcePhase(), new FetchDocValuesPhase())));
        Mockito.when((Object)searchContext.bitsetFilterCache()).thenReturn((Object)new BitsetFilterCache(indexSettings, (BitsetFilterCache.Listener)Mockito.mock(BitsetFilterCache.Listener.class)));
        IndexShard indexShard = (IndexShard)Mockito.mock(IndexShard.class);
        Mockito.when((Object)indexShard.shardId()).thenReturn((Object)new ShardId("test", "test", 0));
        Mockito.when((Object)searchContext.indexShard()).thenReturn((Object)indexShard);
        SearchOperationListener searchOperationListener = new SearchOperationListener(this){};
        Mockito.when((Object)indexShard.getSearchOperationListener()).thenReturn((Object)searchOperationListener);
        Mockito.when((Object)searchContext.aggregations()).thenReturn((Object)new SearchContextAggregations(AggregatorFactories.EMPTY, bucketConsumer));
        Mockito.when((Object)searchContext.query()).thenReturn((Object)query);
        Mockito.when((Object)searchContext.bucketCollectorProcessor()).thenReturn((Object)new BucketCollectorProcessor());
        Mockito.when((Object)searchContext.asLocalBucketCountThresholds((TermsAggregator.BucketCountThresholds)Mockito.any())).thenCallRealMethod();
        BigArrays bigArrays = new MockBigArrays(new MockPageCacheRecycler(Settings.EMPTY), circuitBreakerService).withCircuitBreaking();
        Mockito.when((Object)searchContext.bigArrays()).thenReturn((Object)bigArrays);
        MapperService mapperService = this.mapperServiceMock();
        Mockito.when((Object)mapperService.getIndexSettings()).thenReturn((Object)indexSettings);
        Mockito.when((Object)mapperService.hasNested()).thenReturn((Object)false);
        Mockito.when((Object)searchContext.mapperService()).thenReturn((Object)mapperService);
        QueryShardContext queryShardContext = this.queryShardContextMock((IndexSearcher)contextIndexSearcher, mapperService, indexSettings, circuitBreakerService, bigArrays);
        Mockito.when((Object)searchContext.getQueryShardContext()).thenReturn((Object)queryShardContext);
        Mockito.when((Object)queryShardContext.getObjectMapper(Mockito.anyString())).thenAnswer(invocation -> {
            String fieldName = (String)invocation.getArguments()[0];
            if (fieldName.startsWith(NESTEDFIELD_PREFIX)) {
                Mapper.BuilderContext context = new Mapper.BuilderContext(indexSettings.getSettings(), new ContentPath());
                return new ObjectMapper.Builder(fieldName).nested(ObjectMapper.Nested.newNested()).build(context);
            }
            return null;
        });
        HashMap<String, MappedFieldType> fieldNameToType = new HashMap<String, MappedFieldType>();
        fieldNameToType.putAll(Arrays.stream(fieldTypes).filter(Objects::nonNull).collect(Collectors.toMap(MappedFieldType::name, Function.identity())));
        fieldNameToType.putAll(this.getFieldAliases(fieldTypes));
        Mockito.when((Object)searchContext.maxAggRewriteFilters()).thenReturn((Object)10000);
        AggregatorTestCase.registerFieldTypes(searchContext, mapperService, fieldNameToType);
        ((SearchContext)Mockito.doAnswer(invocation -> {
            this.releasables.add((Releasable)invocation.getArguments()[0]);
            return null;
        }).when((Object)searchContext)).addReleasable((Releasable)Mockito.any());
        return searchContext;
    }

    protected IndexSettings createIndexSettings() {
        return new IndexSettings(IndexMetadata.builder((String)"_index").settings(Settings.builder().put("index.version.created", Version.CURRENT)).numberOfShards(1).numberOfReplicas(0).creationDate(System.currentTimeMillis()).build(), Settings.EMPTY);
    }

    protected MapperService mapperServiceMock() {
        return (MapperService)Mockito.mock(MapperService.class);
    }

    protected QueryShardContext queryShardContextMock(IndexSearcher searcher, MapperService mapperService, IndexSettings indexSettings, CircuitBreakerService circuitBreakerService, BigArrays bigArrays) {
        return new QueryShardContext(0, indexSettings, bigArrays, null, this.getIndexFieldDataLookup(mapperService, circuitBreakerService), mapperService, null, this.getMockScriptService(), this.xContentRegistry(), this.writableRegistry(), null, searcher, System::currentTimeMillis, null, null, () -> true, this.valuesSourceRegistry);
    }

    protected TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> getIndexFieldDataLookup(MapperService mapperService, CircuitBreakerService circuitBreakerService) {
        return (fieldType, s, searchLookup) -> fieldType.fielddataBuilder(mapperService.getIndexSettings().getIndex().getName(), searchLookup).build((IndexFieldDataCache)new IndexFieldDataCache.None(), circuitBreakerService);
    }

    protected ScriptService getMockScriptService() {
        return null;
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, Query query, AggregationBuilder builder, boolean shardFanOut, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(this.createIndexSettings(), searcher, query, builder, 100000, shardFanOut, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, Query query, AggregationBuilder builder, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(this.createIndexSettings(), searcher, query, builder, 100000, AggregatorTestCase.randomBoolean(), fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSettings indexSettings, IndexSearcher searcher, Query query, AggregationBuilder builder, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(indexSettings, searcher, query, builder, 100000, AggregatorTestCase.randomBoolean(), fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, Query query, AggregationBuilder builder, int maxBucket, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(this.createIndexSettings(), searcher, query, builder, maxBucket, AggregatorTestCase.randomBoolean(), fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSettings indexSettings, IndexSearcher searcher, Query query, AggregationBuilder builder, int maxBucket, boolean shardFanOut, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(indexSettings, searcher, query, builder, maxBucket, false, shardFanOut, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSettings indexSettings, IndexSearcher searcher, Query query, AggregationBuilder builder, int maxBucket, boolean hasNested, boolean shardFanOut, MappedFieldType ... fieldTypes) throws IOException {
        IndexReaderContext ctx = searcher.getTopReaderContext();
        PipelineAggregator.PipelineTree pipelines = builder.buildPipelineTree();
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        if (hasNested) {
            query = Queries.filtered((Query)query, (Query)Queries.newNonNestedFilter());
        }
        Query rewritten = searcher.rewrite(query);
        MultiBucketConsumerService.MultiBucketConsumer bucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, new NoneCircuitBreakerService().getBreaker("request"));
        A root = this.createAggregator(query, builder, searcher, bucketConsumer, fieldTypes);
        if (shardFanOut && searcher.getIndexReader().leaves().size() > 0) {
            AggregatorTestCase.assertThat((Object)ctx, (Matcher)Matchers.instanceOf(CompositeReaderContext.class));
            CompositeReaderContext compCTX = (CompositeReaderContext)ctx;
            int size = compCTX.leaves().size();
            ShardSearcher[] subSearchers = new ShardSearcher[size];
            for (int searcherIDX = 0; searcherIDX < subSearchers.length; ++searcherIDX) {
                IndexSearcher.LeafReaderContextPartition partition = IndexSearcher.LeafReaderContextPartition.createForEntireSegment((LeafReaderContext)((LeafReaderContext)compCTX.leaves().get(searcherIDX)));
                subSearchers[searcherIDX] = new ShardSearcher(partition, (IndexReaderContext)compCTX);
            }
            for (ShardSearcher subSearcher : subSearchers) {
                MultiBucketConsumerService.MultiBucketConsumer shardBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, new NoneCircuitBreakerService().getBreaker("request"));
                A a = this.createAggregator(query, builder, (IndexSearcher)subSearcher, indexSettings, shardBucketConsumer, fieldTypes);
                a.preCollection();
                Weight weight = subSearcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
                subSearcher.search(weight, (Collector)a);
                a.postCollection();
                aggs.add(a.buildTopLevel());
            }
        } else {
            root.preCollection();
            searcher.search(rewritten, root);
            root.postCollection();
            aggs.add(root.buildTopLevel());
        }
        if (AggregatorTestCase.randomBoolean() && aggs.size() > 1) {
            int toReduceSize = aggs.size();
            Collections.shuffle(aggs, AggregatorTestCase.random());
            int r = AggregatorTestCase.randomIntBetween(1, toReduceSize);
            List toReduce = aggs.subList(0, r);
            InternalAggregation.ReduceContext context = InternalAggregation.ReduceContext.forPartialReduction((BigArrays)root.context().bigArrays(), (ScriptService)this.getMockScriptService(), () -> PipelineAggregator.PipelineTree.EMPTY);
            InternalAggregation reduced = ((InternalAggregation)aggs.get(0)).reduce(toReduce, context);
            aggs = new ArrayList(aggs.subList(r, toReduceSize));
            aggs.add(reduced);
        }
        MultiBucketConsumerService.MultiBucketConsumer reduceBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, new NoneCircuitBreakerService().getBreaker("request"));
        InternalAggregation.ReduceContext context = InternalAggregation.ReduceContext.forFinalReduction((BigArrays)root.context().bigArrays(), (ScriptService)this.getMockScriptService(), (IntConsumer)reduceBucketConsumer, (PipelineAggregator.PipelineTree)pipelines);
        InternalAggregation internalAgg = ((InternalAggregation)aggs.get(0)).reduce(aggs, context);
        internalAgg = internalAgg.reducePipelines(internalAgg, context, pipelines);
        for (PipelineAggregator pipelineAggregator : pipelines.aggregators()) {
            internalAgg = pipelineAggregator.reduce(internalAgg, context);
        }
        this.doAssertReducedMultiBucketConsumer((Aggregation)internalAgg, reduceBucketConsumer);
        return (A)internalAgg;
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduceStarTree(IndexSettings indexSettings, IndexSearcher searcher, Query query, QueryBuilder queryBuilder, AggregationBuilder builder, CompositeIndexFieldInfo compositeIndexFieldInfo, LinkedHashMap<Dimension, MappedFieldType> supportedDimensions, List<Metric> supportedMetrics, int maxBucket, boolean hasNested, AggregatorFactory aggregatorFactory, boolean assertCollectorEarlyTermination, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduceStarTree(indexSettings, searcher, query, queryBuilder, builder, compositeIndexFieldInfo, supportedDimensions, supportedMetrics, maxBucket, hasNested, aggregatorFactory, assertCollectorEarlyTermination, false, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduceStarTree(IndexSettings indexSettings, IndexSearcher searcher, Query query, QueryBuilder queryBuilder, AggregationBuilder builder, CompositeIndexFieldInfo compositeIndexFieldInfo, LinkedHashMap<Dimension, MappedFieldType> supportedDimensions, List<Metric> supportedMetrics, int maxBucket, boolean hasNested, AggregatorFactory aggregatorFactory, boolean assertCollectorEarlyTermination, boolean skipReducedMultiBucketConsumerAssertion, MappedFieldType ... fieldTypes) throws IOException {
        query = query.rewrite(searcher);
        IndexReaderContext ctx = searcher.getTopReaderContext();
        PipelineAggregator.PipelineTree pipelines = builder.buildPipelineTree();
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        if (hasNested) {
            query = Queries.filtered((Query)query, (Query)Queries.newNonNestedFilter());
        }
        MultiBucketConsumerService.MultiBucketConsumer bucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, new NoneCircuitBreakerService().getBreaker("request"));
        CountingAggregator countingAggregator = this.createCountingAggregator(query, queryBuilder, builder, searcher, indexSettings, compositeIndexFieldInfo, supportedDimensions, supportedMetrics, bucketConsumer, aggregatorFactory, fieldTypes);
        countingAggregator.preCollection();
        searcher.search(query, (Collector)countingAggregator);
        countingAggregator.postCollection();
        aggs.add(countingAggregator.buildTopLevel());
        if (compositeIndexFieldInfo != null && assertCollectorEarlyTermination) {
            AggregatorTestCase.assertEquals((long)0L, (long)countingAggregator.collectCounter.get());
        }
        MultiBucketConsumerService.MultiBucketConsumer reduceBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, new NoneCircuitBreakerService().getBreaker("request"));
        InternalAggregation.ReduceContext context = InternalAggregation.ReduceContext.forFinalReduction((BigArrays)countingAggregator.context().bigArrays(), (ScriptService)this.getMockScriptService(), (IntConsumer)reduceBucketConsumer, (PipelineAggregator.PipelineTree)pipelines);
        InternalAggregation internalAgg = ((InternalAggregation)aggs.get(0)).reduce(aggs, context);
        if (!skipReducedMultiBucketConsumerAssertion) {
            this.doAssertReducedMultiBucketConsumer((Aggregation)internalAgg, reduceBucketConsumer);
        }
        return (A)internalAgg;
    }

    protected void doAssertReducedMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertMultiBucketConsumer(agg, bucketConsumer);
    }

    protected <T extends AggregationBuilder, V extends InternalAggregation> void testCase(T aggregationBuilder, Query query, CheckedConsumer<RandomIndexWriter, IOException> buildIndex, Consumer<V> verify, MappedFieldType ... fieldTypes) throws IOException {
        try (BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();){
            RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
            buildIndex.accept((Object)indexWriter);
            indexWriter.close();
            try (DirectoryReader unwrapped = DirectoryReader.open((Directory)directory);
                 IndexReader indexReader = this.wrapDirectoryReader(unwrapped);){
                IndexSearcher indexSearcher = AggregatorTestCase.newIndexSearcher(indexReader);
                Object agg = this.searchAndReduce(indexSearcher, query, aggregationBuilder, fieldTypes);
                verify.accept(agg);
            }
        }
    }

    protected IndexReader wrapDirectoryReader(DirectoryReader reader) throws IOException {
        return reader;
    }

    protected static DirectoryReader wrapInMockESDirectoryReader(DirectoryReader directoryReader) throws IOException {
        return OpenSearchDirectoryReader.wrap((DirectoryReader)directoryReader, (ShardId)new ShardId(new Index("_index", "_na_"), 0));
    }

    protected static IndexSearcher newIndexSearcher(IndexReader indexReader) {
        if (AggregatorTestCase.randomBoolean()) {
            return new AssertingIndexSearcher(AggregatorTestCase.random(), indexReader);
        }
        return new IndexSearcher(indexReader);
    }

    protected static IndexReader maybeWrapReaderEs(DirectoryReader reader) throws IOException {
        if (AggregatorTestCase.randomBoolean()) {
            return new AssertingDirectoryReader(reader);
        }
        return reader;
    }

    protected List<ValuesSourceType> getSupportedValuesSourceTypes() {
        return Collections.emptyList();
    }

    protected AggregationBuilder createAggBuilderForTypeTest(MappedFieldType fieldType, String fieldName) {
        throw new UnsupportedOperationException("If getSupportedValuesSourceTypes() is implemented, createAggBuilderForTypeTest() must be implemented as well.");
    }

    protected List<String> unsupportedMappedFieldTypes() {
        return Collections.emptyList();
    }

    public void testSupportedFieldTypes() throws IOException {
        MapperRegistry mapperRegistry = new IndicesModule(Collections.emptyList()).getMapperRegistry();
        Settings settings = Settings.builder().put("index.version.created", Version.CURRENT.id).build();
        String fieldName = "typeTestFieldName";
        List<ValuesSourceType> supportedVSTypes = this.getSupportedValuesSourceTypes();
        List<String> unsupportedMappedFieldTypes = this.unsupportedMappedFieldTypes();
        if (supportedVSTypes.isEmpty()) {
            return;
        }
        for (Map.Entry mappedType : mapperRegistry.getMapperParsers().entrySet()) {
            Mapper.Builder builder;
            FieldMapper mapper;
            MappedFieldType fieldType;
            if (TYPE_TEST_DENYLIST.contains(mappedType.getKey())) continue;
            HashMap source = new HashMap();
            source.put(TYPE_NAME, mappedType.getKey());
            if (!((String)mappedType.getKey()).equals("text") && !((String)mappedType.getKey()).equals("match_only_text")) {
                source.put("doc_values", "true");
            }
            if (((String)mappedType.getKey()).equals("constant_keyword")) {
                source.put("value", "default_value");
            }
            if (!(fieldType = (mapper = (FieldMapper)(builder = ((Mapper.TypeParser)mappedType.getValue()).parse(fieldName, source, (Mapper.TypeParser.ParserContext)new MockParserContext(this))).build(new Mapper.BuilderContext(settings, new ContentPath()))).fieldType()).isAggregatable()) continue;
            BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();
            try {
                RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
                this.writeTestDoc(fieldType, fieldName, indexWriter);
                indexWriter.close();
                DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
                try {
                    AssertionError failure;
                    block17: {
                        IndexSearcher indexSearcher = AggregatorTestCase.newIndexSearcher((IndexReader)indexReader);
                        AggregationBuilder aggregationBuilder = this.createAggBuilderForTypeTest(fieldType, fieldName);
                        ValuesSourceType vst = this.fieldToVST(fieldType);
                        failure = null;
                        try {
                            this.searchAndReduce(indexSearcher, (Query)new MatchAllDocsQuery(), aggregationBuilder, fieldType);
                            if (!supportedVSTypes.contains(vst) || unsupportedMappedFieldTypes.contains(fieldType.typeName())) {
                                failure = new AssertionError((Object)("Aggregator [" + aggregationBuilder.getType() + "] should not support field type [" + fieldType.typeName() + "] but executing against the field did not throw an exception"));
                            }
                        }
                        catch (AssertionError | Exception e) {
                            if (!supportedVSTypes.contains(vst) || unsupportedMappedFieldTypes.contains(fieldType.typeName())) break block17;
                            failure = new AssertionError("Aggregator [" + aggregationBuilder.getType() + "] supports field type [" + fieldType.typeName() + "] but executing against the field threw an exception: [" + ((Throwable)e).getMessage() + "]", (Throwable)e);
                        }
                    }
                    if (failure == null) continue;
                    throw failure;
                }
                finally {
                    if (indexReader == null) continue;
                    indexReader.close();
                }
            }
            finally {
                if (directory == null) continue;
                directory.close();
            }
        }
    }

    private ValuesSourceType fieldToVST(MappedFieldType fieldType) {
        return fieldType.fielddataBuilder("", () -> {
            throw new UnsupportedOperationException();
        }).build(null, null).getValuesSourceType();
    }

    private void writeTestDoc(MappedFieldType fieldType, String fieldName, RandomIndexWriter iw) throws IOException {
        String json;
        String typeName = fieldType.typeName();
        ValuesSourceType vst = this.fieldToVST(fieldType);
        Document doc = new Document();
        if (vst.equals((Object)CoreValuesSourceType.NUMERIC)) {
            long v;
            if (typeName.equals(NumberFieldMapper.NumberType.DOUBLE.typeName())) {
                double d = Math.abs(AggregatorTestCase.randomDouble());
                v = NumericUtils.doubleToSortableLong((double)d);
                json = "{ \"" + fieldName + "\" : \"" + d + "\" }";
            } else if (typeName.equals(NumberFieldMapper.NumberType.FLOAT.typeName())) {
                float f = Math.abs(AggregatorTestCase.randomFloat());
                v = NumericUtils.floatToSortableInt((float)f);
                json = "{ \"" + fieldName + "\" : \"" + f + "\" }";
            } else if (typeName.equals(NumberFieldMapper.NumberType.HALF_FLOAT.typeName())) {
                float f = Math.abs((AggregatorTestCase.randomFloat() * 2.0f - 1.0f) * 65504.0f);
                v = HalfFloatPoint.halfFloatToSortableShort((float)f);
                json = "{ \"" + fieldName + "\" : \"" + f + "\" }";
            } else {
                v = Math.abs(AggregatorTestCase.randomByte());
                json = "{ \"" + fieldName + "\" : \"" + v + "\" }";
            }
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
        } else if (vst.equals((Object)CoreValuesSourceType.BYTES)) {
            if (typeName.equals("binary")) {
                doc.add((IndexableField)new BinaryFieldMapper.CustomBinaryDocValuesField(fieldName, new BytesRef((CharSequence)"a").bytes));
                json = "{ \"" + fieldName + "\" : \"a\" }";
            } else {
                doc.add((IndexableField)new SortedSetDocValuesField(fieldName, new BytesRef((CharSequence)"a")));
                json = "{ \"" + fieldName + "\" : \"a\" }";
            }
        } else if (vst.equals((Object)CoreValuesSourceType.DATE)) {
            long v = Math.abs(AggregatorTestCase.randomInt());
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
            json = "{ \"" + fieldName + "\" : \"" + v + "\" }";
        } else if (vst.equals((Object)CoreValuesSourceType.BOOLEAN)) {
            long v = AggregatorTestCase.randomBoolean() ? 0L : 1L;
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
            json = "{ \"" + fieldName + "\" : \"" + (v == 0L ? "false" : "true") + "\" }";
        } else if (vst.equals((Object)CoreValuesSourceType.IP)) {
            InetAddress ip = AggregatorTestCase.randomIp(AggregatorTestCase.randomBoolean());
            json = "{ \"" + fieldName + "\" : \"" + NetworkAddress.format((InetAddress)ip) + "\" }";
            doc.add((IndexableField)new SortedSetDocValuesField(fieldName, new BytesRef(InetAddressPoint.encode((InetAddress)ip))));
        } else if (vst.equals((Object)CoreValuesSourceType.RANGE)) {
            RangeType rangeType;
            Object end;
            Serializable start;
            if (typeName.equals(RangeType.DOUBLE.typeName())) {
                start = AggregatorTestCase.randomDouble();
                end = RangeType.DOUBLE.nextUp((Object)start);
                rangeType = RangeType.DOUBLE;
            } else if (typeName.equals(RangeType.FLOAT.typeName())) {
                start = Float.valueOf(AggregatorTestCase.randomFloat());
                end = RangeType.FLOAT.nextUp((Object)start);
                rangeType = RangeType.DOUBLE;
            } else if (typeName.equals(RangeType.IP.typeName())) {
                boolean v4 = AggregatorTestCase.randomBoolean();
                start = AggregatorTestCase.randomIp(v4);
                end = RangeType.IP.nextUp((Object)start);
                rangeType = RangeType.IP;
            } else if (typeName.equals(RangeType.LONG.typeName())) {
                start = AggregatorTestCase.randomLong();
                end = RangeType.LONG.nextUp((Object)start);
                rangeType = RangeType.LONG;
            } else if (typeName.equals(RangeType.INTEGER.typeName())) {
                start = AggregatorTestCase.randomInt();
                end = RangeType.INTEGER.nextUp((Object)start);
                rangeType = RangeType.INTEGER;
            } else if (typeName.equals(RangeType.DATE.typeName())) {
                start = AggregatorTestCase.randomNonNegativeLong();
                end = RangeType.DATE.nextUp((Object)start);
                rangeType = RangeType.DATE;
            } else {
                throw new IllegalStateException("Unknown type of range [" + typeName + "]");
            }
            RangeFieldMapper.Range range = new RangeFieldMapper.Range(rangeType, (Object)start, end, true, true);
            doc.add((IndexableField)new BinaryDocValuesField(fieldName, rangeType.encodeRanges(Collections.singleton(range))));
            json = "{ \"" + fieldName + "\" : { \n        \"gte\" : \"" + String.valueOf(start) + "\",\n        \"lte\" : \"" + String.valueOf(end) + "\"\n      }}";
        } else if (vst.equals((Object)CoreValuesSourceType.GEOPOINT)) {
            double lat = AggregatorTestCase.randomDouble();
            double lon = AggregatorTestCase.randomDouble();
            doc.add((IndexableField)new LatLonDocValuesField(fieldName, lat, lon));
            json = "{ \"" + fieldName + "\" : \"[" + lon + "," + lat + "]\" }";
        } else {
            throw new IllegalStateException("Unknown field type [" + typeName + "]");
        }
        doc.add((IndexableField)new StoredField("_source", new BytesRef((CharSequence)json)));
        iw.addDocument((Iterable)doc);
    }

    @After
    private void cleanupReleasables() {
        Releasables.close(this.releasables);
        this.releasables.clear();
    }

    protected void afterClose() {
    }

    protected DateFieldMapper.DateFieldType dateField(String name, DateFieldMapper.Resolution resolution) {
        return new DateFieldMapper.DateFieldType(name, resolution);
    }

    protected NumberFieldMapper.NumberFieldType doubleField(String name) {
        return new NumberFieldMapper.NumberFieldType(name, NumberFieldMapper.NumberType.DOUBLE);
    }

    protected GeoPointFieldMapper.GeoPointFieldType geoPointField(String name) {
        return new GeoPointFieldMapper.GeoPointFieldType(name);
    }

    protected KeywordFieldMapper.KeywordFieldType keywordField(String name) {
        return new KeywordFieldMapper.KeywordFieldType(name);
    }

    protected NumberFieldMapper.NumberFieldType longField(String name) {
        return new NumberFieldMapper.NumberFieldType(name, NumberFieldMapper.NumberType.LONG);
    }

    protected RangeFieldMapper.RangeFieldType rangeField(String name, RangeType rangeType) {
        if (rangeType == RangeType.DATE) {
            return new RangeFieldMapper.RangeFieldType(name, RangeFieldMapper.Defaults.DATE_FORMATTER);
        }
        return new RangeFieldMapper.RangeFieldType(name, rangeType);
    }

    public static AggregationBuilder aggCardinality(String name) {
        return new AggCardinalityAggregationBuilder(name);
    }

    static {
        ADD_SORTED_SET_FIELD_NOT_INDEXED = (document, field, value) -> document.add((IndexableField)new SortedSetDocValuesField(field, new BytesRef((CharSequence)value)));
        ADD_SORTED_SET_FIELD_INDEXED = (document, field, value) -> {
            document.add((IndexableField)new SortedSetDocValuesField(field, new BytesRef((CharSequence)value)));
            document.add((IndexableField)new StringField(field, value, Field.Store.NO));
        };
        ArrayList<String> denylist = new ArrayList<String>();
        denylist.add("object");
        denylist.add("geo_shape");
        denylist.add("nested");
        denylist.add("completion");
        denylist.add("alias");
        denylist.add("derived");
        denylist.add("star_tree");
        denylist.add("version");
        TYPE_TEST_DENYLIST = denylist;
    }

    private static class AggCardinalityPlugin
    implements SearchPlugin {
        private AggCardinalityPlugin() {
        }

        public List<SearchPlugin.AggregationSpec> getAggregations() {
            return Collections.singletonList(new SearchPlugin.AggregationSpec("agg_cardinality", in -> null, (p, c) -> null));
        }
    }

    protected static class CountingAggregator
    extends Aggregator {
        private final AtomicInteger collectCounter;
        public final Aggregator delegate;
        private LeafBucketCollector selectedCollector;

        public CountingAggregator(AtomicInteger collectCounter, Aggregator delegate) {
            this.collectCounter = collectCounter;
            this.delegate = delegate;
        }

        public AtomicInteger getCollectCount() {
            return this.collectCounter;
        }

        public LeafBucketCollector getSelectedCollector() {
            return this.selectedCollector;
        }

        public void close() {
            this.delegate.close();
        }

        public String name() {
            return this.delegate.name();
        }

        public SearchContext context() {
            return this.delegate.context();
        }

        public Aggregator parent() {
            return this.delegate.parent();
        }

        public Aggregator subAggregator(String name) {
            return this.delegate.subAggregator(name);
        }

        public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            return this.delegate.buildAggregations(owningBucketOrds);
        }

        public InternalAggregation buildEmptyAggregation() {
            return this.delegate.buildEmptyAggregation();
        }

        public LeafBucketCollector getLeafCollector(final LeafReaderContext ctx) throws IOException {
            return new LeafBucketCollector(this){
                final /* synthetic */ CountingAggregator this$0;
                {
                    this.this$0 = this$0;
                }

                public void collect(int doc, long bucket) throws IOException {
                    this.this$0.selectedCollector = this.this$0.delegate.getLeafCollector(ctx);
                    this.this$0.selectedCollector.collect(doc, bucket);
                    this.this$0.collectCounter.incrementAndGet();
                }
            };
        }

        public ScoreMode scoreMode() {
            return this.delegate.scoreMode();
        }

        public void preCollection() throws IOException {
            this.delegate.preCollection();
        }

        public void postCollection() throws IOException {
            this.delegate.postCollection();
        }

        public void setWeight(Weight weight) {
            this.delegate.setWeight(weight);
        }
    }

    private static class ShardSearcher
    extends IndexSearcher {
        private final IndexSearcher.LeafReaderContextPartition[] partitions;

        ShardSearcher(IndexSearcher.LeafReaderContextPartition partition, IndexReaderContext parent) {
            super(parent);
            this.partitions = new IndexSearcher.LeafReaderContextPartition[]{partition};
        }

        public void search(Weight weight, Collector collector) throws IOException {
            this.search(this.partitions, weight, collector);
        }

        public String toString() {
            return "ShardSearcher(" + String.valueOf(this.partitions[0].ctx) + ")";
        }
    }

    private class MockParserContext
    extends Mapper.TypeParser.ParserContext {
        MockParserContext(AggregatorTestCase aggregatorTestCase) {
            super(null, null, null, Version.CURRENT, null, null, null);
        }

        public Settings getSettings() {
            return Settings.EMPTY;
        }

        public IndexAnalyzers getIndexAnalyzers() {
            NamedAnalyzer defaultAnalyzer = new NamedAnalyzer("default", AnalyzerScope.GLOBAL, (Analyzer)new StandardAnalyzer());
            return new IndexAnalyzers(Collections.singletonMap("default", defaultAnalyzer), Collections.emptyMap(), Collections.emptyMap());
        }
    }

    private static class AggCardinalityAggregationBuilder
    extends AbstractAggregationBuilder<AggCardinalityAggregationBuilder> {
        AggCardinalityAggregationBuilder(String name) {
            super(name);
        }

        protected AggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
            return new AggregatorFactory(this, this.name, queryShardContext, parent, subfactoriesBuilder, this.metadata){

                protected Aggregator createInternal(SearchContext searchContext, Aggregator parent, final CardinalityUpperBound cardinality, final Map<String, Object> metadata) throws IOException {
                    return new MetricsAggregator(this, this.name, searchContext, parent, metadata){

                        protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
                            return LeafBucketCollector.NO_OP_COLLECTOR;
                        }

                        public InternalAggregation buildAggregation(long owningBucketOrd) throws IOException {
                            return new InternalAggCardinality(this.name, cardinality, metadata);
                        }

                        public InternalAggregation buildEmptyAggregation() {
                            return null;
                        }
                    };
                }

                protected boolean supportsConcurrentSegmentSearch() {
                    return true;
                }
            };
        }

        protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }

        public AggregationBuilder.BucketCardinality bucketCardinality() {
            return AggregationBuilder.BucketCardinality.ONE;
        }

        public String getType() {
            return "agg_cardinality";
        }

        protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            throw new UnsupportedOperationException();
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class InternalAggCardinality
    extends InternalAggregation {
        private final CardinalityUpperBound cardinality;

        protected InternalAggCardinality(String name, CardinalityUpperBound cardinality, Map<String, Object> metadata) {
            super(name, metadata);
            this.cardinality = cardinality;
        }

        public CardinalityUpperBound cardinality() {
            return this.cardinality;
        }

        public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
            aggregations.forEach(ia -> Assert.assertThat((Object)((InternalAggCardinality)ia).cardinality, (Matcher)Matchers.equalTo((Object)this.cardinality)));
            return new InternalAggCardinality(this.name, this.cardinality, this.metadata);
        }

        protected boolean mustReduceOnSingleInternalAgg() {
            return true;
        }

        public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.array("cardinality", new Object[]{this.cardinality});
        }

        public Object getProperty(List<String> path) {
            throw new UnsupportedOperationException();
        }

        public String getWriteableName() {
            throw new UnsupportedOperationException();
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

