/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remotestore.multipart.mocks;

import java.io.IOException;
import java.nio.file.Path;
import org.opensearch.OpenSearchException;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.fs.FsBlobStore;
import org.opensearch.remotestore.multipart.mocks.MockFsAsyncBlobContainer;

public class MockFsBlobStore
extends FsBlobStore {
    private final boolean triggerDataIntegrityFailure;

    public MockFsBlobStore(int bufferSizeInBytes, Path path, boolean readonly, boolean triggerDataIntegrityFailure) throws IOException {
        super(bufferSizeInBytes, path, readonly);
        this.triggerDataIntegrityFailure = triggerDataIntegrityFailure;
    }

    public BlobContainer blobContainer(BlobPath path) {
        try {
            return new MockFsAsyncBlobContainer(this, path, this.buildAndCreate(path), this.triggerDataIntegrityFailure);
        }
        catch (IOException ex) {
            throw new OpenSearchException("failed to create blob container", (Throwable)ex, new Object[0]);
        }
    }
}

