/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mockito.Mockito;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.lookup.SourceLookup;
import org.opensearch.test.OpenSearchTestCase;

public abstract class FieldTypeTestCase
extends OpenSearchTestCase {
    public static final QueryShardContext MOCK_QSC = FieldTypeTestCase.createMockQueryShardContext(true, false);
    public static final QueryShardContext MOCK_QSC_DISALLOW_EXPENSIVE = FieldTypeTestCase.createMockQueryShardContext(false, false);
    public static final QueryShardContext MOCK_QSC_ENABLE_INDEX_DOC_VALUES = FieldTypeTestCase.createMockQueryShardContext(true, true);

    protected QueryShardContext randomMockShardContext() {
        return FieldTypeTestCase.randomFrom(MOCK_QSC, MOCK_QSC_DISALLOW_EXPENSIVE);
    }

    static QueryShardContext createMockQueryShardContext(boolean allowExpensiveQueries, boolean keywordIndexOrDocValuesEnabled) {
        QueryShardContext queryShardContext = (QueryShardContext)Mockito.mock(QueryShardContext.class);
        Mockito.when((Object)queryShardContext.allowExpensiveQueries()).thenReturn((Object)allowExpensiveQueries);
        Mockito.when((Object)queryShardContext.keywordFieldIndexOrDocValuesEnabled()).thenReturn((Object)keywordIndexOrDocValuesEnabled);
        return queryShardContext;
    }

    public static List<?> fetchSourceValue(MappedFieldType fieldType, Object sourceValue) throws IOException {
        return FieldTypeTestCase.fetchSourceValue(fieldType, sourceValue, null);
    }

    public static List<?> fetchSourceValue(MappedFieldType fieldType, Object sourceValue, String format) throws IOException {
        String field = fieldType.name();
        QueryShardContext context = (QueryShardContext)Mockito.mock(QueryShardContext.class);
        Mockito.when((Object)context.sourcePath(field)).thenReturn(Set.of(field));
        ValueFetcher fetcher = fieldType.valueFetcher(context, null, format);
        SourceLookup lookup = new SourceLookup();
        lookup.setSource(Collections.singletonMap(field, sourceValue));
        return fetcher.fetchValues(lookup);
    }
}

