/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.opensearch.Version;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexService;
import org.opensearch.index.analysis.AnalyzerScope;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.MockFieldMapper;
import org.opensearch.test.OpenSearchSingleNodeTestCase;

@Deprecated
public abstract class FieldMapperTestCase<T extends FieldMapper.Builder<?>>
extends OpenSearchSingleNodeTestCase {
    protected final Settings SETTINGS = Settings.builder().put("index.version.created", Version.CURRENT).build();
    private final List<Modifier> modifiers = new ArrayList<Modifier>(Arrays.asList(new Modifier(this, "analyzer", false, (a, b) -> {
        a.indexAnalyzer(new NamedAnalyzer("standard", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        a.indexAnalyzer(new NamedAnalyzer("keyword", AnalyzerScope.INDEX, (Analyzer)new KeywordAnalyzer()));
    }), new Modifier(this, "boost", true, (a, b) -> {
        a.boost(1.1f);
        b.boost(1.2f);
    }), new Modifier(this, "doc_values", false, (a, b) -> {
        a.docValues(true);
        b.docValues(false);
    }), this.booleanModifier("eager_global_ordinals", true, (a, t) -> a.setEagerGlobalOrdinals(t.booleanValue())), this.booleanModifier("index", false, (a, t) -> a.index(t.booleanValue())), this.booleanModifier("norms", false, FieldMapper.Builder::omitNorms), new Modifier(this, "search_analyzer", true, (a, b) -> {
        a.searchAnalyzer(new NamedAnalyzer("standard", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        a.searchAnalyzer(new NamedAnalyzer("keyword", AnalyzerScope.INDEX, (Analyzer)new KeywordAnalyzer()));
    }), new Modifier(this, "search_quote_analyzer", true, (a, b) -> {
        a.searchQuoteAnalyzer(new NamedAnalyzer("standard", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer()));
        a.searchQuoteAnalyzer(new NamedAnalyzer("whitespace", AnalyzerScope.INDEX, (Analyzer)new WhitespaceAnalyzer()));
    }), new Modifier(this, "store", false, (a, b) -> {
        a.store(true);
        b.store(false);
    }), new Modifier(this, "term_vector", false, (a, b) -> {
        a.storeTermVectors(true);
        b.storeTermVectors(false);
    }), new Modifier(this, "term_vector_positions", false, (a, b) -> {
        a.storeTermVectors(true);
        b.storeTermVectors(true);
        a.storeTermVectorPositions(true);
        b.storeTermVectorPositions(false);
    }), new Modifier(this, "term_vector_payloads", false, (a, b) -> {
        a.storeTermVectors(true);
        b.storeTermVectors(true);
        a.storeTermVectorPositions(true);
        b.storeTermVectorPositions(true);
        a.storeTermVectorPayloads(true);
        b.storeTermVectorPayloads(false);
    }), new Modifier(this, "term_vector_offsets", false, (a, b) -> {
        a.storeTermVectors(true);
        b.storeTermVectors(true);
        a.storeTermVectorPositions(true);
        b.storeTermVectorPositions(true);
        a.storeTermVectorOffsets(true);
        b.storeTermVectorOffsets(false);
    })));

    private Modifier booleanModifier(String name, boolean updateable, BiConsumer<T, Boolean> method) {
        return new Modifier(this, name, updateable, (a, b) -> {
            method.accept(a, true);
            method.accept(b, false);
        });
    }

    protected Set<String> unsupportedProperties() {
        return Collections.emptySet();
    }

    protected void addModifier(String property, boolean updateable, BiConsumer<T, T> method) {
        this.modifiers.add(new Modifier(this, property, updateable, method));
    }

    protected void addBooleanModifier(String property, boolean updateable, BiConsumer<T, Boolean> method) {
        this.modifiers.add(new Modifier(this, property, updateable, (a, b) -> {
            method.accept(a, true);
            method.accept(b, false);
        }));
    }

    protected abstract T newBuilder();

    public void testMergeConflicts() {
        Mapper.BuilderContext context = new Mapper.BuilderContext(this.SETTINGS, new ContentPath(1));
        T builder1 = this.newBuilder();
        T builder2 = this.newBuilder();
        FieldMapper mapper = (FieldMapper)builder1.build(context);
        Object toMerge = (FieldMapper)builder2.build(context);
        mapper.merge((Mapper)toMerge);
        mapper = (FieldMapper)this.newBuilder().build(context);
        toMerge = new MockFieldMapper(this, "bogus"){

            @Override
            protected String contentType() {
                return "bogustype";
            }
        };
        IllegalArgumentException e = (IllegalArgumentException)FieldMapperTestCase.expectThrows(IllegalArgumentException.class, () -> FieldMapperTestCase.lambda$testMergeConflicts$0(mapper, (FieldMapper)toMerge));
        FieldMapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"cannot be changed from type"));
        FieldMapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"bogustype"));
        for (Modifier modifier : this.modifiers) {
            if (this.unsupportedProperties().contains(modifier.property)) continue;
            builder1 = this.newBuilder();
            builder2 = this.newBuilder();
            modifier.apply(builder1, builder2);
            FieldMapper mapper2 = (FieldMapper)builder1.build(context);
            FieldMapper toMerge2 = (FieldMapper)builder2.build(context);
            if (modifier.updateable) {
                mapper2.merge((Mapper)toMerge2);
                continue;
            }
            IllegalArgumentException e2 = (IllegalArgumentException)FieldMapperTestCase.expectThrows(IllegalArgumentException.class, (String)("Expected an error when merging property difference " + modifier.property), () -> mapper2.merge((Mapper)toMerge2));
            FieldMapperTestCase.assertThat((Object)e2.getMessage(), (Matcher)Matchers.containsString((String)modifier.property));
        }
    }

    public void testSerialization() throws IOException {
        for (Modifier modifier : this.modifiers) {
            if (this.unsupportedProperties().contains(modifier.property)) continue;
            T builder1 = this.newBuilder();
            T builder2 = this.newBuilder();
            modifier.apply(builder1, builder2);
            this.assertSerializes(modifier.property + "-a", builder1);
            this.assertSerializes(modifier.property + "-b", builder2);
        }
    }

    protected Settings getIndexMapperSettings() {
        return Settings.EMPTY;
    }

    protected void assertSerializes(String indexname, T builder) throws IOException {
        IndexService index = this.createIndex("serialize-" + indexname, this.getIndexMapperSettings());
        MapperService mapperService = index.mapperService();
        Mapper.BuilderContext context = new Mapper.BuilderContext(this.SETTINGS, new ContentPath(1));
        String mappings = this.mappingsToString((ToXContent)builder.build(context), false);
        String mappingsWithDefault = this.mappingsToString((ToXContent)builder.build(context), true);
        mapperService.merge("_doc", new CompressedXContent(mappings), MapperService.MergeReason.MAPPING_UPDATE);
        Mapper rebuilt = mapperService.documentMapper().mappers().getMapper(((FieldMapper.Builder)builder).name);
        String reparsed = this.mappingsToString((ToXContent)rebuilt, false);
        String reparsedWithDefault = this.mappingsToString((ToXContent)rebuilt, true);
        FieldMapperTestCase.assertThat((Object)reparsed, (Matcher)Matchers.equalTo((Object)mappings));
        FieldMapperTestCase.assertThat((Object)reparsedWithDefault, (Matcher)Matchers.equalTo((Object)mappingsWithDefault));
    }

    private String mappingsToString(ToXContent builder, boolean includeDefaults) throws IOException {
        ToXContent.Params params = includeDefaults ? new ToXContent.MapParams(Collections.singletonMap("include_defaults", "true")) : ToXContent.EMPTY_PARAMS;
        XContentBuilder x = JsonXContent.contentBuilder();
        x.startObject().startObject("properties");
        builder.toXContent(x, params);
        x.endObject().endObject();
        return x.toString();
    }

    private static /* synthetic */ void lambda$testMergeConflicts$0(FieldMapper mapper, FieldMapper toMerge) throws Throwable {
        mapper.merge((Mapper)toMerge);
    }

    private final class Modifier {
        final String property;
        final boolean updateable;
        final BiConsumer<T, T> modifier;

        Modifier(FieldMapperTestCase fieldMapperTestCase, String property, boolean updateable, BiConsumer<T, T> modifier) {
            this.property = property;
            this.updateable = updateable;
            this.modifier = modifier;
        }

        void apply(T first, T second) {
            this.modifier.accept(first, second);
        }
    }
}

