/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway;

import java.io.IOException;
import org.mockito.Mockito;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.coordination.PersistedStateRegistry;
import org.opensearch.cluster.metadata.Manifest;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataIndexUpgradeService;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.BigArrays;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.gateway.ClusterStateUpdaters;
import org.opensearch.gateway.GatewayMetaState;
import org.opensearch.gateway.MetaStateService;
import org.opensearch.gateway.PersistedClusterStateService;
import org.opensearch.gateway.remote.RemoteClusterStateService;
import org.opensearch.index.recovery.RemoteStoreRestoreService;
import org.opensearch.plugins.MetadataUpgrader;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class MockGatewayMetaState
extends GatewayMetaState {
    private final DiscoveryNode localNode;
    private final BigArrays bigArrays;
    private final RemoteClusterStateService remoteClusterStateService;
    private final RemoteStoreRestoreService remoteStoreRestoreService;
    private boolean prepareFullState = false;

    public MockGatewayMetaState(DiscoveryNode localNode, BigArrays bigArrays, boolean prepareFullState) {
        this(localNode, bigArrays);
        this.prepareFullState = prepareFullState;
    }

    public MockGatewayMetaState(DiscoveryNode localNode, BigArrays bigArrays) {
        this.localNode = localNode;
        this.bigArrays = bigArrays;
        this.remoteClusterStateService = (RemoteClusterStateService)Mockito.mock(RemoteClusterStateService.class);
        this.remoteStoreRestoreService = (RemoteStoreRestoreService)Mockito.mock(RemoteStoreRestoreService.class);
    }

    public MockGatewayMetaState(DiscoveryNode localNode, BigArrays bigArrays, RemoteClusterStateService remoteClusterStateService, RemoteStoreRestoreService remoteStoreRestoreService) {
        this.localNode = localNode;
        this.bigArrays = bigArrays;
        this.remoteClusterStateService = remoteClusterStateService;
        this.remoteStoreRestoreService = remoteStoreRestoreService;
    }

    Metadata upgradeMetadataForNode(Metadata metadata, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader) {
        return metadata;
    }

    ClusterState prepareInitialClusterState(TransportService transportService, ClusterService clusterService, ClusterState clusterState) {
        if (this.prepareFullState) {
            return super.prepareInitialClusterState(transportService, clusterService, clusterState);
        }
        return ClusterStateUpdaters.setLocalNode((ClusterState)clusterState, (DiscoveryNode)this.localNode);
    }

    public void close() throws IOException {
        super.close();
    }

    public void start(Settings settings, NodeEnvironment nodeEnvironment, NamedXContentRegistry xContentRegistry, PersistedStateRegistry persistedStateRegistry) {
        this.start(settings, nodeEnvironment, xContentRegistry, persistedStateRegistry, false);
    }

    public void start(Settings settings, NodeEnvironment nodeEnvironment, NamedXContentRegistry xContentRegistry, PersistedStateRegistry persistedStateRegistry, boolean prepareFullState) {
        TransportService transportService = (TransportService)Mockito.mock(TransportService.class);
        Mockito.when((Object)transportService.getThreadPool()).thenReturn((Object)((ThreadPool)Mockito.mock(ThreadPool.class)));
        ClusterService clusterService = (ClusterService)Mockito.mock(ClusterService.class);
        Mockito.when((Object)clusterService.getClusterSettings()).thenReturn((Object)new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
        MetaStateService metaStateService = (MetaStateService)Mockito.mock(MetaStateService.class);
        try {
            Mockito.when((Object)metaStateService.loadFullState()).thenReturn((Object)new Tuple((Object)Manifest.empty(), (Object)Metadata.builder().build()));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.prepareFullState = prepareFullState;
        this.start(settings, transportService, clusterService, metaStateService, null, null, new PersistedClusterStateService(nodeEnvironment, xContentRegistry, this.bigArrays, new ClusterSettings(settings, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), () -> 0L), this.remoteClusterStateService, persistedStateRegistry, this.remoteStoreRestoreService);
    }
}

