/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.hash;

import java.util.Locale;

public class AvalancheStats {
    private final int inputBits;
    private final int outputBits;
    private final double bias;
    private final double sumOfSquaredErrors;

    public AvalancheStats(int[][] flips, int iterations) {
        this.inputBits = flips.length;
        this.outputBits = flips[0].length;
        double sumOfBiases = 0.0;
        double sumOfSquaredErrors = 0.0;
        for (int i = 0; i < this.inputBits; ++i) {
            for (int o = 0; o < this.outputBits; ++o) {
                sumOfSquaredErrors += Math.pow(0.5 - (double)flips[i][o] / (double)iterations, 2.0);
                sumOfBiases += 2.0 * ((double)flips[i][o] / (double)iterations) - 1.0;
            }
        }
        this.bias = Math.abs(sumOfBiases / (double)(this.inputBits * this.outputBits));
        this.sumOfSquaredErrors = sumOfSquaredErrors;
    }

    public double bias() {
        return this.bias;
    }

    public double diffusion() {
        return 1.0 - this.bias;
    }

    public double sumOfSquaredErrors() {
        return this.sumOfSquaredErrors;
    }

    public String toString() {
        return String.format(Locale.ROOT, "AvalancheStats{inputBits=%d, outputBits=%d, bias=%.4f%%, diffusion=%.4f%%, sumOfSquaredErrors=%.2f}", this.inputBits, this.outputBits, this.bias() * 100.0, this.diffusion() * 100.0, this.sumOfSquaredErrors());
    }
}

