/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.opensearch.Version;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.VersionUtils;
import org.opensearch.test.rest.yaml.Features;
import org.opensearch.test.rest.yaml.section.ParserUtils;
import org.opensearch.test.rest.yaml.section.VersionRange;

public class SkipSection {
    public static final SkipSection EMPTY = new SkipSection();
    private final List<VersionRange> versionRanges;
    private final List<String> features;
    private final String reason;

    public static SkipSection parseIfNext(XContentParser parser) throws IOException {
        ParserUtils.advanceToFieldName(parser);
        if ("skip".equals(parser.currentName())) {
            SkipSection section = SkipSection.parse(parser);
            parser.nextToken();
            return section;
        }
        return EMPTY;
    }

    public static SkipSection parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Expected [" + String.valueOf(XContentParser.Token.START_OBJECT) + ", found [" + String.valueOf(parser.currentToken()) + "], the skip section is not properly indented");
        }
        String currentFieldName = null;
        String version = null;
        String reason = null;
        ArrayList<String> features = new ArrayList<String>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if ("version".equals(currentFieldName)) {
                    version = parser.text();
                    continue;
                }
                if ("reason".equals(currentFieldName)) {
                    reason = parser.text();
                    continue;
                }
                if ("features".equals(currentFieldName)) {
                    String f = parser.text();
                    String[] fs = f.split(",");
                    if (fs != null) {
                        for (String feature : fs) {
                            features.add(feature.trim());
                        }
                        continue;
                    }
                    features.add(f);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "field " + currentFieldName + " not supported within skip section", new Object[0]);
            }
            if (token != XContentParser.Token.START_ARRAY || !"features".equals(currentFieldName)) continue;
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                features.add(parser.text());
            }
        }
        parser.nextToken();
        if (!Strings.hasLength(version) && features.isEmpty()) {
            throw new ParsingException(parser.getTokenLocation(), "version or features is mandatory within skip section", new Object[0]);
        }
        if (Strings.hasLength(version) && !Strings.hasLength(reason)) {
            throw new ParsingException(parser.getTokenLocation(), "reason is mandatory within skip version section", new Object[0]);
        }
        return new SkipSection(version, features, reason);
    }

    private SkipSection() {
        this.versionRanges = new ArrayList<VersionRange>();
        this.features = new ArrayList<String>();
        this.reason = null;
    }

    public SkipSection(String versionRange, List<String> features, String reason) {
        assert (features != null);
        this.versionRanges = SkipSection.parseVersionRanges(versionRange);
        assert (!this.versionRanges.isEmpty());
        this.features = features;
        this.reason = reason;
    }

    public Version getLowerVersion() {
        return this.versionRanges.get(0).getLower();
    }

    public Version getUpperVersion() {
        return this.versionRanges.get(this.versionRanges.size() - 1).getUpper();
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean skip(Version currentVersion) {
        if (this.isEmpty()) {
            return false;
        }
        boolean skip = this.versionRanges.stream().anyMatch(range -> range.contains(currentVersion));
        return skip || !Features.areAllSupported(this.features);
    }

    public boolean isVersionCheck() {
        return this.features.isEmpty();
    }

    public boolean isEmpty() {
        return EMPTY.equals(this);
    }

    static List<VersionRange> parseVersionRanges(String rawRanges) {
        if (rawRanges == null) {
            return Collections.singletonList(new VersionRange(null, null));
        }
        if (rawRanges.trim().equals("all")) {
            return Collections.singletonList(new VersionRange(VersionUtils.getFirstVersion(), Version.CURRENT));
        }
        String[] ranges = rawRanges.split(",");
        ArrayList<VersionRange> versionRanges = new ArrayList<VersionRange>();
        for (String rawRange : ranges) {
            String[] skipVersions = rawRange.split("-", -1);
            if (skipVersions.length > 2) {
                throw new IllegalArgumentException("version range malformed: " + rawRanges);
            }
            String lower = skipVersions[0].trim();
            String upper = skipVersions[1].trim();
            VersionRange versionRange = new VersionRange(lower.isEmpty() ? VersionUtils.getFirstVersion() : Version.fromString((String)lower), upper.isEmpty() ? Version.CURRENT : Version.fromString((String)upper));
            versionRanges.add(versionRange);
        }
        return versionRanges;
    }

    public String getSkipMessage(String description) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("[").append(description).append("] skipped,");
        if (this.reason != null) {
            messageBuilder.append(" reason: [").append(this.getReason()).append("]");
        }
        if (!this.features.isEmpty()) {
            messageBuilder.append(" unsupported features ").append(this.getFeatures());
        }
        return messageBuilder.toString();
    }
}

