/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.Map;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.xcontent.XContentParser;

class ParserUtils {
    private ParserUtils() {
    }

    public static String parseField(XContentParser parser) throws IOException {
        parser.nextToken();
        assert (parser.currentToken().isValue());
        String field = parser.text();
        parser.nextToken();
        return field;
    }

    public static Tuple<String, Object> parseTuple(XContentParser parser) throws IOException {
        parser.nextToken();
        ParserUtils.advanceToFieldName(parser);
        Map map = parser.map();
        assert (parser.currentToken() == XContentParser.Token.END_OBJECT);
        parser.nextToken();
        if (map.size() != 1) {
            throw new IllegalArgumentException("expected key value pair but found an object with " + map.size() + " fields");
        }
        Map.Entry entry = map.entrySet().iterator().next();
        return Tuple.tuple((Object)((String)entry.getKey()), entry.getValue());
    }

    public static void advanceToFieldName(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_ARRAY) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        if (token != XContentParser.Token.FIELD_NAME) {
            throw new IllegalArgumentException("malformed test section: field name expected but found " + String.valueOf(token) + " at " + String.valueOf(parser.getTokenLocation()));
        }
    }
}

