/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.hamcrest;

import java.util.Arrays;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.opensearch.common.collect.Tuple;

public class TupleMatchers {
    public static <V1, V2> TupleMatcher<? extends V1, ? extends V2> isTuple(Matcher<? super V1> v1Matcher, Matcher<? super V2> v2Matcher) {
        return new TupleMatcher<V1, V2>(v1Matcher, v2Matcher);
    }

    private static class TupleMatcher<V1, V2>
    extends TypeSafeMatcher<Tuple<? extends V1, ? extends V2>> {
        private final Matcher<? super V1> v1Matcher;
        private final Matcher<? super V2> v2Matcher;

        private TupleMatcher(Matcher<? super V1> v1Matcher, Matcher<? super V2> v2Matcher) {
            this.v1Matcher = v1Matcher;
            this.v2Matcher = v2Matcher;
        }

        protected boolean matchesSafely(Tuple<? extends V1, ? extends V2> item) {
            return item != null && this.v1Matcher.matches(item.v1()) && this.v2Matcher.matches(item.v2());
        }

        public void describeTo(Description description) {
            description.appendText("expected tuple matching ").appendList("[", ", ", "]", Arrays.asList(this.v1Matcher, this.v2Matcher));
        }
    }
}

