/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import java.io.Closeable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.hc.core5.http.HttpHost;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;
import org.opensearch.action.admin.cluster.node.info.NodeInfo;
import org.opensearch.action.admin.cluster.node.info.NodesInfoResponse;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.Nullable;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.common.transport.TransportAddress;
import org.opensearch.http.HttpInfo;
import org.opensearch.rest.action.RestCancellableNodeClient;
import org.opensearch.test.InternalTestCluster;
import org.opensearch.test.OpenSearchIntegTestCase;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.ParameterizedOpenSearchIntegTestCase;
import org.opensearch.test.TestCluster;
import org.opensearch.test.client.RandomizingClient;
import org.opensearch.test.telemetry.tracing.StrictCheckSpanProcessor;
import org.opensearch.transport.client.Client;

class OpenSearchTestClusterRule
implements MethodRule {
    private final Map<TestCluster, OpenSearchIntegTestCase> suites = new IdentityHashMap<TestCluster, OpenSearchIntegTestCase>();
    private final Map<Class<?>, TestCluster> clusters = new IdentityHashMap();
    private final Logger logger = LogManager.getLogger(this.getClass());
    private TestCluster currentCluster = null;
    private RestClient restClient = null;
    private OpenSearchIntegTestCase suiteInstance = null;
    private Long suiteSeed = null;

    OpenSearchTestClusterRule() {
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        return this.statement(base, method, target);
    }

    void beforeClass() throws Exception {
        this.suiteSeed = OpenSearchTestCase.randomLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterClass() throws Exception {
        try {
            if (this.runTestScopeLifecycle()) {
                this.clearClusters();
            } else {
                this.printTestMessage("cleaning up after");
                this.afterInternal(true, null);
                OpenSearchTestCase.checkStaticState(true);
                Map<Class<?>, TestCluster> map = this.clusters;
                synchronized (map) {
                    TestCluster cluster = this.clusters.remove(OpenSearchTestClusterRule.getTestClass());
                    IOUtils.closeWhileHandlingException((Closeable)cluster);
                    if (cluster != null) {
                        this.suites.remove(cluster);
                    }
                }
            }
            StrictCheckSpanProcessor.validateTracingStateOnShutdown();
        }
        finally {
            this.suiteSeed = null;
            this.currentCluster = null;
            this.suiteInstance = null;
        }
    }

    TestCluster cluster() {
        return this.currentCluster;
    }

    boolean isInternalCluster() {
        return this.cluster() instanceof InternalTestCluster;
    }

    Optional<InternalTestCluster> internalCluster() {
        if (!this.isInternalCluster()) {
            return Optional.empty();
        }
        return Optional.of((InternalTestCluster)this.cluster());
    }

    Client clientForAnyNode() {
        return this.clientForNode(null);
    }

    Client clientForNode(@Nullable String node) {
        if (node != null) {
            return this.internalCluster().orElseThrow(() -> new UnsupportedOperationException("current test cluster is immutable")).client(node);
        }
        Object client = this.cluster().client();
        if (OpenSearchTestCase.frequently()) {
            client = new RandomizingClient((Client)client, OpenSearchTestCase.random());
        }
        return client;
    }

    synchronized RestClient getRestClient() {
        if (this.restClient == null) {
            this.restClient = this.createRestClient();
        }
        return this.restClient;
    }

    protected final void beforeInternal(OpenSearchIntegTestCase target) throws Exception {
        OpenSearchIntegTestCase.Scope currentClusterScope = this.getClusterScope(((Object)((Object)target)).getClass());
        Callable<Void> setup = () -> {
            this.currentCluster.beforeTest(OpenSearchTestCase.random());
            this.currentCluster.wipe(target.excludeTemplates());
            target.randomIndexTemplate();
            return null;
        };
        switch (currentClusterScope) {
            case SUITE: {
                assert (this.suiteSeed != null) : "Suite seed was not initialized";
                this.currentCluster = this.buildAndPutCluster(currentClusterScope, this.suiteSeed, target);
                RandomizedContext.current().runWithPrivateRandomness(this.suiteSeed.longValue(), setup);
                break;
            }
            case TEST: {
                this.currentCluster = this.buildAndPutCluster(currentClusterScope, OpenSearchTestCase.randomLong(), target);
                setup.call();
            }
        }
    }

    protected void before(Object target, FrameworkMethod method) throws Throwable {
        OpenSearchIntegTestCase instance = (OpenSearchIntegTestCase)((Object)target);
        this.initializeSuiteScope(instance, method);
        if (this.runTestScopeLifecycle()) {
            this.printTestMessage("setting up", method);
            this.beforeInternal(instance);
            this.printTestMessage("all set up", method);
        }
    }

    protected void after(Object target, FrameworkMethod method) throws Exception {
        OpenSearchIntegTestCase instance = (OpenSearchIntegTestCase)((Object)target);
        this.internalCluster().ifPresent(c -> c.setBootstrapClusterManagerNodeIndex(-1));
        instance.ensureAllSearchContextsReleased();
        if (this.runTestScopeLifecycle()) {
            this.printTestMessage("cleaning up after", method);
            this.afterInternal(false, instance);
            this.printTestMessage("cleaned up after", method);
        }
    }

    protected RestClient createRestClient() {
        return this.createRestClient(null, "http");
    }

    protected RestClient createRestClient(RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback, String protocol) {
        NodesInfoResponse nodesInfoResponse = (NodesInfoResponse)this.clientForAnyNode().admin().cluster().prepareNodesInfo(new String[0]).get();
        Assert.assertFalse((boolean)nodesInfoResponse.hasFailures());
        return this.createRestClient(nodesInfoResponse.getNodes(), httpClientConfigCallback, protocol);
    }

    protected RestClient createRestClient(List<NodeInfo> nodes, RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback, String protocol) {
        ArrayList<HttpHost> hosts = new ArrayList<HttpHost>();
        for (NodeInfo node : nodes) {
            if (node.getInfo(HttpInfo.class) == null) continue;
            TransportAddress publishAddress = ((HttpInfo)node.getInfo(HttpInfo.class)).address().publishAddress();
            InetSocketAddress address = publishAddress.address();
            hosts.add(new HttpHost(protocol, NetworkAddress.format((InetAddress)address.getAddress()), address.getPort()));
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]));
        if (httpClientConfigCallback != null) {
            builder.setHttpClientConfigCallback(httpClientConfigCallback);
        }
        return builder.build();
    }

    private OpenSearchIntegTestCase.Scope getClusterScope(Class<?> clazz) {
        OpenSearchIntegTestCase.ClusterScope annotation = OpenSearchIntegTestCase.getAnnotation(clazz, OpenSearchIntegTestCase.ClusterScope.class);
        return annotation == null ? OpenSearchIntegTestCase.Scope.SUITE : annotation.scope();
    }

    private TestCluster buildWithPrivateContext(OpenSearchIntegTestCase.Scope scope, long seed, OpenSearchIntegTestCase target) throws Exception {
        return (TestCluster)RandomizedContext.current().runWithPrivateRandomness(seed, () -> target.buildTestCluster(scope, seed));
    }

    private static boolean isSuiteScopedTest(Class<?> clazz) {
        return clazz.getAnnotation(OpenSearchIntegTestCase.SuiteScopeTestCase.class) != null;
    }

    private static boolean hasParametersChanged(ParameterizedOpenSearchIntegTestCase instance, ParameterizedOpenSearchIntegTestCase target) {
        return !instance.hasSameParametersAs(target);
    }

    private boolean runTestScopeLifecycle() {
        return this.suiteInstance == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestCluster buildAndPutCluster(OpenSearchIntegTestCase.Scope currentClusterScope, long seed, OpenSearchIntegTestCase target) throws Exception {
        Class<?> clazz = ((Object)((Object)target)).getClass();
        Map<Class<?>, TestCluster> map = this.clusters;
        synchronized (map) {
            TestCluster testCluster = this.clusters.remove(clazz);
            this.clearClusters();
            switch (currentClusterScope) {
                case SUITE: {
                    OpenSearchIntegTestCase instance;
                    if (testCluster != null && target instanceof ParameterizedOpenSearchIntegTestCase && (instance = this.suites.get(testCluster)) != null) {
                        assert (instance instanceof ParameterizedOpenSearchIntegTestCase);
                        if (OpenSearchTestClusterRule.hasParametersChanged((ParameterizedOpenSearchIntegTestCase)instance, (ParameterizedOpenSearchIntegTestCase)target)) {
                            IOUtils.closeWhileHandlingException((Closeable)testCluster);
                            this.printTestMessage("new instance of parameterized test class, recreating test cluster for suite");
                            testCluster = null;
                        }
                    }
                    if (testCluster != null) break;
                    testCluster = this.buildWithPrivateContext(currentClusterScope, seed, target);
                    this.suites.put(testCluster, target);
                    break;
                }
                case TEST: {
                    IOUtils.closeWhileHandlingException((Closeable)testCluster);
                    testCluster = target.buildTestCluster(currentClusterScope, seed);
                }
            }
            this.clusters.put(clazz, testCluster);
            return testCluster;
        }
    }

    private void printTestMessage(String message) {
        this.logger.info("[{}]: {} suite", (Object)OpenSearchTestClusterRule.getTestClass().getSimpleName(), (Object)message);
    }

    private static Class<?> getTestClass() {
        return OpenSearchTestCase.getTestClass();
    }

    private void printTestMessage(String message, FrameworkMethod method) {
        this.logger.info("[{}#{}]: {} test", (Object)OpenSearchTestClusterRule.getTestClass().getSimpleName(), (Object)method.getName(), (Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void afterInternal(boolean afterClass, OpenSearchIntegTestCase target) throws Exception {
        OpenSearchIntegTestCase.Scope currentClusterScope = this.getClusterScope(OpenSearchTestClusterRule.getTestClass());
        this.internalCluster().ifPresent(InternalTestCluster::clearDisruptionScheme);
        OpenSearchIntegTestCase instance = this.suiteInstance;
        if (instance == null) {
            instance = target;
        }
        try {
            if (this.cluster() != null) {
                if (currentClusterScope != OpenSearchIntegTestCase.Scope.TEST) {
                    Metadata metadata = ((ClusterStateResponse)this.clientForAnyNode().admin().cluster().prepareState().execute().actionGet()).getState().getMetadata();
                    HashSet persistentKeys = new HashSet(metadata.persistentSettings().keySet());
                    Assert.assertThat((String)"test leaves persistent cluster metadata behind", persistentKeys, (Matcher)Matchers.empty());
                    HashSet transientKeys = new HashSet(metadata.transientSettings().keySet());
                    Assert.assertThat((String)"test leaves transient cluster metadata behind", transientKeys, (Matcher)Matchers.empty());
                }
                instance.ensureClusterSizeConsistency();
                instance.ensureClusterStateConsistency();
                instance.ensureClusterStateCanBeReadByNodeTool();
                instance.beforeIndexDeletion();
                this.cluster().wipe(instance.excludeTemplates());
                if (afterClass || currentClusterScope == OpenSearchIntegTestCase.Scope.TEST) {
                    this.cluster().close();
                }
                this.cluster().assertAfterTest();
            }
        }
        finally {
            if (currentClusterScope == OpenSearchIntegTestCase.Scope.TEST) {
                this.clearClusters();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearClusters() throws Exception {
        Map<Class<?>, TestCluster> map = this.clusters;
        synchronized (map) {
            if (!this.clusters.isEmpty()) {
                IOUtils.close(this.clusters.values());
                this.suites.clear();
                this.clusters.clear();
            }
        }
        if (this.restClient != null) {
            this.restClient.close();
            this.restClient = null;
        }
        OpenSearchTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            int numChannels = RestCancellableNodeClient.getNumChannels();
            OpenSearchTestCase.assertEquals((String)(numChannels + " channels still being tracked in " + RestCancellableNodeClient.class.getSimpleName() + " while there should be none"), (long)0L, (long)numChannels);
        }));
    }

    private Statement statement(final Statement base, final FrameworkMethod method, final Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                OpenSearchTestClusterRule.this.before(target, method);
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    errors.add(t);
                }
                finally {
                    try {
                        OpenSearchTestClusterRule.this.after(target, method);
                    }
                    catch (Throwable t) {
                        errors.add(t);
                    }
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeSuiteScope(OpenSearchIntegTestCase target, FrameworkMethod method) throws Exception {
        Class<?> targetClass = OpenSearchTestClusterRule.getTestClass();
        if (this.suiteInstance != null) {
            if (!(target instanceof ParameterizedOpenSearchIntegTestCase)) return;
            assert (this.suiteInstance instanceof ParameterizedOpenSearchIntegTestCase);
            if (!OpenSearchTestClusterRule.hasParametersChanged((ParameterizedOpenSearchIntegTestCase)this.suiteInstance, (ParameterizedOpenSearchIntegTestCase)target)) return;
            this.printTestMessage("new instance of parameterized test class, recreating cluster scope", method);
            this.afterClass();
            this.beforeClass();
        }
        assert (this.suiteInstance == null);
        if (OpenSearchTestClusterRule.isSuiteScopedTest(targetClass)) {
            this.suiteInstance = target;
            boolean success = false;
            try {
                this.printTestMessage("setup", method);
                this.beforeInternal(target);
                this.suiteInstance.setupSuiteScopeCluster();
                success = true;
                return;
            }
            finally {
                if (!success) {
                    this.afterClass();
                }
            }
        } else {
            this.suiteInstance = null;
        }
    }
}

