/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class KeyStoreUtils {
    public static final char[] KEYSTORE_PASSWORD = "keystore_password".toCharArray();

    public static KeyStore createServerKeyStore() throws Exception {
        X500PrivateCredential serverCred = KeyStoreUtils.createCredential();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        keyStore.setKeyEntry(serverCred.getAlias(), serverCred.getPrivateKey(), KEYSTORE_PASSWORD, new X509Certificate[]{serverCred.getCertificate()});
        return keyStore;
    }

    private static X500PrivateCredential createCredential() throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509Certificate rootCert = new JcaX509CertificateConverter().getCertificate(KeyStoreUtils.generateCert(keyPair));
        return new X500PrivateCredential(rootCert, keyPair.getPrivate(), "server-ca");
    }

    private static X509CertificateHolder generateCert(KeyPair pair) throws Exception {
        long baseTime = System.currentTimeMillis();
        long validityPeriod = 315360000000L;
        JcaX509v1CertificateBuilder certBuilder = new JcaX509v1CertificateBuilder(new X500Principal("CN=Test CA Certificate"), BigInteger.valueOf(1L), new Date(baseTime), new Date(baseTime + validityPeriod), new X500Principal("CN=Test CA Certificate"), pair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(pair.getPrivate());
        return certBuilder.build(signer);
    }
}

