/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.SeedUtils;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Accountable;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.termvectors.MultiTermVectorsRequest;
import org.opensearch.action.termvectors.MultiTermVectorsResponse;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsModule;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.env.TestEnvironment;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.cache.bitset.BitsetFilterCache;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.fielddata.IndexFieldDataService;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.indices.IndicesModule;
import org.opensearch.indices.analysis.AnalysisModule;
import org.opensearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.opensearch.indices.mapper.MapperRegistry;
import org.opensearch.node.InternalSettingsPreparer;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.PluginsService;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.script.MockScriptEngine;
import org.opensearch.script.MockScriptService;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptModule;
import org.opensearch.script.ScriptService;
import org.opensearch.search.SearchModule;
import org.opensearch.test.AbstractQueryTestCase;
import org.opensearch.test.IndexSettingsModule;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.TestGeoShapeFieldMapperPlugin;
import org.opensearch.test.VersionUtils;
import org.opensearch.transport.client.Client;

public abstract class AbstractBuilderTestCase
extends OpenSearchTestCase {
    public static final String TEXT_FIELD_NAME = "mapped_string";
    public static final String TEXT_ALIAS_FIELD_NAME = "mapped_string_alias";
    protected static final String KEYWORD_FIELD_NAME = "mapped_string_2";
    protected static final String INT_FIELD_NAME = "mapped_int";
    protected static final String INT_ALIAS_FIELD_NAME = "mapped_int_field_alias";
    protected static final String INT_RANGE_FIELD_NAME = "mapped_int_range";
    protected static final String DOUBLE_FIELD_NAME = "mapped_double";
    protected static final String BOOLEAN_FIELD_NAME = "mapped_boolean";
    protected static final String DATE_NANOS_FIELD_NAME = "mapped_date_nanos";
    protected static final String DATE_FIELD_NAME = "mapped_date";
    protected static final String DATE_ALIAS_FIELD_NAME = "mapped_date_alias";
    protected static final String DATE_RANGE_FIELD_NAME = "mapped_date_range";
    protected static final String OBJECT_FIELD_NAME = "mapped_object";
    protected static final String GEO_POINT_FIELD_NAME = "mapped_geo_point";
    protected static final String GEO_POINT_ALIAS_FIELD_NAME = "mapped_geo_point_alias";
    protected static final String GEO_SHAPE_FIELD_NAME = "mapped_geo_shape";
    protected static final String[] MAPPED_FIELD_NAMES = new String[]{"mapped_string", "mapped_string_alias", "mapped_int", "mapped_int_range", "mapped_double", "mapped_boolean", "mapped_date_nanos", "mapped_date", "mapped_date_range", "mapped_object", "mapped_geo_point", "mapped_geo_point_alias", "mapped_geo_shape"};
    protected static final String[] MAPPED_LEAF_FIELD_NAMES = new String[]{"mapped_string", "mapped_string_alias", "mapped_int", "mapped_int_range", "mapped_double", "mapped_boolean", "mapped_date_nanos", "mapped_date", "mapped_date_range", "mapped_geo_point", "mapped_geo_point_alias"};
    private static final Map<String, String> ALIAS_TO_CONCRETE_FIELD_NAME = new HashMap<String, String>();
    private static ServiceHolder serviceHolder;
    private static ServiceHolder serviceHolderWithNoType;
    private static int queryNameId;
    private static Settings nodeSettings;
    private static Index index;
    private static long nowInMillis;

    protected static Index getIndex() {
        return index;
    }

    protected Collection<Class<? extends Plugin>> getPlugins() {
        return Collections.singletonList(TestGeoShapeFieldMapperPlugin.class);
    }

    protected void initializeAdditionalMappings(MapperService mapperService) throws IOException {
    }

    @BeforeClass
    public static void beforeClass() {
        nodeSettings = Settings.builder().put("node.name", AbstractQueryTestCase.class.toString()).put(Environment.PATH_HOME_SETTING.getKey(), AbstractBuilderTestCase.createTempDir()).build();
        index = new Index(AbstractBuilderTestCase.randomAlphaOfLengthBetween(1, 10), AbstractBuilderTestCase.randomAlphaOfLength(10));
        nowInMillis = AbstractBuilderTestCase.randomNonNegativeLong();
    }

    @Override
    protected NamedXContentRegistry xContentRegistry() {
        return AbstractBuilderTestCase.serviceHolder.xContentRegistry;
    }

    protected NamedWriteableRegistry namedWriteableRegistry() {
        return AbstractBuilderTestCase.serviceHolder.namedWriteableRegistry;
    }

    protected static String createUniqueRandomName() {
        String queryName = AbstractBuilderTestCase.randomAlphaOfLengthBetween(1, 10) + queryNameId;
        ++queryNameId;
        return queryName;
    }

    protected Settings createTestIndexSettings() {
        Version indexVersionCreated = AbstractBuilderTestCase.randomBoolean() ? Version.CURRENT : VersionUtils.randomIndexCompatibleVersion(AbstractBuilderTestCase.random());
        return Settings.builder().put("index.version.created", indexVersionCreated).build();
    }

    protected static IndexSettings indexSettings() {
        return AbstractBuilderTestCase.serviceHolder.idxSettings;
    }

    protected static String expectedFieldName(String builderFieldName) {
        return ALIAS_TO_CONCRETE_FIELD_NAME.getOrDefault(builderFieldName, builderFieldName);
    }

    protected Iterable<MappedFieldType> getMapping() {
        return AbstractBuilderTestCase.serviceHolder.mapperService.fieldTypes();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        IOUtils.close((Closeable)serviceHolder);
        IOUtils.close((Closeable)serviceHolderWithNoType);
        serviceHolder = null;
        serviceHolderWithNoType = null;
    }

    @Before
    public void beforeTest() throws Exception {
        if (serviceHolder == null) {
            assert (serviceHolderWithNoType == null);
            long clusterManagerSeed = SeedUtils.parseSeed((String)RandomizedTest.getContext().getRunnerSeedAsString());
            RandomizedTest.getContext().runWithPrivateRandomness(clusterManagerSeed, () -> {
                serviceHolder = new ServiceHolder(nodeSettings, this.createTestIndexSettings(), this.getPlugins(), nowInMillis, this, true);
                serviceHolderWithNoType = new ServiceHolder(nodeSettings, this.createTestIndexSettings(), this.getPlugins(), nowInMillis, this, false);
                return null;
            });
        }
        AbstractBuilderTestCase.serviceHolder.clientInvocationHandler.delegate = this;
        AbstractBuilderTestCase.serviceHolderWithNoType.clientInvocationHandler.delegate = this;
    }

    @After
    public void afterTest() {
        AbstractBuilderTestCase.serviceHolder.clientInvocationHandler.delegate = null;
        AbstractBuilderTestCase.serviceHolderWithNoType.clientInvocationHandler.delegate = null;
    }

    protected GetResponse executeGet(GetRequest getRequest) {
        throw new UnsupportedOperationException("this test can't handle GET requests");
    }

    protected MultiTermVectorsResponse executeMultiTermVectors(MultiTermVectorsRequest mtvRequest) {
        throw new UnsupportedOperationException("this test can't handle MultiTermVector requests");
    }

    protected static QueryShardContext createShardContext(IndexSearcher searcher) {
        return serviceHolder.createShardContext(searcher);
    }

    protected static QueryShardContext createShardContextWithNoType() {
        return serviceHolderWithNoType.createShardContext(null);
    }

    protected static QueryShardContext createShardContext() {
        return AbstractBuilderTestCase.createShardContext(null);
    }

    protected static QueryBuilderVisitor createTestVisitor(final List<QueryBuilder> visitedQueries) {
        return new QueryBuilderVisitor(){

            public void accept(QueryBuilder qb) {
                visitedQueries.add(qb);
            }

            public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
                return this;
            }
        };
    }

    static {
        ALIAS_TO_CONCRETE_FIELD_NAME.put(TEXT_ALIAS_FIELD_NAME, TEXT_FIELD_NAME);
        ALIAS_TO_CONCRETE_FIELD_NAME.put(INT_ALIAS_FIELD_NAME, INT_FIELD_NAME);
        ALIAS_TO_CONCRETE_FIELD_NAME.put(DATE_ALIAS_FIELD_NAME, DATE_FIELD_NAME);
        ALIAS_TO_CONCRETE_FIELD_NAME.put(GEO_POINT_ALIAS_FIELD_NAME, GEO_POINT_FIELD_NAME);
        queryNameId = 0;
    }

    private static class ServiceHolder
    implements Closeable {
        private final IndexFieldDataService indexFieldDataService;
        private final SearchModule searchModule;
        private final NamedWriteableRegistry namedWriteableRegistry;
        private final NamedXContentRegistry xContentRegistry;
        private final ClientInvocationHandler clientInvocationHandler = new ClientInvocationHandler();
        private final IndexSettings idxSettings;
        private final SimilarityService similarityService;
        private final MapperService mapperService;
        private final BitsetFilterCache bitsetFilterCache;
        private final ScriptService scriptService;
        private final Client client;
        private final long nowInMillis;

        ServiceHolder(Settings nodeSettings, Settings indexSettings, Collection<Class<? extends Plugin>> plugins, long nowInMillis, AbstractBuilderTestCase testCase, boolean registerType) throws IOException {
            this.nowInMillis = nowInMillis;
            Environment env = InternalSettingsPreparer.prepareEnvironment((Settings)nodeSettings, Collections.emptyMap(), null, () -> {
                throw new AssertionError((Object)"node.name must be set");
            });
            PluginsService pluginsService = new PluginsService(nodeSettings, null, env.modulesDir(), env.pluginsDir(), plugins);
            this.client = (Client)Proxy.newProxyInstance(Client.class.getClassLoader(), new Class[]{Client.class}, (InvocationHandler)this.clientInvocationHandler);
            ScriptModule scriptModule = this.createScriptModule(pluginsService.filterPlugins(ScriptPlugin.class));
            List additionalSettings = pluginsService.getPluginSettings();
            SettingsModule settingsModule = new SettingsModule(nodeSettings, additionalSettings, pluginsService.getPluginSettingsFilter(), Collections.emptySet());
            this.searchModule = new SearchModule(nodeSettings, pluginsService.filterPlugins(SearchPlugin.class));
            IndicesModule indicesModule = new IndicesModule(pluginsService.filterPlugins(MapperPlugin.class));
            ArrayList entries = new ArrayList();
            entries.addAll(indicesModule.getNamedWriteables());
            entries.addAll(this.searchModule.getNamedWriteables());
            this.namedWriteableRegistry = new NamedWriteableRegistry(entries);
            this.xContentRegistry = new NamedXContentRegistry(Stream.of(this.searchModule.getNamedXContents().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            IndexScopedSettings indexScopedSettings = settingsModule.getIndexScopedSettings();
            this.idxSettings = IndexSettingsModule.newIndexSettings(index, indexSettings, indexScopedSettings);
            AnalysisModule analysisModule = new AnalysisModule(TestEnvironment.newEnvironment(nodeSettings), Collections.emptyList());
            IndexAnalyzers indexAnalyzers = analysisModule.getAnalysisRegistry().build(this.idxSettings);
            this.scriptService = new MockScriptService(Settings.EMPTY, scriptModule.engines, scriptModule.contexts);
            this.similarityService = new SimilarityService(this.idxSettings, null, Collections.emptyMap());
            MapperRegistry mapperRegistry = indicesModule.getMapperRegistry();
            this.mapperService = new MapperService(this.idxSettings, indexAnalyzers, this.xContentRegistry, this.similarityService, mapperRegistry, () -> this.createShardContext(null), () -> false, null);
            IndicesFieldDataCache indicesFieldDataCache = new IndicesFieldDataCache(nodeSettings, new IndexFieldDataCache.Listener(this){});
            this.indexFieldDataService = new IndexFieldDataService(this.idxSettings, indicesFieldDataCache, (CircuitBreakerService)new NoneCircuitBreakerService(), this.mapperService);
            this.bitsetFilterCache = new BitsetFilterCache(this.idxSettings, new BitsetFilterCache.Listener(this){

                public void onCache(ShardId shardId, Accountable accountable) {
                }

                public void onRemoval(ShardId shardId, Accountable accountable) {
                }
            });
            if (registerType) {
                this.mapperService.merge("_doc", new CompressedXContent(PutMappingRequest.simpleMapping((String[])new String[]{AbstractBuilderTestCase.TEXT_FIELD_NAME, "type=text", AbstractBuilderTestCase.KEYWORD_FIELD_NAME, "type=keyword", AbstractBuilderTestCase.TEXT_ALIAS_FIELD_NAME, "type=alias,path=mapped_string", AbstractBuilderTestCase.INT_FIELD_NAME, "type=integer", AbstractBuilderTestCase.INT_ALIAS_FIELD_NAME, "type=alias,path=mapped_int", AbstractBuilderTestCase.INT_RANGE_FIELD_NAME, "type=integer_range", AbstractBuilderTestCase.DOUBLE_FIELD_NAME, "type=double", AbstractBuilderTestCase.BOOLEAN_FIELD_NAME, "type=boolean", AbstractBuilderTestCase.DATE_NANOS_FIELD_NAME, "type=date_nanos", AbstractBuilderTestCase.DATE_FIELD_NAME, "type=date", AbstractBuilderTestCase.DATE_ALIAS_FIELD_NAME, "type=alias,path=mapped_date", AbstractBuilderTestCase.DATE_RANGE_FIELD_NAME, "type=date_range", AbstractBuilderTestCase.OBJECT_FIELD_NAME, "type=object", AbstractBuilderTestCase.GEO_POINT_FIELD_NAME, "type=geo_point", AbstractBuilderTestCase.GEO_POINT_ALIAS_FIELD_NAME, "type=alias,path=mapped_geo_point", AbstractBuilderTestCase.GEO_SHAPE_FIELD_NAME, "type=geo_shape"}).toString()), MapperService.MergeReason.MAPPING_UPDATE);
                this.mapperService.merge("_doc", new CompressedXContent("{\"properties\":{\"mapped_object\":{\"type\":\"object\",\"properties\":{\"mapped_date\":{\"type\":\"date\"},\"mapped_int\":{\"type\":\"integer\"}}}}}"), MapperService.MergeReason.MAPPING_UPDATE);
                testCase.initializeAdditionalMappings(this.mapperService);
            }
        }

        public static Predicate<String> indexNameMatcher() {
            return pattern -> Regex.simpleMatch((String)pattern, (String)index.getName());
        }

        @Override
        public void close() throws IOException {
        }

        QueryShardContext createShardContext(IndexSearcher searcher) {
            return new QueryShardContext(0, this.idxSettings, BigArrays.NON_RECYCLING_INSTANCE, this.bitsetFilterCache, (arg_0, arg_1, arg_2) -> ((IndexFieldDataService)this.indexFieldDataService).getForField(arg_0, arg_1, arg_2), this.mapperService, this.similarityService, this.scriptService, this.xContentRegistry, this.namedWriteableRegistry, this.client, searcher, () -> this.nowInMillis, null, ServiceHolder.indexNameMatcher(), () -> true, null);
        }

        ScriptModule createScriptModule(List<ScriptPlugin> scriptPlugins) {
            if (scriptPlugins == null || scriptPlugins.isEmpty()) {
                return new ScriptModule(Settings.EMPTY, Collections.singletonList(new ScriptPlugin(this){

                    public ScriptEngine getScriptEngine(Settings settings, Collection<ScriptContext<?>> contexts) {
                        return new MockScriptEngine("mockscript", Collections.singletonMap("1", script -> "1"), Collections.emptyMap());
                    }
                }));
            }
            return new ScriptModule(Settings.EMPTY, scriptPlugins);
        }
    }

    private static class ClientInvocationHandler
    implements InvocationHandler {
        AbstractBuilderTestCase delegate;

        private ClientInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, final Object[] args) throws Throwable {
            if (method.equals(Client.class.getMethod("get", GetRequest.class, ActionListener.class))) {
                GetResponse getResponse = this.delegate.executeGet((GetRequest)args[0]);
                ActionListener listener = (ActionListener)args[1];
                if (OpenSearchTestCase.randomBoolean()) {
                    listener.onResponse((Object)getResponse);
                } else {
                    new Thread(() -> listener.onResponse((Object)getResponse)).start();
                }
                return null;
            }
            if (method.equals(Client.class.getMethod("multiTermVectors", MultiTermVectorsRequest.class))) {
                return new PlainActionFuture<MultiTermVectorsResponse>(){

                    public MultiTermVectorsResponse get() throws InterruptedException, ExecutionException {
                        return delegate.executeMultiTermVectors((MultiTermVectorsRequest)args[0]);
                    }
                };
            }
            if (method.equals(Object.class.getMethod("toString", new Class[0]))) {
                return "MockClient";
            }
            throw new UnsupportedOperationException("this test can't handle calls to: " + String.valueOf(method));
        }
    }
}

