/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.script;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.opensearch.common.settings.Settings;
import org.opensearch.plugins.Plugin;
import org.opensearch.script.ScriptContext;
import org.opensearch.script.ScriptEngine;
import org.opensearch.script.ScriptService;
import org.opensearch.script.StoredScriptSource;

public class MockScriptService
extends ScriptService {
    public MockScriptService(Settings settings, Map<String, ScriptEngine> engines, Map<String, ScriptContext<?>> contexts) {
        super(settings, engines, contexts);
    }

    boolean compilationLimitsEnabled() {
        return false;
    }

    public static <T> MockScriptService singleContext(final ScriptContext<T> context, final Function<String, T> compile, final Map<String, StoredScriptSource> storedLookup) {
        ScriptEngine engine = new ScriptEngine(){

            public String getType() {
                return "lang";
            }

            public <FactoryType> FactoryType compile(String name, String code, ScriptContext<FactoryType> context2, Map<String, String> params) {
                return (FactoryType)context2.factoryClazz.cast(compile.apply(code));
            }

            public Set<ScriptContext<?>> getSupportedContexts() {
                return Set.of(context);
            }
        };
        return new MockScriptService(Settings.EMPTY, Map.of("lang", engine), Map.of(context.name, context)){

            protected StoredScriptSource getScriptFromClusterState(String id) {
                return (StoredScriptSource)storedLookup.get(id);
            }
        };
    }

    public static class TestPlugin
    extends Plugin {
    }
}

