/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remotestore;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.admin.indices.flush.FlushRequest;
import org.opensearch.action.admin.indices.recovery.RecoveryResponse;
import org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchPhaseExecutionException;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.cluster.health.ClusterHealthStatus;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.allocation.command.AllocationCommand;
import org.opensearch.cluster.routing.allocation.command.MoveAllocationCommand;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.Priority;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.BufferedAsyncIOProcessor;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.remote.RemoteStoreEnums;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.IndexShardClosedException;
import org.opensearch.index.shard.IndexShardTestCase;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.RemoteStoreSettings;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.plugins.Plugin;
import org.opensearch.remotestore.RemoteStoreBaseIntegTestCase;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotState;
import org.opensearch.test.InternalTestCluster;
import org.opensearch.test.OpenSearchIntegTestCase;
import org.opensearch.test.hamcrest.OpenSearchAssertions;
import org.opensearch.test.transport.MockTransportService;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Requests;

@OpenSearchIntegTestCase.ClusterScope(scope=OpenSearchIntegTestCase.Scope.TEST, numDataNodes=0)
public class RemoteStoreCoreTestCase
extends RemoteStoreBaseIntegTestCase {
    protected final String INDEX_NAME = "remote-store-test-idx-1";

    @Override
    protected Collection<Class<? extends Plugin>> nodePlugins() {
        return Stream.concat(super.nodePlugins().stream(), Stream.of(MockTransportService.TestPlugin.class)).collect(Collectors.toList());
    }

    @Override
    public Settings indexSettings() {
        return this.remoteStoreIndexSettings(0);
    }

    private void testPeerRecovery(int numberOfIterations, boolean invokeFlush) throws Exception {
        RemoteStoreCoreTestCase.internalCluster().startNodes(3);
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(0));
        this.ensureYellowAndNoInitializingShards("remote-store-test-idx-1");
        this.ensureGreen("remote-store-test-idx-1");
        Map<String, Long> indexStats = this.indexData(numberOfIterations, invokeFlush, "remote-store-test-idx-1");
        RemoteStoreCoreTestCase.client().admin().indices().prepareUpdateSettings(new String[]{"remote-store-test-idx-1"}).setSettings(Settings.builder().put("index.number_of_replicas", 1)).get();
        this.ensureYellowAndNoInitializingShards("remote-store-test-idx-1");
        this.ensureGreen("remote-store-test-idx-1");
        this.refresh("remote-store-test-idx-1");
        String replicaNodeName = this.replicaNodeName("remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client(replicaNodeName).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).get(), (Long)indexStats.get("total-operations"))), 30L, TimeUnit.SECONDS);
        RecoveryResponse recoveryResponse = (RecoveryResponse)RemoteStoreCoreTestCase.client(replicaNodeName).admin().indices().prepareRecoveries(new String[0]).get();
        Optional<RecoveryState> recoverySource = ((List)recoveryResponse.shardRecoveryStates().get("remote-store-test-idx-1")).stream().filter(rs -> rs.getRecoverySource().getType() == RecoverySource.Type.PEER).findFirst();
        RemoteStoreCoreTestCase.assertFalse((boolean)recoverySource.isEmpty());
        RemoteStoreCoreTestCase.assertEquals((long)1L, (long)recoverySource.get().getIndex().recoveredFileCount());
        IndexResponse response = this.indexSingleDoc("remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertEquals((long)(indexStats.get("max-seq-no-total") + 1L), (long)response.getSeqNo());
        this.refresh("remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client(replicaNodeName).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).get(), (Long)indexStats.get("total-operations") + 1L)), 30L, TimeUnit.SECONDS);
    }

    public void testRemoteStoreIndexCreationAndDeletionWithReferencedStore() throws InterruptedException, ExecutionException {
        String dataNode = RemoteStoreCoreTestCase.internalCluster().startNodes(1).get(0);
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(0));
        this.ensureYellowAndNoInitializingShards("remote-store-test-idx-1");
        this.ensureGreen("remote-store-test-idx-1");
        IndexShard indexShard = this.getIndexShard(dataNode, "remote-store-test-idx-1");
        indexShard.store().incRef();
        OpenSearchAssertions.assertAcked(RemoteStoreCoreTestCase.client().admin().indices().prepareDelete(new String[]{"remote-store-test-idx-1"}));
        indexShard.store().decRef();
    }

    public void testPeerRecoveryWithRemoteStoreAndRemoteTranslogNoDataFlush() throws Exception {
        this.testPeerRecovery(1, true);
    }

    public void testPeerRecoveryWithRemoteStoreAndRemoteTranslogFlush() throws Exception {
        this.testPeerRecovery(RemoteStoreCoreTestCase.randomIntBetween(1, 2), true);
    }

    public void testPeerRecoveryWithLowActivityTimeout() throws Exception {
        ClusterUpdateSettingsRequest req = new ClusterUpdateSettingsRequest().persistentSettings(Settings.builder().put(RecoverySettings.INDICES_RECOVERY_MAX_BYTES_PER_SEC_SETTING.getKey(), "20kb").put(RecoverySettings.INDICES_RECOVERY_ACTIVITY_TIMEOUT_SETTING.getKey(), "1s"));
        RemoteStoreCoreTestCase.internalCluster().client().admin().cluster().updateSettings(req).get();
        this.testPeerRecovery(RemoteStoreCoreTestCase.randomIntBetween(1, 3), true);
    }

    public void testPeerRecoveryWithRemoteStoreAndRemoteTranslogNoDataRefresh() throws Exception {
        this.testPeerRecovery(1, false);
    }

    public void testPeerRecoveryWithRemoteStoreAndRemoteTranslogRefresh() throws Exception {
        this.testPeerRecovery(RemoteStoreCoreTestCase.randomIntBetween(1, 3), false);
    }

    private void verifyRemoteStoreCleanup() throws Exception {
        RemoteStoreCoreTestCase.internalCluster().startNodes(3);
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(1));
        this.indexData(5, RemoteStoreCoreTestCase.randomBoolean(), "remote-store-test-idx-1");
        String indexUUID = ((GetSettingsResponse)RemoteStoreCoreTestCase.client().admin().indices().prepareGetSettings(new String[]{"remote-store-test-idx-1"}).get()).getSetting("remote-store-test-idx-1", "index.uuid");
        Path indexPath = Path.of(String.valueOf(this.segmentRepoPath), indexUUID);
        RemoteStoreCoreTestCase.assertTrue((RemoteStoreCoreTestCase.getFileCount(indexPath) > 0 ? 1 : 0) != 0);
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)RemoteStoreCoreTestCase.client().admin().indices().delete(new DeleteIndexRequest("remote-store-test-idx-1")).get());
        RemoteStoreCoreTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            try {
                RemoteStoreCoreTestCase.assertThat((Object)RemoteStoreCoreTestCase.getFileCount(indexPath), (Matcher)Matchers.comparesEqualTo((Comparable)Integer.valueOf(0)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }), 30L, TimeUnit.SECONDS);
    }

    @LuceneTestCase.AwaitsFix(bugUrl="https://github.com/opensearch-project/OpenSearch/issues/9327")
    public void testRemoteTranslogCleanup() throws Exception {
        this.verifyRemoteStoreCleanup();
    }

    public void testStaleCommitDeletionWithInvokeFlush() throws Exception {
        String clusterManagerName = RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        RemoteStoreCoreTestCase.client(clusterManagerName).admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING.getKey(), RemoteStoreCoreTestCase.randomIntBetween(2, 4))).get();
        String dataNode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNode();
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(1, 10000L, -1));
        int numberOfIterations = RemoteStoreCoreTestCase.randomIntBetween(1, 5);
        this.indexData(numberOfIterations, true, "remote-store-test-idx-1");
        String segmentsPathFixedPrefix = (String)RemoteStoreSettings.CLUSTER_REMOTE_STORE_SEGMENTS_PATH_PREFIX.get(this.getNodeSettings());
        String shardPath = RemoteStoreCoreTestCase.getShardLevelBlobPath(RemoteStoreCoreTestCase.client(), "remote-store-test-idx-1", this.getSegmentBasePath(), "0", RemoteStoreEnums.DataCategory.SEGMENTS, RemoteStoreEnums.DataType.METADATA, segmentsPathFixedPrefix).buildAsString();
        IndexShard indexShard = this.getIndexShard(dataNode, "remote-store-test-idx-1");
        int lastNMetadataFilesToKeep = indexShard.getRemoteStoreSettings().getMinRemoteSegmentMetadataFiles();
        RemoteStoreCoreTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            int actualFileCount = this.getActualFileCount(this.segmentRepoPath, shardPath);
            if (numberOfIterations <= lastNMetadataFilesToKeep) {
                MatcherAssert.assertThat((Object)actualFileCount, (Matcher)Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{numberOfIterations - 1, numberOfIterations, numberOfIterations + 1})));
            } else if (RemoteStoreSettings.isPinnedTimestampsEnabled()) {
                RemoteStoreCoreTestCase.assertTrue((actualFileCount >= lastNMetadataFilesToKeep ? 1 : 0) != 0);
            } else {
                MatcherAssert.assertThat((Object)actualFileCount, (Matcher)Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{lastNMetadataFilesToKeep - 1, lastNMetadataFilesToKeep, lastNMetadataFilesToKeep + 1})));
            }
        }), 30L, TimeUnit.SECONDS);
    }

    public void testStaleCommitDeletionWithoutInvokeFlush() throws Exception {
        String clusterManagerName = RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        RemoteStoreCoreTestCase.client(clusterManagerName).admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING.getKey(), RemoteStoreCoreTestCase.randomIntBetween(2, 4))).get();
        RemoteStoreCoreTestCase.internalCluster().startDataOnlyNode();
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(1, 10000L, -1));
        int numberOfIterations = RemoteStoreCoreTestCase.randomIntBetween(1, 5);
        this.indexData(numberOfIterations, false, "remote-store-test-idx-1");
        String segmentsPathFixedPrefix = (String)RemoteStoreSettings.CLUSTER_REMOTE_STORE_SEGMENTS_PATH_PREFIX.get(this.getNodeSettings());
        String shardPath = RemoteStoreCoreTestCase.getShardLevelBlobPath(RemoteStoreCoreTestCase.client(), "remote-store-test-idx-1", this.getSegmentBasePath(), "0", RemoteStoreEnums.DataCategory.SEGMENTS, RemoteStoreEnums.DataType.METADATA, segmentsPathFixedPrefix).buildAsString();
        int actualFileCount = this.getActualFileCount(this.segmentRepoPath, shardPath);
        MatcherAssert.assertThat((Object)actualFileCount, (Matcher)Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{numberOfIterations - 1, numberOfIterations, numberOfIterations + 1})));
    }

    public void testStaleCommitDeletionWithMinSegmentFiles_3() throws Exception {
        Settings.Builder settings = Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING.getKey(), "3");
        RemoteStoreCoreTestCase.internalCluster().startNode(settings);
        String segmentsPathFixedPrefix = (String)RemoteStoreSettings.CLUSTER_REMOTE_STORE_SEGMENTS_PATH_PREFIX.get(this.getNodeSettings());
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(1, 10000L, -1));
        int numberOfIterations = RemoteStoreCoreTestCase.randomIntBetween(5, 15);
        this.indexData(numberOfIterations, true, "remote-store-test-idx-1");
        String shardPath = RemoteStoreCoreTestCase.getShardLevelBlobPath(RemoteStoreCoreTestCase.client(), "remote-store-test-idx-1", this.getSegmentBasePath(), "0", RemoteStoreEnums.DataCategory.SEGMENTS, RemoteStoreEnums.DataType.METADATA, segmentsPathFixedPrefix).buildAsString();
        int actualFileCount = this.getActualFileCount(this.segmentRepoPath, shardPath);
        if (RemoteStoreSettings.isPinnedTimestampsEnabled()) {
            RemoteStoreCoreTestCase.assertTrue((actualFileCount >= 4 ? 1 : 0) != 0);
        } else {
            RemoteStoreCoreTestCase.assertEquals((long)4L, (long)actualFileCount);
        }
    }

    protected BlobPath getSegmentBasePath() {
        return BlobPath.cleanPath();
    }

    public void testStaleCommitDeletionWithMinSegmentFiles_Disabled() throws Exception {
        Settings.Builder settings = Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING.getKey(), "-1");
        RemoteStoreCoreTestCase.internalCluster().startNode(settings);
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(1, 10000L, -1));
        int numberOfIterations = RemoteStoreCoreTestCase.randomIntBetween(2, 5);
        this.indexData(numberOfIterations, true, "remote-store-test-idx-1");
        String segmentsPathFixedPrefix = (String)RemoteStoreSettings.CLUSTER_REMOTE_STORE_SEGMENTS_PATH_PREFIX.get(this.getNodeSettings());
        String shardPath = RemoteStoreCoreTestCase.getShardLevelBlobPath(RemoteStoreCoreTestCase.client(), "remote-store-test-idx-1", this.getSegmentBasePath(), "0", RemoteStoreEnums.DataCategory.SEGMENTS, RemoteStoreEnums.DataType.METADATA, segmentsPathFixedPrefix).buildAsString();
        int actualFileCount = this.getActualFileCount(this.segmentRepoPath, shardPath);
        MatcherAssert.assertThat((Object)actualFileCount, (Matcher)Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{numberOfIterations, numberOfIterations + 1})));
    }

    protected int getActualFileCount(Path segmentRepoPath, String shardPath) throws IOException {
        Path indexPath = Path.of(String.valueOf(segmentRepoPath) + "/" + shardPath, new String[0]);
        return RemoteStoreCoreTestCase.getFileCount(indexPath);
    }

    public void testDefaultBufferInterval() throws ExecutionException, InterruptedException {
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        String clusterManagerName = RemoteStoreCoreTestCase.internalCluster().getClusterManagerName();
        String dataNode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        this.createIndex("remote-store-test-idx-1");
        this.ensureYellowAndNoInitializingShards("remote-store-test-idx-1");
        this.ensureGreen("remote-store-test-idx-1");
        this.assertClusterRemoteBufferInterval(IndexSettings.DEFAULT_REMOTE_TRANSLOG_BUFFER_INTERVAL, dataNode);
        IndexShard indexShard = this.getIndexShard(dataNode, "remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertTrue((boolean)(indexShard.getTranslogSyncProcessor() instanceof BufferedAsyncIOProcessor));
        this.assertBufferInterval(IndexSettings.DEFAULT_REMOTE_TRANSLOG_BUFFER_INTERVAL, indexShard);
        TimeValue clusterBufferInterval = TimeValue.timeValueSeconds((long)RemoteStoreCoreTestCase.randomIntBetween(100, 200));
        RemoteStoreCoreTestCase.client(clusterManagerName).admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey(), clusterBufferInterval)).get();
        this.assertBufferInterval(clusterBufferInterval, indexShard);
        this.clearClusterBufferIntervalSetting(clusterManagerName);
    }

    public void testOverriddenBufferInterval() throws ExecutionException, InterruptedException {
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        String clusterManagerName = RemoteStoreCoreTestCase.internalCluster().getClusterManagerName();
        String dataNode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        TimeValue bufferInterval = TimeValue.timeValueSeconds((long)RemoteStoreCoreTestCase.randomIntBetween(0, 100));
        Settings indexSettings = Settings.builder().put(this.indexSettings()).put(IndexSettings.INDEX_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey(), bufferInterval).build();
        this.createIndex("remote-store-test-idx-1", indexSettings);
        this.ensureYellowAndNoInitializingShards("remote-store-test-idx-1");
        this.ensureGreen("remote-store-test-idx-1");
        IndexShard indexShard = this.getIndexShard(dataNode, "remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertTrue((boolean)(indexShard.getTranslogSyncProcessor() instanceof BufferedAsyncIOProcessor));
        this.assertBufferInterval(bufferInterval, indexShard);
        TimeValue clusterBufferInterval = TimeValue.timeValueSeconds((long)RemoteStoreCoreTestCase.randomIntBetween(100, 200));
        RemoteStoreCoreTestCase.client(clusterManagerName).admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey(), clusterBufferInterval)).get();
        this.assertBufferInterval(bufferInterval, indexShard);
        bufferInterval = TimeValue.timeValueSeconds((long)(bufferInterval.seconds() + (long)RemoteStoreCoreTestCase.randomIntBetween(1, 100)));
        RemoteStoreCoreTestCase.client(clusterManagerName).admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{"remote-store-test-idx-1"}).settings(Settings.builder().put(IndexSettings.INDEX_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey(), bufferInterval))).get();
        this.assertBufferInterval(bufferInterval, indexShard);
        RemoteStoreCoreTestCase.client(clusterManagerName).admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{"remote-store-test-idx-1"}).settings(Settings.builder().putNull(IndexSettings.INDEX_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey()))).get();
        this.assertBufferInterval(clusterBufferInterval, indexShard);
        this.clearClusterBufferIntervalSetting(clusterManagerName);
    }

    public void testOverriddenBufferIntervalValidation() {
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        TimeValue bufferInterval = TimeValue.timeValueSeconds((long)-1L);
        Settings indexSettings = Settings.builder().put(this.indexSettings()).put(IndexSettings.INDEX_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey(), bufferInterval).build();
        IllegalArgumentException exceptionDuringCreateIndex = (IllegalArgumentException)RemoteStoreCoreTestCase.assertThrows(IllegalArgumentException.class, () -> this.createIndex("remote-store-test-idx-1", indexSettings));
        RemoteStoreCoreTestCase.assertEquals((Object)"failed to parse value [-1] for setting [index.remote_store.translog.buffer_interval], must be >= [0ms]", (Object)exceptionDuringCreateIndex.getMessage());
    }

    public void testClusterBufferIntervalValidation() {
        String clusterManagerName = RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        IllegalArgumentException exception = (IllegalArgumentException)RemoteStoreCoreTestCase.assertThrows(IllegalArgumentException.class, () -> RemoteStoreCoreTestCase.client(clusterManagerName).admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey(), TimeValue.timeValueSeconds((long)-1L))).get());
        RemoteStoreCoreTestCase.assertEquals((Object)"failed to parse value [-1] for setting [cluster.remote_store.translog.buffer_interval], must be >= [0ms]", (Object)exception.getMessage());
    }

    public void testRequestDurabilityWhenRestrictSettingExplicitFalse() throws ExecutionException, InterruptedException {
        this.testRestrictSettingFalse(true, Translog.Durability.REQUEST);
    }

    public void testAsyncDurabilityWhenRestrictSettingExplicitFalse() throws ExecutionException, InterruptedException {
        this.testRestrictSettingFalse(true, Translog.Durability.ASYNC);
    }

    public void testRequestDurabilityWhenRestrictSettingImplicitFalse() throws ExecutionException, InterruptedException {
        this.testRestrictSettingFalse(false, Translog.Durability.REQUEST);
    }

    public void testAsyncDurabilityWhenRestrictSettingImplicitFalse() throws ExecutionException, InterruptedException {
        this.testRestrictSettingFalse(false, Translog.Durability.ASYNC);
    }

    private void testRestrictSettingFalse(boolean setRestrictFalse, Translog.Durability durability) throws ExecutionException, InterruptedException {
        String clusterManagerName = setRestrictFalse ? RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode(Settings.builder().put(IndicesService.CLUSTER_REMOTE_INDEX_RESTRICT_ASYNC_DURABILITY_SETTING.getKey(), false).build()) : RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        String dataNode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        Settings indexSettings = Settings.builder().put(this.indexSettings()).put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), (Enum)durability).build();
        this.createIndex("remote-store-test-idx-1", indexSettings);
        IndexShard indexShard = this.getIndexShard(dataNode, "remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertEquals((Object)durability, (Object)indexShard.indexSettings().getTranslogDurability());
        durability = RemoteStoreCoreTestCase.randomFrom(Translog.Durability.values());
        RemoteStoreCoreTestCase.client(clusterManagerName).admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{"remote-store-test-idx-1"}).settings(Settings.builder().put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), (Enum)durability))).get();
        RemoteStoreCoreTestCase.assertEquals((Object)durability, (Object)indexShard.indexSettings().getTranslogDurability());
    }

    public void testAsyncDurabilityThrowsExceptionWhenRestrictSettingTrue() throws ExecutionException, InterruptedException {
        String expectedExceptionMsg = "index setting [index.translog.durability=async] is not allowed as cluster setting [cluster.remote_store.index.restrict.async-durability=true]";
        String clusterManagerName = RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode(Settings.builder().put(IndicesService.CLUSTER_REMOTE_INDEX_RESTRICT_ASYNC_DURABILITY_SETTING.getKey(), true).build());
        String dataNode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        Settings indexSettings = Settings.builder().put(this.indexSettings()).put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), (Enum)Translog.Durability.ASYNC).build();
        IllegalArgumentException exception = (IllegalArgumentException)RemoteStoreCoreTestCase.assertThrows(IllegalArgumentException.class, () -> this.createIndex("remote-store-test-idx-1", indexSettings));
        RemoteStoreCoreTestCase.assertEquals((Object)expectedExceptionMsg, (Object)exception.getMessage());
        this.createIndex("remote-store-test-idx-1");
        IndexShard indexShard = this.getIndexShard(dataNode, "remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertEquals((Object)Translog.Durability.REQUEST, (Object)indexShard.indexSettings().getTranslogDurability());
        exception = (IllegalArgumentException)RemoteStoreCoreTestCase.assertThrows(IllegalArgumentException.class, () -> RemoteStoreCoreTestCase.client(clusterManagerName).admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{"remote-store-test-idx-1"}).settings(indexSettings)).actionGet());
        RemoteStoreCoreTestCase.assertEquals((Object)expectedExceptionMsg, (Object)exception.getMessage());
    }

    private void assertClusterRemoteBufferInterval(TimeValue expectedBufferInterval, String dataNode) {
        IndicesService indicesService = RemoteStoreCoreTestCase.internalCluster().getInstance(IndicesService.class, dataNode);
        RemoteStoreCoreTestCase.assertEquals((Object)expectedBufferInterval, (Object)indicesService.getRemoteStoreSettings().getClusterRemoteTranslogBufferInterval());
    }

    private void assertBufferInterval(TimeValue expectedBufferInterval, IndexShard indexShard) {
        RemoteStoreCoreTestCase.assertEquals((Object)expectedBufferInterval, ((BufferedAsyncIOProcessor)indexShard.getTranslogSyncProcessor()).getBufferIntervalSupplier().get());
    }

    private void clearClusterBufferIntervalSetting(String clusterManagerName) {
        RemoteStoreCoreTestCase.client(clusterManagerName).admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.builder().putNull(RemoteStoreSettings.CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey())).get();
    }

    public void testRestoreSnapshotToIndexWithSameNameDifferentUUID() throws Exception {
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        List<String> dataNodes = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(2);
        Path absolutePath = this.randomRepoPath().toAbsolutePath();
        this.createRepository("test-repo", "fs", Settings.builder().put("location", absolutePath));
        this.logger.info("--> Create index and ingest 50 docs");
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(1));
        this.indexBulk("remote-store-test-idx-1", 50);
        this.flushAndRefresh("remote-store-test-idx-1");
        String originalIndexUUID = ((GetSettingsResponse)RemoteStoreCoreTestCase.client().admin().indices().prepareGetSettings(new String[]{"remote-store-test-idx-1"}).get()).getSetting("remote-store-test-idx-1", "index.uuid");
        RemoteStoreCoreTestCase.assertNotNull((Object)originalIndexUUID);
        RemoteStoreCoreTestCase.assertNotEquals((Object)"_na_", (Object)originalIndexUUID);
        this.ensureGreen(new String[0]);
        this.logger.info("--> take a snapshot");
        RemoteStoreCoreTestCase.client().admin().cluster().prepareCreateSnapshot("test-repo", "test-snap").setIndices(new String[]{"remote-store-test-idx-1"}).setWaitForCompletion(true).get();
        this.logger.info("--> wipe all indices");
        RemoteStoreCoreTestCase.cluster().wipeIndices("remote-store-test-idx-1");
        this.logger.info("--> Create index with the same name, different UUID");
        OpenSearchAssertions.assertAcked(this.prepareCreate("remote-store-test-idx-1").setSettings(Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 1)));
        this.ensureGreen(TimeValue.timeValueSeconds((long)30L), "remote-store-test-idx-1");
        String newIndexUUID = ((GetSettingsResponse)RemoteStoreCoreTestCase.client().admin().indices().prepareGetSettings(new String[]{"remote-store-test-idx-1"}).get()).getSetting("remote-store-test-idx-1", "index.uuid");
        RemoteStoreCoreTestCase.assertNotNull((Object)newIndexUUID);
        RemoteStoreCoreTestCase.assertNotEquals((Object)"_na_", (Object)newIndexUUID);
        RemoteStoreCoreTestCase.assertNotEquals((Object)newIndexUUID, (Object)originalIndexUUID);
        this.logger.info("--> close index");
        RemoteStoreCoreTestCase.client().admin().indices().prepareClose(new String[]{"remote-store-test-idx-1"}).get();
        this.logger.info("--> restore all indices from the snapshot");
        RestoreSnapshotResponse restoreSnapshotResponse = (RestoreSnapshotResponse)this.clusterAdmin().prepareRestoreSnapshot("test-repo", "test-snap").setWaitForCompletion(true).execute().actionGet();
        RemoteStoreCoreTestCase.assertThat((Object)restoreSnapshotResponse.getRestoreInfo().totalShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.flushAndRefresh("remote-store-test-idx-1");
        this.ensureGreen("remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client((String)dataNodes.get(0)).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).get(), 50L);
            OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client((String)dataNodes.get(1)).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).get(), 50L);
        }));
    }

    public void testNoSearchIdleForAnyReplicaCount() throws ExecutionException, InterruptedException {
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        String primaryShardNode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(0));
        this.ensureGreen("remote-store-test-idx-1");
        IndexShard indexShard = this.getIndexShard(primaryShardNode, "remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertFalse((boolean)indexShard.isSearchIdleSupported());
        String replicaShardNode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        OpenSearchAssertions.assertAcked(RemoteStoreCoreTestCase.client().admin().indices().prepareUpdateSettings(new String[]{"remote-store-test-idx-1"}).setSettings(Settings.builder().put("index.number_of_replicas", 1)));
        this.ensureGreen("remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertFalse((boolean)indexShard.isSearchIdleSupported());
        indexShard = this.getIndexShard(replicaShardNode, "remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertFalse((boolean)indexShard.isSearchIdleSupported());
    }

    public void testFallbackToNodeToNodeSegmentCopy() throws Exception {
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        List<String> dataNodes = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(2);
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(0, 10000L, -1));
        this.ensureGreen("remote-store-test-idx-1");
        this.indexBulk("remote-store-test-idx-1", 50);
        this.flushAndRefresh("remote-store-test-idx-1");
        String segmentsPathFixedPrefix = (String)RemoteStoreSettings.CLUSTER_REMOTE_STORE_SEGMENTS_PATH_PREFIX.get(this.getNodeSettings());
        String shardPath = RemoteStoreCoreTestCase.getShardLevelBlobPath(RemoteStoreCoreTestCase.client(), "remote-store-test-idx-1", this.getSegmentBasePath(), "0", RemoteStoreEnums.DataCategory.SEGMENTS, RemoteStoreEnums.DataType.DATA, segmentsPathFixedPrefix).buildAsString();
        this.delete(this.segmentRepoPath, shardPath);
        OpenSearchAssertions.assertAcked(RemoteStoreCoreTestCase.client().admin().indices().prepareUpdateSettings(new String[]{"remote-store-test-idx-1"}).setSettings(Settings.builder().put("index.number_of_replicas", 1)));
        this.ensureGreen("remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client((String)dataNodes.get(0)).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).get(), 50L);
            OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client((String)dataNodes.get(1)).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).get(), 50L);
        }));
    }

    protected void delete(Path baseRepoPath, String shardPath) throws IOException {
        Path segmentDataPath = Path.of(String.valueOf(baseRepoPath) + "/" + shardPath, new String[0]);
        try (Stream<Path> files = Files.list(segmentDataPath);){
            files.forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
        }
    }

    public void testNoMultipleWriterDuringPrimaryRelocation() throws ExecutionException, InterruptedException {
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        String oldPrimary = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(0));
        this.ensureGreen("remote-store-test-idx-1");
        this.indexBulk("remote-store-test-idx-1", RemoteStoreCoreTestCase.randomIntBetween(5, 10));
        String newPrimary = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        this.ensureStableCluster(3);
        IndexShard oldPrimaryIndexShard = this.getIndexShard(oldPrimary, "remote-store-test-idx-1");
        CountDownLatch flushLatch = new CountDownLatch(1);
        MockTransportService mockTargetTransportService = (MockTransportService)RemoteStoreCoreTestCase.internalCluster().getInstance(TransportService.class, oldPrimary);
        mockTargetTransportService.addSendBehavior((connection, requestId, action, request, options) -> {
            if ("internal:index/shard/recovery/handoff_primary_context".equals(action)) {
                flushLatch.countDown();
            }
            connection.sendRequest(requestId, action, request, options);
        });
        this.logger.info("--> relocate the shard");
        RemoteStoreCoreTestCase.client().admin().cluster().prepareReroute().add(new AllocationCommand[]{new MoveAllocationCommand("remote-store-test-idx-1", 0, oldPrimary, newPrimary)}).execute().actionGet();
        CountDownLatch flushDone = new CountDownLatch(1);
        Thread flushThread = new Thread(() -> {
            try {
                flushLatch.await(2L, TimeUnit.SECONDS);
                oldPrimaryIndexShard.flush(new FlushRequest(new String[0]).waitIfOngoing(true).force(true));
            }
            catch (IndexShardClosedException indexShardClosedException) {
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                flushDone.countDown();
            }
        });
        flushThread.start();
        flushDone.await(5L, TimeUnit.SECONDS);
        flushThread.join();
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)RemoteStoreCoreTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForStatus(ClusterHealthStatus.GREEN).setWaitForEvents(Priority.LANGUID).setWaitForNoRelocatingShards(true).setTimeout(TimeValue.timeValueSeconds((long)5L)).execute().actionGet();
        RemoteStoreCoreTestCase.assertFalse((boolean)clusterHealthResponse.isTimedOut());
        RemoteStoreCoreTestCase.client().admin().indices().updateSettings(new UpdateSettingsRequest(new String[]{"remote-store-test-idx-1"}).settings(Settings.builder().put("index.number_of_replicas", 1))).get();
        clusterHealthResponse = (ClusterHealthResponse)RemoteStoreCoreTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForStatus(ClusterHealthStatus.GREEN).setWaitForEvents(Priority.LANGUID).setWaitForNoRelocatingShards(true).setTimeout(TimeValue.timeValueSeconds((long)5L)).execute().actionGet();
        RemoteStoreCoreTestCase.assertFalse((boolean)clusterHealthResponse.isTimedOut());
    }

    public void testResumeUploadAfterFailedPrimaryRelocation() throws ExecutionException, InterruptedException, IOException {
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        String oldPrimary = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(0));
        this.ensureGreen("remote-store-test-idx-1");
        int docs = RemoteStoreCoreTestCase.randomIntBetween(5, 10);
        this.indexBulk("remote-store-test-idx-1", docs);
        this.flushAndRefresh("remote-store-test-idx-1");
        OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client(oldPrimary).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).setPreference("_only_local").get(), docs);
        String newPrimary = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        this.ensureStableCluster(3);
        IndexShard oldPrimaryIndexShard = this.getIndexShard(oldPrimary, "remote-store-test-idx-1");
        CountDownLatch handOffLatch = new CountDownLatch(1);
        MockTransportService mockTargetTransportService = (MockTransportService)RemoteStoreCoreTestCase.internalCluster().getInstance(TransportService.class, oldPrimary);
        mockTargetTransportService.addSendBehavior((connection, requestId, action, request, options) -> {
            if ("internal:index/shard/recovery/handoff_primary_context".equals(action)) {
                handOffLatch.countDown();
                throw new OpenSearchException("failing recovery for test purposes", new Object[0]);
            }
            connection.sendRequest(requestId, action, request, options);
        });
        this.logger.info("--> relocate the shard");
        RemoteStoreCoreTestCase.client().admin().cluster().prepareReroute().add(new AllocationCommand[]{new MoveAllocationCommand("remote-store-test-idx-1", 0, oldPrimary, newPrimary)}).execute().actionGet();
        handOffLatch.await(30L, TimeUnit.SECONDS);
        RemoteStoreCoreTestCase.assertTrue((boolean)oldPrimaryIndexShard.isStartedPrimary());
        RemoteStoreCoreTestCase.assertEquals((Object)oldPrimary, (Object)this.primaryNodeName("remote-store-test-idx-1"));
        OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client(oldPrimary).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).setPreference("_only_local").get(), docs);
        SearchPhaseExecutionException ex = (SearchPhaseExecutionException)RemoteStoreCoreTestCase.assertThrows(SearchPhaseExecutionException.class, () -> RemoteStoreCoreTestCase.client(newPrimary).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).setPreference("_only_local").get());
        RemoteStoreCoreTestCase.assertEquals((Object)"all shards failed", (Object)ex.getMessage());
        int moreDocs = RemoteStoreCoreTestCase.randomIntBetween(5, 10);
        this.indexBulk("remote-store-test-idx-1", moreDocs);
        this.flushAndRefresh("remote-store-test-idx-1");
        int uncommittedOps = RemoteStoreCoreTestCase.randomIntBetween(5, 10);
        this.indexBulk("remote-store-test-idx-1", uncommittedOps);
        OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client(oldPrimary).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).setPreference("_only_local").get(), docs + moreDocs);
        RemoteStoreCoreTestCase.internalCluster().stopRandomNode(InternalTestCluster.nameFilter(this.primaryNodeName("remote-store-test-idx-1")));
        this.restore(true, "remote-store-test-idx-1");
        this.ensureGreen("remote-store-test-idx-1");
        OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client(newPrimary).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).setPreference("_only_local").get(), docs + moreDocs + uncommittedOps);
        String newNode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        this.ensureStableCluster(3);
        RemoteStoreCoreTestCase.client().admin().cluster().prepareReroute().add(new AllocationCommand[]{new MoveAllocationCommand("remote-store-test-idx-1", 0, newPrimary, newNode)}).execute().actionGet();
        ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)RemoteStoreCoreTestCase.client().admin().cluster().prepareHealth(new String[0]).setWaitForStatus(ClusterHealthStatus.GREEN).setWaitForEvents(Priority.LANGUID).setWaitForNoRelocatingShards(true).setTimeout(TimeValue.timeValueSeconds((long)10L)).execute().actionGet();
        RemoteStoreCoreTestCase.assertFalse((boolean)clusterHealthResponse.isTimedOut());
        ex = (SearchPhaseExecutionException)RemoteStoreCoreTestCase.assertThrows(SearchPhaseExecutionException.class, () -> RemoteStoreCoreTestCase.client(newPrimary).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).setPreference("_only_local").get());
        RemoteStoreCoreTestCase.assertEquals((Object)"all shards failed", (Object)ex.getMessage());
        OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client(newNode).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).setPreference("_only_local").get(), docs + moreDocs + uncommittedOps);
    }

    public void testLocalOnlyTranslogCleanupOnNodeRestart() throws Exception {
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        String dataNode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNode();
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(0, 10000L, -1));
        this.ensureGreen("remote-store-test-idx-1");
        int searchableDocs = 0;
        for (int i = 0; i < RemoteStoreCoreTestCase.randomIntBetween(1, 3); ++i) {
            this.indexBulk("remote-store-test-idx-1", 15);
            this.refresh("remote-store-test-idx-1");
            searchableDocs += 15;
        }
        this.indexBulk("remote-store-test-idx-1", 15);
        OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client(dataNode).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).get(), searchableDocs);
        String translogPathFixedPrefix = (String)RemoteStoreSettings.CLUSTER_REMOTE_STORE_TRANSLOG_PATH_PREFIX.get(this.getNodeSettings());
        String shardPath = RemoteStoreCoreTestCase.getShardLevelBlobPath(RemoteStoreCoreTestCase.client(), "remote-store-test-idx-1", this.getSegmentBasePath(), "0", RemoteStoreEnums.DataCategory.TRANSLOG, RemoteStoreEnums.DataType.METADATA, translogPathFixedPrefix).buildAsString();
        this.delete(this.translogRepoPath, shardPath);
        RemoteStoreCoreTestCase.internalCluster().restartNode(dataNode);
        this.ensureGreen("remote-store-test-idx-1");
        MatcherAssert.assertThat((Object)((int)((SearchResponse)RemoteStoreCoreTestCase.client(dataNode).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).get()).getHits().getTotalHits().value()), (Matcher)Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{searchableDocs, searchableDocs + 15})));
        this.indexBulk("remote-store-test-idx-1", 15);
        this.refresh("remote-store-test-idx-1");
        MatcherAssert.assertThat((Object)((int)((SearchResponse)RemoteStoreCoreTestCase.client(dataNode).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).get()).getHits().getTotalHits().value()), (Matcher)Matchers.is((Matcher)Matchers.oneOf((Object[])new Integer[]{searchableDocs + 15, searchableDocs + 30})));
    }

    public void testFlushOnTooManyRemoteTranslogFiles() throws Exception {
        long totalFiles;
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        String datanode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(0, 10000L, -1));
        this.ensureGreen("remote-store-test-idx-1");
        ClusterUpdateSettingsRequest updateSettingsRequest = new ClusterUpdateSettingsRequest();
        updateSettingsRequest.persistentSettings(Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_MAX_TRANSLOG_READERS.getKey(), "100").put(RemoteStoreSettings.CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey(), "0ms"));
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)RemoteStoreCoreTestCase.client().admin().cluster().updateSettings(updateSettingsRequest).actionGet());
        IndexShard indexShard = this.getIndexShard(datanode, "remote-store-test-idx-1");
        Path translogLocation = IndexShardTestCase.getTranslog(indexShard).location();
        RemoteStoreCoreTestCase.assertFalse((boolean)indexShard.shouldPeriodicallyFlush());
        try (Stream<Path> files = Files.list(translogLocation);){
            totalFiles = files.filter(f -> f.getFileName().toString().endsWith(".tlog")).count();
            RemoteStoreCoreTestCase.assertEquals((long)totalFiles, (long)1L);
        }
        for (int i = 0; i < 100; ++i) {
            this.indexBulk("remote-store-test-idx-1", 1);
        }
        files = Files.list(translogLocation);
        try {
            totalFiles = files.filter(f -> f.getFileName().toString().endsWith(".tlog")).count();
            RemoteStoreCoreTestCase.assertEquals((long)totalFiles, (long)101L);
        }
        finally {
            if (files != null) {
                files.close();
            }
        }
        this.indexBulk("remote-store-test-idx-1", 1);
        RemoteStoreCoreTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            try (Stream<Path> files = Files.list(translogLocation);){
                long totalFiles = files.filter(f -> f.getFileName().toString().endsWith(".tlog")).count();
                RemoteStoreCoreTestCase.assertEquals((long)totalFiles, (long)1L);
            }
        }), 30L, TimeUnit.SECONDS);
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)RemoteStoreCoreTestCase.internalCluster().client().admin().cluster().prepareUpdateSettings().setPersistentSettings(Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_MAX_TRANSLOG_READERS.getKey(), "-1")).get());
        for (int i = 0; i < 500; ++i) {
            this.indexBulk("remote-store-test-idx-1", 1);
        }
        files = Files.list(translogLocation);
        try {
            totalFiles = files.filter(f -> f.getFileName().toString().endsWith(".tlog")).count();
            RemoteStoreCoreTestCase.assertEquals((long)totalFiles, (long)501L);
        }
        finally {
            if (files != null) {
                files.close();
            }
        }
    }

    public void testAsyncTranslogDurabilityRestrictionsThroughIdxTemplates() throws Exception {
        this.logger.info("Starting up cluster manager with cluster.remote_store.index.restrict.async-durability set to true");
        String cm1 = RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode(Settings.builder().put(IndicesService.CLUSTER_REMOTE_INDEX_RESTRICT_ASYNC_DURABILITY_SETTING.getKey(), true).build());
        RemoteStoreCoreTestCase.internalCluster().startDataOnlyNode();
        this.ensureStableCluster(2);
        RemoteStoreCoreTestCase.assertThrows(IllegalArgumentException.class, () -> RemoteStoreCoreTestCase.internalCluster().client().admin().indices().preparePutTemplate("test").setPatterns(Arrays.asList("test*")).setSettings(Settings.builder().put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), "async")).get());
        this.logger.info("Starting up another cluster manager with cluster.remote_store.index.restrict.async-durability set to false");
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode(Settings.builder().put(IndicesService.CLUSTER_REMOTE_INDEX_RESTRICT_ASYNC_DURABILITY_SETTING.getKey(), false).build());
        RemoteStoreCoreTestCase.internalCluster().stopRandomNode(InternalTestCluster.nameFilter(cm1));
        this.ensureStableCluster(2);
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)RemoteStoreCoreTestCase.internalCluster().client().admin().indices().preparePutTemplate("test").setPatterns(Arrays.asList("test*")).setSettings(Settings.builder().put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), "async")).get());
    }

    public void testCloseIndexWithNoOpSyncAndFlushForSyncTranslog() throws InterruptedException {
        RemoteStoreCoreTestCase.internalCluster().startNodes(3);
        RemoteStoreCoreTestCase.client().admin().cluster().prepareUpdateSettings().setTransientSettings(Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey(), "5s")).get();
        Settings.Builder settings = Settings.builder().put(this.remoteStoreIndexSettings(0, 10000L, -1)).put(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey(), "1s");
        this.createIndex("remote-store-test-idx-1", settings.build());
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            if (RemoteStoreCoreTestCase.randomBoolean()) {
                for (int i = 0; i < RemoteStoreCoreTestCase.randomIntBetween(1, 5); ++i) {
                    this.indexSingleDoc("remote-store-test-idx-1");
                }
                this.flushAndRefresh("remote-store-test-idx-1");
            }
            this.indexSingleDoc("remote-store-test-idx-1");
            latch.countDown();
            this.indexSingleDoc("remote-store-test-idx-1");
        }).start();
        latch.await();
        Thread.sleep(1000L);
        this.flush("remote-store-test-idx-1");
        RemoteStoreCoreTestCase.client().admin().indices().close(Requests.closeIndexRequest((String)"remote-store-test-idx-1")).actionGet();
        Thread.sleep(10000L);
        this.ensureGreen("remote-store-test-idx-1");
    }

    public void testCloseIndexWithNoOpSyncAndFlushForAsyncTranslog() throws InterruptedException {
        RemoteStoreCoreTestCase.internalCluster().startNodes(3);
        Settings.Builder settings = Settings.builder().put(this.remoteStoreIndexSettings(0, 10000L, -1)).put(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey(), "1s").put(IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.getKey(), (Enum)Translog.Durability.ASYNC).put(IndexSettings.INDEX_TRANSLOG_SYNC_INTERVAL_SETTING.getKey(), "10s");
        this.createIndex("remote-store-test-idx-1", settings.build());
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            this.indexSingleDoc("remote-store-test-idx-1");
            this.indexSingleDoc("remote-store-test-idx-1");
            this.indexSingleDoc("remote-store-test-idx-1");
            latch.countDown();
        }).start();
        latch.await();
        this.flush("remote-store-test-idx-1");
        RemoteStoreCoreTestCase.client().admin().indices().close(Requests.closeIndexRequest((String)"remote-store-test-idx-1")).actionGet();
        Thread.sleep(10000L);
        this.ensureGreen("remote-store-test-idx-1");
    }

    public void testSuccessfulShallowV1SnapshotPostIndexClose() throws Exception {
        RemoteStoreCoreTestCase.internalCluster().startClusterManagerOnlyNode();
        String dataNode = RemoteStoreCoreTestCase.internalCluster().startDataOnlyNodes(1).get(0);
        this.createIndex("remote-store-test-idx-1", this.remoteStoreIndexSettings(0, 10000L, -1));
        this.ensureGreen("remote-store-test-idx-1");
        ClusterUpdateSettingsRequest updateSettingsRequest = new ClusterUpdateSettingsRequest();
        updateSettingsRequest.persistentSettings(Settings.builder().put(RemoteStoreSettings.CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.getKey(), "0ms"));
        OpenSearchAssertions.assertAcked((AcknowledgedResponse)RemoteStoreCoreTestCase.client().admin().cluster().updateSettings(updateSettingsRequest).actionGet());
        this.logger.info("Create shallow snapshot setting enabled repo");
        String shallowSnapshotRepoName = "shallow-snapshot-repo-name";
        Path shallowSnapshotRepoPath = this.randomRepoPath();
        Settings.Builder settings = Settings.builder().put("location", shallowSnapshotRepoPath).put(BlobStoreRepository.REMOTE_STORE_INDEX_SHALLOW_COPY.getKey(), Boolean.TRUE.booleanValue());
        this.createRepository(shallowSnapshotRepoName, "fs", settings);
        for (int i = 0; i < 3; ++i) {
            this.indexBulk("remote-store-test-idx-1", 1);
        }
        this.flushAndRefresh("remote-store-test-idx-1");
        this.logger.info("Verify shallow snapshot created before close");
        String snapshot1 = "snapshot1";
        SnapshotInfo snapshotInfo1 = ((CreateSnapshotResponse)RemoteStoreCoreTestCase.internalCluster().client().admin().cluster().prepareCreateSnapshot(shallowSnapshotRepoName, "snapshot1").setIndices(new String[]{"remote-store-test-idx-1"}).setWaitForCompletion(true).get()).getSnapshotInfo();
        RemoteStoreCoreTestCase.assertEquals((Object)SnapshotState.SUCCESS, (Object)snapshotInfo1.state());
        RemoteStoreCoreTestCase.assertTrue((snapshotInfo1.successfulShards() > 0 ? 1 : 0) != 0);
        RemoteStoreCoreTestCase.assertEquals((long)0L, (long)snapshotInfo1.failedShards());
        for (int i = 0; i < 3; ++i) {
            this.indexBulk("remote-store-test-idx-1", 1);
        }
        RemoteStoreCoreTestCase.client().admin().indices().close(Requests.closeIndexRequest((String)"remote-store-test-idx-1")).actionGet();
        Thread.sleep(1000L);
        this.logger.info("Verify shallow snapshot created after close");
        String snapshot2 = "snapshot2";
        SnapshotInfo snapshotInfo2 = ((CreateSnapshotResponse)RemoteStoreCoreTestCase.internalCluster().client().admin().cluster().prepareCreateSnapshot(shallowSnapshotRepoName, "snapshot2").setIndices(new String[]{"remote-store-test-idx-1"}).setWaitForCompletion(true).get()).getSnapshotInfo();
        RemoteStoreCoreTestCase.assertEquals((Object)SnapshotState.SUCCESS, (Object)snapshotInfo2.state());
        RemoteStoreCoreTestCase.assertTrue((snapshotInfo2.successfulShards() > 0 ? 1 : 0) != 0);
        RemoteStoreCoreTestCase.assertEquals((long)0L, (long)snapshotInfo2.failedShards());
        RemoteStoreCoreTestCase.cluster().wipeIndices("remote-store-test-idx-1");
        RestoreSnapshotResponse restoreSnapshotResponse = (RestoreSnapshotResponse)this.clusterAdmin().prepareRestoreSnapshot(shallowSnapshotRepoName, "snapshot2").setWaitForCompletion(true).execute().actionGet();
        RemoteStoreCoreTestCase.assertThat((Object)restoreSnapshotResponse.getRestoreInfo().totalShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        this.ensureGreen("remote-store-test-idx-1");
        this.flushAndRefresh("remote-store-test-idx-1");
        RemoteStoreCoreTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> OpenSearchAssertions.assertHitCount((SearchResponse)RemoteStoreCoreTestCase.client(dataNode).prepareSearch(new String[]{"remote-store-test-idx-1"}).setSize(0).get(), 6L)));
    }
}

