/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.shard;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opensearch.Version;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.index.shard.IndexShardTestCase;

public class IndexShardTestUtils {
    public static final String MOCK_STATE_REPO_NAME = "state-test-repo";
    public static final String MOCK_SEGMENT_REPO_NAME = "segment-test-repo";
    public static final String MOCK_TLOG_REPO_NAME = "tlog-test-repo";

    public static DiscoveryNode getFakeDiscoNode(String id) {
        return new DiscoveryNode(id, id, IndexShardTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), (Set)DiscoveryNodeRole.BUILT_IN_ROLES, Version.CURRENT);
    }

    public static DiscoveryNode getFakeRemoteEnabledNode(String id) {
        HashMap<String, String> remoteNodeAttributes = new HashMap<String, String>();
        remoteNodeAttributes.put("remote_store.state.repository", MOCK_STATE_REPO_NAME);
        remoteNodeAttributes.put("remote_store.segment.repository", MOCK_SEGMENT_REPO_NAME);
        remoteNodeAttributes.put("remote_store.translog.repository", MOCK_TLOG_REPO_NAME);
        return new DiscoveryNode(id, id, IndexShardTestCase.buildNewFakeTransportAddress(), remoteNodeAttributes, (Set)DiscoveryNodeRole.BUILT_IN_ROLES, Version.CURRENT);
    }

    public static DiscoveryNodes getFakeDiscoveryNodes(List<ShardRouting> shardRoutings) {
        DiscoveryNodes.Builder builder = DiscoveryNodes.builder();
        for (ShardRouting routing : shardRoutings) {
            builder.add(IndexShardTestUtils.getFakeDiscoNode(routing.currentNodeId()));
        }
        return builder.build();
    }

    public static DiscoveryNodes getFakeRemoteEnabledDiscoveryNodes(List<ShardRouting> shardRoutings) {
        DiscoveryNodes.Builder builder = DiscoveryNodes.builder();
        for (ShardRouting routing : shardRoutings) {
            builder.add(IndexShardTestUtils.getFakeRemoteEnabledNode(routing.currentNodeId()));
        }
        return builder.build();
    }

    public static DiscoveryNodes getFakeDiscoveryNodes(ShardRouting shardRouting) {
        return DiscoveryNodes.builder().add(IndexShardTestUtils.getFakeDiscoNode(shardRouting.currentNodeId())).build();
    }
}

