/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.mockito.Mockito;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AnalyzerScope;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.Mapping;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.similarity.SimilarityService;
import org.opensearch.indices.IndicesModule;
import org.opensearch.indices.mapper.MapperRegistry;
import org.opensearch.plugins.MapperPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.script.ScriptModule;
import org.opensearch.script.ScriptService;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.test.OpenSearchTestCase;

public abstract class MapperServiceTestCase
extends OpenSearchTestCase {
    protected static final Settings SETTINGS = Settings.builder().put("index.version.created", Version.CURRENT).build();
    protected static final ToXContent.Params INCLUDE_DEFAULTS = new ToXContent.MapParams(Collections.singletonMap("include_defaults", "true"));

    protected Collection<? extends Plugin> getPlugins() {
        return Collections.emptyList();
    }

    protected Settings getIndexSettings() {
        return SETTINGS;
    }

    protected IndexAnalyzers createIndexAnalyzers(IndexSettings indexSettings) {
        return new IndexAnalyzers(Collections.singletonMap("default", new NamedAnalyzer("default", AnalyzerScope.INDEX, (Analyzer)new StandardAnalyzer())), Collections.emptyMap(), Collections.emptyMap());
    }

    protected final String randomIndexOptions() {
        return MapperServiceTestCase.randomFrom("docs", "freqs", "positions", "offsets");
    }

    protected final DocumentMapper createDocumentMapper(XContentBuilder mappings) throws IOException {
        return this.createMapperService(mappings).documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(Version version, XContentBuilder mappings) throws IOException {
        return this.createMapperService(version, mappings).documentMapper();
    }

    protected final DocumentMapper createDocumentMapper(String type, String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.merge(type, mapperService, mappings);
        return mapperService.documentMapper();
    }

    protected MapperService createMapperService(XContentBuilder mappings) throws IOException {
        return this.createMapperService(Version.CURRENT, mappings);
    }

    protected final MapperService createMapperService(String type, String mappings) throws IOException {
        MapperService mapperService = this.createMapperService(this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {})));
        this.merge(type, mapperService, mappings);
        return mapperService;
    }

    protected final MapperService createMapperService(Version version, XContentBuilder mapping) throws IOException {
        IndexMetadata meta = IndexMetadata.builder((String)"index").settings(Settings.builder().put("index.version.created", version)).numberOfReplicas(0).numberOfShards(1).build();
        IndexSettings indexSettings = new IndexSettings(meta, this.getIndexSettings());
        MapperRegistry mapperRegistry = new IndicesModule(this.getPlugins().stream().filter(p -> p instanceof MapperPlugin).map(p -> (MapperPlugin)p).collect(Collectors.toList())).getMapperRegistry();
        ScriptModule scriptModule = new ScriptModule(Settings.EMPTY, this.getPlugins().stream().filter(p -> p instanceof ScriptPlugin).map(p -> (ScriptPlugin)p).collect(Collectors.toList()));
        ScriptService scriptService = new ScriptService(this.getIndexSettings(), scriptModule.engines, scriptModule.contexts);
        SimilarityService similarityService = new SimilarityService(indexSettings, scriptService, Collections.emptyMap());
        MapperService mapperService = new MapperService(indexSettings, this.createIndexAnalyzers(indexSettings), this.xContentRegistry(), similarityService, mapperRegistry, () -> {
            throw new UnsupportedOperationException();
        }, () -> true, scriptService);
        this.merge(mapperService, mapping);
        return mapperService;
    }

    protected final void withLuceneIndex(MapperService mapperService, CheckedConsumer<RandomIndexWriter, IOException> builder, CheckedConsumer<IndexReader, IOException> test) throws IOException {
        try (BaseDirectoryWrapper dir = MapperServiceTestCase.newDirectory();
             RandomIndexWriter iw = new RandomIndexWriter(MapperServiceTestCase.random(), (Directory)dir, new IndexWriterConfig(mapperService.indexAnalyzer()));){
            builder.accept((Object)iw);
            try (DirectoryReader reader = iw.getReader();){
                test.accept((Object)reader);
            }
        }
    }

    protected final SourceToParse source(CheckedConsumer<XContentBuilder, IOException> build) throws IOException {
        XContentBuilder builder = JsonXContent.contentBuilder().startObject();
        build.accept((Object)builder);
        builder.endObject();
        return new SourceToParse("test", "1", BytesReference.bytes((XContentBuilder)builder), MediaTypeRegistry.JSON);
    }

    protected final SourceToParse source(String source) {
        return new SourceToParse("test", "1", (BytesReference)new BytesArray(source), MediaTypeRegistry.JSON);
    }

    protected final void merge(MapperService mapperService, XContentBuilder mapping) throws IOException {
        this.merge(mapperService, MapperService.MergeReason.MAPPING_UPDATE, mapping);
    }

    protected final void merge(String type, MapperService mapperService, String mapping) throws IOException {
        mapperService.merge(type, new CompressedXContent(mapping), MapperService.MergeReason.MAPPING_UPDATE);
    }

    protected final void merge(MapperService mapperService, MapperService.MergeReason reason, XContentBuilder mapping) throws IOException {
        mapperService.merge("_doc", new CompressedXContent(BytesReference.bytes((XContentBuilder)mapping)), reason);
    }

    protected final XContentBuilder topMapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject();
    }

    protected final XContentBuilder mapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("properties");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject().endObject();
    }

    protected final XContentBuilder derivedMapping(CheckedConsumer<XContentBuilder, IOException> buildFields) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject().startObject("_doc").startObject("derived");
        buildFields.accept((Object)builder);
        return builder.endObject().endObject().endObject();
    }

    protected final XContentBuilder dynamicMapping(Mapping dynamicMapping) throws IOException {
        XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
        dynamicMapping.toXContent(builder, ToXContent.EMPTY_PARAMS);
        return builder.endObject();
    }

    protected XContentBuilder fieldMapping(CheckedConsumer<XContentBuilder, IOException> buildField) throws IOException {
        return this.fieldMapping(buildField, false);
    }

    protected final XContentBuilder fieldMapping(CheckedConsumer<XContentBuilder, IOException> buildField, Boolean isDerived) throws IOException {
        if (isDerived.booleanValue()) {
            return this.derivedMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                b.startObject("field");
                buildField.accept(b);
                b.endObject();
            }));
        }
        return this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("field");
            buildField.accept(b);
            b.endObject();
        }));
    }

    protected QueryShardContext createQueryShardContext(MapperService mapperService) {
        QueryShardContext queryShardContext = (QueryShardContext)Mockito.mock(QueryShardContext.class);
        Mockito.when((Object)queryShardContext.getMapperService()).thenReturn((Object)mapperService);
        Mockito.when((Object)queryShardContext.fieldMapper(Mockito.anyString())).thenAnswer(inv -> mapperService.fieldType(inv.getArguments()[0].toString()));
        Mockito.when((Object)queryShardContext.getIndexAnalyzers()).thenReturn((Object)mapperService.getIndexAnalyzers());
        Mockito.when((Object)queryShardContext.getSearchQuoteAnalyzer((MappedFieldType)Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)queryShardContext.getSearchAnalyzer((MappedFieldType)Mockito.any())).thenCallRealMethod();
        Mockito.when((Object)queryShardContext.getIndexSettings()).thenReturn((Object)mapperService.getIndexSettings());
        Mockito.when((Object)queryShardContext.getObjectMapper(Mockito.anyString())).thenAnswer(inv -> mapperService.getObjectMapper(inv.getArguments()[0].toString()));
        Mockito.when((Object)queryShardContext.simpleMatchToIndexNames((String)Mockito.any())).thenAnswer(inv -> mapperService.simpleMatchToFullName(inv.getArguments()[0].toString()));
        Mockito.when((Object)queryShardContext.allowExpensiveQueries()).thenReturn((Object)true);
        Mockito.when((Object)queryShardContext.lookup()).thenReturn((Object)new SearchLookup(mapperService, (ft, s) -> {
            throw new UnsupportedOperationException("search lookup not available");
        }, -1));
        Mockito.when((Object)queryShardContext.getFieldType((String)Mockito.any())).thenAnswer(inv -> mapperService.fieldType(inv.getArguments()[0].toString()));
        Mockito.when((Object)queryShardContext.documentMapper(Mockito.anyString())).thenReturn((Object)mapperService.documentMapper());
        return queryShardContext;
    }
}

