/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToLongBiFunction;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.LiveIndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.opensearch.Version;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.routing.AllocationId;
import org.opensearch.common.CheckedBiFunction;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.Nullable;
import org.opensearch.common.Randomness;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.concurrent.GatedCloseable;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.common.util.set.Sets;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.bytes.BytesArray;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.index.Index;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.env.ShardLock;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.MapperTestUtils;
import org.opensearch.index.VersionType;
import org.opensearch.index.codec.CodecService;
import org.opensearch.index.engine.DocIdSeqNoAndSource;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.engine.EngineConfig;
import org.opensearch.index.engine.InternalEngine;
import org.opensearch.index.engine.InternalTestEngine;
import org.opensearch.index.engine.NRTReplicationEngine;
import org.opensearch.index.engine.SafeCommitInfo;
import org.opensearch.index.engine.TranslogHandler;
import org.opensearch.index.fieldvisitor.IdOnlyFieldVisitor;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.DocumentMapperForType;
import org.opensearch.index.mapper.IdFieldMapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.Mapping;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.SeqNoFieldMapper;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.mapper.Uid;
import org.opensearch.index.seqno.LocalCheckpointTracker;
import org.opensearch.index.seqno.ReplicationTracker;
import org.opensearch.index.seqno.RetentionLeases;
import org.opensearch.index.seqno.SequenceNumbers;
import org.opensearch.index.store.Store;
import org.opensearch.index.translog.InternalTranslogManager;
import org.opensearch.index.translog.LocalTranslog;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogConfig;
import org.opensearch.index.translog.TranslogDeletionPolicies;
import org.opensearch.index.translog.TranslogDeletionPolicy;
import org.opensearch.index.translog.TranslogManager;
import org.opensearch.index.translog.TranslogRecoveryRunner;
import org.opensearch.index.translog.listener.TranslogEventListener;
import org.opensearch.test.DummyShardLock;
import org.opensearch.test.IndexSettingsModule;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.TestThreadPool;
import org.opensearch.threadpool.ThreadPool;

public abstract class EngineTestCase
extends OpenSearchTestCase {
    protected final ShardId shardId = new ShardId(new Index("index", "_na_"), 0);
    protected final AllocationId allocationId = AllocationId.newInitializing();
    protected static final IndexSettings INDEX_SETTINGS = IndexSettingsModule.newIndexSettings("index", Settings.EMPTY, new Setting[0]);
    protected ThreadPool threadPool;
    protected TranslogHandler translogHandler;
    protected Store store;
    protected Store storeReplica;
    protected InternalEngine engine;
    protected InternalEngine replicaEngine;
    protected IndexSettings defaultSettings;
    protected String codecName;
    protected Path primaryTranslogDir;
    protected Path replicaTranslogDir;
    protected final PrimaryTermSupplier primaryTerm = new PrimaryTermSupplier(1L);
    protected static final BytesReference B_1 = new BytesArray(new byte[]{1});
    protected static final BytesReference B_2 = new BytesArray(new byte[]{2});
    protected static final BytesReference B_3 = new BytesArray(new byte[]{3});
    protected static final BytesArray SOURCE = EngineTestCase.bytesArray("{}");

    protected static void assertVisibleCount(Engine engine, int numDocs, boolean refresh) throws IOException {
        if (refresh) {
            engine.refresh("test");
        }
        try (Engine.Searcher searcher = engine.acquireSearcher("test");){
            TotalHitCountCollector collector = new TotalHitCountCollector();
            searcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
            EngineTestCase.assertThat((Object)collector.getTotalHits(), (Matcher)Matchers.equalTo((Object)numDocs));
        }
    }

    protected Settings indexSettings() {
        return Settings.builder().put(IndexSettings.INDEX_GC_DELETES_SETTING.getKey(), "1h").put(EngineConfig.INDEX_CODEC_SETTING.getKey(), this.codecName).put("index.version.created", Version.CURRENT).put(IndexSettings.MAX_REFRESH_LISTENERS_PER_SHARD.getKey(), EngineTestCase.between(10, 10 * (Integer)IndexSettings.MAX_REFRESH_LISTENERS_PER_SHARD.get(Settings.EMPTY))).put(IndexSettings.INDEX_SOFT_DELETES_RETENTION_OPERATIONS_SETTING.getKey(), EngineTestCase.between(0, 1000)).build();
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.primaryTerm.set(EngineTestCase.randomLongBetween(1L, Long.MAX_VALUE));
        CodecService codecService = new CodecService(null, INDEX_SETTINGS, this.logger);
        String name = Codec.getDefault().getName();
        this.codecName = Arrays.asList(codecService.availableCodecs()).contains(name) ? name : "default";
        this.defaultSettings = IndexSettingsModule.newIndexSettings("test", this.indexSettings(), new Setting[0]);
        this.threadPool = new TestThreadPool(((Object)((Object)this)).getClass().getName(), new ExecutorBuilder[0]);
        this.store = this.createStore();
        this.storeReplica = this.createStore();
        Lucene.cleanLuceneIndex((Directory)this.store.directory());
        Lucene.cleanLuceneIndex((Directory)this.storeReplica.directory());
        this.primaryTranslogDir = EngineTestCase.createTempDir((String)"translog-primary");
        this.engine = this.createEngine(this.store, this.primaryTranslogDir);
        LiveIndexWriterConfig currentIndexWriterConfig = this.engine.getCurrentIndexWriterConfig();
        EngineTestCase.assertEquals((Object)this.engine.config().getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        EngineTestCase.assertEquals((Object)currentIndexWriterConfig.getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        if (EngineTestCase.randomBoolean()) {
            this.engine.config().setEnableGcDeletes(false);
        }
        this.replicaTranslogDir = EngineTestCase.createTempDir((String)"translog-replica");
        this.replicaEngine = this.createEngine(this.storeReplica, this.replicaTranslogDir);
        currentIndexWriterConfig = this.replicaEngine.getCurrentIndexWriterConfig();
        EngineTestCase.assertEquals((Object)this.replicaEngine.config().getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        EngineTestCase.assertEquals((Object)currentIndexWriterConfig.getCodec().getName(), (Object)codecService.codec(this.codecName).getName());
        if (EngineTestCase.randomBoolean()) {
            this.engine.config().setEnableGcDeletes(false);
        }
    }

    public EngineConfig copy(EngineConfig config, LongSupplier globalCheckpointSupplier) {
        return new EngineConfig.Builder().shardId(config.getShardId()).threadPool(config.getThreadPool()).indexSettings(config.getIndexSettings()).warmer(config.getWarmer()).store(config.getStore()).mergePolicy(config.getMergePolicy()).analyzer(config.getAnalyzer()).similarity(config.getSimilarity()).codecService(new CodecService(null, config.getIndexSettings(), this.logger)).eventListener(config.getEventListener()).queryCache(config.getQueryCache()).queryCachingPolicy(config.getQueryCachingPolicy()).translogConfig(config.getTranslogConfig()).flushMergesAfter(config.getFlushMergesAfter()).externalRefreshListener(config.getExternalRefreshListener()).internalRefreshListener(Collections.emptyList()).indexSort(config.getIndexSort()).circuitBreakerService(config.getCircuitBreakerService()).globalCheckpointSupplier(globalCheckpointSupplier).retentionLeasesSupplier(config.retentionLeasesSupplier()).primaryTermSupplier(config.getPrimaryTermSupplier()).tombstoneDocSupplier(EngineTestCase.tombstoneDocSupplier()).build();
    }

    public EngineConfig copy(EngineConfig config, Analyzer analyzer) {
        return new EngineConfig.Builder().shardId(config.getShardId()).threadPool(config.getThreadPool()).indexSettings(config.getIndexSettings()).warmer(config.getWarmer()).store(config.getStore()).mergePolicy(config.getMergePolicy()).analyzer(analyzer).similarity(config.getSimilarity()).codecService(new CodecService(null, config.getIndexSettings(), this.logger)).eventListener(config.getEventListener()).queryCache(config.getQueryCache()).queryCachingPolicy(config.getQueryCachingPolicy()).translogConfig(config.getTranslogConfig()).flushMergesAfter(config.getFlushMergesAfter()).externalRefreshListener(config.getExternalRefreshListener()).internalRefreshListener(Collections.emptyList()).indexSort(config.getIndexSort()).circuitBreakerService(config.getCircuitBreakerService()).globalCheckpointSupplier(config.getGlobalCheckpointSupplier()).retentionLeasesSupplier(config.retentionLeasesSupplier()).primaryTermSupplier(config.getPrimaryTermSupplier()).tombstoneDocSupplier(config.getTombstoneDocSupplier()).build();
    }

    public EngineConfig copy(EngineConfig config, MergePolicy mergePolicy) {
        return new EngineConfig.Builder().shardId(config.getShardId()).threadPool(config.getThreadPool()).indexSettings(config.getIndexSettings()).warmer(config.getWarmer()).store(config.getStore()).mergePolicy(mergePolicy).analyzer(config.getAnalyzer()).similarity(config.getSimilarity()).codecService(new CodecService(null, config.getIndexSettings(), this.logger)).eventListener(config.getEventListener()).queryCache(config.getQueryCache()).queryCachingPolicy(config.getQueryCachingPolicy()).translogConfig(config.getTranslogConfig()).flushMergesAfter(config.getFlushMergesAfter()).externalRefreshListener(config.getExternalRefreshListener()).internalRefreshListener(Collections.emptyList()).indexSort(config.getIndexSort()).circuitBreakerService(config.getCircuitBreakerService()).globalCheckpointSupplier(config.getGlobalCheckpointSupplier()).retentionLeasesSupplier(config.retentionLeasesSupplier()).primaryTermSupplier(config.getPrimaryTermSupplier()).tombstoneDocSupplier(config.getTombstoneDocSupplier()).build();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        try {
            if (this.engine != null && !this.engine.isClosed.get()) {
                this.engine.ensureOpen();
                this.assertEngineCleanedUp((Engine)this.engine, this.assertAndGetInternalTranslogManager(this.engine.translogManager()).getDeletionPolicy());
            }
            if (this.replicaEngine != null && !this.replicaEngine.isClosed.get()) {
                this.replicaEngine.ensureOpen();
                this.assertEngineCleanedUp((Engine)this.replicaEngine, this.assertAndGetInternalTranslogManager(this.replicaEngine.translogManager()).getDeletionPolicy());
            }
        }
        catch (Throwable throwable) {
            IOUtils.close((Closeable[])new Closeable[]{this.replicaEngine, this.storeReplica, this.engine, this.store, () -> EngineTestCase.terminate(this.threadPool)});
            throw throwable;
        }
        IOUtils.close((Closeable[])new Closeable[]{this.replicaEngine, this.storeReplica, this.engine, this.store, () -> EngineTestCase.terminate(this.threadPool)});
    }

    protected InternalTranslogManager assertAndGetInternalTranslogManager(TranslogManager translogManager) {
        EngineTestCase.assertThat((Object)translogManager, (Matcher)Matchers.instanceOf(InternalTranslogManager.class));
        return (InternalTranslogManager)translogManager;
    }

    protected void assertEngineCleanedUp(Engine engine, TranslogDeletionPolicy translogDeletionPolicy) throws Exception {
        if (!engine.isClosed.get()) {
            translogDeletionPolicy.assertNoOpenTranslogRefs();
            EngineTestCase.assertConsistentHistoryBetweenTranslogAndLuceneIndex(engine);
            EngineTestCase.assertNoInFlightDocuments(engine);
            EngineTestCase.assertMaxSeqNoInCommitUserData(engine);
            EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber(engine);
        }
    }

    protected static ParseContext.Document testDocumentWithTextField() {
        return EngineTestCase.testDocumentWithTextField("test");
    }

    protected static ParseContext.Document testDocumentWithTextField(String value) {
        ParseContext.Document document = EngineTestCase.testDocument();
        document.add((IndexableField)new TextField("value", value, Field.Store.YES));
        return document;
    }

    protected static ParseContext.Document testDocument() {
        return new ParseContext.Document();
    }

    public static ParsedDocument createParsedDoc(String id, String routing) {
        return EngineTestCase.testParsedDocument(id, routing, EngineTestCase.testDocumentWithTextField(), (BytesReference)new BytesArray("{ \"value\" : \"test\" }"), null);
    }

    public static ParsedDocument createParsedDoc(String id, String routing, boolean recoverySource) {
        return EngineTestCase.testParsedDocument(id, routing, EngineTestCase.testDocumentWithTextField(), (BytesReference)new BytesArray("{ \"value\" : \"test\" }"), null, recoverySource);
    }

    protected static ParsedDocument testParsedDocument(String id, String routing, ParseContext.Document document, BytesReference source, Mapping mappingUpdate) {
        return EngineTestCase.testParsedDocument(id, routing, document, source, mappingUpdate, false);
    }

    protected static ParsedDocument testParsedDocument(String id, String routing, ParseContext.Document document, BytesReference source, Mapping mappingUpdate, boolean recoverySource) {
        Field uidField = new Field("_id", Uid.encodeId((String)id), (IndexableFieldType)IdFieldMapper.Defaults.FIELD_TYPE);
        NumericDocValuesField versionField = new NumericDocValuesField("_version", 0L);
        SeqNoFieldMapper.SequenceIDFields seqID = SeqNoFieldMapper.SequenceIDFields.emptySeqID();
        document.add((IndexableField)uidField);
        document.add((IndexableField)versionField);
        document.add((IndexableField)seqID.seqNo);
        document.add((IndexableField)seqID.seqNoDocValue);
        document.add((IndexableField)seqID.primaryTerm);
        BytesRef ref = source.toBytesRef();
        if (recoverySource) {
            document.add((IndexableField)new StoredField("_recovery_source", ref.bytes, ref.offset, ref.length));
            document.add((IndexableField)new NumericDocValuesField("_recovery_source", 1L));
        } else {
            document.add((IndexableField)new StoredField("_source", ref.bytes, ref.offset, ref.length));
        }
        return new ParsedDocument((Field)versionField, seqID, id, routing, Arrays.asList(document), source, MediaTypeRegistry.JSON, mappingUpdate);
    }

    public static CheckedBiFunction<String, Integer, ParsedDocument, IOException> nestedParsedDocFactory() throws Exception {
        MapperService mapperService = EngineTestCase.createMapperService();
        String nestedMapping = XContentFactory.jsonBuilder().startObject().startObject("type").startObject("properties").startObject("nested_field").field("type", "nested").endObject().endObject().endObject().endObject().toString();
        DocumentMapper nestedMapper = mapperService.documentMapperParser().parse("type", new CompressedXContent(nestedMapping));
        return (docId, nestedFieldValues) -> {
            XContentBuilder source = XContentFactory.jsonBuilder().startObject().field("field", "value");
            if (nestedFieldValues > 0) {
                XContentBuilder nestedField = source.startObject("nested_field");
                for (int i = 0; i < nestedFieldValues; ++i) {
                    nestedField.field("field-" + i, "value-" + i);
                }
                source.endObject();
            }
            source.endObject();
            return nestedMapper.parse(new SourceToParse("test", docId, BytesReference.bytes((XContentBuilder)source), MediaTypeRegistry.JSON));
        };
    }

    public static EngineConfig.TombstoneDocSupplier tombstoneDocSupplier() {
        return new EngineConfig.TombstoneDocSupplier(){

            public ParsedDocument newDeleteTombstoneDoc(String id) {
                ParseContext.Document doc = new ParseContext.Document();
                Field uidField = new Field("_id", Uid.encodeId((String)id), (IndexableFieldType)IdFieldMapper.Defaults.FIELD_TYPE);
                doc.add((IndexableField)uidField);
                NumericDocValuesField versionField = new NumericDocValuesField("_version", 0L);
                doc.add((IndexableField)versionField);
                SeqNoFieldMapper.SequenceIDFields seqID = SeqNoFieldMapper.SequenceIDFields.emptySeqID();
                doc.add((IndexableField)seqID.seqNo);
                doc.add((IndexableField)seqID.seqNoDocValue);
                doc.add((IndexableField)seqID.primaryTerm);
                seqID.tombstoneField.setLongValue(1L);
                doc.add((IndexableField)seqID.tombstoneField);
                return new ParsedDocument((Field)versionField, seqID, id, null, Collections.singletonList(doc), (BytesReference)new BytesArray("{}"), MediaTypeRegistry.JSON, null);
            }

            public ParsedDocument newNoopTombstoneDoc(String reason) {
                ParseContext.Document doc = new ParseContext.Document();
                SeqNoFieldMapper.SequenceIDFields seqID = SeqNoFieldMapper.SequenceIDFields.emptySeqID();
                doc.add((IndexableField)seqID.seqNo);
                doc.add((IndexableField)seqID.seqNoDocValue);
                doc.add((IndexableField)seqID.primaryTerm);
                seqID.tombstoneField.setLongValue(1L);
                doc.add((IndexableField)seqID.tombstoneField);
                NumericDocValuesField versionField = new NumericDocValuesField("_version", 0L);
                doc.add((IndexableField)versionField);
                BytesRef byteRef = new BytesRef((CharSequence)reason);
                doc.add((IndexableField)new StoredField("_source", byteRef.bytes, byteRef.offset, byteRef.length));
                return new ParsedDocument((Field)versionField, seqID, null, null, Collections.singletonList(doc), null, MediaTypeRegistry.JSON, null);
            }
        };
    }

    protected Store createStore() throws IOException {
        return this.createStore((Directory)EngineTestCase.newDirectory());
    }

    protected Store createStore(Directory directory) throws IOException {
        return this.createStore(INDEX_SETTINGS, directory);
    }

    protected Store createStore(IndexSettings indexSettings, Directory directory) throws IOException {
        return new Store(this.shardId, indexSettings, directory, (ShardLock)new DummyShardLock(this.shardId));
    }

    protected Translog createTranslog(LongSupplier primaryTermSupplier) throws IOException {
        return this.createTranslog(this.primaryTranslogDir, primaryTermSupplier);
    }

    protected Translog createTranslog(Path translogPath, LongSupplier primaryTermSupplier) throws IOException {
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, INDEX_SETTINGS, BigArrays.NON_RECYCLING_INSTANCE, "", false);
        String translogUUID = Translog.createEmptyTranslog((Path)translogPath, (long)-1L, (ShardId)this.shardId, (long)primaryTermSupplier.getAsLong());
        return new LocalTranslog(translogConfig, translogUUID, TranslogDeletionPolicies.createTranslogDeletionPolicy(INDEX_SETTINGS), () -> -1L, primaryTermSupplier, seqNo -> {});
    }

    protected TranslogHandler createTranslogHandler(IndexSettings indexSettings, Engine engine) {
        return new TranslogHandler(this.xContentRegistry(), indexSettings, engine);
    }

    protected InternalEngine createEngine(Store store, Path translogPath) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, LongSupplier globalCheckpointSupplier) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, localCheckpointTrackerSupplier, null);
    }

    protected InternalEngine createEngine(Store store, Path translogPath, BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation) throws IOException {
        return this.createEngine(this.defaultSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, localCheckpointTrackerSupplier, null, seqNoForOperation);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, null);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, null, null);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable LongSupplier globalCheckpointSupplier) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, localCheckpointTrackerSupplier, null, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable LongSupplier globalCheckpointSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation) throws IOException {
        return this.createEngine(indexSettings, store, translogPath, mergePolicy, indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, null, globalCheckpointSupplier);
    }

    protected InternalEngine createEngine(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, @Nullable Sort indexSort, @Nullable LongSupplier globalCheckpointSupplier) throws IOException {
        EngineConfig config = this.config(indexSettings, store, translogPath, mergePolicy, null, indexSort, globalCheckpointSupplier);
        return this.createEngine(indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, config);
    }

    protected InternalEngine createEngine(EngineConfig config) throws IOException {
        return this.createEngine(null, null, null, config);
    }

    protected InternalEngine createEngine(@Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, EngineConfig config) throws IOException {
        Store store = config.getStore();
        Directory directory = store.directory();
        if (!Lucene.indexExists((Directory)directory)) {
            store.createEmpty(config.getIndexSettings().getIndexVersionCreated().luceneVersion);
            String translogUuid = Translog.createEmptyTranslog((Path)config.getTranslogConfig().getTranslogPath(), (long)-1L, (ShardId)this.shardId, (long)this.primaryTerm.get());
            store.associateIndexWithNewTranslog(translogUuid);
        }
        InternalEngine internalEngine = EngineTestCase.createInternalEngine(indexWriterFactory, localCheckpointTrackerSupplier, seqNoForOperation, config);
        this.translogHandler = this.createTranslogHandler(config.getIndexSettings(), (Engine)internalEngine);
        internalEngine.translogManager().recoverFromTranslog((TranslogRecoveryRunner)this.translogHandler, internalEngine.getProcessedLocalCheckpoint(), Long.MAX_VALUE);
        return internalEngine;
    }

    public static InternalEngine createEngine(EngineConfig engineConfig, int maxDocs) {
        return new InternalEngine(engineConfig, maxDocs, LocalCheckpointTracker::new, TranslogEventListener.NOOP_TRANSLOG_EVENT_LISTENER);
    }

    public static long generateNewSeqNo(Engine engine) {
        assert (engine instanceof InternalEngine) : "expected InternalEngine, got: " + String.valueOf(engine.getClass());
        InternalEngine internalEngine = (InternalEngine)engine;
        return internalEngine.getLocalCheckpointTracker().generateSeqNo();
    }

    public static InternalEngine createInternalEngine(final @Nullable IndexWriterFactory indexWriterFactory, @Nullable BiFunction<Long, Long, LocalCheckpointTracker> localCheckpointTrackerSupplier, final @Nullable ToLongBiFunction<Engine, Engine.Operation> seqNoForOperation, EngineConfig config) {
        if (localCheckpointTrackerSupplier == null) {
            return new InternalTestEngine(config){

                IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
                    return indexWriterFactory != null ? indexWriterFactory.createWriter(directory, iwc) : super.createWriter(directory, iwc);
                }

                protected long doGenerateSeqNoForOperation(Engine.Operation operation) {
                    return seqNoForOperation != null ? seqNoForOperation.applyAsLong(this, operation) : super.doGenerateSeqNoForOperation(operation);
                }
            };
        }
        return new InternalTestEngine(config, 0x7FFFFF7F, localCheckpointTrackerSupplier){

            IndexWriter createWriter(Directory directory, IndexWriterConfig iwc) throws IOException {
                return indexWriterFactory != null ? indexWriterFactory.createWriter(directory, iwc) : super.createWriter(directory, iwc);
            }

            protected long doGenerateSeqNoForOperation(Engine.Operation operation) {
                return seqNoForOperation != null ? seqNoForOperation.applyAsLong(this, operation) : super.doGenerateSeqNoForOperation(operation);
            }
        };
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener) {
        return this.config(indexSettings, store, translogPath, mergePolicy, refreshListener, null, () -> -1L);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener, Sort indexSort, LongSupplier globalCheckpointSupplier) {
        return this.config(indexSettings, store, translogPath, mergePolicy, refreshListener, indexSort, globalCheckpointSupplier, globalCheckpointSupplier == null ? null : () -> RetentionLeases.EMPTY);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener refreshListener, Sort indexSort, LongSupplier globalCheckpointSupplier, Supplier<RetentionLeases> retentionLeasesSupplier) {
        return this.config(indexSettings, store, translogPath, mergePolicy, refreshListener, null, indexSort, globalCheckpointSupplier, retentionLeasesSupplier, (CircuitBreakerService)new NoneCircuitBreakerService());
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener externalRefreshListener, ReferenceManager.RefreshListener internalRefreshListener, Sort indexSort, @Nullable LongSupplier maybeGlobalCheckpointSupplier, CircuitBreakerService breakerService) {
        return this.config(indexSettings, store, translogPath, mergePolicy, externalRefreshListener, internalRefreshListener, indexSort, maybeGlobalCheckpointSupplier, maybeGlobalCheckpointSupplier == null ? null : () -> RetentionLeases.EMPTY, breakerService);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener externalRefreshListener, ReferenceManager.RefreshListener internalRefreshListener, Sort indexSort, @Nullable LongSupplier maybeGlobalCheckpointSupplier, @Nullable Supplier<RetentionLeases> maybeRetentionLeasesSupplier, CircuitBreakerService breakerService) {
        Engine.EventListener eventListener = new Engine.EventListener(this){};
        return this.config(indexSettings, store, translogPath, mergePolicy, externalRefreshListener, internalRefreshListener, indexSort, maybeGlobalCheckpointSupplier, maybeGlobalCheckpointSupplier == null ? null : () -> RetentionLeases.EMPTY, breakerService, eventListener);
    }

    public EngineConfig config(IndexSettings indexSettings, Store store, Path translogPath, MergePolicy mergePolicy, ReferenceManager.RefreshListener externalRefreshListener, ReferenceManager.RefreshListener internalRefreshListener, Sort indexSort, @Nullable LongSupplier maybeGlobalCheckpointSupplier, @Nullable Supplier<RetentionLeases> maybeRetentionLeasesSupplier, CircuitBreakerService breakerService, Engine.EventListener eventListener) {
        Supplier<RetentionLeases> retentionLeasesSupplier;
        LongSupplier globalCheckpointSupplier;
        List<Object> intRefreshListenerList;
        IndexWriterConfig iwc = EngineTestCase.newIndexWriterConfig();
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, indexSettings, BigArrays.NON_RECYCLING_INSTANCE, "", false);
        List<Object> extRefreshListenerList = externalRefreshListener == null ? Collections.emptyList() : Collections.singletonList(externalRefreshListener);
        List<Object> list = intRefreshListenerList = internalRefreshListener == null ? Collections.emptyList() : Collections.singletonList(internalRefreshListener);
        if (maybeGlobalCheckpointSupplier == null) {
            assert (maybeRetentionLeasesSupplier == null);
            ReplicationTracker replicationTracker = new ReplicationTracker(this.shardId, this.allocationId.getId(), indexSettings, EngineTestCase.randomNonNegativeLong(), -1L, update -> {}, () -> 0L, (leases, listener) -> listener.onResponse((Object)new ReplicationResponse()), () -> SafeCommitInfo.EMPTY, sId -> false);
            globalCheckpointSupplier = replicationTracker;
            retentionLeasesSupplier = () -> ((ReplicationTracker)replicationTracker).getRetentionLeases();
        } else {
            assert (maybeRetentionLeasesSupplier != null);
            globalCheckpointSupplier = maybeGlobalCheckpointSupplier;
            retentionLeasesSupplier = maybeRetentionLeasesSupplier;
        }
        return new EngineConfig.Builder().shardId(this.shardId).threadPool(this.threadPool).indexSettings(indexSettings).warmer(null).store(store).mergePolicy(mergePolicy).analyzer(iwc.getAnalyzer()).similarity(iwc.getSimilarity()).codecService(new CodecService(null, indexSettings, this.logger)).eventListener(eventListener).queryCache(IndexSearcher.getDefaultQueryCache()).queryCachingPolicy(IndexSearcher.getDefaultQueryCachingPolicy()).translogConfig(translogConfig).flushMergesAfter(TimeValue.timeValueMinutes((long)5L)).externalRefreshListener(extRefreshListenerList).internalRefreshListener(intRefreshListenerList).indexSort(indexSort).circuitBreakerService(breakerService).globalCheckpointSupplier(globalCheckpointSupplier).retentionLeasesSupplier(retentionLeasesSupplier).primaryTermSupplier((LongSupplier)this.primaryTerm).tombstoneDocSupplier(EngineTestCase.tombstoneDocSupplier()).build();
    }

    protected EngineConfig config(EngineConfig config, Store store, Path translogPath, EngineConfig.TombstoneDocSupplier tombstoneDocSupplier) {
        IndexSettings indexSettings = IndexSettingsModule.newIndexSettings("test", Settings.builder().put(config.getIndexSettings().getSettings()).put(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), true).build(), new Setting[0]);
        TranslogConfig translogConfig = new TranslogConfig(this.shardId, translogPath, indexSettings, BigArrays.NON_RECYCLING_INSTANCE, "", false);
        return new EngineConfig.Builder().shardId(config.getShardId()).threadPool(config.getThreadPool()).indexSettings(indexSettings).warmer(config.getWarmer()).store(store).mergePolicy(config.getMergePolicy()).analyzer(config.getAnalyzer()).similarity(config.getSimilarity()).codecService(new CodecService(null, indexSettings, this.logger)).eventListener(config.getEventListener()).queryCache(config.getQueryCache()).queryCachingPolicy(config.getQueryCachingPolicy()).translogConfig(translogConfig).flushMergesAfter(config.getFlushMergesAfter()).externalRefreshListener(config.getExternalRefreshListener()).internalRefreshListener(config.getInternalRefreshListener()).indexSort(config.getIndexSort()).circuitBreakerService(config.getCircuitBreakerService()).globalCheckpointSupplier(config.getGlobalCheckpointSupplier()).retentionLeasesSupplier(config.retentionLeasesSupplier()).primaryTermSupplier(config.getPrimaryTermSupplier()).tombstoneDocSupplier(tombstoneDocSupplier).build();
    }

    protected EngineConfig config(EngineConfig config, Supplier<DocumentMapperForType> documentMapperForTypeSupplier) {
        IndexSettings indexSettings = IndexSettingsModule.newIndexSettings("test", Settings.builder().put(config.getIndexSettings().getSettings()).build(), new Setting[0]);
        return new EngineConfig.Builder().shardId(config.getShardId()).threadPool(config.getThreadPool()).indexSettings(indexSettings).warmer(config.getWarmer()).store(config.getStore()).mergePolicy(config.getMergePolicy()).analyzer(config.getAnalyzer()).similarity(config.getSimilarity()).codecService(new CodecService(null, indexSettings, this.logger)).eventListener(config.getEventListener()).queryCache(config.getQueryCache()).queryCachingPolicy(config.getQueryCachingPolicy()).translogConfig(config.getTranslogConfig()).flushMergesAfter(config.getFlushMergesAfter()).externalRefreshListener(config.getExternalRefreshListener()).internalRefreshListener(config.getInternalRefreshListener()).indexSort(config.getIndexSort()).circuitBreakerService(config.getCircuitBreakerService()).globalCheckpointSupplier(config.getGlobalCheckpointSupplier()).retentionLeasesSupplier(config.retentionLeasesSupplier()).primaryTermSupplier(config.getPrimaryTermSupplier()).tombstoneDocSupplier(config.getTombstoneDocSupplier()).documentMapperForTypeSupplier(documentMapperForTypeSupplier).build();
    }

    protected EngineConfig noOpConfig(IndexSettings indexSettings, Store store, Path translogPath) {
        return this.noOpConfig(indexSettings, store, translogPath, null);
    }

    protected EngineConfig noOpConfig(IndexSettings indexSettings, Store store, Path translogPath, LongSupplier globalCheckpointSupplier) {
        return this.config(indexSettings, store, translogPath, EngineTestCase.newMergePolicy(), null, null, globalCheckpointSupplier);
    }

    protected static BytesArray bytesArray(String string) {
        return new BytesArray(string.getBytes(Charset.defaultCharset()));
    }

    public static Term newUid(String id) {
        return new Term("_id", Uid.encodeId((String)id));
    }

    public static Term newUid(ParsedDocument doc) {
        return EngineTestCase.newUid(doc.id());
    }

    protected Engine.Get newGet(boolean realtime, ParsedDocument doc) {
        return new Engine.Get(realtime, realtime, doc.id(), EngineTestCase.newUid(doc));
    }

    protected Engine.Index indexForDoc(ParsedDocument doc) {
        return new Engine.Index(EngineTestCase.newUid(doc), this.primaryTerm.get(), doc);
    }

    protected Engine.Index replicaIndexForDoc(ParsedDocument doc, long version, long seqNo, boolean isRetry) {
        return new Engine.Index(EngineTestCase.newUid(doc), doc, seqNo, this.primaryTerm.get(), version, null, Engine.Operation.Origin.REPLICA, System.nanoTime(), -1L, isRetry, -2L, 0L);
    }

    protected Engine.Delete replicaDeleteForDoc(String id, long version, long seqNo, long startTime) {
        return new Engine.Delete(id, EngineTestCase.newUid(id), seqNo, 1L, version, null, Engine.Operation.Origin.REPLICA, startTime, -2L, 0L);
    }

    protected static void assertVisibleCount(InternalEngine engine, int numDocs) throws IOException {
        EngineTestCase.assertVisibleCount(engine, numDocs, true);
    }

    protected static void assertVisibleCount(InternalEngine engine, int numDocs, boolean refresh) throws IOException {
        if (refresh) {
            engine.refresh("test");
        }
        try (Engine.Searcher searcher = engine.acquireSearcher("test");){
            TotalHitCountCollector collector = new TotalHitCountCollector();
            searcher.search((Query)new MatchAllDocsQuery(), (Collector)collector);
            EngineTestCase.assertThat((Object)collector.getTotalHits(), (Matcher)Matchers.equalTo((Object)numDocs));
        }
    }

    public static List<Engine.Operation> generateSingleDocHistory(boolean forReplica, VersionType versionType, long primaryTerm, int minOpCount, int maxOpCount, String docId) {
        int numOfOps = EngineTestCase.randomIntBetween(minOpCount, maxOpCount);
        ArrayList<Engine.Operation> ops = new ArrayList<Engine.Operation>();
        Term id = EngineTestCase.newUid(docId);
        boolean startWithSeqNo = false;
        String valuePrefix = (forReplica ? "r_" : "p_") + docId + "_";
        boolean incrementTermWhenIntroducingSeqNo = EngineTestCase.randomBoolean();
        for (int i = 0; i < numOfOps; ++i) {
            long version = switch (versionType) {
                case VersionType.INTERNAL -> forReplica ? (long)i : -3L;
                case VersionType.EXTERNAL -> i;
                case VersionType.EXTERNAL_GTE -> EngineTestCase.randomBoolean() ? (long)Math.max(i - 1, 0) : (long)i;
                default -> throw new UnsupportedOperationException("unknown version type: " + String.valueOf(versionType));
            };
            Object op = EngineTestCase.randomBoolean() ? new Engine.Index(id, EngineTestCase.testParsedDocument(docId, null, EngineTestCase.testDocumentWithTextField(valuePrefix + i), (BytesReference)SOURCE, null), forReplica && i >= 0 ? (long)(i * 2) : -2L, forReplica && i >= 0 && incrementTermWhenIntroducingSeqNo ? primaryTerm + 1L : primaryTerm, version, forReplica ? null : versionType, forReplica ? Engine.Operation.Origin.REPLICA : Engine.Operation.Origin.PRIMARY, System.currentTimeMillis(), -1L, false, -2L, 0L) : new Engine.Delete(docId, id, forReplica && i >= 0 ? (long)(i * 2) : -2L, forReplica && i >= 0 && incrementTermWhenIntroducingSeqNo ? primaryTerm + 1L : primaryTerm, version, forReplica ? null : versionType, forReplica ? Engine.Operation.Origin.REPLICA : Engine.Operation.Origin.PRIMARY, System.currentTimeMillis(), -2L, 0L);
            ops.add((Engine.Operation)op);
        }
        return ops;
    }

    public List<Engine.Operation> generateHistoryOnReplica(int numOps, boolean allowGapInSeqNo, boolean allowDuplicate, boolean includeNestedDocs) throws Exception {
        return this.generateHistoryOnReplica(numOps, allowGapInSeqNo, allowDuplicate, includeNestedDocs, EngineTestCase.randomFrom(Engine.Operation.TYPE.values()));
    }

    public List<Engine.Operation> generateHistoryOnReplica(int numOps, boolean allowGapInSeqNo, boolean allowDuplicate, boolean includeNestedDocs, Engine.Operation.TYPE opType) throws Exception {
        long seqNo = 0L;
        int maxIdValue = EngineTestCase.randomInt(numOps * 2);
        ArrayList<Engine.Operation> operations = new ArrayList<Engine.Operation>(numOps);
        CheckedBiFunction<String, Integer, ParsedDocument, IOException> nestedParsedDocFactory = EngineTestCase.nestedParsedDocFactory();
        for (int i = 0; i < numOps; ++i) {
            String id = Integer.toString(EngineTestCase.randomInt(maxIdValue));
            boolean isNestedDoc = includeNestedDocs && opType == Engine.Operation.TYPE.INDEX && EngineTestCase.randomBoolean();
            int nestedValues = EngineTestCase.between(0, 3);
            long startTime = this.threadPool.relativeTimeInNanos();
            int copies = allowDuplicate && EngineTestCase.rarely() ? EngineTestCase.between(2, 4) : 1;
            block6: for (int copy = 0; copy < copies; ++copy) {
                ParsedDocument doc = isNestedDoc ? (ParsedDocument)nestedParsedDocFactory.apply((Object)id, (Object)nestedValues) : EngineTestCase.createParsedDoc(id, null);
                switch (opType) {
                    case INDEX: {
                        operations.add((Engine.Operation)new Engine.Index(EngineTestCase.newUid(doc), doc, seqNo, this.primaryTerm.get(), (long)i, null, EngineTestCase.randomFrom(Engine.Operation.Origin.REPLICA, Engine.Operation.Origin.PEER_RECOVERY), startTime, -1L, true, -2L, 0L));
                        continue block6;
                    }
                    case DELETE: {
                        operations.add((Engine.Operation)new Engine.Delete(doc.id(), EngineTestCase.newUid(doc), seqNo, this.primaryTerm.get(), (long)i, null, EngineTestCase.randomFrom(Engine.Operation.Origin.REPLICA, Engine.Operation.Origin.PEER_RECOVERY), startTime, -2L, 0L));
                        continue block6;
                    }
                    case NO_OP: {
                        operations.add((Engine.Operation)new Engine.NoOp(seqNo, this.primaryTerm.get(), EngineTestCase.randomFrom(Engine.Operation.Origin.REPLICA, Engine.Operation.Origin.PEER_RECOVERY), startTime, "test-" + i));
                        continue block6;
                    }
                    default: {
                        throw new IllegalStateException("Unknown operation type [" + String.valueOf(opType) + "]");
                    }
                }
            }
            ++seqNo;
            if (!allowGapInSeqNo || !EngineTestCase.rarely()) continue;
            ++seqNo;
        }
        Randomness.shuffle(operations);
        return operations;
    }

    public static void assertOpsOnReplica(List<Engine.Operation> ops, InternalEngine replicaEngine, boolean shuffleOps, Logger logger) throws IOException {
        String lastFieldValue;
        Engine.Operation lastOp = ops.get(ops.size() - 1);
        if (lastOp instanceof Engine.Index) {
            Engine.Index index = (Engine.Index)lastOp;
            lastFieldValue = ((ParseContext.Document)index.docs().get(0)).get("value");
        } else {
            lastFieldValue = null;
        }
        if (shuffleOps) {
            int firstOpWithSeqNo;
            for (firstOpWithSeqNo = 0; firstOpWithSeqNo < ops.size() && ops.get(firstOpWithSeqNo).seqNo() < 0L; ++firstOpWithSeqNo) {
            }
            Collections.shuffle(ops.subList(0, firstOpWithSeqNo), EngineTestCase.random());
            Collections.shuffle(ops.subList(firstOpWithSeqNo, ops.size()), EngineTestCase.random());
        }
        boolean firstOp = true;
        for (Engine.Operation op : ops) {
            logger.info("performing [{}], v [{}], seq# [{}], term [{}]", (Object)Character.valueOf(op.operationType().name().charAt(0)), (Object)op.version(), (Object)op.seqNo(), (Object)op.primaryTerm());
            if (op instanceof Engine.Index) {
                result = replicaEngine.index((Engine.Index)op);
                EngineTestCase.assertThat((Object)result.isCreated(), (Matcher)Matchers.equalTo((Object)firstOp));
                EngineTestCase.assertThat((Object)result.getVersion(), (Matcher)Matchers.equalTo((Object)op.version()));
                EngineTestCase.assertThat((Object)result.getResultType(), (Matcher)Matchers.equalTo((Object)Engine.Result.Type.SUCCESS));
            } else {
                result = replicaEngine.delete((Engine.Delete)op);
                EngineTestCase.assertThat((Object)result.isFound(), (Matcher)Matchers.equalTo((Object)(!firstOp ? 1 : 0)));
                EngineTestCase.assertThat((Object)result.getVersion(), (Matcher)Matchers.equalTo((Object)op.version()));
                EngineTestCase.assertThat((Object)result.getResultType(), (Matcher)Matchers.equalTo((Object)Engine.Result.Type.SUCCESS));
            }
            if (EngineTestCase.randomBoolean()) {
                replicaEngine.refresh("test");
            }
            if (EngineTestCase.randomBoolean()) {
                replicaEngine.flush();
                replicaEngine.refresh("test");
            }
            firstOp = false;
        }
        EngineTestCase.assertVisibleCount(replicaEngine, lastFieldValue == null ? 0 : 1);
        if (lastFieldValue != null) {
            try (Engine.Searcher searcher = replicaEngine.acquireSearcher("test");){
                TotalHitCountCollector collector = new TotalHitCountCollector();
                searcher.search((Query)new TermQuery(new Term("value", lastFieldValue)), (Collector)collector);
                EngineTestCase.assertThat((Object)collector.getTotalHits(), (Matcher)Matchers.equalTo((Object)1));
            }
        }
    }

    public static void concurrentlyApplyOps(List<Engine.Operation> ops, InternalEngine engine) throws InterruptedException {
        int i;
        Thread[] thread = new Thread[EngineTestCase.randomIntBetween(3, 5)];
        CountDownLatch startGun = new CountDownLatch(thread.length);
        AtomicInteger offset = new AtomicInteger(-1);
        for (i = 0; i < thread.length; ++i) {
            thread[i] = new Thread(() -> {
                int docOffset;
                startGun.countDown();
                try {
                    startGun.await();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                while ((docOffset = offset.incrementAndGet()) < ops.size()) {
                    try {
                        EngineTestCase.applyOperation((Engine)engine, (Engine.Operation)ops.get(docOffset));
                        if ((docOffset + 1) % 4 == 0) {
                            engine.refresh("test");
                        }
                        if (!EngineTestCase.rarely()) continue;
                        engine.flush();
                    }
                    catch (IOException e) {
                        throw new AssertionError((Object)e);
                    }
                }
            });
            thread[i].start();
        }
        for (i = 0; i < thread.length; ++i) {
            thread[i].join();
        }
    }

    public static void applyOperations(Engine engine, List<Engine.Operation> operations) throws IOException {
        for (Engine.Operation operation : operations) {
            EngineTestCase.applyOperation(engine, operation);
            if (EngineTestCase.randomInt(100) < 10) {
                engine.refresh("test");
            }
            if (!EngineTestCase.rarely()) continue;
            engine.flush();
        }
    }

    public static Engine.Result applyOperation(Engine engine, Engine.Operation operation) throws IOException {
        return switch (operation.operationType()) {
            case Engine.Operation.TYPE.INDEX -> engine.index((Engine.Index)operation);
            case Engine.Operation.TYPE.DELETE -> engine.delete((Engine.Delete)operation);
            case Engine.Operation.TYPE.NO_OP -> engine.noOp((Engine.NoOp)operation);
            default -> throw new IllegalStateException("No operation defined for [" + String.valueOf(operation) + "]");
        };
    }

    public static List<DocIdSeqNoAndSource> getDocIds(Engine engine, boolean refresh) throws IOException {
        if (refresh) {
            engine.refresh("test_get_doc_ids");
        }
        try (Engine.Searcher searcher = engine.acquireSearcher("test_get_doc_ids", Engine.SearcherScope.INTERNAL);){
            ArrayList<DocIdSeqNoAndSource> docs = new ArrayList<DocIdSeqNoAndSource>();
            for (LeafReaderContext leafContext : searcher.getIndexReader().leaves()) {
                LeafReader reader = leafContext.reader();
                NumericDocValues seqNoDocValues = reader.getNumericDocValues("_seq_no");
                NumericDocValues primaryTermDocValues = reader.getNumericDocValues("_primary_term");
                NumericDocValues versionDocValues = reader.getNumericDocValues("_version");
                Bits liveDocs = reader.getLiveDocs();
                StoredFields storedFields = reader.storedFields();
                for (int i = 0; i < reader.maxDoc(); ++i) {
                    if (liveDocs != null && !liveDocs.get(i) || !primaryTermDocValues.advanceExact(i)) continue;
                    long primaryTerm = primaryTermDocValues.longValue();
                    Document doc = storedFields.document(i, (Set)Sets.newHashSet((Object[])new String[]{"_id", "_source"}));
                    BytesRef binaryID = doc.getBinaryValue("_id");
                    String id = Uid.decodeId((byte[])Arrays.copyOfRange(binaryID.bytes, binaryID.offset, binaryID.offset + binaryID.length));
                    BytesRef source = doc.getBinaryValue("_source");
                    if (!seqNoDocValues.advanceExact(i)) {
                        throw new AssertionError((Object)("seqNoDocValues not found for doc[" + i + "] id[" + id + "]"));
                    }
                    long seqNo = seqNoDocValues.longValue();
                    if (!versionDocValues.advanceExact(i)) {
                        throw new AssertionError((Object)("versionDocValues not found for doc[" + i + "] id[" + id + "]"));
                    }
                    long version = versionDocValues.longValue();
                    docs.add(new DocIdSeqNoAndSource(id, source, seqNo, primaryTerm, version));
                }
            }
            docs.sort(Comparator.comparingLong(DocIdSeqNoAndSource::getSeqNo).thenComparingLong(DocIdSeqNoAndSource::getPrimaryTerm).thenComparing(DocIdSeqNoAndSource::getId));
            ArrayList<DocIdSeqNoAndSource> arrayList = docs;
            return arrayList;
        }
    }

    public static List<Translog.Operation> readAllOperationsInLucene(Engine engine) throws IOException {
        ArrayList<Translog.Operation> operations = new ArrayList<Translog.Operation>();
        try (Translog.Snapshot snapshot = engine.newChangesSnapshot("test", 0L, Long.MAX_VALUE, false, EngineTestCase.randomBoolean());){
            Translog.Operation op;
            while ((op = snapshot.next()) != null) {
                operations.add(op);
            }
        }
        return operations;
    }

    public static List<Translog.Operation> readAllOperationsBasedOnSource(Engine engine) throws IOException {
        ArrayList<Translog.Operation> operations = new ArrayList<Translog.Operation>();
        try (Translog.Snapshot snapshot = engine.newChangesSnapshot("test", 0L, Long.MAX_VALUE, false, EngineTestCase.randomBoolean());){
            Translog.Operation op;
            while ((op = snapshot.next()) != null) {
                operations.add(op);
            }
        }
        return operations;
    }

    public static void assertConsistentHistoryBetweenTranslogAndLuceneIndex(Engine engine) throws IOException {
        long seqNoForRecovery;
        if (!(engine instanceof InternalEngine)) {
            return;
        }
        ArrayList<Translog.Operation> translogOps = new ArrayList<Translog.Operation>();
        try (Translog.Snapshot snapshot = EngineTestCase.getTranslog(engine).newSnapshot();){
            Translog.Operation op;
            while ((op = snapshot.next()) != null) {
                translogOps.add(op);
            }
        }
        Map luceneOps = EngineTestCase.readAllOperationsInLucene(engine).stream().collect(Collectors.toMap(Translog.Operation::seqNo, Function.identity()));
        long maxSeqNo = ((InternalEngine)engine).getLocalCheckpointTracker().getMaxSeqNo();
        for (Translog.Operation op : translogOps) {
            EngineTestCase.assertThat((String)("translog operation [" + String.valueOf(op) + "] > max_seq_no[" + maxSeqNo + "]"), (Object)op.seqNo(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(maxSeqNo)));
        }
        for (Translog.Operation op : luceneOps.values()) {
            EngineTestCase.assertThat((String)("lucene operation [" + String.valueOf(op) + "] > max_seq_no[" + maxSeqNo + "]"), (Object)op.seqNo(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(maxSeqNo)));
        }
        long globalCheckpoint = EngineTestCase.getTranslog(engine).getLastSyncedGlobalCheckpoint();
        long retainedOps = engine.config().getIndexSettings().getSoftDeleteRetentionOperations();
        if (engine.config().getIndexSettings().isSoftDeleteEnabled()) {
            try (GatedCloseable wrappedSafeCommit = engine.acquireSafeIndexCommit();){
                seqNoForRecovery = Long.parseLong((String)((IndexCommit)wrappedSafeCommit.get()).getUserData().get("local_checkpoint")) + 1L;
            }
        } else {
            seqNoForRecovery = engine.getMinRetainedSeqNo();
        }
        long minSeqNoToRetain = Math.min(seqNoForRecovery, globalCheckpoint + 1L - retainedOps);
        for (Translog.Operation translogOp : translogOps) {
            Translog.Operation luceneOp = (Translog.Operation)luceneOps.get(translogOp.seqNo());
            if (luceneOp == null) {
                if (minSeqNoToRetain > translogOp.seqNo()) continue;
                EngineTestCase.fail((String)("Operation not found seq# [" + translogOp.seqNo() + "], global checkpoint [" + globalCheckpoint + "], retention policy [" + retainedOps + "], maxSeqNo [" + maxSeqNo + "], translog op [" + String.valueOf(translogOp) + "]"));
            }
            EngineTestCase.assertThat((Object)luceneOp, (Matcher)Matchers.notNullValue());
            EngineTestCase.assertThat((String)luceneOp.toString(), (Object)luceneOp.primaryTerm(), (Matcher)Matchers.equalTo((Object)translogOp.primaryTerm()));
            EngineTestCase.assertThat((Object)luceneOp.opType(), (Matcher)Matchers.equalTo((Object)translogOp.opType()));
            if (luceneOp.opType() != Translog.Operation.Type.INDEX) continue;
            EngineTestCase.assertThat((Object)luceneOp.getSource().source, (Matcher)Matchers.equalTo((Object)translogOp.getSource().source));
        }
    }

    public static void assertMaxSeqNoInCommitUserData(Engine engine) throws Exception {
        List commits = DirectoryReader.listCommits((Directory)engine.store.directory());
        for (IndexCommit commit : commits) {
            DirectoryReader reader = DirectoryReader.open((IndexCommit)commit);
            try {
                EngineTestCase.assertThat((Object)Long.parseLong((String)commit.getUserData().get("max_seq_no")), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(EngineTestCase.maxSeqNosInReader(reader))));
            }
            finally {
                if (reader == null) continue;
                reader.close();
            }
        }
    }

    public static void assertAtMostOneLuceneDocumentPerSequenceNumber(Engine engine) throws IOException {
        if (engine instanceof InternalEngine) {
            try {
                engine.refresh("test");
                try (Engine.Searcher searcher = engine.acquireSearcher("test");){
                    EngineTestCase.assertAtMostOneLuceneDocumentPerSequenceNumber(engine.config().getIndexSettings(), searcher.getDirectoryReader());
                }
            }
            catch (AlreadyClosedException alreadyClosedException) {
                // empty catch block
            }
        }
    }

    public static void assertAtMostOneLuceneDocumentPerSequenceNumber(IndexSettings indexSettings, DirectoryReader reader) throws IOException {
        HashSet<Long> seqNos = new HashSet<Long>();
        DirectoryReader wrappedReader = indexSettings.isSoftDeleteEnabled() ? Lucene.wrapAllDocsLive((DirectoryReader)reader) : reader;
        for (LeafReaderContext leaf : wrappedReader.leaves()) {
            int docId;
            NumericDocValues primaryTermDocValues = leaf.reader().getNumericDocValues("_primary_term");
            NumericDocValues seqNoDocValues = leaf.reader().getNumericDocValues("_seq_no");
            StoredFields storedFields = leaf.reader().storedFields();
            while ((docId = seqNoDocValues.nextDoc()) != Integer.MAX_VALUE) {
                EngineTestCase.assertTrue((boolean)seqNoDocValues.advanceExact(docId));
                long seqNo = seqNoDocValues.longValue();
                EngineTestCase.assertThat((Object)seqNo, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
                if (!primaryTermDocValues.advanceExact(docId) || seqNos.add(seqNo)) continue;
                IdOnlyFieldVisitor idFieldVisitor = new IdOnlyFieldVisitor();
                storedFields.document(docId, (StoredFieldVisitor)idFieldVisitor);
                throw new AssertionError((Object)("found multiple documents for seq=" + seqNo + " id=" + idFieldVisitor.getId()));
            }
        }
    }

    public static MapperService createMapperService() throws IOException {
        return EngineTestCase.createMapperService("{\"properties\": {}}");
    }

    public static MapperService createMapperService(String mapping) throws IOException {
        IndexMetadata indexMetadata = IndexMetadata.builder((String)"test").settings(Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_shards", 1).put("index.number_of_replicas", 1)).putMapping(mapping).build();
        MapperService mapperService = MapperTestUtils.newMapperService(new NamedXContentRegistry(ClusterModule.getNamedXWriteables()), EngineTestCase.createTempDir(), Settings.EMPTY, "test");
        mapperService.merge(indexMetadata, MapperService.MergeReason.MAPPING_UPDATE);
        return mapperService;
    }

    public static Translog getTranslog(Engine engine) {
        assert (engine instanceof InternalEngine || engine instanceof NRTReplicationEngine) : "only InternalEngines or NRTReplicationEngines have translogs, got: " + String.valueOf(engine.getClass());
        engine.ensureOpen();
        TranslogManager translogManager = engine.translogManager();
        assert (translogManager instanceof InternalTranslogManager) : "only InternalTranslogManager have translogs, got: " + String.valueOf(engine.getClass());
        InternalTranslogManager internalTranslogManager = (InternalTranslogManager)translogManager;
        return internalTranslogManager.getTranslog();
    }

    public static void waitForOpsToComplete(InternalEngine engine, long seqNo) throws InterruptedException {
        engine.getLocalCheckpointTracker().waitForProcessedOpsToComplete(seqNo);
    }

    public static boolean hasSnapshottedCommits(Engine engine) {
        assert (engine instanceof InternalEngine) : "only InternalEngines have snapshotted commits, got: " + String.valueOf(engine.getClass());
        InternalEngine internalEngine = (InternalEngine)engine;
        return internalEngine.hasSnapshottedCommits();
    }

    static long maxSeqNosInReader(DirectoryReader reader) throws IOException {
        long maxSeqNo = -1L;
        for (LeafReaderContext leaf : reader.leaves()) {
            NumericDocValues seqNoDocValues = leaf.reader().getNumericDocValues("_seq_no");
            while (seqNoDocValues.nextDoc() != Integer.MAX_VALUE) {
                maxSeqNo = SequenceNumbers.max((long)maxSeqNo, (long)seqNoDocValues.longValue());
            }
        }
        return maxSeqNo;
    }

    public static long getNumVersionLookups(Engine engine) {
        return ((InternalEngine)engine).getNumVersionLookups();
    }

    public static long getInFlightDocCount(Engine engine) {
        if (engine instanceof InternalEngine) {
            return ((InternalEngine)engine).getInFlightDocCount();
        }
        return 0L;
    }

    public static void assertNoInFlightDocuments(Engine engine) throws Exception {
        EngineTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> EngineTestCase.assertThat((Object)EngineTestCase.getInFlightDocCount(engine), (Matcher)Matchers.equalTo((Object)0L))));
    }

    public static final class PrimaryTermSupplier
    implements LongSupplier {
        private final AtomicLong term;

        PrimaryTermSupplier(long initialTerm) {
            this.term = new AtomicLong(initialTerm);
        }

        public long get() {
            return this.term.get();
        }

        public void set(long newTerm) {
            this.term.set(newTerm);
        }

        @Override
        public long getAsLong() {
            return this.get();
        }
    }

    @FunctionalInterface
    public static interface IndexWriterFactory {
        public IndexWriter createWriter(Directory var1, IndexWriterConfig var2) throws IOException;
    }
}

