/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import org.apache.lucene.tests.geo.GeoTestUtil;
import org.opensearch.geometry.Circle;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.GeometryCollection;
import org.opensearch.geometry.GeometryVisitor;
import org.opensearch.geometry.Line;
import org.opensearch.geometry.LinearRing;
import org.opensearch.geometry.MultiLine;
import org.opensearch.geometry.MultiPoint;
import org.opensearch.geometry.MultiPolygon;
import org.opensearch.geometry.Point;
import org.opensearch.geometry.Polygon;
import org.opensearch.geometry.Rectangle;
import org.opensearch.test.OpenSearchTestCase;

public class GeometryTestUtils {
    public static double randomLat() {
        return GeoTestUtil.nextLatitude();
    }

    public static double randomLon() {
        return GeoTestUtil.nextLongitude();
    }

    public static double randomAlt() {
        return OpenSearchTestCase.randomDouble();
    }

    public static Circle randomCircle(boolean hasAlt) {
        if (hasAlt) {
            return new Circle(GeometryTestUtils.randomLon(), GeometryTestUtils.randomLat(), OpenSearchTestCase.randomDouble(), OpenSearchTestCase.randomDoubleBetween(0.0, 100.0, false));
        }
        return new Circle(GeometryTestUtils.randomLon(), GeometryTestUtils.randomLat(), OpenSearchTestCase.randomDoubleBetween(0.0, 100.0, false));
    }

    public static Line randomLine(boolean hasAlts) {
        org.apache.lucene.geo.Polygon lucenePolygon = GeoTestUtil.nextPolygon();
        int size = lucenePolygon.numPoints() - 1;
        double[] lats = new double[size];
        double[] lons = new double[size];
        double[] alts = hasAlts ? new double[size] : null;
        for (int i = 0; i < size; ++i) {
            lats[i] = lucenePolygon.getPolyLat(i);
            lons[i] = lucenePolygon.getPolyLon(i);
            if (!hasAlts) continue;
            alts[i] = GeometryTestUtils.randomAlt();
        }
        if (hasAlts) {
            return new Line(lons, lats, alts);
        }
        return new Line(lons, lats);
    }

    public static Point randomPoint() {
        return GeometryTestUtils.randomPoint(OpenSearchTestCase.randomBoolean());
    }

    public static Point randomPoint(boolean hasAlt) {
        if (hasAlt) {
            return new Point(GeometryTestUtils.randomLon(), GeometryTestUtils.randomLat(), GeometryTestUtils.randomAlt());
        }
        return new Point(GeometryTestUtils.randomLon(), GeometryTestUtils.randomLat());
    }

    public static Polygon randomPolygon(boolean hasAlt) {
        org.apache.lucene.geo.Polygon lucenePolygon = OpenSearchTestCase.randomValueOtherThanMany(p -> GeometryTestUtils.area(p) == 0.0, GeoTestUtil::nextPolygon);
        if (lucenePolygon.numHoles() > 0) {
            org.apache.lucene.geo.Polygon[] luceneHoles = lucenePolygon.getHoles();
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            for (int i = 0; i < lucenePolygon.numHoles(); ++i) {
                org.apache.lucene.geo.Polygon poly = luceneHoles[i];
                holes.add(GeometryTestUtils.linearRing(poly.getPolyLons(), poly.getPolyLats(), hasAlt));
            }
            return new Polygon(GeometryTestUtils.linearRing(lucenePolygon.getPolyLons(), lucenePolygon.getPolyLats(), hasAlt), holes);
        }
        return new Polygon(GeometryTestUtils.linearRing(lucenePolygon.getPolyLons(), lucenePolygon.getPolyLats(), hasAlt));
    }

    private static double area(org.apache.lucene.geo.Polygon lucenePolygon) {
        double windingSum = 0.0;
        int numPts = lucenePolygon.numPoints() - 1;
        for (int i = 0; i < numPts; ++i) {
            windingSum += lucenePolygon.getPolyLon(i) * lucenePolygon.getPolyLat(i + 1) - lucenePolygon.getPolyLat(i) * lucenePolygon.getPolyLon(i + 1);
        }
        return Math.abs(windingSum / 2.0);
    }

    private static double[] randomAltRing(int size) {
        double[] alts = new double[size];
        for (int i = 0; i < size - 1; ++i) {
            alts[i] = GeometryTestUtils.randomAlt();
        }
        alts[size - 1] = alts[0];
        return alts;
    }

    public static LinearRing linearRing(double[] lons, double[] lats, boolean generateAlts) {
        if (generateAlts) {
            return new LinearRing(lons, lats, GeometryTestUtils.randomAltRing(lats.length));
        }
        return new LinearRing(lons, lats);
    }

    public static Rectangle randomRectangle() {
        org.apache.lucene.geo.Rectangle rectangle = GeoTestUtil.nextBox();
        return new Rectangle(rectangle.minLon, rectangle.maxLon, rectangle.maxLat, rectangle.minLat);
    }

    public static MultiPoint randomMultiPoint(boolean hasAlt) {
        int size = OpenSearchTestCase.randomIntBetween(3, 10);
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < size; ++i) {
            points.add(GeometryTestUtils.randomPoint(hasAlt));
        }
        return new MultiPoint(points);
    }

    public static MultiLine randomMultiLine(boolean hasAlt) {
        int size = OpenSearchTestCase.randomIntBetween(3, 10);
        ArrayList<Line> lines = new ArrayList<Line>();
        for (int i = 0; i < size; ++i) {
            lines.add(GeometryTestUtils.randomLine(hasAlt));
        }
        return new MultiLine(lines);
    }

    public static MultiPolygon randomMultiPolygon(boolean hasAlt) {
        int size = OpenSearchTestCase.randomIntBetween(3, 10);
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < size; ++i) {
            polygons.add(GeometryTestUtils.randomPolygon(hasAlt));
        }
        return new MultiPolygon(polygons);
    }

    public static GeometryCollection<Geometry> randomGeometryCollection(boolean hasAlt) {
        return GeometryTestUtils.randomGeometryCollection(0, hasAlt);
    }

    private static GeometryCollection<Geometry> randomGeometryCollection(int level, boolean hasAlt) {
        int size = OpenSearchTestCase.randomIntBetween(1, 10);
        ArrayList<Geometry> shapes = new ArrayList<Geometry>();
        for (int i = 0; i < size; ++i) {
            shapes.add(GeometryTestUtils.randomGeometry(level, hasAlt));
        }
        return new GeometryCollection(shapes);
    }

    public static Geometry randomGeometry(boolean hasAlt) {
        return GeometryTestUtils.randomGeometry(0, hasAlt);
    }

    protected static Geometry randomGeometry(int level, boolean hasAlt) {
        Function geometry = OpenSearchTestCase.randomFrom(GeometryTestUtils::randomCircle, GeometryTestUtils::randomLine, GeometryTestUtils::randomPoint, GeometryTestUtils::randomPolygon, GeometryTestUtils::randomMultiLine, GeometryTestUtils::randomMultiPoint, GeometryTestUtils::randomMultiPolygon, hasAlt ? GeometryTestUtils::randomPoint : b -> GeometryTestUtils.randomRectangle(), level < 3 ? b -> GeometryTestUtils.randomGeometryCollection(level + 1, b) : GeometryTestUtils::randomPoint);
        return (Geometry)geometry.apply(hasAlt);
    }

    public static MultiPoint toMultiPoint(Geometry geometry) {
        return (MultiPoint)geometry.visit((GeometryVisitor)new GeometryVisitor<MultiPoint, RuntimeException>(){

            public MultiPoint visit(Circle circle) throws RuntimeException {
                throw new UnsupportedOperationException("not supporting circles yet");
            }

            public MultiPoint visit(GeometryCollection<?> collection) throws RuntimeException {
                ArrayList points = new ArrayList();
                collection.forEach(geometry -> GeometryTestUtils.toMultiPoint(geometry).forEach(points::add));
                return new MultiPoint(points);
            }

            public MultiPoint visit(Line line) throws RuntimeException {
                ArrayList<Point> points = new ArrayList<Point>();
                for (int i = 0; i < line.length(); ++i) {
                    points.add(new Point(line.getX(i), line.getY(i), line.getZ(i)));
                }
                return new MultiPoint(points);
            }

            public MultiPoint visit(LinearRing ring) throws RuntimeException {
                return this.visit((Line)ring);
            }

            public MultiPoint visit(MultiLine multiLine) throws RuntimeException {
                return this.visit((GeometryCollection<?>)multiLine);
            }

            public MultiPoint visit(MultiPoint multiPoint) throws RuntimeException {
                return multiPoint;
            }

            public MultiPoint visit(MultiPolygon multiPolygon) throws RuntimeException {
                return this.visit((GeometryCollection<?>)multiPolygon);
            }

            public MultiPoint visit(Point point) throws RuntimeException {
                return new MultiPoint(Collections.singletonList(point));
            }

            public MultiPoint visit(Polygon polygon) throws RuntimeException {
                ArrayList<MultiPoint> multiPoints = new ArrayList<MultiPoint>();
                multiPoints.add(GeometryTestUtils.toMultiPoint((Geometry)polygon.getPolygon()));
                for (int i = 0; i < polygon.getNumberOfHoles(); ++i) {
                    multiPoints.add(GeometryTestUtils.toMultiPoint((Geometry)polygon.getHole(i)));
                }
                return GeometryTestUtils.toMultiPoint((Geometry)new GeometryCollection(multiPoints));
            }

            public MultiPoint visit(Rectangle rectangle) throws RuntimeException {
                return new MultiPoint(Arrays.asList(new Point(rectangle.getMinX(), rectangle.getMinY(), rectangle.getMinZ()), new Point(rectangle.getMaxX(), rectangle.getMaxY(), rectangle.getMaxZ())));
            }
        });
    }
}

