/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.hash;

import java.util.Arrays;
import java.util.Random;
import org.opensearch.common.Randomness;
import org.opensearch.common.hash.AvalancheStats;
import org.opensearch.test.OpenSearchTestCase;

public abstract class HashFunctionTestCase
extends OpenSearchTestCase {
    private static final int[] INPUT_BITS = new int[]{24, 32, 40, 48, 56, 64, 72, 80, 96, 112, 128, 160, 512, 1024};
    private static final int ITERATIONS = 1000;
    private static final double BIAS_THRESHOLD = 0.01;

    public abstract byte[] hash(byte[] var1);

    public abstract int outputBits();

    public void testAvalanche() {
        for (int inputBits : INPUT_BITS) {
            AvalancheStats stats = this.simulate(inputBits);
            if (!(stats.bias() >= 0.01)) continue;
            HashFunctionTestCase.fail((String)("bias exceeds threshold: " + String.valueOf(stats)));
        }
    }

    private AvalancheStats simulate(int inputBits) {
        int outputBits = this.outputBits();
        assert (inputBits % 8 == 0);
        assert (outputBits % 8 == 0);
        byte[] input = new byte[inputBits >>> 3];
        Random random = Randomness.get();
        int[][] flips = new int[inputBits][outputBits];
        for (int iter = 0; iter < 1000; ++iter) {
            random.nextBytes(input);
            byte[] hash = Arrays.copyOf(this.hash(input), outputBits >>> 3);
            for (int i = 0; i < inputBits; ++i) {
                HashFunctionTestCase.flipBit(input, i);
                byte[] newHash = this.hash(input);
                HashFunctionTestCase.flipBit(input, i);
                for (int o = 0; o < outputBits; ++o) {
                    int[] nArray = flips[i];
                    int n = o;
                    nArray[n] = nArray[n] + (HashFunctionTestCase.getBit(hash, o) ^ HashFunctionTestCase.getBit(newHash, o));
                }
            }
        }
        return new AvalancheStats(flips, 1000);
    }

    private static void flipBit(byte[] input, int position) {
        int offset = position / 8;
        int bit = position & 7;
        int n = offset;
        input[n] = (byte)(input[n] ^ 1 << bit);
    }

    private static int getBit(byte[] input, int position) {
        int offset = position / 8;
        int bit = position & 7;
        return input[offset] >>> bit & 1;
    }
}

