/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.transport;

import java.io.IOException;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.opensearch.cluster.ClusterModule;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Nullable;
import org.opensearch.common.Randomness;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.transport.BoundTransportAddress;
import org.opensearch.test.transport.FakeTransport;
import org.opensearch.test.transport.StubbableConnectionManager;
import org.opensearch.test.transport.StubbableTransport;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.CloseableConnection;
import org.opensearch.transport.ClusterConnectionManager;
import org.opensearch.transport.ConnectionManager;
import org.opensearch.transport.RemoteTransportException;
import org.opensearch.transport.SendRequestTransportException;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportMessageListener;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponse;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class MockTransport
extends StubbableTransport {
    private TransportMessageListener listener;
    private ConcurrentMap<Long, Tuple<DiscoveryNode, String>> requests = new ConcurrentHashMap<Long, Tuple<DiscoveryNode, String>>();

    public TransportService createTransportService(Settings settings, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        StubbableConnectionManager connectionManager = new StubbableConnectionManager((ConnectionManager)new ClusterConnectionManager(settings, (Transport)this));
        connectionManager.setDefaultNodeConnectedBehavior((cm, node) -> false);
        connectionManager.setDefaultGetConnectionBehavior((cm, discoveryNode) -> this.createConnection(discoveryNode));
        return new TransportService(settings, (Transport)this, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders, (ConnectionManager)connectionManager);
    }

    public MockTransport() {
        super(new FakeTransport());
        this.setDefaultConnectBehavior((transport, discoveryNode, profile, listener) -> listener.onResponse((Object)this.createConnection(discoveryNode)));
    }

    public <Response extends TransportResponse> void handleResponse(long requestId, Response response) {
        TransportResponseHandler transportResponseHandler = this.getResponseHandlers().onResponseReceived(requestId, this.listener);
        if (transportResponseHandler != null) {
            TransportResponse deliveredResponse;
            try (BytesStreamOutput output = new BytesStreamOutput();){
                response.writeTo((StreamOutput)output);
                deliveredResponse = (TransportResponse)transportResponseHandler.read((StreamInput)new NamedWriteableAwareStreamInput(output.bytes().streamInput(), this.writeableRegistry()));
            }
            catch (IOException | UnsupportedOperationException e) {
                throw new AssertionError("failed to serialize/deserialize response " + response, e);
            }
            transportResponseHandler.handleResponse(deliveredResponse);
        }
    }

    public void handleLocalError(long requestId, Throwable t) {
        Tuple request = (Tuple)this.requests.get(requestId);
        assert (request != null);
        this.handleError(requestId, (TransportException)new SendRequestTransportException((DiscoveryNode)request.v1(), (String)request.v2(), t));
    }

    public void handleRemoteError(long requestId, Throwable t) {
        RemoteTransportException remoteException;
        if (LuceneTestCase.rarely((Random)Randomness.get())) {
            remoteException = new RemoteTransportException("remote failure, coming from local node", t);
        } else {
            try (BytesStreamOutput output = new BytesStreamOutput();){
                output.writeException(t);
                remoteException = new RemoteTransportException("remote failure", (Throwable)output.bytes().streamInput().readException());
            }
            catch (IOException ioException) {
                throw new AssertionError("failed to serialize/deserialize supplied exception " + t, ioException);
            }
        }
        this.handleError(requestId, (TransportException)remoteException);
    }

    public void handleError(long requestId, TransportException e) {
        TransportResponseHandler transportResponseHandler = this.getResponseHandlers().onResponseReceived(requestId, this.listener);
        if (transportResponseHandler != null) {
            transportResponseHandler.handleException(e);
        }
    }

    public Transport.Connection createConnection(final DiscoveryNode node) {
        return new CloseableConnection(){

            public DiscoveryNode getNode() {
                return node;
            }

            public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws TransportException {
                MockTransport.this.requests.put(requestId, (Tuple<DiscoveryNode, String>)Tuple.tuple((Object)node, (Object)action));
                MockTransport.this.onSendRequest(requestId, action, request, node, options);
            }
        };
    }

    protected void onSendRequest(long requestId, String action, TransportRequest request, DiscoveryNode node) {
    }

    protected void onSendRequest(long requestId, String action, TransportRequest request, DiscoveryNode node, TransportRequestOptions options) {
        this.onSendRequest(requestId, action, request, node);
    }

    @Override
    public void setMessageListener(TransportMessageListener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("listener already set");
        }
        this.listener = listener;
        super.setMessageListener(listener);
    }

    protected NamedWriteableRegistry writeableRegistry() {
        return new NamedWriteableRegistry(ClusterModule.getNamedWriteables());
    }
}

