/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml.section;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.NotEqualMessageBuilder;
import org.opensearch.test.hamcrest.RegexMatcher;
import org.opensearch.test.rest.yaml.section.Assertion;
import org.opensearch.test.rest.yaml.section.ParserUtils;

public class MatchAssertion
extends Assertion {
    private static final Logger logger = LogManager.getLogger(MatchAssertion.class);

    public static MatchAssertion parse(XContentParser parser) throws IOException {
        XContentLocation location = parser.getTokenLocation();
        Tuple<String, Object> stringObjectTuple = ParserUtils.parseTuple(parser);
        return new MatchAssertion(location, (String)stringObjectTuple.v1(), stringObjectTuple.v2());
    }

    public MatchAssertion(XContentLocation location, String field, Object expectedValue) {
        super(location, field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        String expValue;
        if (expectedValue instanceof String && (expValue = ((String)expectedValue).trim()).length() > 2 && expValue.startsWith("/") && expValue.endsWith("/")) {
            Assert.assertThat((String)("field [" + this.getField() + "] was expected to be of type String but is an instanceof [" + this.safeClass(actualValue) + "]"), (Object)actualValue, (Matcher)Matchers.instanceOf(String.class));
            String stringValue = (String)actualValue;
            String regex = expValue.substring(1, expValue.length() - 1);
            logger.trace("assert that [{}] matches [{}]", (Object)stringValue, (Object)regex);
            Assert.assertThat((String)("field [" + this.getField() + "] was expected to match the provided regex but didn't"), (Object)stringValue, (Matcher)RegexMatcher.matches(regex, 4));
            return;
        }
        logger.trace("assert that [{}] matches [{}] (field [{}])", actualValue, expectedValue, (Object)this.getField());
        if (expectedValue == null) {
            Assert.assertNull((String)("field [" + this.getField() + "] should be null but was [" + actualValue + "]"), (Object)actualValue);
            return;
        }
        Assert.assertNotNull((String)("field [" + this.getField() + "] is null"), (Object)actualValue);
        if (!actualValue.getClass().equals(this.safeClass(expectedValue)) && actualValue instanceof Number && expectedValue instanceof Number) {
            Assert.assertThat((String)("field [" + this.getField() + "] doesn't match the expected value"), (Object)((Number)actualValue).doubleValue(), (Matcher)Matchers.equalTo((Object)((Number)expectedValue).doubleValue()));
            return;
        }
        if (!expectedValue.equals(actualValue)) {
            NotEqualMessageBuilder message = new NotEqualMessageBuilder();
            message.compare(this.getField(), true, actualValue, expectedValue);
            throw new AssertionError((Object)(this.getField() + " didn't match expected value:\n" + message));
        }
    }
}

