/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml.section;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.client.NodeSelector;
import org.opensearch.common.ParsingException;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.yaml.YamlXContent;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParseException;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.rest.yaml.section.ClientYamlTestSection;
import org.opensearch.test.rest.yaml.section.ContainsAssertion;
import org.opensearch.test.rest.yaml.section.DoSection;
import org.opensearch.test.rest.yaml.section.ExecutableSection;
import org.opensearch.test.rest.yaml.section.SetupSection;
import org.opensearch.test.rest.yaml.section.SkipSection;
import org.opensearch.test.rest.yaml.section.TeardownSection;

public class ClientYamlTestSuite {
    private final String api;
    private final String name;
    private final SetupSection setupSection;
    private final TeardownSection teardownSection;
    private final List<ClientYamlTestSection> testSections;

    public static ClientYamlTestSuite parse(NamedXContentRegistry executeableSectionRegistry, String api, Path file) throws IOException {
        ClientYamlTestSuite clientYamlTestSuite;
        block19: {
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                throw new IllegalArgumentException(file.toAbsolutePath() + " is not a file");
            }
            String filename = file.getFileName().toString();
            int i = filename.lastIndexOf(46);
            if (i > 0) {
                filename = filename.substring(0, i);
            }
            try (FileChannel channel = FileChannel.open(file, StandardOpenOption.READ);){
                ByteBuffer bb = ByteBuffer.wrap(new byte[1]);
                if (channel.size() == 0L) {
                    throw new IllegalArgumentException("test suite file " + file.toString() + " is empty");
                }
                channel.read(bb, channel.size() - 1L);
                if (bb.get(0) != 10) {
                    throw new IOException("test suite [" + api + "/" + filename + "] doesn't end with line feed (\\n)");
                }
            }
            XContentParser parser = YamlXContent.yamlXContent.createParser(executeableSectionRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, Files.newInputStream(file, new OpenOption[0]));
            try {
                clientYamlTestSuite = ClientYamlTestSuite.parse(api, filename, parser);
                if (parser == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Error parsing " + api + "/" + filename, e);
                }
            }
            parser.close();
        }
        return clientYamlTestSuite;
    }

    public static ClientYamlTestSuite parse(String api, String suiteName, XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new XContentParseException(parser.getTokenLocation(), "expected token to be START_OBJECT but was " + parser.currentToken());
        }
        SetupSection setupSection = SetupSection.parseIfNext(parser);
        TeardownSection teardownSection = TeardownSection.parseIfNext(parser);
        TreeSet<ClientYamlTestSection> testSections = new TreeSet<ClientYamlTestSection>();
        while (parser.currentToken() != null || parser.nextToken() != null) {
            ClientYamlTestSection testSection = ClientYamlTestSection.parse(parser);
            if (testSections.add(testSection)) continue;
            throw new ParsingException(testSection.getLocation(), "duplicate test section [" + testSection.getName() + "]", new Object[0]);
        }
        return new ClientYamlTestSuite(api, suiteName, setupSection, teardownSection, new ArrayList<ClientYamlTestSection>(testSections));
    }

    public ClientYamlTestSuite(String api, String name, SetupSection setupSection, TeardownSection teardownSection, List<ClientYamlTestSection> testSections) {
        this.api = api;
        this.name = name;
        this.setupSection = Objects.requireNonNull(setupSection, "setup section cannot be null");
        this.teardownSection = Objects.requireNonNull(teardownSection, "teardown section cannot be null");
        this.testSections = Collections.unmodifiableList(testSections);
    }

    public String getApi() {
        return this.api;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.api + "/" + this.name;
    }

    public SetupSection getSetupSection() {
        return this.setupSection;
    }

    public TeardownSection getTeardownSection() {
        return this.teardownSection;
    }

    public void validate() {
        Stream<String> errors = ClientYamlTestSuite.validateExecutableSections(this.setupSection.getExecutableSections(), null, this.setupSection, null);
        errors = Stream.concat(errors, ClientYamlTestSuite.validateExecutableSections(this.teardownSection.getDoSections(), null, null, this.teardownSection));
        String errorMessage = (errors = Stream.concat(errors, this.testSections.stream().flatMap(section -> ClientYamlTestSuite.validateExecutableSections(section.getExecutableSections(), section, this.setupSection, this.teardownSection)))).collect(Collectors.joining(",\n"));
        if (!errorMessage.isEmpty()) {
            throw new IllegalArgumentException(this.getPath() + ":\n" + errorMessage);
        }
    }

    private static Stream<String> validateExecutableSections(List<ExecutableSection> sections, ClientYamlTestSection testSection, SetupSection setupSection, TeardownSection teardownSection) {
        Stream<String> errors = sections.stream().filter(section -> section instanceof DoSection).map(section -> (DoSection)section).filter(section -> false == section.getExpectedWarningHeaders().isEmpty()).filter(section -> false == ClientYamlTestSuite.hasSkipFeature("warnings", testSection, setupSection, teardownSection)).map(section -> "attempted to add a [do] with a [warnings] section without a corresponding [\"skip\": \"features\": \"warnings\"] so runners that do not support the [warnings] section can skip the test at line [" + section.getLocation().lineNumber + "]");
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof DoSection).map(section -> (DoSection)section).filter(section -> false == section.getAllowedWarningHeaders().isEmpty()).filter(section -> false == ClientYamlTestSuite.hasSkipFeature("allowed_warnings", testSection, setupSection, teardownSection)).map(section -> "attempted to add a [do] with a [allowed_warnings] section without a corresponding [\"skip\": \"features\": \"allowed_warnings\"] so runners that do not support the [allowed_warnings] section can skip the test at line [" + section.getLocation().lineNumber + "]"));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof DoSection).map(section -> (DoSection)section).filter(section -> NodeSelector.ANY != section.getApiCallSection().getNodeSelector()).filter(section -> false == ClientYamlTestSuite.hasSkipFeature("node_selector", testSection, setupSection, teardownSection)).map(section -> "attempted to add a [do] with a [node_selector] section without a corresponding [\"skip\": \"features\": \"node_selector\"] so runners that do not support the [node_selector] section can skip the test at line [" + section.getLocation().lineNumber + "]"));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof ContainsAssertion).filter(section -> false == ClientYamlTestSuite.hasSkipFeature("contains", testSection, setupSection, teardownSection)).map(section -> "attempted to add a [contains] assertion without a corresponding [\"skip\": \"features\": \"contains\"] so runners that do not support the [contains] assertion can skip the test at line [" + section.getLocation().lineNumber + "]"));
        errors = Stream.concat(errors, sections.stream().filter(section -> section instanceof DoSection).map(section -> (DoSection)section).filter(section -> false == section.getApiCallSection().getHeaders().isEmpty()).filter(section -> false == ClientYamlTestSuite.hasSkipFeature("headers", testSection, setupSection, teardownSection)).map(section -> "attempted to add a [do] with a [headers] section without a corresponding [\"skip\": \"features\": \"headers\"] so runners that do not support the [headers] section can skip the test at line [" + section.getLocation().lineNumber + "]"));
        return errors;
    }

    private static boolean hasSkipFeature(String feature, ClientYamlTestSection testSection, SetupSection setupSection, TeardownSection teardownSection) {
        return testSection != null && ClientYamlTestSuite.hasSkipFeature(feature, testSection.getSkipSection()) || setupSection != null && ClientYamlTestSuite.hasSkipFeature(feature, setupSection.getSkipSection()) || teardownSection != null && ClientYamlTestSuite.hasSkipFeature(feature, teardownSection.getSkipSection());
    }

    private static boolean hasSkipFeature(String feature, SkipSection skipSection) {
        return skipSection != null && skipSection.getFeatures().contains(feature);
    }

    public List<ClientYamlTestSection> getTestSections() {
        return this.testSections;
    }
}

