/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.opensearch.client.Response;
import org.opensearch.common.Strings;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.test.rest.yaml.ObjectPath;
import org.opensearch.test.rest.yaml.Stash;

public class ClientYamlTestResponse {
    private final Response response;
    private final byte[] body;
    private final XContentType bodyContentType;
    private ObjectPath parsedResponse;
    private String bodyAsString;

    public ClientYamlTestResponse(Response response) throws IOException {
        this.response = response;
        if (response.getEntity() != null) {
            String contentType = response.getHeader("Content-Type");
            this.bodyContentType = XContentType.fromMediaType((String)contentType);
            try {
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
                if (this.bodyContentType != null) {
                    this.parsedResponse = ObjectPath.createFromXContent(this.bodyContentType.xContent(), (BytesReference)new BytesArray(bytes));
                }
                this.body = bytes;
            }
            catch (IOException e) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw e;
            }
        } else {
            this.body = null;
            this.bodyContentType = null;
        }
    }

    public int getStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getReasonPhrase() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    public List<String> getWarningHeaders() {
        ArrayList<String> warningHeaders = new ArrayList<String>();
        for (Header header : this.response.getHeaders()) {
            if (!header.getName().equals("Warning")) continue;
            warningHeaders.add(header.getValue());
        }
        return warningHeaders;
    }

    public Object getBody() throws IOException {
        if (this.parsedResponse != null) {
            return this.parsedResponse.evaluate("");
        }
        assert (this.bodyContentType == null);
        return this.getBodyAsString();
    }

    public String getBodyAsString() {
        if (this.bodyAsString == null && this.body != null) {
            if (this.bodyContentType == null || this.bodyContentType == XContentType.JSON || this.bodyContentType == XContentType.YAML) {
                this.bodyAsString = new String(this.body, StandardCharsets.UTF_8);
            } else {
                try (XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();){
                    try (XContentParser parser = this.bodyContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, this.body);){
                        jsonBuilder.copyCurrentStructure(parser);
                    }
                    this.bodyAsString = Strings.toString((XContentBuilder)jsonBuilder);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("unable to convert response body to a string format", e);
                }
            }
        }
        return this.bodyAsString;
    }

    public boolean isError() {
        return this.response.getStatusLine().getStatusCode() >= 400;
    }

    public Object evaluate(String path) throws IOException {
        return this.evaluate(path, Stash.EMPTY);
    }

    public Object evaluate(String path, Stash stash) throws IOException {
        if (this.response == null) {
            return null;
        }
        if (this.parsedResponse == null) {
            if ("".equals(path) && "HEAD".equals(this.response.getRequestLine().getMethod())) {
                return !this.isError();
            }
            return null;
        }
        return this.parsedResponse.evaluate(path, stash);
    }
}

