/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.disruption;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.action.ActionListener;
import org.opensearch.cluster.coordination.DeterministicTaskQueue;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.Nullable;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.transport.BoundTransportAddress;
import org.opensearch.common.transport.TransportAddress;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.transport.MockTransport;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.CloseableConnection;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.ConnectionProfile;
import org.opensearch.transport.RequestHandlerRegistry;
import org.opensearch.transport.Transport;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportInterceptor;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestOptions;
import org.opensearch.transport.TransportResponse;
import org.opensearch.transport.TransportService;

public abstract class DisruptableMockTransport
extends MockTransport {
    private final DiscoveryNode localNode;
    private final Logger logger;
    private final DeterministicTaskQueue deterministicTaskQueue;

    public DisruptableMockTransport(DiscoveryNode localNode, Logger logger, DeterministicTaskQueue deterministicTaskQueue) {
        this.localNode = localNode;
        this.logger = logger;
        this.deterministicTaskQueue = deterministicTaskQueue;
    }

    protected abstract ConnectionStatus getConnectionStatus(DiscoveryNode var1);

    protected abstract Optional<DisruptableMockTransport> getDisruptableMockTransport(TransportAddress var1);

    protected abstract void execute(Runnable var1);

    public DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    @Override
    public TransportService createTransportService(Settings settings, ThreadPool threadPool, TransportInterceptor interceptor, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, Set<String> taskHeaders) {
        return new TransportService(settings, (Transport)this, threadPool, interceptor, localNodeFactory, clusterSettings, taskHeaders);
    }

    @Override
    public void openConnection(final DiscoveryNode node, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        Optional<DisruptableMockTransport> optionalMatchingTransport = this.getDisruptableMockTransport(node.getAddress());
        if (optionalMatchingTransport.isPresent()) {
            final DisruptableMockTransport matchingTransport = optionalMatchingTransport.get();
            ConnectionStatus connectionStatus = this.getConnectionStatus(matchingTransport.getLocalNode());
            if (connectionStatus != ConnectionStatus.CONNECTED) {
                listener.onFailure((Exception)new ConnectTransportException(node, "node [" + node + "] is [" + connectionStatus + "] not [CONNECTED]"));
            } else {
                listener.onResponse((Object)new CloseableConnection(){

                    public DiscoveryNode getNode() {
                        return node;
                    }

                    public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws TransportException {
                        DisruptableMockTransport.this.onSendRequest(requestId, action, request, matchingTransport);
                    }
                });
            }
        } else {
            listener.onFailure((Exception)new ConnectTransportException(node, "node " + node + " does not exist"));
        }
    }

    protected void onSendRequest(final long requestId, final String action, final TransportRequest request, final DisruptableMockTransport destinationTransport) {
        assert (!destinationTransport.getLocalNode().equals((Object)this.getLocalNode())) : "non-local message from " + this.getLocalNode() + " to itself";
        destinationTransport.execute(new Runnable(){

            @Override
            public void run() {
                ConnectionStatus connectionStatus = DisruptableMockTransport.this.getConnectionStatus(destinationTransport.getLocalNode());
                switch (connectionStatus) {
                    case BLACK_HOLE: 
                    case BLACK_HOLE_REQUESTS_ONLY: {
                        DisruptableMockTransport.this.onBlackholedDuringSend(requestId, action, destinationTransport);
                        break;
                    }
                    case DISCONNECTED: {
                        DisruptableMockTransport.this.onDisconnectedDuringSend(requestId, action, destinationTransport);
                        break;
                    }
                    case CONNECTED: {
                        DisruptableMockTransport.this.onConnectedDuringSend(requestId, action, request, destinationTransport);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("unexpected status: " + connectionStatus));
                    }
                }
            }

            public String toString() {
                return DisruptableMockTransport.this.getRequestDescription(requestId, action, destinationTransport.getLocalNode());
            }
        });
    }

    protected Runnable getDisconnectException(final long requestId, final String action, final DiscoveryNode destination) {
        return new Runnable(){

            @Override
            public void run() {
                DisruptableMockTransport.this.handleError(requestId, (TransportException)new ConnectTransportException(destination, "disconnected"));
            }

            public String toString() {
                return "disconnection response to " + DisruptableMockTransport.this.getRequestDescription(requestId, action, destination);
            }
        };
    }

    protected String getRequestDescription(long requestId, String action, DiscoveryNode destination) {
        return new ParameterizedMessage("[{}][{}] from {} to {}", new Object[]{requestId, action, this.getLocalNode(), destination}).getFormattedMessage();
    }

    protected void onBlackholedDuringSend(long requestId, String action, DisruptableMockTransport destinationTransport) {
        this.logger.trace("dropping {}", (Object)this.getRequestDescription(requestId, action, destinationTransport.getLocalNode()));
        this.deterministicTaskQueue.scheduleAt(this.deterministicTaskQueue.getCurrentTimeMillis() + TimeUnit.DAYS.toMillis(1L), () -> this.onDisconnectedDuringSend(requestId, action, destinationTransport));
    }

    protected void onDisconnectedDuringSend(long requestId, String action, DisruptableMockTransport destinationTransport) {
        destinationTransport.execute(this.getDisconnectException(requestId, action, destinationTransport.getLocalNode()));
    }

    protected void onConnectedDuringSend(final long requestId, final String action, TransportRequest request, final DisruptableMockTransport destinationTransport) {
        TransportRequest copiedRequest;
        RequestHandlerRegistry requestHandler = destinationTransport.getRequestHandlers().getHandler(action);
        DiscoveryNode destination = destinationTransport.getLocalNode();
        final String requestDescription = this.getRequestDescription(requestId, action, destination);
        TransportChannel transportChannel = new TransportChannel(){

            public String getProfileName() {
                return "default";
            }

            public String getChannelType() {
                return "disruptable-mock-transport-channel";
            }

            public void sendResponse(final TransportResponse response) {
                DisruptableMockTransport.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionStatus connectionStatus = destinationTransport.getConnectionStatus(DisruptableMockTransport.this.getLocalNode());
                        switch (connectionStatus) {
                            case BLACK_HOLE_REQUESTS_ONLY: 
                            case CONNECTED: {
                                DisruptableMockTransport.this.handleResponse(requestId, response);
                                break;
                            }
                            case BLACK_HOLE: 
                            case DISCONNECTED: {
                                TransportChannel.logger.trace("delaying response to {}: channel is {}", (Object)requestDescription, (Object)connectionStatus);
                                DisruptableMockTransport.this.onBlackholedDuringSend(requestId, action, destinationTransport);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("unexpected status: " + connectionStatus));
                            }
                        }
                    }

                    public String toString() {
                        return "response to " + requestDescription;
                    }
                });
            }

            public void sendResponse(final Exception exception) {
                DisruptableMockTransport.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionStatus connectionStatus = destinationTransport.getConnectionStatus(DisruptableMockTransport.this.getLocalNode());
                        switch (connectionStatus) {
                            case BLACK_HOLE_REQUESTS_ONLY: 
                            case CONNECTED: {
                                DisruptableMockTransport.this.handleRemoteError(requestId, exception);
                                break;
                            }
                            case BLACK_HOLE: 
                            case DISCONNECTED: {
                                TransportChannel.logger.trace("delaying exception response to {}: channel is {}", (Object)requestDescription, (Object)connectionStatus);
                                DisruptableMockTransport.this.onBlackholedDuringSend(requestId, action, destinationTransport);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("unexpected status: " + connectionStatus));
                            }
                        }
                    }

                    public String toString() {
                        return "error response to " + requestDescription;
                    }
                });
            }
        };
        try {
            copiedRequest = OpenSearchTestCase.copyWriteable(request, this.writeableRegistry(), arg_0 -> ((RequestHandlerRegistry)requestHandler).newRequest(arg_0));
        }
        catch (IOException e) {
            throw new AssertionError("exception de/serializing request", e);
        }
        try {
            requestHandler.processMessageReceived(copiedRequest, transportChannel);
        }
        catch (Exception e) {
            try {
                transportChannel.sendResponse(e);
            }
            catch (Exception ee) {
                this.logger.warn("failed to send failure", (Throwable)e);
            }
        }
    }

    public static enum ConnectionStatus {
        CONNECTED,
        DISCONNECTED,
        BLACK_HOLE,
        BLACK_HOLE_REQUESTS_ONLY;

    }
}

