/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.generators.RandomNumbers;
import com.carrotsearch.randomizedtesting.generators.RandomPicks;
import com.carrotsearch.randomizedtesting.generators.RandomStrings;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import org.opensearch.OpenSearchException;
import org.opensearch.action.admin.indices.analyze.AnalyzeAction;
import org.opensearch.action.support.replication.ReplicationResponse;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.coordination.NoClusterManagerBlockService;
import org.opensearch.common.bytes.BytesArray;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.shard.IndexShardRecoveringException;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.shard.ShardNotFoundException;
import org.opensearch.rest.RestStatus;
import org.opensearch.test.OpenSearchTestCase;

public final class RandomObjects {
    private RandomObjects() {
    }

    public static Tuple<List<Object>, List<Object>> randomStoredFieldValues(Random random, MediaType mediaType) {
        if (!(mediaType instanceof XContentType)) {
            throw new IllegalArgumentException("Unable to parse media type [" + mediaType.getClass().getName() + "]");
        }
        int numValues = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)5);
        List<Object> originalValues = RandomObjects.randomStoredFieldValues(random, numValues);
        ArrayList<Object> expectedParsedValues = new ArrayList<Object>(numValues);
        for (Object originalValue : originalValues) {
            expectedParsedValues.add(RandomObjects.getExpectedParsedValue(XContentType.fromMediaType((MediaType)mediaType), originalValue));
        }
        return Tuple.tuple(originalValues, expectedParsedValues);
    }

    private static List<Object> randomStoredFieldValues(Random random, int numValues) {
        ArrayList<Object> values = new ArrayList<Object>(numValues);
        int dataType = RandomNumbers.randomIntBetween((Random)random, (int)0, (int)8);
        block11: for (int i = 0; i < numValues; ++i) {
            switch (dataType) {
                case 0: {
                    values.add(random.nextLong());
                    continue block11;
                }
                case 1: {
                    values.add(random.nextInt());
                    continue block11;
                }
                case 2: {
                    values.add((short)random.nextInt());
                    continue block11;
                }
                case 3: {
                    values.add((byte)random.nextInt());
                    continue block11;
                }
                case 4: {
                    values.add(random.nextDouble());
                    continue block11;
                }
                case 5: {
                    values.add(Float.valueOf(random.nextFloat()));
                    continue block11;
                }
                case 6: {
                    values.add(random.nextBoolean());
                    continue block11;
                }
                case 7: {
                    values.add(random.nextBoolean() ? RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)3, (int)10) : RandomStrings.randomUnicodeOfLengthBetween((Random)random, (int)3, (int)10));
                    continue block11;
                }
                case 8: {
                    byte[] randomBytes = RandomStrings.randomUnicodeOfLengthBetween((Random)random, (int)10, (int)50).getBytes(StandardCharsets.UTF_8);
                    values.add(new BytesArray(randomBytes));
                    continue block11;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        return values;
    }

    public static Object getExpectedParsedValue(XContentType xContentType, Object value) {
        if (value instanceof BytesArray && xContentType == XContentType.JSON) {
            return Base64.getEncoder().encodeToString(((BytesArray)value).toBytesRef().bytes);
        }
        if (value instanceof Float) {
            if (xContentType == XContentType.CBOR || xContentType == XContentType.SMILE) {
                return value;
            }
            return Double.parseDouble(value.toString());
        }
        if (value instanceof Byte) {
            return ((Byte)value).intValue();
        }
        if (value instanceof Short) {
            return ((Short)value).intValue();
        }
        return value;
    }

    public static BytesReference randomSource(Random random) {
        return RandomObjects.randomSource(random, (XContentType)RandomPicks.randomFrom((Random)random, (Object[])XContentType.values()));
    }

    public static BytesReference randomSource(Random random, XContentType xContentType) {
        return RandomObjects.randomSource(random, xContentType, 1);
    }

    public static BytesReference randomSource(Random random, XContentType xContentType, int minNumFields) {
        BytesReference bytesReference;
        block8: {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);
            try {
                builder.startObject();
                RandomObjects.addFields(random, builder, minNumFields, 0);
                builder.endObject();
                bytesReference = BytesReference.bytes((XContentBuilder)builder);
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            builder.close();
        }
        return bytesReference;
    }

    private static void addFields(Random random, XContentBuilder builder, int minNumFields, int currentDepth) throws IOException {
        int numFields = RandomNumbers.randomIntBetween((Random)random, (int)minNumFields, (int)5);
        for (int i = 0; i < numFields; ++i) {
            if (currentDepth < 5 && random.nextInt(100) >= 70) {
                if (random.nextBoolean()) {
                    builder.startObject(RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)6, (int)10));
                    RandomObjects.addFields(random, builder, minNumFields, currentDepth + 1);
                    builder.endObject();
                    continue;
                }
                builder.startArray(RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)6, (int)10));
                int numElements = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)5);
                boolean object = random.nextBoolean();
                int dataType = -1;
                if (!object) {
                    dataType = RandomObjects.randomDataType(random);
                }
                for (int j = 0; j < numElements; ++j) {
                    if (object) {
                        builder.startObject();
                        RandomObjects.addFields(random, builder, minNumFields, 5);
                        builder.endObject();
                        continue;
                    }
                    builder.value(RandomObjects.randomFieldValue(random, dataType));
                }
                builder.endArray();
                continue;
            }
            builder.field(RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)6, (int)10), RandomObjects.randomFieldValue(random, RandomObjects.randomDataType(random)));
        }
    }

    private static int randomDataType(Random random) {
        return RandomNumbers.randomIntBetween((Random)random, (int)0, (int)3);
    }

    private static Object randomFieldValue(Random random, int dataType) {
        switch (dataType) {
            case 0: {
                return RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)3, (int)10);
            }
            case 1: {
                return RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)3, (int)10);
            }
            case 2: {
                return random.nextLong();
            }
            case 3: {
                return random.nextDouble();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Tuple<ReplicationResponse.ShardInfo, ReplicationResponse.ShardInfo> randomShardInfo(Random random) {
        return RandomObjects.randomShardInfo(random, random.nextBoolean());
    }

    public static Tuple<ReplicationResponse.ShardInfo, ReplicationResponse.ShardInfo> randomShardInfo(Random random, boolean withShardFailures) {
        int total = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
        if (!withShardFailures) {
            return Tuple.tuple((Object)new ReplicationResponse.ShardInfo(total, total, new ReplicationResponse.ShardInfo.Failure[0]), (Object)new ReplicationResponse.ShardInfo(total, total, new ReplicationResponse.ShardInfo.Failure[0]));
        }
        int successful = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)Math.max(1, total - 1));
        int failures = Math.max(1, total - successful);
        ReplicationResponse.ShardInfo.Failure[] actualFailures = new ReplicationResponse.ShardInfo.Failure[failures];
        ReplicationResponse.ShardInfo.Failure[] expectedFailures = new ReplicationResponse.ShardInfo.Failure[failures];
        for (int i = 0; i < failures; ++i) {
            Tuple<ReplicationResponse.ShardInfo.Failure, ReplicationResponse.ShardInfo.Failure> failure = RandomObjects.randomShardInfoFailure(random);
            actualFailures[i] = (ReplicationResponse.ShardInfo.Failure)failure.v1();
            expectedFailures[i] = (ReplicationResponse.ShardInfo.Failure)failure.v2();
        }
        return Tuple.tuple((Object)new ReplicationResponse.ShardInfo(total, successful, actualFailures), (Object)new ReplicationResponse.ShardInfo(total, successful, expectedFailures));
    }

    private static Tuple<ReplicationResponse.ShardInfo.Failure, ReplicationResponse.ShardInfo.Failure> randomShardInfoFailure(Random random) {
        OpenSearchException expectedException;
        Object actualException;
        String index = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)5);
        String indexUuid = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)5);
        int shardId = RandomNumbers.randomIntBetween((Random)random, (int)1, (int)10);
        String nodeId = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)5);
        RestStatus status = OpenSearchTestCase.randomFrom(random, new RestStatus[]{RestStatus.INTERNAL_SERVER_ERROR, RestStatus.FORBIDDEN, RestStatus.NOT_FOUND});
        boolean primary = random.nextBoolean();
        ShardId shard = new ShardId(index, indexUuid, shardId);
        int type = RandomNumbers.randomIntBetween((Random)random, (int)0, (int)3);
        switch (type) {
            case 0: {
                actualException = new ClusterBlockException(Collections.singleton(NoClusterManagerBlockService.NO_CLUSTER_MANAGER_BLOCK_WRITES));
                expectedException = new OpenSearchException("OpenSearch exception [type=cluster_block_exception, reason=blocked by: [SERVICE_UNAVAILABLE/2/no cluster-manager];]", new Object[0]);
                break;
            }
            case 1: {
                actualException = new ShardNotFoundException(shard);
                expectedException = new OpenSearchException("OpenSearch exception [type=shard_not_found_exception, reason=no such shard]", new Object[0]);
                expectedException.setShard(shard);
                break;
            }
            case 2: {
                actualException = new IllegalArgumentException("Closed resource", new RuntimeException("Resource"));
                expectedException = new OpenSearchException("OpenSearch exception [type=illegal_argument_exception, reason=Closed resource]", (Throwable)new OpenSearchException("OpenSearch exception [type=runtime_exception, reason=Resource]", new Object[0]), new Object[0]);
                break;
            }
            case 3: {
                actualException = new IndexShardRecoveringException(shard);
                expectedException = new OpenSearchException("OpenSearch exception [type=index_shard_recovering_exception, reason=CurrentState[RECOVERING] Already recovering]", new Object[0]);
                expectedException.setShard(shard);
                break;
            }
            default: {
                throw new UnsupportedOperationException("No randomized exceptions generated for type [" + type + "]");
            }
        }
        ReplicationResponse.ShardInfo.Failure actual = new ReplicationResponse.ShardInfo.Failure(shard, nodeId, (Exception)actualException, status, primary);
        ReplicationResponse.ShardInfo.Failure expected = new ReplicationResponse.ShardInfo.Failure(new ShardId(index, "_na_", shardId), nodeId, (Exception)expectedException, status, primary);
        return Tuple.tuple((Object)actual, (Object)expected);
    }

    public static AnalyzeAction.AnalyzeToken randomToken(Random random) {
        String token = RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)1, (int)20);
        int position = RandomizedTest.randomIntBetween((int)0, (int)1000);
        int startOffset = RandomizedTest.randomIntBetween((int)0, (int)1000);
        int endOffset = RandomizedTest.randomIntBetween((int)0, (int)1000);
        int posLength = RandomizedTest.randomIntBetween((int)1, (int)5);
        String type = RandomStrings.randomAsciiLettersOfLengthBetween((Random)random, (int)1, (int)20);
        HashMap<String, Object> extras = new HashMap<String, Object>();
        if (random.nextBoolean()) {
            int entryCount = RandomNumbers.randomIntBetween((Random)random, (int)0, (int)6);
            block5: for (int i = 0; i < entryCount; ++i) {
                switch (RandomNumbers.randomIntBetween((Random)random, (int)0, (int)6)) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        String key = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)5);
                        String value = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)10);
                        extras.put(key, value);
                        continue block5;
                    }
                    case 4: {
                        String objkey = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)5);
                        HashMap<String, String> obj = new HashMap<String, String>();
                        obj.put(RandomStrings.randomAsciiLettersOfLength((Random)random, (int)5), RandomStrings.randomAsciiLettersOfLength((Random)random, (int)10));
                        extras.put(objkey, obj);
                        continue block5;
                    }
                    case 5: {
                        String listkey = RandomStrings.randomAsciiLettersOfLength((Random)random, (int)5);
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(RandomStrings.randomAsciiLettersOfLength((Random)random, (int)4));
                        list.add(RandomStrings.randomAsciiLettersOfLength((Random)random, (int)6));
                        extras.put(listkey, list);
                    }
                }
            }
        }
        return new AnalyzeAction.AnalyzeToken(token, position, startOffset, endOffset, posLength, type, extras);
    }
}

