/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.CompositeReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.tests.index.AssertingDirectoryReader;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.apache.lucene.tests.search.AssertingIndexSearcher;
import org.apache.lucene.tests.store.BaseDirectoryWrapper;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.mockito.Mockito;
import org.opensearch.Version;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.TriFunction;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.lucene.index.OpenSearchDirectoryReader;
import org.opensearch.common.network.NetworkAddress;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.BigArrays;
import org.opensearch.common.util.MockBigArrays;
import org.opensearch.common.util.MockPageCacheRecycler;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.Index;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.analysis.AnalyzerScope;
import org.opensearch.index.analysis.IndexAnalyzers;
import org.opensearch.index.analysis.NamedAnalyzer;
import org.opensearch.index.cache.bitset.BitsetFilterCache;
import org.opensearch.index.cache.query.DisabledQueryCache;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.fielddata.IndexFieldDataService;
import org.opensearch.index.mapper.BinaryFieldMapper;
import org.opensearch.index.mapper.ContentPath;
import org.opensearch.index.mapper.DateFieldMapper;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.GeoPointFieldMapper;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.Mapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.index.mapper.ObjectMapper;
import org.opensearch.index.mapper.RangeFieldMapper;
import org.opensearch.index.mapper.RangeType;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.indices.IndicesModule;
import org.opensearch.indices.breaker.CircuitBreakerService;
import org.opensearch.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.opensearch.indices.mapper.MapperRegistry;
import org.opensearch.plugins.SearchPlugin;
import org.opensearch.script.ScriptService;
import org.opensearch.search.SearchModule;
import org.opensearch.search.aggregations.AbstractAggregationBuilder;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.MultiBucketConsumerService;
import org.opensearch.search.aggregations.SearchContextAggregations;
import org.opensearch.search.aggregations.metrics.MetricsAggregator;
import org.opensearch.search.aggregations.pipeline.PipelineAggregator;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.fetch.FetchPhase;
import org.opensearch.search.fetch.subphase.FetchDocValuesPhase;
import org.opensearch.search.fetch.subphase.FetchSourcePhase;
import org.opensearch.search.internal.ContextIndexSearcher;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.lookup.SearchLookup;
import org.opensearch.test.InternalAggregationTestCase;
import org.opensearch.test.OpenSearchTestCase;

public abstract class AggregatorTestCase
extends OpenSearchTestCase {
    private static final String NESTEDFIELD_PREFIX = "nested_";
    private List<Releasable> releasables = new ArrayList<Releasable>();
    private static final String TYPE_NAME = "type";
    protected ValuesSourceRegistry valuesSourceRegistry;
    private static List<String> TYPE_TEST_DENYLIST;

    protected Map<String, MappedFieldType> getFieldAliases(MappedFieldType ... fieldTypes) {
        return Collections.emptyMap();
    }

    private static void registerFieldTypes(SearchContext searchContext, MapperService mapperService, Map<String, MappedFieldType> fieldNameToType) {
        for (Map.Entry<String, MappedFieldType> entry : fieldNameToType.entrySet()) {
            String fieldName = entry.getKey();
            MappedFieldType fieldType = entry.getValue();
            Mockito.when((Object)mapperService.fieldType(fieldName)).thenReturn((Object)fieldType);
            Mockito.when((Object)searchContext.fieldType(fieldName)).thenReturn((Object)fieldType);
        }
    }

    @Before
    public void initValuesSourceRegistry() {
        ArrayList<SearchPlugin> plugins = new ArrayList<SearchPlugin>(this.getSearchPlugins());
        plugins.add(new AggCardinalityPlugin());
        SearchModule searchModule = new SearchModule(Settings.EMPTY, plugins);
        this.valuesSourceRegistry = searchModule.getValuesSourceRegistry();
    }

    protected List<SearchPlugin> getSearchPlugins() {
        return Collections.emptyList();
    }

    protected <A extends Aggregator> A createAggregator(AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(aggregationBuilder, indexSearcher, this.createIndexSettings(), new MultiBucketConsumerService.MultiBucketConsumer(100000, new NoneCircuitBreakerService().getBreaker("request")), fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(query, aggregationBuilder, indexSearcher, indexSettings, new MultiBucketConsumerService.MultiBucketConsumer(100000, new NoneCircuitBreakerService().getBreaker("request")), fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(query, aggregationBuilder, indexSearcher, this.createIndexSettings(), bucketConsumer, fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        return this.createAggregator(null, aggregationBuilder, indexSearcher, indexSettings, bucketConsumer, fieldTypes);
    }

    protected <A extends Aggregator> A createAggregator(Query query, AggregationBuilder aggregationBuilder, IndexSearcher indexSearcher, IndexSettings indexSettings, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        SearchContext searchContext = this.createSearchContext(indexSearcher, indexSettings, query, bucketConsumer, fieldTypes);
        return this.createAggregator(aggregationBuilder, searchContext);
    }

    protected <A extends Aggregator> A createAggregator(AggregationBuilder aggregationBuilder, SearchContext searchContext) throws IOException {
        Aggregator aggregator = aggregationBuilder.rewrite((QueryRewriteContext)searchContext.getQueryShardContext()).build(searchContext.getQueryShardContext(), null).create(searchContext, null, CardinalityUpperBound.ONE);
        return (A)aggregator;
    }

    protected SearchContext createSearchContext(IndexSearcher indexSearcher, IndexSettings indexSettings, Query query, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, MappedFieldType ... fieldTypes) throws IOException {
        return this.createSearchContext(indexSearcher, indexSettings, query, bucketConsumer, (CircuitBreakerService)new NoneCircuitBreakerService(), fieldTypes);
    }

    protected SearchContext createSearchContext(IndexSearcher indexSearcher, IndexSettings indexSettings, Query query, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer, CircuitBreakerService circuitBreakerService, MappedFieldType ... fieldTypes) throws IOException {
        DisabledQueryCache queryCache = new DisabledQueryCache(indexSettings);
        QueryCachingPolicy queryCachingPolicy = new QueryCachingPolicy(){

            public void onUse(Query query) {
            }

            public boolean shouldCache(Query query) {
                return false;
            }
        };
        ContextIndexSearcher contextIndexSearcher = new ContextIndexSearcher(indexSearcher.getIndexReader(), indexSearcher.getSimilarity(), (QueryCache)queryCache, queryCachingPolicy, false, null);
        SearchContext searchContext = (SearchContext)Mockito.mock(SearchContext.class);
        Mockito.when((Object)searchContext.numberOfShards()).thenReturn((Object)1);
        Mockito.when((Object)searchContext.searcher()).thenReturn((Object)contextIndexSearcher);
        Mockito.when((Object)searchContext.fetchPhase()).thenReturn((Object)new FetchPhase(Arrays.asList(new FetchSourcePhase(), new FetchDocValuesPhase())));
        Mockito.when((Object)searchContext.bitsetFilterCache()).thenReturn((Object)new BitsetFilterCache(indexSettings, (BitsetFilterCache.Listener)Mockito.mock(BitsetFilterCache.Listener.class)));
        IndexShard indexShard = (IndexShard)Mockito.mock(IndexShard.class);
        Mockito.when((Object)indexShard.shardId()).thenReturn((Object)new ShardId("test", "test", 0));
        Mockito.when((Object)searchContext.indexShard()).thenReturn((Object)indexShard);
        Mockito.when((Object)searchContext.aggregations()).thenReturn((Object)new SearchContextAggregations(AggregatorFactories.EMPTY, bucketConsumer));
        Mockito.when((Object)searchContext.query()).thenReturn((Object)query);
        BigArrays bigArrays = new MockBigArrays(new MockPageCacheRecycler(Settings.EMPTY), circuitBreakerService).withCircuitBreaking();
        Mockito.when((Object)searchContext.bigArrays()).thenReturn((Object)bigArrays);
        MapperService mapperService = this.mapperServiceMock();
        Mockito.when((Object)mapperService.getIndexSettings()).thenReturn((Object)indexSettings);
        Mockito.when((Object)mapperService.hasNested()).thenReturn((Object)false);
        Mockito.when((Object)searchContext.mapperService()).thenReturn((Object)mapperService);
        IndexFieldDataService ifds = new IndexFieldDataService(indexSettings, new IndicesFieldDataCache(Settings.EMPTY, new IndexFieldDataCache.Listener(){}), circuitBreakerService, mapperService);
        QueryShardContext queryShardContext = this.queryShardContextMock((IndexSearcher)contextIndexSearcher, mapperService, indexSettings, circuitBreakerService, bigArrays);
        Mockito.when((Object)searchContext.getQueryShardContext()).thenReturn((Object)queryShardContext);
        Mockito.when((Object)queryShardContext.getObjectMapper(Mockito.anyString())).thenAnswer(invocation -> {
            String fieldName = (String)invocation.getArguments()[0];
            if (fieldName.startsWith(NESTEDFIELD_PREFIX)) {
                Mapper.BuilderContext context = new Mapper.BuilderContext(indexSettings.getSettings(), new ContentPath());
                return new ObjectMapper.Builder(fieldName).nested(ObjectMapper.Nested.newNested()).build(context);
            }
            return null;
        });
        HashMap<String, MappedFieldType> fieldNameToType = new HashMap<String, MappedFieldType>();
        fieldNameToType.putAll(Arrays.stream(fieldTypes).filter(Objects::nonNull).collect(Collectors.toMap(MappedFieldType::name, Function.identity())));
        fieldNameToType.putAll(this.getFieldAliases(fieldTypes));
        AggregatorTestCase.registerFieldTypes(searchContext, mapperService, fieldNameToType);
        ((SearchContext)Mockito.doAnswer(invocation -> {
            this.releasables.add((Releasable)invocation.getArguments()[0]);
            return null;
        }).when((Object)searchContext)).addReleasable((Releasable)Mockito.any());
        return searchContext;
    }

    protected IndexSettings createIndexSettings() {
        return new IndexSettings(IndexMetadata.builder((String)"_index").settings(Settings.builder().put("index.version.created", Version.CURRENT)).numberOfShards(1).numberOfReplicas(0).creationDate(System.currentTimeMillis()).build(), Settings.EMPTY);
    }

    protected MapperService mapperServiceMock() {
        return (MapperService)Mockito.mock(MapperService.class);
    }

    protected QueryShardContext queryShardContextMock(IndexSearcher searcher, MapperService mapperService, IndexSettings indexSettings, CircuitBreakerService circuitBreakerService, BigArrays bigArrays) {
        return new QueryShardContext(0, indexSettings, bigArrays, null, this.getIndexFieldDataLookup(mapperService, circuitBreakerService), mapperService, null, this.getMockScriptService(), this.xContentRegistry(), this.writableRegistry(), null, searcher, System::currentTimeMillis, null, null, () -> true, this.valuesSourceRegistry);
    }

    protected TriFunction<MappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> getIndexFieldDataLookup(MapperService mapperService, CircuitBreakerService circuitBreakerService) {
        return (fieldType, s, searchLookup) -> fieldType.fielddataBuilder(mapperService.getIndexSettings().getIndex().getName(), searchLookup).build((IndexFieldDataCache)new IndexFieldDataCache.None(), circuitBreakerService);
    }

    protected ScriptService getMockScriptService() {
        return null;
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, Query query, AggregationBuilder builder, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(this.createIndexSettings(), searcher, query, builder, 100000, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSettings indexSettings, IndexSearcher searcher, Query query, AggregationBuilder builder, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(indexSettings, searcher, query, builder, 100000, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSearcher searcher, Query query, AggregationBuilder builder, int maxBucket, MappedFieldType ... fieldTypes) throws IOException {
        return this.searchAndReduce(this.createIndexSettings(), searcher, query, builder, maxBucket, fieldTypes);
    }

    protected <A extends InternalAggregation, C extends Aggregator> A searchAndReduce(IndexSettings indexSettings, IndexSearcher searcher, Query query, AggregationBuilder builder, int maxBucket, MappedFieldType ... fieldTypes) throws IOException {
        IndexReaderContext ctx = searcher.getTopReaderContext();
        PipelineAggregator.PipelineTree pipelines = builder.buildPipelineTree();
        ArrayList<InternalAggregation> aggs = new ArrayList<InternalAggregation>();
        Query rewritten = searcher.rewrite(query);
        MultiBucketConsumerService.MultiBucketConsumer bucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, new NoneCircuitBreakerService().getBreaker("request"));
        A root = this.createAggregator(query, builder, searcher, bucketConsumer, fieldTypes);
        if (AggregatorTestCase.randomBoolean() && searcher.getIndexReader().leaves().size() > 0) {
            AggregatorTestCase.assertThat((Object)ctx, (Matcher)Matchers.instanceOf(CompositeReaderContext.class));
            CompositeReaderContext compCTX = (CompositeReaderContext)ctx;
            int size = compCTX.leaves().size();
            ShardSearcher[] subSearchers = new ShardSearcher[size];
            for (int searcherIDX = 0; searcherIDX < subSearchers.length; ++searcherIDX) {
                LeafReaderContext leave = (LeafReaderContext)compCTX.leaves().get(searcherIDX);
                subSearchers[searcherIDX] = new ShardSearcher(leave, (IndexReaderContext)compCTX);
            }
            for (ShardSearcher subSearcher : subSearchers) {
                MultiBucketConsumerService.MultiBucketConsumer shardBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, new NoneCircuitBreakerService().getBreaker("request"));
                A a = this.createAggregator(query, builder, (IndexSearcher)subSearcher, indexSettings, shardBucketConsumer, fieldTypes);
                a.preCollection();
                Weight weight = subSearcher.createWeight(rewritten, ScoreMode.COMPLETE, 1.0f);
                subSearcher.search(weight, (Collector)a);
                a.postCollection();
                aggs.add(a.buildTopLevel());
            }
        } else {
            root.preCollection();
            searcher.search(rewritten, root);
            root.postCollection();
            aggs.add(root.buildTopLevel());
        }
        if (AggregatorTestCase.randomBoolean() && aggs.size() > 1) {
            int toReduceSize = aggs.size();
            Collections.shuffle(aggs, AggregatorTestCase.random());
            int r = AggregatorTestCase.randomIntBetween(1, toReduceSize);
            List toReduce = aggs.subList(0, r);
            InternalAggregation.ReduceContext context = InternalAggregation.ReduceContext.forPartialReduction((BigArrays)root.context().bigArrays(), (ScriptService)this.getMockScriptService(), () -> PipelineAggregator.PipelineTree.EMPTY);
            InternalAggregation reduced = ((InternalAggregation)aggs.get(0)).reduce(toReduce, context);
            aggs = new ArrayList(aggs.subList(r, toReduceSize));
            aggs.add(reduced);
        }
        MultiBucketConsumerService.MultiBucketConsumer reduceBucketConsumer = new MultiBucketConsumerService.MultiBucketConsumer(maxBucket, new NoneCircuitBreakerService().getBreaker("request"));
        InternalAggregation.ReduceContext context = InternalAggregation.ReduceContext.forFinalReduction((BigArrays)root.context().bigArrays(), (ScriptService)this.getMockScriptService(), (IntConsumer)reduceBucketConsumer, (PipelineAggregator.PipelineTree)pipelines);
        InternalAggregation internalAgg = ((InternalAggregation)aggs.get(0)).reduce(aggs, context);
        internalAgg = internalAgg.reducePipelines(internalAgg, context, pipelines);
        for (PipelineAggregator pipelineAggregator : pipelines.aggregators()) {
            internalAgg = pipelineAggregator.reduce(internalAgg, context);
        }
        this.doAssertReducedMultiBucketConsumer((Aggregation)internalAgg, reduceBucketConsumer);
        return (A)internalAgg;
    }

    protected void doAssertReducedMultiBucketConsumer(Aggregation agg, MultiBucketConsumerService.MultiBucketConsumer bucketConsumer) {
        InternalAggregationTestCase.assertMultiBucketConsumer(agg, bucketConsumer);
    }

    protected <T extends AggregationBuilder, V extends InternalAggregation> void testCase(T aggregationBuilder, Query query, CheckedConsumer<RandomIndexWriter, IOException> buildIndex, Consumer<V> verify, MappedFieldType ... fieldTypes) throws IOException {
        try (BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();){
            RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
            buildIndex.accept((Object)indexWriter);
            indexWriter.close();
            try (DirectoryReader unwrapped = DirectoryReader.open((Directory)directory);
                 IndexReader indexReader = this.wrapDirectoryReader(unwrapped);){
                IndexSearcher indexSearcher = AggregatorTestCase.newIndexSearcher(indexReader);
                Object agg = this.searchAndReduce(indexSearcher, query, aggregationBuilder, fieldTypes);
                verify.accept(agg);
            }
        }
    }

    protected IndexReader wrapDirectoryReader(DirectoryReader reader) throws IOException {
        return reader;
    }

    protected static DirectoryReader wrapInMockESDirectoryReader(DirectoryReader directoryReader) throws IOException {
        return OpenSearchDirectoryReader.wrap((DirectoryReader)directoryReader, (ShardId)new ShardId(new Index("_index", "_na_"), 0));
    }

    protected static IndexSearcher newIndexSearcher(IndexReader indexReader) {
        if (AggregatorTestCase.randomBoolean()) {
            return new AssertingIndexSearcher(AggregatorTestCase.random(), indexReader);
        }
        return new IndexSearcher(indexReader);
    }

    protected static IndexReader maybeWrapReaderEs(DirectoryReader reader) throws IOException {
        if (AggregatorTestCase.randomBoolean()) {
            return new AssertingDirectoryReader(reader);
        }
        return reader;
    }

    protected List<ValuesSourceType> getSupportedValuesSourceTypes() {
        return Collections.emptyList();
    }

    protected AggregationBuilder createAggBuilderForTypeTest(MappedFieldType fieldType, String fieldName) {
        throw new UnsupportedOperationException("If getSupportedValuesSourceTypes() is implemented, createAggBuilderForTypeTest() must be implemented as well.");
    }

    protected List<String> unsupportedMappedFieldTypes() {
        return Collections.emptyList();
    }

    public void testSupportedFieldTypes() throws IOException {
        MapperRegistry mapperRegistry = new IndicesModule(Collections.emptyList()).getMapperRegistry();
        Settings settings = Settings.builder().put("index.version.created", Version.CURRENT.id).build();
        String fieldName = "typeTestFieldName";
        List<ValuesSourceType> supportedVSTypes = this.getSupportedValuesSourceTypes();
        List<String> unsupportedMappedFieldTypes = this.unsupportedMappedFieldTypes();
        if (supportedVSTypes.isEmpty()) {
            return;
        }
        for (Map.Entry mappedType : mapperRegistry.getMapperParsers().entrySet()) {
            Mapper.Builder builder;
            FieldMapper mapper;
            MappedFieldType fieldType;
            if (TYPE_TEST_DENYLIST.contains(mappedType.getKey())) continue;
            HashMap source = new HashMap();
            source.put(TYPE_NAME, mappedType.getKey());
            if (!((String)mappedType.getKey()).equals("text")) {
                source.put("doc_values", "true");
            }
            if (!(fieldType = (mapper = (FieldMapper)(builder = ((Mapper.TypeParser)mappedType.getValue()).parse(fieldName, source, (Mapper.TypeParser.ParserContext)new MockParserContext())).build(new Mapper.BuilderContext(settings, new ContentPath()))).fieldType()).isAggregatable()) continue;
            BaseDirectoryWrapper directory = AggregatorTestCase.newDirectory();
            try {
                RandomIndexWriter indexWriter = new RandomIndexWriter(AggregatorTestCase.random(), (Directory)directory);
                this.writeTestDoc(fieldType, fieldName, indexWriter);
                indexWriter.close();
                DirectoryReader indexReader = DirectoryReader.open((Directory)directory);
                try {
                    AssertionError failure;
                    block16: {
                        IndexSearcher indexSearcher = AggregatorTestCase.newIndexSearcher((IndexReader)indexReader);
                        AggregationBuilder aggregationBuilder = this.createAggBuilderForTypeTest(fieldType, fieldName);
                        ValuesSourceType vst = this.fieldToVST(fieldType);
                        failure = null;
                        try {
                            this.searchAndReduce(indexSearcher, (Query)new MatchAllDocsQuery(), aggregationBuilder, fieldType);
                            if (!supportedVSTypes.contains(vst) || unsupportedMappedFieldTypes.contains(fieldType.typeName())) {
                                failure = new AssertionError((Object)("Aggregator [" + aggregationBuilder.getType() + "] should not support field type [" + fieldType.typeName() + "] but executing against the field did not throw an exception"));
                            }
                        }
                        catch (AssertionError | Exception e) {
                            if (!supportedVSTypes.contains(vst) || unsupportedMappedFieldTypes.contains(fieldType.typeName())) break block16;
                            failure = new AssertionError("Aggregator [" + aggregationBuilder.getType() + "] supports field type [" + fieldType.typeName() + "] but executing against the field threw an exception: [" + ((Throwable)e).getMessage() + "]", (Throwable)e);
                        }
                    }
                    if (failure == null) continue;
                    throw failure;
                }
                finally {
                    if (indexReader == null) continue;
                    indexReader.close();
                }
            }
            finally {
                if (directory == null) continue;
                directory.close();
            }
        }
    }

    private ValuesSourceType fieldToVST(MappedFieldType fieldType) {
        return fieldType.fielddataBuilder("", () -> {
            throw new UnsupportedOperationException();
        }).build(null, null).getValuesSourceType();
    }

    private void writeTestDoc(MappedFieldType fieldType, String fieldName, RandomIndexWriter iw) throws IOException {
        String json;
        String typeName = fieldType.typeName();
        ValuesSourceType vst = this.fieldToVST(fieldType);
        Document doc = new Document();
        if (vst.equals(CoreValuesSourceType.NUMERIC)) {
            long v;
            if (typeName.equals(NumberFieldMapper.NumberType.DOUBLE.typeName())) {
                double d = Math.abs(AggregatorTestCase.randomDouble());
                v = NumericUtils.doubleToSortableLong((double)d);
                json = "{ \"" + fieldName + "\" : \"" + d + "\" }";
            } else if (typeName.equals(NumberFieldMapper.NumberType.FLOAT.typeName())) {
                float f = Math.abs(AggregatorTestCase.randomFloat());
                v = NumericUtils.floatToSortableInt((float)f);
                json = "{ \"" + fieldName + "\" : \"" + f + "\" }";
            } else if (typeName.equals(NumberFieldMapper.NumberType.HALF_FLOAT.typeName())) {
                float f = Math.abs((AggregatorTestCase.randomFloat() * 2.0f - 1.0f) * 65504.0f);
                v = HalfFloatPoint.halfFloatToSortableShort((float)f);
                json = "{ \"" + fieldName + "\" : \"" + f + "\" }";
            } else {
                v = Math.abs(AggregatorTestCase.randomByte());
                json = "{ \"" + fieldName + "\" : \"" + v + "\" }";
            }
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
        } else if (vst.equals(CoreValuesSourceType.BYTES)) {
            if (typeName.equals("binary")) {
                doc.add((IndexableField)new BinaryFieldMapper.CustomBinaryDocValuesField(fieldName, new BytesRef((CharSequence)"a").bytes));
                json = "{ \"" + fieldName + "\" : \"a\" }";
            } else {
                doc.add((IndexableField)new SortedSetDocValuesField(fieldName, new BytesRef((CharSequence)"a")));
                json = "{ \"" + fieldName + "\" : \"a\" }";
            }
        } else if (vst.equals(CoreValuesSourceType.DATE)) {
            long v = Math.abs(AggregatorTestCase.randomInt());
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
            json = "{ \"" + fieldName + "\" : \"" + v + "\" }";
        } else if (vst.equals(CoreValuesSourceType.BOOLEAN)) {
            long v = AggregatorTestCase.randomBoolean() ? 0L : 1L;
            doc.add((IndexableField)new SortedNumericDocValuesField(fieldName, v));
            json = "{ \"" + fieldName + "\" : \"" + (v == 0L ? "false" : "true") + "\" }";
        } else if (vst.equals(CoreValuesSourceType.IP)) {
            InetAddress ip = AggregatorTestCase.randomIp(AggregatorTestCase.randomBoolean());
            json = "{ \"" + fieldName + "\" : \"" + NetworkAddress.format((InetAddress)ip) + "\" }";
            doc.add((IndexableField)new SortedSetDocValuesField(fieldName, new BytesRef(InetAddressPoint.encode((InetAddress)ip))));
        } else if (vst.equals(CoreValuesSourceType.RANGE)) {
            RangeType rangeType;
            Object end;
            Serializable start;
            if (typeName.equals(RangeType.DOUBLE.typeName())) {
                start = AggregatorTestCase.randomDouble();
                end = RangeType.DOUBLE.nextUp((Object)start);
                rangeType = RangeType.DOUBLE;
            } else if (typeName.equals(RangeType.FLOAT.typeName())) {
                start = Float.valueOf(AggregatorTestCase.randomFloat());
                end = RangeType.FLOAT.nextUp((Object)start);
                rangeType = RangeType.DOUBLE;
            } else if (typeName.equals(RangeType.IP.typeName())) {
                boolean v4 = AggregatorTestCase.randomBoolean();
                start = AggregatorTestCase.randomIp(v4);
                end = RangeType.IP.nextUp((Object)start);
                rangeType = RangeType.IP;
            } else if (typeName.equals(RangeType.LONG.typeName())) {
                start = AggregatorTestCase.randomLong();
                end = RangeType.LONG.nextUp((Object)start);
                rangeType = RangeType.LONG;
            } else if (typeName.equals(RangeType.INTEGER.typeName())) {
                start = AggregatorTestCase.randomInt();
                end = RangeType.INTEGER.nextUp((Object)start);
                rangeType = RangeType.INTEGER;
            } else if (typeName.equals(RangeType.DATE.typeName())) {
                start = AggregatorTestCase.randomNonNegativeLong();
                end = RangeType.DATE.nextUp((Object)start);
                rangeType = RangeType.DATE;
            } else {
                throw new IllegalStateException("Unknown type of range [" + typeName + "]");
            }
            RangeFieldMapper.Range range = new RangeFieldMapper.Range(rangeType, (Object)start, end, true, true);
            doc.add((IndexableField)new BinaryDocValuesField(fieldName, rangeType.encodeRanges(Collections.singleton(range))));
            json = "{ \"" + fieldName + "\" : { \n        \"gte\" : \"" + start + "\",\n        \"lte\" : \"" + end + "\"\n      }}";
        } else if (vst.equals(CoreValuesSourceType.GEOPOINT)) {
            double lat = AggregatorTestCase.randomDouble();
            double lon = AggregatorTestCase.randomDouble();
            doc.add((IndexableField)new LatLonDocValuesField(fieldName, lat, lon));
            json = "{ \"" + fieldName + "\" : \"[" + lon + "," + lat + "]\" }";
        } else {
            throw new IllegalStateException("Unknown field type [" + typeName + "]");
        }
        doc.add((IndexableField)new StoredField("_source", new BytesRef((CharSequence)json)));
        iw.addDocument((Iterable)doc);
    }

    @After
    private void cleanupReleasables() {
        Releasables.close(this.releasables);
        this.releasables.clear();
    }

    protected void afterClose() {
    }

    protected DateFieldMapper.DateFieldType dateField(String name, DateFieldMapper.Resolution resolution) {
        return new DateFieldMapper.DateFieldType(name, resolution);
    }

    protected NumberFieldMapper.NumberFieldType doubleField(String name) {
        return new NumberFieldMapper.NumberFieldType(name, NumberFieldMapper.NumberType.DOUBLE);
    }

    protected GeoPointFieldMapper.GeoPointFieldType geoPointField(String name) {
        return new GeoPointFieldMapper.GeoPointFieldType(name);
    }

    protected KeywordFieldMapper.KeywordFieldType keywordField(String name) {
        return new KeywordFieldMapper.KeywordFieldType(name);
    }

    protected NumberFieldMapper.NumberFieldType longField(String name) {
        return new NumberFieldMapper.NumberFieldType(name, NumberFieldMapper.NumberType.LONG);
    }

    protected RangeFieldMapper.RangeFieldType rangeField(String name, RangeType rangeType) {
        if (rangeType == RangeType.DATE) {
            return new RangeFieldMapper.RangeFieldType(name, RangeFieldMapper.Defaults.DATE_FORMATTER);
        }
        return new RangeFieldMapper.RangeFieldType(name, rangeType);
    }

    public static AggregationBuilder aggCardinality(String name) {
        return new AggCardinalityAggregationBuilder(name);
    }

    static {
        ArrayList<String> denylist = new ArrayList<String>();
        denylist.add("object");
        denylist.add("geo_shape");
        denylist.add("nested");
        denylist.add("completion");
        denylist.add("alias");
        TYPE_TEST_DENYLIST = denylist;
    }

    private static class AggCardinalityPlugin
    implements SearchPlugin {
        private AggCardinalityPlugin() {
        }

        public List<SearchPlugin.AggregationSpec> getAggregations() {
            return Collections.singletonList(new SearchPlugin.AggregationSpec("agg_cardinality", in -> null, (p, c) -> null));
        }
    }

    private static class ShardSearcher
    extends IndexSearcher {
        private final List<LeafReaderContext> ctx;

        ShardSearcher(LeafReaderContext ctx, IndexReaderContext parent) {
            super(parent);
            this.ctx = Collections.singletonList(ctx);
        }

        public void search(Weight weight, Collector collector) throws IOException {
            this.search(this.ctx, weight, collector);
        }

        public String toString() {
            return "ShardSearcher(" + this.ctx.get(0) + ")";
        }
    }

    private class MockParserContext
    extends Mapper.TypeParser.ParserContext {
        MockParserContext() {
            super(null, null, null, Version.CURRENT, null, null, null);
        }

        public Settings getSettings() {
            return Settings.EMPTY;
        }

        public IndexAnalyzers getIndexAnalyzers() {
            NamedAnalyzer defaultAnalyzer = new NamedAnalyzer("default", AnalyzerScope.GLOBAL, (Analyzer)new StandardAnalyzer());
            return new IndexAnalyzers(Collections.singletonMap("default", defaultAnalyzer), Collections.emptyMap(), Collections.emptyMap());
        }
    }

    private static class AggCardinalityAggregationBuilder
    extends AbstractAggregationBuilder<AggCardinalityAggregationBuilder> {
        AggCardinalityAggregationBuilder(String name) {
            super(name);
        }

        protected AggregatorFactory doBuild(QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subfactoriesBuilder) throws IOException {
            return new AggregatorFactory(this.name, queryShardContext, parent, subfactoriesBuilder, this.metadata){

                protected Aggregator createInternal(SearchContext searchContext, Aggregator parent, final CardinalityUpperBound cardinality, final Map<String, Object> metadata) throws IOException {
                    return new MetricsAggregator(this.name, searchContext, parent, metadata){

                        protected LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
                            return LeafBucketCollector.NO_OP_COLLECTOR;
                        }

                        public InternalAggregation buildAggregation(long owningBucketOrd) throws IOException {
                            return new InternalAggCardinality(this.name, cardinality, metadata);
                        }

                        public InternalAggregation buildEmptyAggregation() {
                            return null;
                        }
                    };
                }
            };
        }

        protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }

        public AggregationBuilder.BucketCardinality bucketCardinality() {
            return AggregationBuilder.BucketCardinality.ONE;
        }

        public String getType() {
            return "agg_cardinality";
        }

        protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
            throw new UnsupportedOperationException();
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class InternalAggCardinality
    extends InternalAggregation {
        private final CardinalityUpperBound cardinality;

        protected InternalAggCardinality(String name, CardinalityUpperBound cardinality, Map<String, Object> metadata) {
            super(name, metadata);
            this.cardinality = cardinality;
        }

        public CardinalityUpperBound cardinality() {
            return this.cardinality;
        }

        public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
            aggregations.forEach(ia -> Assert.assertThat((Object)((InternalAggCardinality)ia).cardinality, (Matcher)Matchers.equalTo((Object)this.cardinality)));
            return new InternalAggCardinality(this.name, this.cardinality, this.metadata);
        }

        protected boolean mustReduceOnSingleInternalAgg() {
            return true;
        }

        public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.array("cardinality", new Object[]{this.cardinality});
        }

        public Object getProperty(List<String> path) {
            throw new UnsupportedOperationException();
        }

        public String getWriteableName() {
            throw new UnsupportedOperationException();
        }

        protected void doWriteTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

