/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.admin.cluster.repositories.cleanup.CleanupRepositoryResponse;
import org.opensearch.action.admin.cluster.snapshots.create.CreateSnapshotResponse;
import org.opensearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.opensearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.common.Strings;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.blobstore.support.PlainBlobMetadata;
import org.opensearch.common.settings.SecureSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.repositories.blobstore.BlobStoreTestUtil;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotState;
import org.opensearch.test.OpenSearchSingleNodeTestCase;

public abstract class AbstractThirdPartyRepositoryTestCase
extends OpenSearchSingleNodeTestCase {
    @Override
    protected Settings nodeSettings() {
        return Settings.builder().put(super.nodeSettings()).setSecureSettings(this.credentials()).build();
    }

    protected abstract SecureSettings credentials();

    protected abstract void createRepository(String var1);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createRepository("test-repo");
        this.deleteAndAssertEmpty(this.getRepository().basePath());
    }

    @Override
    public void tearDown() throws Exception {
        this.deleteAndAssertEmpty(this.getRepository().basePath());
        this.client().admin().cluster().prepareDeleteRepository("test-repo").get();
        super.tearDown();
    }

    private void deleteAndAssertEmpty(BlobPath path) throws Exception {
        BlobStoreRepository repo = this.getRepository();
        PlainActionFuture future = PlainActionFuture.newFuture();
        repo.threadPool().generic().execute((Runnable)ActionRunnable.run((ActionListener)future, () -> repo.blobStore().blobContainer(path).delete()));
        future.actionGet();
        BlobPath parent = path.parent();
        if (parent == null) {
            this.assertChildren(path, Collections.emptyList());
        } else {
            this.assertDeleted(parent, path.toArray()[path.toArray().length - 1]);
        }
    }

    public void testCreateSnapshot() {
        this.createIndex("test-idx-1");
        this.createIndex("test-idx-2");
        this.createIndex("test-idx-3");
        this.ensureGreen(new String[0]);
        this.logger.info("--> indexing some data");
        for (int i = 0; i < 100; ++i) {
            this.client().prepareIndex("test-idx-1").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.client().prepareIndex("test-idx-2").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.client().prepareIndex("test-idx-3").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
        }
        this.client().admin().indices().prepareRefresh(new String[0]).get();
        String snapshotName = "test-snap-" + System.currentTimeMillis();
        this.logger.info("--> snapshot");
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.client().admin().cluster().prepareCreateSnapshot("test-repo", snapshotName).setWaitForCompletion(true).setIndices(new String[]{"test-idx-*", "-test-idx-3"}).get();
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)createSnapshotResponse.getSnapshotInfo().totalShards()));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)((SnapshotInfo)((GetSnapshotsResponse)this.client().admin().cluster().prepareGetSnapshots("test-repo").setSnapshots(new String[]{snapshotName}).get()).getSnapshots().get(0)).state(), (Matcher)Matchers.equalTo((Object)SnapshotState.SUCCESS));
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)((AcknowledgedResponse)this.client().admin().cluster().prepareDeleteSnapshot("test-repo", new String[]{snapshotName}).get()).isAcknowledged());
    }

    public void testListChildren() throws Exception {
        BlobStoreRepository repo = this.getRepository();
        PlainActionFuture future = PlainActionFuture.newFuture();
        ExecutorService genericExec = repo.threadPool().generic();
        int testBlobLen = AbstractThirdPartyRepositoryTestCase.randomIntBetween(1, 100);
        genericExec.execute((Runnable)ActionRunnable.run((ActionListener)future, () -> {
            BlobStore blobStore = repo.blobStore();
            blobStore.blobContainer(repo.basePath().add("foo")).writeBlob("nested-blob", (InputStream)new ByteArrayInputStream(AbstractThirdPartyRepositoryTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
            blobStore.blobContainer(repo.basePath().add("foo").add("nested")).writeBlob("bar", (InputStream)new ByteArrayInputStream(AbstractThirdPartyRepositoryTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
            blobStore.blobContainer(repo.basePath().add("foo").add("nested2")).writeBlob("blub", (InputStream)new ByteArrayInputStream(AbstractThirdPartyRepositoryTestCase.randomByteArrayOfLength(testBlobLen)), (long)testBlobLen, false);
        }));
        future.actionGet();
        this.assertChildren(repo.basePath(), Collections.singleton("foo"));
        this.assertBlobsByPrefix(repo.basePath(), "fo", Collections.emptyMap());
        this.assertChildren(repo.basePath().add("foo"), Arrays.asList("nested", "nested2"));
        this.assertBlobsByPrefix(repo.basePath().add("foo"), "nest", Collections.singletonMap("nested-blob", new PlainBlobMetadata("nested-blob", (long)testBlobLen)));
        this.assertChildren(repo.basePath().add("foo").add("nested"), Collections.emptyList());
        if (AbstractThirdPartyRepositoryTestCase.randomBoolean()) {
            this.deleteAndAssertEmpty(repo.basePath());
        } else {
            this.deleteAndAssertEmpty(repo.basePath().add("foo"));
        }
    }

    protected void assertBlobsByPrefix(BlobPath path, String prefix, Map<String, BlobMetadata> blobs) throws Exception {
        BlobStoreTestUtil.assertBlobsByPrefix(this.getRepository(), path, prefix, blobs);
    }

    public void testCleanup() throws Exception {
        this.createIndex("test-idx-1");
        this.createIndex("test-idx-2");
        this.createIndex("test-idx-3");
        this.ensureGreen(new String[0]);
        this.logger.info("--> indexing some data");
        for (int i = 0; i < 100; ++i) {
            this.client().prepareIndex("test-idx-1").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.client().prepareIndex("test-idx-2").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
            this.client().prepareIndex("test-idx-3").setId(Integer.toString(i)).setSource(new Object[]{"foo", "bar" + i}).get();
        }
        this.client().admin().indices().prepareRefresh(new String[0]).get();
        String snapshotName = "test-snap-" + System.currentTimeMillis();
        this.logger.info("--> snapshot");
        CreateSnapshotResponse createSnapshotResponse = (CreateSnapshotResponse)this.client().admin().cluster().prepareCreateSnapshot("test-repo", snapshotName).setWaitForCompletion(true).setIndices(new String[]{"test-idx-*", "-test-idx-3"}).get();
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)createSnapshotResponse.getSnapshotInfo().successfulShards(), (Matcher)Matchers.equalTo((Object)createSnapshotResponse.getSnapshotInfo().totalShards()));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)((SnapshotInfo)((GetSnapshotsResponse)this.client().admin().cluster().prepareGetSnapshots("test-repo").setSnapshots(new String[]{snapshotName}).get()).getSnapshots().get(0)).state(), (Matcher)Matchers.equalTo((Object)SnapshotState.SUCCESS));
        BlobStoreRepository repo = (BlobStoreRepository)this.getInstanceFromNode(RepositoriesService.class).repository("test-repo");
        ExecutorService genericExec = repo.threadPool().executor("generic");
        this.logger.info("--> creating a dangling index folder");
        this.createDanglingIndex(repo, genericExec);
        this.logger.info("--> deleting a snapshot to trigger repository cleanup");
        this.client().admin().cluster().deleteSnapshot(new DeleteSnapshotRequest("test-repo", new String[]{snapshotName})).actionGet();
        this.assertConsistentRepository(repo, genericExec);
        this.logger.info("--> Create dangling index");
        this.createDanglingIndex(repo, genericExec);
        this.logger.info("--> Execute repository cleanup");
        CleanupRepositoryResponse response = (CleanupRepositoryResponse)this.client().admin().cluster().prepareCleanupRepository("test-repo").get();
        this.assertCleanupResponse(response, 3L, 1L);
    }

    protected void assertCleanupResponse(CleanupRepositoryResponse response, long bytes, long blobs) {
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)response.result().blobs(), (Matcher)Matchers.equalTo((Object)3L));
        AbstractThirdPartyRepositoryTestCase.assertThat((Object)response.result().bytes(), (Matcher)Matchers.equalTo((Object)9L));
    }

    private void createDanglingIndex(BlobStoreRepository repo, Executor genericExec) throws Exception {
        PlainActionFuture future = PlainActionFuture.newFuture();
        genericExec.execute((Runnable)ActionRunnable.run((ActionListener)future, () -> {
            BlobStore blobStore = repo.blobStore();
            blobStore.blobContainer(repo.basePath().add("indices").add("foo")).writeBlob("bar", (InputStream)new ByteArrayInputStream(new byte[3]), 3L, false);
            for (String prefix : Arrays.asList("snap-", "meta-")) {
                blobStore.blobContainer(repo.basePath()).writeBlob(prefix + "foo.dat", (InputStream)new ByteArrayInputStream(new byte[3]), 3L, false);
            }
        }));
        future.actionGet();
        AbstractThirdPartyRepositoryTestCase.assertTrue((boolean)this.assertCorruptionVisible(repo, genericExec));
    }

    protected boolean assertCorruptionVisible(BlobStoreRepository repo, Executor executor) throws Exception {
        PlainActionFuture future = PlainActionFuture.newFuture();
        executor.execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> {
            BlobStore blobStore = repo.blobStore();
            return blobStore.blobContainer(repo.basePath().add("indices")).children().containsKey("foo") && blobStore.blobContainer(repo.basePath().add("indices").add("foo")).blobExists("bar") && blobStore.blobContainer(repo.basePath()).blobExists("meta-foo.dat") && blobStore.blobContainer(repo.basePath()).blobExists("snap-foo.dat");
        }));
        return (Boolean)future.actionGet();
    }

    protected void assertConsistentRepository(BlobStoreRepository repo, Executor executor) throws Exception {
        BlobStoreTestUtil.assertConsistency(repo, executor);
    }

    protected void assertDeleted(BlobPath path, String name) throws Exception {
        AbstractThirdPartyRepositoryTestCase.assertThat(this.listChildren(path), (Matcher)Matchers.not((Matcher)Matchers.contains((Object[])new String[]{name})));
    }

    protected void assertChildren(BlobPath path, Collection<String> children) throws Exception {
        this.listChildren(path);
        Set<String> foundChildren = this.listChildren(path);
        if (children.isEmpty()) {
            AbstractThirdPartyRepositoryTestCase.assertThat(foundChildren, (Matcher)Matchers.empty());
        } else {
            AbstractThirdPartyRepositoryTestCase.assertThat(foundChildren, (Matcher)Matchers.containsInAnyOrder((Object[])children.toArray(Strings.EMPTY_ARRAY)));
        }
    }

    private Set<String> listChildren(BlobPath path) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        BlobStoreRepository repository = this.getRepository();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> repository.blobStore().blobContainer(path).children().keySet()));
        return (Set)future.actionGet();
    }

    protected BlobStoreRepository getRepository() {
        return (BlobStoreRepository)this.getInstanceFromNode(RepositoriesService.class).repository("test-repo");
    }
}

