/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest.yaml.section;

import java.io.IOException;
import java.util.Map;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.test.rest.yaml.ClientYamlTestExecutionContext;
import org.opensearch.test.rest.yaml.section.ExecutableSection;

public abstract class Assertion
implements ExecutableSection {
    private final XContentLocation location;
    private final String field;
    private final Object expectedValue;

    protected Assertion(XContentLocation location, String field, Object expectedValue) {
        this.location = location;
        this.field = field;
        this.expectedValue = expectedValue;
    }

    public final String getField() {
        return this.field;
    }

    public final Object getExpectedValue() {
        return this.expectedValue;
    }

    protected final Object resolveExpectedValue(ClientYamlTestExecutionContext executionContext) throws IOException {
        if (this.expectedValue instanceof Map) {
            Map map = (Map)this.expectedValue;
            return executionContext.stash().replaceStashedValues(map);
        }
        if (executionContext.stash().containsStashedValue(this.expectedValue)) {
            return executionContext.stash().getValue(this.expectedValue.toString());
        }
        return this.expectedValue;
    }

    protected final Object getActualValue(ClientYamlTestExecutionContext executionContext) throws IOException {
        if (executionContext.stash().containsStashedValue(this.field)) {
            return executionContext.stash().getValue(this.field);
        }
        return executionContext.response(this.field);
    }

    @Override
    public XContentLocation getLocation() {
        return this.location;
    }

    @Override
    public final void execute(ClientYamlTestExecutionContext executionContext) throws IOException {
        this.doAssert(this.getActualValue(executionContext), this.resolveExpectedValue(executionContext));
    }

    protected abstract void doAssert(Object var1, Object var2);

    protected Class<?> safeClass(Object o) {
        return o == null ? null : o.getClass();
    }
}

