/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.rest;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.opensearch.LegacyESVersion;
import org.opensearch.Version;
import org.opensearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.opensearch.client.Request;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.Response;
import org.opensearch.client.ResponseException;
import org.opensearch.client.RestClient;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.WarningsHandler;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.SetOnce;
import org.opensearch.common.io.PathUtils;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.common.xcontent.support.XContentMapValues;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.seqno.ReplicationTracker;
import org.opensearch.snapshots.SnapshotState;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.rest.yaml.ObjectPath;

public abstract class OpenSearchRestTestCase
extends OpenSearchTestCase {
    public static final String TRUSTSTORE_PATH = "truststore.path";
    public static final String TRUSTSTORE_PASSWORD = "truststore.password";
    public static final String CLIENT_SOCKET_TIMEOUT = "client.socket.timeout";
    public static final String CLIENT_PATH_PREFIX = "client.path.prefix";
    private static Set<String> assertedWarnings = ConcurrentHashMap.newKeySet();
    private static List<HttpHost> clusterHosts;
    private static RestClient client;
    private static RestClient adminClient;
    private static TreeSet<Version> nodeVersions;
    static final Pattern CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES;
    static final Pattern PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES;

    public static Map<String, Object> entityAsMap(Response response) throws IOException {
        MediaType mediaType = MediaType.fromMediaType((String)response.getEntity().getContentType().getValue());
        try (XContentParser parser = mediaType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, response.getEntity().getContent());){
            Map map = parser.map();
            return map;
        }
    }

    public static List<Object> entityAsList(Response response) throws IOException {
        MediaType mediaType = MediaType.fromMediaType((String)response.getEntity().getContentType().getValue());
        try (XContentParser parser = mediaType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, response.getEntity().getContent());){
            List list = parser.list();
            return list;
        }
    }

    @Before
    public void initClient() throws IOException {
        if (client == null) {
            assert (adminClient == null);
            assert (clusterHosts == null);
            assert (nodeVersions == null);
            String cluster = this.getTestRestCluster();
            String[] stringUrls = cluster.split(",");
            ArrayList<HttpHost> hosts = new ArrayList<HttpHost>(stringUrls.length);
            for (String stringUrl : stringUrls) {
                int portSeparator = stringUrl.lastIndexOf(58);
                if (portSeparator < 0) {
                    throw new IllegalArgumentException("Illegal cluster url [" + stringUrl + "]");
                }
                String host = stringUrl.substring(0, portSeparator);
                int port = Integer.valueOf(stringUrl.substring(portSeparator + 1));
                hosts.add(this.buildHttpHost(host, port));
            }
            clusterHosts = Collections.unmodifiableList(hosts);
            this.logger.info("initializing REST clients against {}", clusterHosts);
            client = this.buildClient(this.restClientSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            adminClient = this.buildClient(this.restAdminSettings(), clusterHosts.toArray(new HttpHost[clusterHosts.size()]));
            nodeVersions = new TreeSet();
            Map<String, Object> response = OpenSearchRestTestCase.entityAsMap(adminClient.performRequest(new Request("GET", "_nodes/plugins")));
            Map nodes = (Map)response.get("nodes");
            for (Map.Entry node : nodes.entrySet()) {
                Map nodeInfo = (Map)node.getValue();
                nodeVersions.add(Version.fromString((String)nodeInfo.get("version").toString()));
            }
        }
        assert (client != null);
        assert (adminClient != null);
        assert (clusterHosts != null);
        assert (nodeVersions != null);
    }

    protected String getTestRestCluster() {
        String cluster = System.getProperty("tests.rest.cluster");
        if (cluster == null) {
            throw new RuntimeException("Must specify [tests.rest.cluster] system property with a comma delimited list of [host:port] to which to send REST requests");
        }
        return cluster;
    }

    public static RequestOptions expectVersionSpecificWarnings(Consumer<VersionSensitiveWarningsHandler> expectationsSetter) {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        VersionSensitiveWarningsHandler warningsHandler = new VersionSensitiveWarningsHandler(nodeVersions);
        expectationsSetter.accept(warningsHandler);
        builder.setWarningsHandler((WarningsHandler)warningsHandler);
        return builder.build();
    }

    public static RequestOptions expectWarnings(String ... warnings) {
        return OpenSearchRestTestCase.expectVersionSpecificWarnings(consumer -> consumer.current(warnings));
    }

    public static RequestOptions expectWarningsOnce(String deprecationWarning) {
        if (assertedWarnings.contains(deprecationWarning)) {
            return RequestOptions.DEFAULT;
        }
        assertedWarnings.add(deprecationWarning);
        return OpenSearchRestTestCase.expectWarnings(deprecationWarning);
    }

    @Deprecated
    public static RequestOptions allowTypesRemovalWarnings() {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        builder.setWarningsHandler(new WarningsHandler(){

            public boolean warningsShouldFailRequest(List<String> warnings) {
                for (String warning : warnings) {
                    if (warning.startsWith("[types removal]")) continue;
                    return true;
                }
                return false;
            }
        });
        return builder.build();
    }

    protected HttpHost buildHttpHost(String host, int port) {
        return new HttpHost(host, port, this.getProtocol());
    }

    @After
    public final void cleanUpCluster() throws Exception {
        if (!this.preserveClusterUponCompletion()) {
            OpenSearchRestTestCase.ensureNoInitializingShards();
            this.wipeCluster();
            this.waitForClusterStateUpdatesToFinish();
            this.logIfThereAreRunningTasks();
        }
    }

    @AfterClass
    public static void closeClients() throws IOException {
        try {
            IOUtils.close((Closeable[])new Closeable[]{client, adminClient});
        }
        finally {
            clusterHosts = null;
            client = null;
            adminClient = null;
            nodeVersions = null;
        }
    }

    protected static RestClient client() {
        return client;
    }

    protected static RestClient adminClient() {
        return adminClient;
    }

    public static void waitForPendingTasks(RestClient adminClient) throws Exception {
        OpenSearchRestTestCase.waitForPendingTasks(adminClient, taskName -> false);
    }

    public static void waitForPendingTasks(RestClient adminClient, Predicate<String> taskFilter) throws Exception {
        OpenSearchRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            block8: {
                try {
                    Request request = new Request("GET", "/_cat/tasks");
                    request.addParameter("detailed", "true");
                    Response response = adminClient.performRequest(request);
                    if (response.getStatusLine().getStatusCode() != 200) break block8;
                    try (BufferedReader responseReader = new BufferedReader(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));){
                        String line;
                        int activeTasks = 0;
                        StringBuilder tasksListString = new StringBuilder();
                        while ((line = responseReader.readLine()) != null) {
                            String taskName = line.split("\\s+")[0];
                            if (taskName.startsWith("cluster:monitor/tasks/lists") || taskFilter.test(taskName)) continue;
                            ++activeTasks;
                            tasksListString.append(line);
                            tasksListString.append('\n');
                        }
                        OpenSearchRestTestCase.assertEquals((String)(activeTasks + " active tasks found:\n" + String.valueOf(tasksListString)), (long)0L, (long)activeTasks);
                    }
                }
                catch (IOException e) {
                    throw new AssertionError("error getting active tasks list", e);
                }
            }
        }), 30L, TimeUnit.SECONDS);
    }

    protected boolean preserveClusterUponCompletion() {
        return false;
    }

    protected boolean preserveIndicesUponCompletion() {
        return false;
    }

    protected boolean preserveTemplatesUponCompletion() {
        return false;
    }

    protected boolean preserveDataStreamsUponCompletion() {
        return false;
    }

    protected boolean preserveClusterSettings() {
        return false;
    }

    protected boolean preserveReposUponCompletion() {
        return false;
    }

    protected boolean preserveSnapshotsUponCompletion() {
        return false;
    }

    protected boolean preserveSLMPoliciesUponCompletion() {
        return false;
    }

    protected boolean waitForAllSnapshotsWiped() {
        return false;
    }

    private void wipeCluster() throws Exception {
        if (nodeVersions.first().onOrAfter((Version)LegacyESVersion.V_7_4_0) && nodeVersions.first().before(Version.V_1_0_0) && !this.preserveSLMPoliciesUponCompletion()) {
            OpenSearchRestTestCase.deleteAllSLMPolicies();
        }
        SetOnce inProgressSnapshots = new SetOnce();
        if (this.waitForAllSnapshotsWiped()) {
            AtomicReference snapshots = new AtomicReference();
            try {
                OpenSearchRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                    snapshots.set(this.wipeSnapshots());
                    OpenSearchRestTestCase.assertThat((Object)((Map)snapshots.get()), (Matcher)Matchers.anEmptyMap());
                }), 2L, TimeUnit.MINUTES);
                inProgressSnapshots.set((Object)((Map)snapshots.get()));
            }
            catch (AssertionError e) {
                inProgressSnapshots.set((Object)((Map)snapshots.get()));
            }
        } else {
            inProgressSnapshots.set(this.wipeSnapshots());
        }
        if (!this.preserveDataStreamsUponCompletion()) {
            OpenSearchRestTestCase.wipeDataStreams();
        }
        if (!this.preserveIndicesUponCompletion()) {
            OpenSearchRestTestCase.wipeAllIndices();
        }
        if (!this.preserveTemplatesUponCompletion()) {
            this.logger.debug("Clearing all templates");
            OpenSearchRestTestCase.adminClient().performRequest(new Request("DELETE", "_template/*"));
            try {
                OpenSearchRestTestCase.adminClient().performRequest(new Request("DELETE", "_index_template/*"));
                OpenSearchRestTestCase.adminClient().performRequest(new Request("DELETE", "_component_template/*"));
            }
            catch (ResponseException responseException) {
                // empty catch block
            }
        }
        if (!this.preserveClusterSettings()) {
            this.wipeClusterSettings();
        }
        OpenSearchRestTestCase.assertThat((String)("Found in progress snapshots [" + String.valueOf(inProgressSnapshots.get()) + "]."), (Object)((Map)inProgressSnapshots.get()), (Matcher)Matchers.anEmptyMap());
    }

    protected static void wipeAllIndices() throws IOException {
        block8: {
            boolean includeHidden = OpenSearchRestTestCase.minimumNodeVersion().onOrAfter((Version)LegacyESVersion.V_7_7_0);
            try {
                Request deleteRequest = new Request("DELETE", "*");
                deleteRequest.addParameter("expand_wildcards", "open,closed" + (includeHidden ? ",hidden" : ""));
                RequestOptions.Builder allowSystemIndexAccessWarningOptions = RequestOptions.DEFAULT.toBuilder();
                allowSystemIndexAccessWarningOptions.setWarningsHandler(warnings -> {
                    if (warnings.size() == 0) {
                        return false;
                    }
                    if (warnings.size() > 1) {
                        return true;
                    }
                    String warning = (String)warnings.get(0);
                    boolean isSystemIndexWarning = warning.contains("this request accesses system indices") && warning.contains("but in a future major version, direct access to system indices will be prevented by default");
                    return !isSystemIndexWarning;
                });
                deleteRequest.setOptions(allowSystemIndexAccessWarningOptions);
                Response response = OpenSearchRestTestCase.adminClient().performRequest(deleteRequest);
                try (InputStream is = response.getEntity().getContent();){
                    OpenSearchRestTestCase.assertTrue((boolean)((Boolean)XContentHelper.convertToMap((XContent)MediaTypeRegistry.JSON.xContent(), (InputStream)is, (boolean)true).get("acknowledged")));
                }
            }
            catch (ResponseException e) {
                if (e.getResponse().getStatusLine().getStatusCode() == 404) break block8;
                throw e;
            }
        }
    }

    protected static void wipeDataStreams() throws IOException {
        block2: {
            try {
                OpenSearchRestTestCase.adminClient().performRequest(new Request("DELETE", "_data_stream/*"));
            }
            catch (ResponseException e) {
                int statusCode = e.getResponse().getStatusLine().getStatusCode();
                if (Set.of(Integer.valueOf(404), Integer.valueOf(405), Integer.valueOf(500)).contains(statusCode)) break block2;
                throw e;
            }
        }
    }

    protected Map<String, List<Map<?, ?>>> wipeSnapshots() throws IOException {
        HashMap inProgressSnapshots = new HashMap();
        for (Map.Entry<String, Object> repo : OpenSearchRestTestCase.entityAsMap(adminClient.performRequest(new Request("GET", "/_snapshot/_all"))).entrySet()) {
            String repoName = repo.getKey();
            Map repoSpec = (Map)repo.getValue();
            String repoType = (String)repoSpec.get("type");
            if (!this.preserveSnapshotsUponCompletion() && repoType.equals("fs")) {
                Request listRequest = new Request("GET", "/_snapshot/" + repoName + "/_all");
                listRequest.addParameter("ignore_unavailable", "true");
                List snapshots = (List)OpenSearchRestTestCase.entityAsMap(adminClient.performRequest(listRequest)).get("snapshots");
                for (Object snapshot : snapshots) {
                    Map snapshotInfo = (Map)snapshot;
                    String name = (String)snapshotInfo.get("snapshot");
                    if (name.startsWith("force_preserve")) continue;
                    if (!SnapshotState.valueOf((String)((String)snapshotInfo.get("state"))).completed()) {
                        inProgressSnapshots.computeIfAbsent(repoName, key -> new ArrayList()).add(snapshotInfo);
                    }
                    this.logger.debug("wiping snapshot [{}/{}]", (Object)repoName, (Object)name);
                    OpenSearchRestTestCase.adminClient().performRequest(new Request("DELETE", "/_snapshot/" + repoName + "/" + name));
                }
            }
            if (this.preserveReposUponCompletion()) continue;
            this.deleteRepository(repoName);
        }
        return inProgressSnapshots;
    }

    protected void deleteRepository(String repoName) throws IOException {
        this.logger.debug("wiping snapshot repository [{}]", (Object)repoName);
        OpenSearchRestTestCase.adminClient().performRequest(new Request("DELETE", "_snapshot/" + repoName));
    }

    private void wipeClusterSettings() throws IOException {
        Map<String, Object> getResponse = OpenSearchRestTestCase.entityAsMap(OpenSearchRestTestCase.adminClient().performRequest(new Request("GET", "/_cluster/settings")));
        boolean mustClear = false;
        XContentBuilder clearCommand = JsonXContent.contentBuilder();
        clearCommand.startObject();
        for (Map.Entry<String, Object> entry : getResponse.entrySet()) {
            String type = entry.getKey().toString();
            Map settings = (Map)entry.getValue();
            if (settings.isEmpty()) continue;
            mustClear = true;
            clearCommand.startObject(type);
            for (Object key : settings.keySet()) {
                clearCommand.field(String.valueOf(key) + ".*").nullValue();
            }
            clearCommand.endObject();
        }
        clearCommand.endObject();
        if (mustClear) {
            Request request = new Request("PUT", "/_cluster/settings");
            request.setJsonEntity(clearCommand.toString());
            OpenSearchRestTestCase.adminClient().performRequest(request);
        }
    }

    protected void refreshAllIndices() throws IOException {
        boolean includeHidden = OpenSearchRestTestCase.minimumNodeVersion().onOrAfter((Version)LegacyESVersion.V_7_7_0);
        Request refreshRequest = new Request("POST", "/_refresh");
        refreshRequest.addParameter("expand_wildcards", "open" + (includeHidden ? ",hidden" : ""));
        RequestOptions.Builder requestOptions = RequestOptions.DEFAULT.toBuilder();
        requestOptions.setWarningsHandler(warnings -> {
            if (warnings.isEmpty()) {
                return false;
            }
            if (warnings.size() > 1) {
                return true;
            }
            return !((String)warnings.get(0)).startsWith("this request accesses system indices:");
        });
        refreshRequest.setOptions(requestOptions);
        OpenSearchRestTestCase.client().performRequest(refreshRequest);
    }

    private static void deleteAllSLMPolicies() throws IOException {
        Map<String, Object> policies;
        try {
            Response response = OpenSearchRestTestCase.adminClient().performRequest(new Request("GET", "/_slm/policy"));
            policies = OpenSearchRestTestCase.entityAsMap(response);
        }
        catch (ResponseException e) {
            if (RestStatus.METHOD_NOT_ALLOWED.getStatus() == e.getResponse().getStatusLine().getStatusCode() || RestStatus.BAD_REQUEST.getStatus() == e.getResponse().getStatusLine().getStatusCode()) {
                return;
            }
            throw e;
        }
        if (policies == null || policies.isEmpty()) {
            return;
        }
        for (String policyName : policies.keySet()) {
            OpenSearchRestTestCase.adminClient().performRequest(new Request("DELETE", "/_slm/policy/" + policyName));
        }
    }

    private void logIfThereAreRunningTasks() throws IOException {
        Set<String> runningTasks = this.runningTasks(OpenSearchRestTestCase.adminClient().performRequest(new Request("GET", "/_tasks")));
        runningTasks.remove("cluster:monitor/tasks/lists");
        runningTasks.remove("cluster:monitor/tasks/lists[n]");
        if (runningTasks.isEmpty()) {
            return;
        }
        ArrayList<String> stillRunning = new ArrayList<String>(runningTasks);
        Collections.sort(stillRunning);
        this.logger.info("There are still tasks running after this test that might break subsequent tests {}.", stillRunning);
    }

    private void waitForClusterStateUpdatesToFinish() throws Exception {
        OpenSearchRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            try {
                Response response = OpenSearchRestTestCase.adminClient().performRequest(new Request("GET", "/_cluster/pending_tasks"));
                List tasks = (List)OpenSearchRestTestCase.entityAsMap(response).get("tasks");
                if (!tasks.isEmpty()) {
                    StringBuilder message = new StringBuilder("there are still running tasks:");
                    for (Object task : tasks) {
                        message.append('\n').append(task.toString());
                    }
                    OpenSearchRestTestCase.fail((String)message.toString());
                }
            }
            catch (IOException e) {
                OpenSearchRestTestCase.fail((String)("cannot get cluster's pending tasks: " + e.getMessage()));
            }
        }), 30L, TimeUnit.SECONDS);
    }

    protected Settings restClientSettings() {
        Settings.Builder builder = Settings.builder();
        if (System.getProperty("tests.rest.client_path_prefix") != null) {
            builder.put(CLIENT_PATH_PREFIX, System.getProperty("tests.rest.client_path_prefix"));
        }
        return builder.build();
    }

    protected Settings restAdminSettings() {
        return this.restClientSettings();
    }

    protected final List<HttpHost> getClusterHosts() {
        return clusterHosts;
    }

    protected String getProtocol() {
        return "http";
    }

    protected RestClient buildClient(Settings settings, HttpHost[] hosts) throws IOException {
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        OpenSearchRestTestCase.configureClient(builder, settings);
        builder.setStrictDeprecationMode(true);
        return builder.build();
    }

    protected static void configureClient(RestClientBuilder builder, Settings settings) throws IOException {
        String keystorePath = settings.get(TRUSTSTORE_PATH);
        if (keystorePath != null) {
            String keystorePass = settings.get(TRUSTSTORE_PASSWORD);
            if (keystorePass == null) {
                throw new IllegalStateException("truststore.path is provided but not truststore.password");
            }
            Path path = PathUtils.get((String)keystorePath, (String[])new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                throw new IllegalStateException("truststore.path is set but points to a non-existing file");
            }
            try {
                String keyStoreType = keystorePath.endsWith(".p12") ? "PKCS12" : "jks";
                KeyStore keyStore = KeyStore.getInstance(keyStoreType);
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    keyStore.load(is, keystorePass.toCharArray());
                }
                SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(keyStore, null).build();
                SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslcontext);
                builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy));
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                throw new RuntimeException("Error setting up ssl", e);
            }
        }
        Map headers = ThreadContext.buildDefaultHeaders((Settings)settings);
        Header[] defaultHeaders = new Header[headers.size()];
        int i = 0;
        for (Map.Entry entry : headers.entrySet()) {
            defaultHeaders[i++] = new BasicHeader((String)entry.getKey(), (String)entry.getValue());
        }
        builder.setDefaultHeaders(defaultHeaders);
        String socketTimeoutString = settings.get(CLIENT_SOCKET_TIMEOUT);
        TimeValue socketTimeout = TimeValue.parseTimeValue((String)(socketTimeoutString == null ? "60s" : socketTimeoutString), (String)CLIENT_SOCKET_TIMEOUT);
        builder.setRequestConfigCallback(conf -> conf.setSocketTimeout(Math.toIntExact(socketTimeout.getMillis())));
        if (settings.hasValue(CLIENT_PATH_PREFIX)) {
            builder.setPathPrefix(settings.get(CLIENT_PATH_PREFIX));
        }
    }

    private Set<String> runningTasks(Response response) throws IOException {
        HashSet<String> runningTasks = new HashSet<String>();
        Map nodes = (Map)OpenSearchRestTestCase.entityAsMap(response).get("nodes");
        for (Map.Entry node : nodes.entrySet()) {
            Map nodeInfo = (Map)node.getValue();
            Map nodeTasks = (Map)nodeInfo.get("tasks");
            for (Map.Entry taskAndName : nodeTasks.entrySet()) {
                Map task = (Map)taskAndName.getValue();
                runningTasks.add(task.get("action").toString());
            }
        }
        return runningTasks;
    }

    protected static void assertOK(Response response) {
        OpenSearchRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.anyOf((Matcher)Matchers.equalTo((Object)200), (Matcher)Matchers.equalTo((Object)201)));
    }

    public static void ensureGreen(String index) throws IOException {
        OpenSearchRestTestCase.ensureHealth(index, request -> {
            request.addParameter("wait_for_status", "green");
            request.addParameter("wait_for_no_relocating_shards", "true");
            request.addParameter("timeout", "70s");
            request.addParameter("level", "shards");
        });
    }

    protected static void ensureHealth(Consumer<Request> requestConsumer) throws IOException {
        OpenSearchRestTestCase.ensureHealth("", requestConsumer);
    }

    protected static void ensureHealth(String index, Consumer<Request> requestConsumer) throws IOException {
        OpenSearchRestTestCase.ensureHealth(OpenSearchRestTestCase.client(), index, requestConsumer);
    }

    protected static void ensureHealth(RestClient client, String index, Consumer<Request> requestConsumer) throws IOException {
        Request request = new Request("GET", "/_cluster/health" + (String)(index.trim().isEmpty() ? "" : "/" + index));
        requestConsumer.accept(request);
        try {
            client.performRequest(request);
        }
        catch (ResponseException e) {
            if (e.getResponse().getStatusLine().getStatusCode() == 408) {
                try {
                    Response clusterStateResponse = client.performRequest(new Request("GET", "/_cluster/state?pretty"));
                    OpenSearchRestTestCase.fail((String)("timed out waiting for green state for index [" + index + "] cluster state [" + EntityUtils.toString((HttpEntity)clusterStateResponse.getEntity()) + "]"));
                }
                catch (Exception inner) {
                    e.addSuppressed((Throwable)inner);
                }
            }
            throw e;
        }
    }

    protected static void ensureNoInitializingShards() throws IOException {
        Request request = new Request("GET", "/_cluster/health");
        request.addParameter("wait_for_no_initializing_shards", "true");
        request.addParameter("timeout", "70s");
        request.addParameter("level", "shards");
        OpenSearchRestTestCase.adminClient().performRequest(request);
    }

    protected static void createIndex(String name, Settings settings) throws IOException {
        OpenSearchRestTestCase.createIndex(name, settings, null);
    }

    protected static void createIndex(String name, Settings settings, String mapping) throws IOException {
        OpenSearchRestTestCase.createIndex(name, settings, mapping, null);
    }

    protected static void createIndex(String name, Settings settings, String mapping, String aliases) throws IOException {
        Request request = new Request("PUT", "/" + name);
        String entity = "{\"settings\": " + Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)settings);
        if (mapping != null) {
            entity = entity + ",\"mappings\" : {" + mapping + "}";
        }
        if (aliases != null) {
            entity = entity + ",\"aliases\": {" + aliases + "}";
        }
        entity = entity + "}";
        if (!settings.getAsBoolean(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), Boolean.valueOf(true)).booleanValue()) {
            OpenSearchRestTestCase.expectSoftDeletesWarning(request, name);
        }
        request.setJsonEntity(entity);
        OpenSearchRestTestCase.client().performRequest(request);
    }

    protected static void deleteIndex(String name) throws IOException {
        Request request = new Request("DELETE", "/" + name);
        OpenSearchRestTestCase.client().performRequest(request);
    }

    protected static void updateIndexSettings(String index, Settings.Builder settings) throws IOException {
        OpenSearchRestTestCase.updateIndexSettings(index, settings.build());
    }

    private static void updateIndexSettings(String index, Settings settings) throws IOException {
        Request request = new Request("PUT", "/" + index + "/_settings");
        request.setJsonEntity(Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)settings));
        OpenSearchRestTestCase.client().performRequest(request);
    }

    protected static void expectSoftDeletesWarning(Request request, String indexName) {
        List<CallSite> esExpectedWarnings = Collections.singletonList("Creating indices with soft-deletes disabled is deprecated and will be removed in future Elasticsearch versions. Please do not specify value for setting [index.soft_deletes.enabled] of index [" + indexName + "].");
        List<CallSite> opensearchExpectedWarnings = Collections.singletonList("Creating indices with soft-deletes disabled is deprecated and will be removed in future OpenSearch versions. Please do not specify value for setting [index.soft_deletes.enabled] of index [" + indexName + "].");
        RequestOptions.Builder requestOptions = RequestOptions.DEFAULT.toBuilder();
        if (nodeVersions.stream().allMatch(version -> version.onOrAfter((Version)LegacyESVersion.V_7_6_0) && version.before(Version.V_1_0_0))) {
            requestOptions.setWarningsHandler(warnings -> !warnings.equals(esExpectedWarnings));
            request.setOptions(requestOptions);
        } else if (nodeVersions.stream().anyMatch(version -> version.onOrAfter((Version)LegacyESVersion.V_7_6_0) && version.before(Version.V_1_0_0))) {
            requestOptions.setWarningsHandler(warnings -> !warnings.isEmpty() && !warnings.equals(esExpectedWarnings));
            request.setOptions(requestOptions);
        }
        if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_1_0_0))) {
            requestOptions.setWarningsHandler(warnings -> !warnings.equals(opensearchExpectedWarnings));
            request.setOptions(requestOptions);
        } else if (nodeVersions.stream().anyMatch(version -> version.onOrAfter(Version.V_1_0_0))) {
            requestOptions.setWarningsHandler(warnings -> !warnings.isEmpty() && !warnings.equals(opensearchExpectedWarnings));
            request.setOptions(requestOptions);
        }
    }

    protected static Map<String, Object> getIndexSettings(String index) throws IOException {
        Request request = new Request("GET", "/" + index + "/_settings");
        request.addParameter("flat_settings", "true");
        Response response = OpenSearchRestTestCase.client().performRequest(request);
        try (InputStream is = response.getEntity().getContent();){
            Map map = XContentHelper.convertToMap((XContent)MediaTypeRegistry.JSON.xContent(), (InputStream)is, (boolean)true);
            return map;
        }
    }

    protected Map<String, Object> getIndexSettingsAsMap(String index) throws IOException {
        Map<String, Object> indexSettings = OpenSearchRestTestCase.getIndexSettings(index);
        return (Map)((Map)indexSettings.get(index)).get("settings");
    }

    protected static boolean indexExists(String index) throws IOException {
        Response response = OpenSearchRestTestCase.client().performRequest(new Request("HEAD", "/" + index));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static void closeIndex(String index) throws IOException {
        Response response = OpenSearchRestTestCase.client().performRequest(new Request("POST", "/" + index + "/_close"));
        OpenSearchRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static void openIndex(String index) throws IOException {
        Response response = OpenSearchRestTestCase.client().performRequest(new Request("POST", "/" + index + "/_open"));
        OpenSearchRestTestCase.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static boolean aliasExists(String alias) throws IOException {
        Response response = OpenSearchRestTestCase.client().performRequest(new Request("HEAD", "/_alias/" + alias));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static boolean aliasExists(String index, String alias) throws IOException {
        Response response = OpenSearchRestTestCase.client().performRequest(new Request("HEAD", "/" + index + "/_alias/" + alias));
        return RestStatus.OK.getStatus() == response.getStatusLine().getStatusCode();
    }

    protected static Map<String, Object> getAlias(String index, String alias) throws IOException {
        Object endpoint = "/_alias";
        if (!Strings.isEmpty((CharSequence)index)) {
            endpoint = index + (String)endpoint;
        }
        if (!Strings.isEmpty((CharSequence)alias)) {
            endpoint = (String)endpoint + "/" + alias;
        }
        Map<String, Object> getAliasResponse = OpenSearchRestTestCase.getAsMap((String)endpoint);
        return (Map)XContentMapValues.extractValue((String)(index + ".aliases." + alias), getAliasResponse);
    }

    protected static Map<String, Object> getAsMap(String endpoint) throws IOException {
        Response response = OpenSearchRestTestCase.client().performRequest(new Request("GET", endpoint));
        return OpenSearchRestTestCase.responseAsMap(response);
    }

    protected static Map<String, Object> responseAsMap(Response response) throws IOException {
        MediaType entityContentType = MediaType.fromMediaType((String)response.getEntity().getContentType().getValue());
        Map responseEntity = XContentHelper.convertToMap((XContent)entityContentType.xContent(), (InputStream)response.getEntity().getContent(), (boolean)false);
        OpenSearchRestTestCase.assertNotNull((Object)responseEntity);
        return responseEntity;
    }

    protected static void registerRepository(String repository, String type, boolean verify, Settings settings) throws IOException {
        Request request = new Request("PUT", "_snapshot/" + repository);
        request.addParameter("verify", Boolean.toString(verify));
        request.setJsonEntity(Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)new PutRepositoryRequest(repository).type(type).settings(settings)));
        Response response = OpenSearchRestTestCase.client().performRequest(request);
        OpenSearchRestTestCase.assertAcked("Failed to create repository [" + repository + "] of type [" + type + "]: " + String.valueOf(response), response);
    }

    protected static void createSnapshot(String repository, String snapshot, boolean waitForCompletion) throws IOException {
        Request request = new Request("PUT", "_snapshot/" + repository + "/" + snapshot);
        request.addParameter("wait_for_completion", Boolean.toString(waitForCompletion));
        Response response = OpenSearchRestTestCase.client().performRequest(request);
        OpenSearchRestTestCase.assertThat((String)("Failed to create snapshot [" + snapshot + "] in repository [" + repository + "]: " + String.valueOf(response)), (Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    protected static void restoreSnapshot(String repository, String snapshot, boolean waitForCompletion) throws IOException {
        Request request = new Request("POST", "_snapshot/" + repository + "/" + snapshot + "/_restore");
        request.addParameter("wait_for_completion", Boolean.toString(waitForCompletion));
        Response response = OpenSearchRestTestCase.client().performRequest(request);
        OpenSearchRestTestCase.assertThat((String)("Failed to restore snapshot [" + snapshot + "] from repository [" + repository + "]: " + String.valueOf(response)), (Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
    }

    private static void assertAcked(String message, Response response) throws IOException {
        int responseStatusCode = response.getStatusLine().getStatusCode();
        OpenSearchRestTestCase.assertThat((String)(message + ": expecting response code [200] but got [" + responseStatusCode + "]"), (Object)responseStatusCode, (Matcher)Matchers.equalTo((Object)RestStatus.OK.getStatus()));
        Map<String, Object> responseAsMap = OpenSearchRestTestCase.responseAsMap(response);
        Boolean acknowledged = (Boolean)XContentMapValues.extractValue(responseAsMap, (String[])new String[]{"acknowledged"});
        OpenSearchRestTestCase.assertThat((String)(message + ": response is not acknowledged"), (Object)acknowledged, (Matcher)Matchers.equalTo((Object)Boolean.TRUE));
    }

    public void flush(String index, boolean force) throws IOException {
        this.logger.info("flushing index {} force={}", (Object)index, (Object)force);
        Request flushRequest = new Request("POST", "/" + index + "/_flush");
        flushRequest.addParameter("force", Boolean.toString(force));
        flushRequest.addParameter("wait_if_ongoing", "true");
        OpenSearchRestTestCase.assertOK(OpenSearchRestTestCase.client().performRequest(flushRequest));
    }

    public void assertNoFileBasedRecovery(String indexName, Predicate<String> targetNode) throws IOException {
        Map<String, Object> recoveries = OpenSearchRestTestCase.entityAsMap(OpenSearchRestTestCase.client().performRequest(new Request("GET", indexName + "/_recovery?detailed=true")));
        List shards = (List)XContentMapValues.extractValue((String)(indexName + ".shards"), recoveries);
        OpenSearchRestTestCase.assertNotNull((Object)shards);
        boolean foundReplica = false;
        this.logger.info("index {} recovery stats {}", (Object)indexName, (Object)shards);
        for (Map shard : shards) {
            if (shard.get("primary") != Boolean.FALSE || !targetNode.test((String)XContentMapValues.extractValue((String)"target.name", (Map)shard))) continue;
            List details = (List)XContentMapValues.extractValue((String)"index.files.details", (Map)shard);
            if (details == null) {
                long totalFiles = ((Number)XContentMapValues.extractValue((String)"index.files.total", (Map)shard)).longValue();
                long reusedFiles = ((Number)XContentMapValues.extractValue((String)"index.files.reused", (Map)shard)).longValue();
                this.logger.info("total [{}] reused [{}]", (Object)totalFiles, (Object)reusedFiles);
                OpenSearchRestTestCase.assertThat((String)("must reuse all files, recoveries [" + String.valueOf(recoveries) + "]"), (Object)totalFiles, (Matcher)Matchers.equalTo((Object)reusedFiles));
            } else {
                OpenSearchRestTestCase.assertNotNull((Object)details);
                OpenSearchRestTestCase.assertThat((Object)details, (Matcher)Matchers.empty());
            }
            foundReplica = true;
        }
        OpenSearchRestTestCase.assertTrue((String)"must find replica", (boolean)foundReplica);
    }

    public void assertEmptyTranslog(String index) throws Exception {
        Map<String, Object> stats = OpenSearchRestTestCase.entityAsMap(OpenSearchRestTestCase.client().performRequest(new Request("GET", index + "/_stats?level=shards")));
        OpenSearchRestTestCase.assertThat((Object)XContentMapValues.extractValue((String)("indices." + index + ".total.translog.uncommitted_operations"), stats), (Matcher)Matchers.equalTo((Object)0));
        OpenSearchRestTestCase.assertThat((Object)XContentMapValues.extractValue((String)("indices." + index + ".total.translog.operations"), stats), (Matcher)Matchers.equalTo((Object)0));
    }

    public void ensurePeerRecoveryRetentionLeasesRenewedAndSynced(String index) throws Exception {
        boolean alwaysExists = OpenSearchRestTestCase.minimumNodeVersion().onOrAfter((Version)LegacyESVersion.V_7_6_0);
        OpenSearchRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            Map<String, Object> stats = OpenSearchRestTestCase.entityAsMap(OpenSearchRestTestCase.client().performRequest(new Request("GET", index + "/_stats?level=shards")));
            Map shards = (Map)XContentMapValues.extractValue((String)("indices." + index + ".shards"), stats);
            for (List shard : shards.values()) {
                for (Map copy : shard) {
                    Integer globalCheckpoint = (Integer)XContentMapValues.extractValue((String)"seq_no.global_checkpoint", (Map)copy);
                    OpenSearchRestTestCase.assertNotNull((Object)globalCheckpoint);
                    OpenSearchRestTestCase.assertThat((Object)XContentMapValues.extractValue((String)"seq_no.max_seq_no", (Map)copy), (Matcher)Matchers.equalTo((Object)globalCheckpoint));
                    List retentionLeases = (List)XContentMapValues.extractValue((String)"retention_leases.leases", (Map)copy);
                    if (!alwaysExists && retentionLeases == null) continue;
                    OpenSearchRestTestCase.assertNotNull((Object)retentionLeases);
                    for (Map retentionLease : retentionLeases) {
                        if (!((String)retentionLease.get("id")).startsWith("peer_recovery/")) continue;
                        OpenSearchRestTestCase.assertThat(retentionLease.get("retaining_seq_no"), (Matcher)Matchers.equalTo((Object)(globalCheckpoint + 1)));
                    }
                    if (!alwaysExists) continue;
                    List existingLeaseIds = retentionLeases.stream().map(lease -> (String)lease.get("id")).collect(Collectors.toList());
                    List expectedLeaseIds = shard.stream().map(shr -> (String)XContentMapValues.extractValue((String)"routing.node", (Map)shr)).map(ReplicationTracker::getPeerRecoveryRetentionLeaseId).collect(Collectors.toList());
                    OpenSearchRestTestCase.assertThat((String)"not every active copy has established its PPRL", expectedLeaseIds, (Matcher)Matchers.everyItem((Matcher)Matchers.in(existingLeaseIds)));
                }
            }
        }), 60L, TimeUnit.SECONDS);
    }

    protected static Version minimumNodeVersion() throws IOException {
        Request request = new Request("GET", "_nodes");
        request.addParameter("filter_path", "nodes.*.version");
        Response response = OpenSearchRestTestCase.adminClient().performRequest(request);
        Map nodes = (Map)ObjectPath.createFromResponse(response).evaluate("nodes");
        Version minVersion = null;
        for (Map.Entry node : nodes.entrySet()) {
            Version nodeVersion = Version.fromString((String)((String)((Map)node.getValue()).get("version")));
            if (minVersion != null && !minVersion.after(nodeVersion)) continue;
            minVersion = nodeVersion;
        }
        OpenSearchRestTestCase.assertNotNull(minVersion);
        return minVersion;
    }

    protected void syncedFlush(String indexName, boolean retryOnConflict) throws Exception {
        Request request = new Request("POST", indexName + "/_flush/synced");
        RequestOptions.Builder options = RequestOptions.DEFAULT.toBuilder();
        List<String> warningMessage = Arrays.asList("Synced flush is deprecated and will be removed in 3.0. Use flush at _/flush or /{index}/_flush instead.");
        List<String> expectedWarnings = Arrays.asList("Synced flush was removed and a normal flush was performed instead. This transition will be removed in a future version.");
        if (nodeVersions.stream().allMatch(version -> version.onOrAfter(Version.V_2_0_0))) {
            options.setWarningsHandler(warnings -> !warnings.isEmpty() && !warnings.equals(expectedWarnings));
        } else if (nodeVersions.stream().anyMatch(version -> version.onOrAfter((Version)LegacyESVersion.V_7_6_0))) {
            options.setWarningsHandler(warnings -> !warnings.isEmpty() && !warnings.equals(expectedWarnings) && !warnings.equals(warningMessage));
        }
        request.setOptions(options);
        OpenSearchRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            block3: {
                try {
                    Response resp = OpenSearchRestTestCase.client().performRequest(request);
                    if (retryOnConflict) {
                        Map result = (Map)ObjectPath.createFromResponse(resp).evaluate("_shards");
                        OpenSearchRestTestCase.assertThat(result.get("failed"), (Matcher)Matchers.equalTo((Object)0));
                    }
                }
                catch (ResponseException ex) {
                    OpenSearchRestTestCase.assertThat((Object)ex.getResponse().getStatusLine(), (Matcher)Matchers.equalTo((Object)409));
                    if (!retryOnConflict) break block3;
                    throw new AssertionError((Object)ex);
                }
            }
        }));
        this.ensureGlobalCheckpointSynced(indexName);
    }

    private void ensureGlobalCheckpointSynced(String index) throws Exception {
        OpenSearchRestTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            Map<String, Object> stats = OpenSearchRestTestCase.entityAsMap(OpenSearchRestTestCase.client().performRequest(new Request("GET", index + "/_stats?level=shards")));
            List shardStats = (List)XContentMapValues.extractValue((String)("indices." + index + ".shards.0"), stats);
            shardStats.stream().map(shard -> (Map)XContentMapValues.extractValue((String)"seq_no", (Map)shard)).filter(Objects::nonNull).forEach(seqNoStat -> {
                long globalCheckpoint = ((Number)XContentMapValues.extractValue((String)"global_checkpoint", (Map)seqNoStat)).longValue();
                long localCheckpoint = ((Number)XContentMapValues.extractValue((String)"local_checkpoint", (Map)seqNoStat)).longValue();
                long maxSeqNo = ((Number)XContentMapValues.extractValue((String)"max_seq_no", (Map)seqNoStat)).longValue();
                OpenSearchRestTestCase.assertThat((String)shardStats.toString(), (Object)localCheckpoint, (Matcher)Matchers.equalTo((Object)maxSeqNo));
                OpenSearchRestTestCase.assertThat((String)shardStats.toString(), (Object)globalCheckpoint, (Matcher)Matchers.equalTo((Object)maxSeqNo));
            });
        }), 60L, TimeUnit.SECONDS);
    }

    protected static void useIgnoreMultipleMatchingTemplatesWarningsHandler(Request request) throws IOException {
        RequestOptions.Builder options = request.getOptions().toBuilder();
        options.setWarningsHandler(warnings -> {
            if (warnings.size() > 0) {
                boolean matches = warnings.stream().anyMatch(message -> CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES.matcher((CharSequence)message).matches() || PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES.matcher((CharSequence)message).matches());
                return !matches;
            }
            return false;
        });
        request.setOptions(options);
    }

    static {
        CREATE_INDEX_MULTIPLE_MATCHING_TEMPLATES = Pattern.compile("^index \\[(.+)\\] matches multiple legacy templates \\[(.+)\\], composable templates will only match a single template$");
        PUT_TEMPLATE_MULTIPLE_MATCHING_TEMPLATES = Pattern.compile("^index template \\[(.+)\\] has index patterns \\[(.+)\\] matching patterns from existing older templates \\[(.+)\\] with patterns \\((.+)\\); this template \\[(.+)\\] will take precedence during new index creation$");
    }

    public static class VersionSensitiveWarningsHandler
    implements WarningsHandler {
        Set<String> requiredSameVersionClusterWarnings = new HashSet<String>();
        Set<String> allowedWarnings = new HashSet<String>();
        final Set<Version> testNodeVersions;

        public VersionSensitiveWarningsHandler(Set<Version> nodeVersions) {
            this.testNodeVersions = nodeVersions;
        }

        public void current(String ... requiredWarnings) {
            this.requiredSameVersionClusterWarnings.addAll(Arrays.asList(requiredWarnings));
        }

        public void compatible(String ... allowedWarnings) {
            this.allowedWarnings.addAll(Arrays.asList(allowedWarnings));
        }

        public boolean warningsShouldFailRequest(List<String> warnings) {
            if (warnings.isEmpty()) {
                return false;
            }
            if (this.isExclusivelyTargetingCurrentVersionCluster()) {
                HashSet<String> actual = new HashSet<String>(warnings);
                return false == this.requiredSameVersionClusterWarnings.equals(actual);
            }
            for (String actualWarning : warnings) {
                if (this.allowedWarnings.contains(actualWarning) || this.requiredSameVersionClusterWarnings.contains(actualWarning)) continue;
                return true;
            }
            return false;
        }

        private boolean isExclusivelyTargetingCurrentVersionCluster() {
            Assert.assertFalse((String)"Node versions running in the cluster are missing", (boolean)this.testNodeVersions.isEmpty());
            return this.testNodeVersions.size() == 1 && this.testNodeVersions.iterator().next().equals((Object)Version.CURRENT);
        }
    }
}

