/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test.client;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionModule;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.Client;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskListener;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.TestThreadPool;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.RemoteClusterService;

public class NoOpNodeClient
extends NodeClient {
    public NoOpNodeClient(ThreadPool threadPool) {
        super(Settings.EMPTY, threadPool);
    }

    public NoOpNodeClient(String testName) {
        super(Settings.EMPTY, (ThreadPool)new TestThreadPool(testName, new ExecutorBuilder[0]));
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        listener.onResponse(null);
    }

    public void initialize(ActionModule.DynamicActionRegistry dynamicActionRegistry, Supplier<String> localNodeId, RemoteClusterService remoteClusterService, NamedWriteableRegistry namedWriteableRegistry) {
        throw new UnsupportedOperationException("cannot initialize " + ((Object)((Object)this)).getClass().getSimpleName());
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        listener.onResponse(null);
        return null;
    }

    public <Request extends ActionRequest, Response extends ActionResponse> Task executeLocally(ActionType<Response> action, Request request, TaskListener<Response> listener) {
        listener.onResponse(null, null);
        return null;
    }

    public String getLocalNodeId() {
        return null;
    }

    public Client getRemoteClusterClient(String clusterAlias) {
        return null;
    }

    public void close() {
        try {
            ThreadPool.terminate((ThreadPool)this.threadPool(), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new OpenSearchException(e.getMessage(), (Throwable)e, new Object[0]);
        }
    }
}

