/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.admin.cluster.repositories.get.GetRepositoriesResponse;
import org.opensearch.action.admin.cluster.state.ClusterStateResponse;
import org.opensearch.action.admin.indices.datastream.DeleteDataStreamAction;
import org.opensearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.indices.IndexTemplateMissingException;
import org.opensearch.repositories.RepositoryMissingException;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.test.hamcrest.OpenSearchAssertions;

public abstract class TestCluster
implements Closeable {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final long seed;
    protected Random random;

    public TestCluster(long seed) {
        this.seed = seed;
    }

    public long seed() {
        return this.seed;
    }

    public void beforeTest(Random random) throws IOException, InterruptedException {
        this.random = new Random(random.nextLong());
    }

    public void wipe(Set<String> excludeTemplates) {
        this.wipeAllDataStreams();
        this.wipeIndices("_all");
        this.wipeAllTemplates(excludeTemplates);
        this.wipeRepositories(new String[0]);
    }

    public void beforeIndexDeletion() throws Exception {
    }

    public void assertAfterTest() throws Exception {
        this.ensureEstimatedStats();
    }

    public abstract void afterTest() throws IOException;

    public abstract Client client();

    public abstract int size();

    public abstract int numDataNodes();

    public int numDataAndClusterManagerNodes() {
        return this.numDataAndMasterNodes();
    }

    @Deprecated
    public int numDataAndMasterNodes() {
        throw new UnsupportedOperationException("Must be overridden");
    }

    public abstract InetSocketAddress[] httpAddresses();

    @Override
    public abstract void close() throws IOException;

    public void wipeAllDataStreams() {
        if (this.size() > 0) {
            AcknowledgedResponse response = (AcknowledgedResponse)this.client().admin().indices().deleteDataStream(new DeleteDataStreamAction.Request(new String[]{"*"})).actionGet();
            OpenSearchAssertions.assertAcked(response);
        }
    }

    public void wipeIndices(String ... indices) {
        block6: {
            assert (indices != null && indices.length > 0);
            if (this.size() > 0) {
                try {
                    OpenSearchAssertions.assertAcked(this.client().admin().indices().prepareDelete(indices).setIndicesOptions(IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false)));
                }
                catch (IndexNotFoundException indexNotFoundException) {
                }
                catch (IllegalArgumentException e) {
                    if (!"_all".equals(indices[0])) break block6;
                    ClusterStateResponse clusterStateResponse = (ClusterStateResponse)this.client().admin().cluster().prepareState().execute().actionGet();
                    ArrayList<String> concreteIndices = new ArrayList<String>();
                    for (IndexMetadata indexMetadata : clusterStateResponse.getState().metadata()) {
                        concreteIndices.add(indexMetadata.getIndex().getName());
                    }
                    if (concreteIndices.isEmpty()) break block6;
                    OpenSearchAssertions.assertAcked(this.client().admin().indices().prepareDelete(concreteIndices.toArray(new String[concreteIndices.size()])));
                }
            }
        }
    }

    public void wipeAllTemplates(Set<String> exclude) {
        if (this.size() > 0) {
            GetIndexTemplatesResponse response = (GetIndexTemplatesResponse)this.client().admin().indices().prepareGetTemplates(new String[0]).get();
            for (IndexTemplateMetadata indexTemplate : response.getIndexTemplates()) {
                if (exclude.contains(indexTemplate.getName())) continue;
                try {
                    this.client().admin().indices().prepareDeleteTemplate(indexTemplate.getName()).execute().actionGet();
                }
                catch (IndexTemplateMissingException indexTemplateMissingException) {}
            }
        }
    }

    public void wipeTemplates(String ... templates) {
        if (this.size() > 0) {
            if (templates.length == 0) {
                templates = new String[]{"*"};
            }
            for (String template : templates) {
                try {
                    this.client().admin().indices().prepareDeleteTemplate(template).execute().actionGet();
                }
                catch (IndexTemplateMissingException indexTemplateMissingException) {
                    // empty catch block
                }
            }
        }
    }

    public void wipeRepositories(String ... repositories) {
        if (this.size() > 0) {
            if (repositories.length == 0) {
                repositories = new String[]{"*"};
            }
            for (String repository : repositories) {
                try {
                    List repositoryMetadata = ((GetRepositoriesResponse)this.client().admin().cluster().prepareGetRepositories(new String[]{repository}).execute().actionGet()).repositories();
                    if (!repositoryMetadata.isEmpty() && ((Boolean)BlobStoreRepository.SYSTEM_REPOSITORY_SETTING.get(((RepositoryMetadata)repositoryMetadata.get(0)).settings())).booleanValue()) {
                        this.client().admin().cluster().prepareCleanupRepository(repository).execute().actionGet();
                        continue;
                    }
                    this.client().admin().cluster().prepareDeleteRepository(repository).execute().actionGet();
                }
                catch (RepositoryMissingException repositoryMissingException) {
                    // empty catch block
                }
            }
        }
    }

    public abstract void ensureEstimatedStats();

    public abstract String getClusterName();

    public abstract Iterable<Client> getClients();

    public abstract NamedWriteableRegistry getNamedWriteableRegistry();
}

