/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.apache.logging.log4j.core.util.Throwables;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateTaskConfig;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.NodeConnectionsService;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.cluster.coordination.ClusterStatePublisher;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterApplier;
import org.opensearch.cluster.service.ClusterApplierService;
import org.opensearch.cluster.service.ClusterManagerService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.cluster.service.MasterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.node.Node;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.threadpool.ThreadPool;

public class ClusterServiceUtils {
    public static ClusterManagerService createClusterManagerService(ThreadPool threadPool, ClusterState initialClusterState) {
        ClusterManagerService clusterManagerService = new ClusterManagerService(Settings.builder().put(Node.NODE_NAME_SETTING.getKey(), "test_cluster_manager_node").build(), new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS), threadPool);
        AtomicReference<ClusterState> clusterStateRef = new AtomicReference<ClusterState>(initialClusterState);
        clusterManagerService.setClusterStatePublisher((event, publishListener, ackListener) -> {
            clusterStateRef.set(event.state());
            publishListener.onResponse(null);
        });
        clusterManagerService.setClusterStateSupplier(clusterStateRef::get);
        clusterManagerService.start();
        return clusterManagerService;
    }

    public static ClusterManagerService createClusterManagerService(ThreadPool threadPool, DiscoveryNode localNode) {
        ClusterState initialClusterState = ClusterState.builder((ClusterName)new ClusterName(ClusterServiceUtils.class.getSimpleName())).nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).clusterManagerNodeId(localNode.getId())).blocks(ClusterBlocks.EMPTY_CLUSTER_BLOCK).build();
        return ClusterServiceUtils.createClusterManagerService(threadPool, initialClusterState);
    }

    @Deprecated
    public static MasterService createMasterService(ThreadPool threadPool, ClusterState initialClusterState) {
        return ClusterServiceUtils.createClusterManagerService(threadPool, initialClusterState);
    }

    @Deprecated
    public static MasterService createMasterService(ThreadPool threadPool, DiscoveryNode localNode) {
        return ClusterServiceUtils.createClusterManagerService(threadPool, localNode);
    }

    public static void setState(ClusterApplierService executor, ClusterState clusterState) {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference exception = new AtomicReference();
        executor.onNewClusterState("test setting state", () -> ClusterState.builder((ClusterState)clusterState).version(clusterState.version() + 1L).build(), new ClusterApplier.ClusterApplyListener(){

            public void onSuccess(String source) {
                latch.countDown();
            }

            public void onFailure(String source, Exception e) {
                exception.set(e);
                latch.countDown();
            }
        });
        try {
            latch.await();
            if (exception.get() != null) {
                Throwables.rethrow((Throwable)((Throwable)exception.get()));
            }
        }
        catch (InterruptedException e) {
            throw new OpenSearchException("unexpected exception", (Throwable)e, new Object[0]);
        }
    }

    public static void setState(ClusterManagerService executor, final ClusterState clusterState) {
        final CountDownLatch latch = new CountDownLatch(1);
        executor.submitStateUpdateTask("test setting state", (ClusterStateTaskConfig)new ClusterStateUpdateTask(){

            public ClusterState execute(ClusterState currentState) throws Exception {
                return ClusterState.builder((ClusterState)clusterState).build();
            }

            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                latch.countDown();
            }

            public void onFailure(String source, Exception e) {
                TestCase.fail((String)("unexpected exception" + String.valueOf(e)));
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new OpenSearchException("unexpected interruption", (Throwable)e, new Object[0]);
        }
    }

    public static ClusterService createClusterService(ThreadPool threadPool) {
        DiscoveryNode discoveryNode = new DiscoveryNode("node", OpenSearchTestCase.buildNewFakeTransportAddress(), Collections.emptyMap(), (Set)DiscoveryNodeRole.BUILT_IN_ROLES, Version.CURRENT);
        return ClusterServiceUtils.createClusterService(threadPool, discoveryNode);
    }

    public static ClusterService createClusterService(ThreadPool threadPool, DiscoveryNode localNode) {
        return ClusterServiceUtils.createClusterService(threadPool, localNode, new ClusterSettings(Settings.EMPTY, ClusterSettings.BUILT_IN_CLUSTER_SETTINGS));
    }

    public static ClusterService createClusterService(ThreadPool threadPool, DiscoveryNode localNode, ClusterSettings clusterSettings) {
        Settings settings = Settings.builder().put("node.name", "test").put("cluster.name", "ClusterServiceTests").build();
        ClusterService clusterService = new ClusterService(settings, clusterSettings, threadPool);
        clusterService.setNodeConnectionsService(ClusterServiceUtils.createNoOpNodeConnectionsService());
        ClusterState initialClusterState = ClusterState.builder((ClusterName)new ClusterName(ClusterServiceUtils.class.getSimpleName())).nodes(DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).clusterManagerNodeId(localNode.getId())).blocks(ClusterBlocks.EMPTY_CLUSTER_BLOCK).build();
        clusterService.getClusterApplierService().setInitialState(initialClusterState);
        clusterService.getClusterManagerService().setClusterStatePublisher(ClusterServiceUtils.createClusterStatePublisher((ClusterApplier)clusterService.getClusterApplierService()));
        clusterService.getClusterManagerService().setClusterStateSupplier(() -> ((ClusterApplierService)clusterService.getClusterApplierService()).state());
        clusterService.start();
        return clusterService;
    }

    public static NodeConnectionsService createNoOpNodeConnectionsService() {
        return new NodeConnectionsService(Settings.EMPTY, null, null){

            public void connectToNodes(DiscoveryNodes discoveryNodes, Runnable onCompletion) {
                onCompletion.run();
            }

            public void disconnectFromNodesExcept(DiscoveryNodes nodesToKeep) {
            }
        };
    }

    public static ClusterStatePublisher createClusterStatePublisher(ClusterApplier clusterApplier) {
        return (event, publishListener, ackListener) -> clusterApplier.onNewClusterState("mock_publish_to_self[" + event.source() + "]", () -> event.state(), new ClusterApplier.ClusterApplyListener(){

            public void onSuccess(String source) {
                publishListener.onResponse(null);
            }

            public void onFailure(String source, Exception e) {
                publishListener.onFailure(e);
            }
        });
    }

    public static ClusterService createClusterService(ClusterState initialState, ThreadPool threadPool) {
        ClusterService clusterService = ClusterServiceUtils.createClusterService(threadPool);
        ClusterServiceUtils.setState(clusterService, initialState);
        return clusterService;
    }

    public static void setState(ClusterService clusterService, ClusterState.Builder clusterStateBuilder) {
        ClusterServiceUtils.setState(clusterService, clusterStateBuilder.build());
    }

    public static void setState(ClusterService clusterService, ClusterState clusterState) {
        ClusterServiceUtils.setState(clusterService.getClusterApplierService(), clusterState);
    }
}

