/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.test;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.admin.cluster.remote.RemoteInfoAction;
import org.opensearch.action.admin.cluster.remote.RemoteInfoRequest;
import org.opensearch.action.admin.cluster.remote.RemoteInfoResponse;
import org.opensearch.client.Client;
import org.opensearch.common.CheckedRunnable;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.discovery.DiscoveryModule;
import org.opensearch.discovery.SettingsBasedSeedHostsProvider;
import org.opensearch.plugins.Plugin;
import org.opensearch.test.InternalTestCluster;
import org.opensearch.test.MockHttpTransport;
import org.opensearch.test.NodeConfigurationSource;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.test.transport.MockTransportService;
import org.opensearch.transport.RemoteConnectionInfo;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.nio.MockNioTransportPlugin;

public abstract class AbstractMultiClustersTestCase
extends OpenSearchTestCase {
    public static final String LOCAL_CLUSTER = "";
    private static volatile ClusterGroup clusterGroup;

    protected Collection<String> remoteClusterAlias() {
        return AbstractMultiClustersTestCase.randomSubsetOf(Arrays.asList("cluster-a", "cluster-b"));
    }

    protected Collection<Class<? extends Plugin>> nodePlugins(String clusterAlias) {
        return Collections.emptyList();
    }

    protected final Client client() {
        return this.client(LOCAL_CLUSTER);
    }

    protected final Client client(String clusterAlias) {
        return this.cluster(clusterAlias).client();
    }

    protected final InternalTestCluster cluster(String clusterAlias) {
        return clusterGroup.getCluster(clusterAlias);
    }

    protected final Map<String, InternalTestCluster> clusters() {
        return Collections.unmodifiableMap(AbstractMultiClustersTestCase.clusterGroup.clusters);
    }

    protected boolean reuseClusters() {
        return true;
    }

    @Before
    public final void startClusters() throws Exception {
        if (clusterGroup != null && this.reuseClusters()) {
            return;
        }
        AbstractMultiClustersTestCase.stopClusters();
        HashMap<String, InternalTestCluster> clusters = new HashMap<String, InternalTestCluster>();
        ArrayList<String> clusterAliases = new ArrayList<String>(this.remoteClusterAlias());
        clusterAliases.add(LOCAL_CLUSTER);
        for (String clusterAlias : clusterAliases) {
            String clusterName = clusterAlias.equals(LOCAL_CLUSTER) ? "main-cluster" : clusterAlias;
            int numberOfNodes = AbstractMultiClustersTestCase.randomIntBetween(1, 3);
            List<Class<? extends Plugin>> mockPlugins = Arrays.asList(MockHttpTransport.TestPlugin.class, MockTransportService.TestPlugin.class, MockNioTransportPlugin.class);
            Collection<Class<? extends Plugin>> nodePlugins = this.nodePlugins(clusterAlias);
            Settings nodeSettings = Settings.EMPTY;
            NodeConfigurationSource nodeConfigurationSource = AbstractMultiClustersTestCase.nodeConfigurationSource(nodeSettings, nodePlugins);
            InternalTestCluster cluster = new InternalTestCluster(AbstractMultiClustersTestCase.randomLong(), AbstractMultiClustersTestCase.createTempDir(), true, true, numberOfNodes, numberOfNodes, clusterName, nodeConfigurationSource, 0, clusterName + "-", mockPlugins, Function.identity());
            cluster.beforeTest(AbstractMultiClustersTestCase.random());
            clusters.put(clusterAlias, cluster);
        }
        clusterGroup = new ClusterGroup(clusters);
        this.configureAndConnectsToRemoteClusters();
    }

    @After
    public void assertAfterTest() throws Exception {
        for (InternalTestCluster cluster : this.clusters().values()) {
            cluster.wipe(Collections.emptySet());
            cluster.assertAfterTest();
        }
    }

    @AfterClass
    public static void stopClusters() throws IOException {
        IOUtils.close((Closeable)clusterGroup);
        clusterGroup = null;
    }

    protected void disconnectFromRemoteClusters() throws Exception {
        Settings.Builder settings = Settings.builder();
        Set<String> clusterAliases = clusterGroup.clusterAliases();
        for (String clusterAlias : clusterAliases) {
            if (clusterAlias.equals(LOCAL_CLUSTER)) continue;
            settings.putNull("cluster.remote." + clusterAlias + ".seeds");
        }
        this.client().admin().cluster().prepareUpdateSettings().setPersistentSettings(settings).get();
        AbstractMultiClustersTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            for (TransportService transportService : this.cluster(LOCAL_CLUSTER).getInstances(TransportService.class)) {
                AbstractMultiClustersTestCase.assertThat((Object)transportService.getRemoteClusterService().getRegisteredRemoteClusterNames(), (Matcher)Matchers.empty());
            }
        }));
    }

    protected void configureAndConnectsToRemoteClusters() throws Exception {
        HashMap<String, List<String>> seedNodes = new HashMap<String, List<String>>();
        for (String clusterAlias : clusterGroup.clusterAliases()) {
            if (clusterAlias.equals(LOCAL_CLUSTER)) continue;
            InternalTestCluster cluster = clusterGroup.getCluster(clusterAlias);
            String[] allNodes = cluster.getNodeNames();
            List<String> selectedNodes = AbstractMultiClustersTestCase.randomSubsetOf(AbstractMultiClustersTestCase.randomIntBetween(1, Math.min(3, allNodes.length)), allNodes);
            seedNodes.put(clusterAlias, selectedNodes);
        }
        if (seedNodes.isEmpty()) {
            return;
        }
        Settings.Builder settings = Settings.builder();
        for (Map.Entry entry : seedNodes.entrySet()) {
            String clusterAlias = (String)entry.getKey();
            String seeds = ((List)entry.getValue()).stream().map(node -> this.cluster(clusterAlias).getInstance(TransportService.class, (String)node).boundAddress().publishAddress().toString()).collect(Collectors.joining(","));
            settings.put("cluster.remote." + clusterAlias + ".seeds", seeds);
        }
        this.client().admin().cluster().prepareUpdateSettings().setPersistentSettings(settings).get();
        AbstractMultiClustersTestCase.assertBusy((CheckedRunnable<Exception>)((CheckedRunnable)() -> {
            List remoteConnectionInfos = ((RemoteInfoResponse)this.client().execute((ActionType)RemoteInfoAction.INSTANCE, (ActionRequest)new RemoteInfoRequest()).actionGet()).getInfos().stream().filter(RemoteConnectionInfo::isConnected).collect(Collectors.toList());
            long totalConnections = seedNodes.values().stream().map(List::size).count();
            AbstractMultiClustersTestCase.assertThat(remoteConnectionInfos, (Matcher)Matchers.hasSize((int)Math.toIntExact(totalConnections)));
        }));
    }

    static NodeConfigurationSource nodeConfigurationSource(Settings nodeSettings, final Collection<Class<? extends Plugin>> nodePlugins) {
        final Settings.Builder builder = Settings.builder();
        builder.putList(SettingsBasedSeedHostsProvider.DISCOVERY_SEED_HOSTS_SETTING.getKey(), new String[0]);
        builder.putList(DiscoveryModule.DISCOVERY_SEED_PROVIDERS_SETTING.getKey(), new String[]{"file"});
        builder.put("transport.type", AbstractMultiClustersTestCase.getTestTransportType());
        builder.put(nodeSettings);
        return new NodeConfigurationSource(){

            @Override
            public Settings nodeSettings(int nodeOrdinal) {
                return builder.build();
            }

            @Override
            public Path nodeConfigPath(int nodeOrdinal) {
                return null;
            }

            @Override
            public Collection<Class<? extends Plugin>> nodePlugins() {
                return nodePlugins;
            }
        };
    }

    static class ClusterGroup
    implements Closeable {
        private final Map<String, InternalTestCluster> clusters;

        ClusterGroup(Map<String, InternalTestCluster> clusters) {
            this.clusters = Collections.unmodifiableMap(clusters);
        }

        InternalTestCluster getCluster(String clusterAlias) {
            Assert.assertThat(this.clusters, (Matcher)Matchers.hasKey((Object)clusterAlias));
            return this.clusters.get(clusterAlias);
        }

        Set<String> clusterAliases() {
            return this.clusters.keySet();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close(this.clusters.values());
        }
    }
}

