/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure;

import java.util.concurrent.atomic.AtomicBoolean;
import org.mockito.Mockito;
import org.opensearch.core.tasks.resourcetracker.TaskResourceUsage;
import org.opensearch.tasks.CancellableTask;
import org.opensearch.test.OpenSearchTestCase;

public class SearchBackpressureTestHelpers
extends OpenSearchTestCase {
    public static <T extends CancellableTask> T createMockTaskWithResourceStats(Class<T> type, long cpuUsage, long heapUsage) {
        return SearchBackpressureTestHelpers.createMockTaskWithResourceStats(type, cpuUsage, heapUsage, 0L);
    }

    public static <T extends CancellableTask> T createMockTaskWithResourceStats(Class<T> type, long cpuUsage, long heapUsage, long startTimeNanos) {
        CancellableTask task = (CancellableTask)Mockito.mock(type);
        Mockito.when((Object)task.getTotalResourceStats()).thenReturn((Object)new TaskResourceUsage(cpuUsage, heapUsage));
        Mockito.when((Object)task.getStartTimeNanos()).thenReturn((Object)startTimeNanos);
        AtomicBoolean isCancelled = new AtomicBoolean(false);
        ((CancellableTask)Mockito.doAnswer(invocation -> {
            isCancelled.set(true);
            return null;
        }).when((Object)task)).cancel(Mockito.anyString());
        ((CancellableTask)Mockito.doAnswer(invocation -> isCancelled.get()).when((Object)task)).isCancelled();
        return (T)task;
    }
}

