/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchType;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.text.Text;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;
import org.opensearch.search.SearchExtBuilder;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.builder.PointInTimeBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.collapse.CollapseBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.opensearch.search.rescore.RescorerBuilder;
import org.opensearch.search.searchafter.SearchAfterBuilder;
import org.opensearch.search.slice.SliceBuilder;
import org.opensearch.search.sort.ScriptSortBuilder;
import org.opensearch.search.sort.SortBuilders;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.search.suggest.SuggestBuilder;
import org.opensearch.test.AbstractQueryTestCase;
import org.opensearch.test.OpenSearchTestCase;

public class RandomSearchRequestGenerator {
    private RandomSearchRequestGenerator() {
    }

    public static SearchRequest randomSearchRequest(Supplier<SearchSourceBuilder> randomSearchSourceBuilder) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.allowPartialSearchResults(true);
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.setCcsMinimizeRoundtrips(OpenSearchTestCase.randomBoolean());
        }
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.indices(OpenSearchTestCase.generateRandomStringArray(10, 10, false, false));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.indicesOptions(IndicesOptions.fromOptions((boolean)OpenSearchTestCase.randomBoolean(), (boolean)OpenSearchTestCase.randomBoolean(), (boolean)OpenSearchTestCase.randomBoolean(), (boolean)OpenSearchTestCase.randomBoolean()));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.preference(OpenSearchTestCase.randomAlphaOfLengthBetween(3, 10));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.requestCache(Boolean.valueOf(OpenSearchTestCase.randomBoolean()));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.routing(OpenSearchTestCase.randomAlphaOfLengthBetween(3, 10));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.scroll(OpenSearchTestCase.randomPositiveTimeValue());
        }
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.searchType(OpenSearchTestCase.randomFrom(SearchType.DFS_QUERY_THEN_FETCH, SearchType.QUERY_THEN_FETCH));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.source(randomSearchSourceBuilder.get());
        }
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.setCancelAfterTimeInterval(TimeValue.parseTimeValue((String)OpenSearchTestCase.randomTimeValue(), null, (String)"cancel_after_time_interval"));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            searchRequest.setPhaseTook(Boolean.valueOf(OpenSearchTestCase.randomBoolean()));
        }
        return searchRequest;
    }

    public static SearchSourceBuilder randomSearchSourceBuilder(Supplier<HighlightBuilder> randomHighlightBuilder, Supplier<SuggestBuilder> randomSuggestBuilder, Supplier<RescorerBuilder<?>> randomRescoreBuilder, Supplier<List<SearchExtBuilder>> randomExtBuilders, Supplier<CollapseBuilder> randomCollapseBuilder) {
        int i;
        SearchSourceBuilder builder = new SearchSourceBuilder();
        if (OpenSearchTestCase.randomBoolean()) {
            builder.from(OpenSearchTestCase.randomIntBetween(0, 10000));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.size(OpenSearchTestCase.randomIntBetween(0, 10000));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.explain(Boolean.valueOf(OpenSearchTestCase.randomBoolean()));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.version(Boolean.valueOf(OpenSearchTestCase.randomBoolean()));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.seqNoAndPrimaryTerm(Boolean.valueOf(OpenSearchTestCase.randomBoolean()));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.trackScores(OpenSearchTestCase.randomBoolean());
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.minScore(OpenSearchTestCase.randomFloat() * 1000.0f);
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.timeout(TimeValue.parseTimeValue((String)OpenSearchTestCase.randomTimeValue(), null, (String)"timeout"));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.terminateAfter(OpenSearchTestCase.randomIntBetween(1, 100000));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            if (OpenSearchTestCase.randomBoolean()) {
                builder.trackTotalHits(OpenSearchTestCase.randomBoolean());
            } else {
                builder.trackTotalHitsUpTo(OpenSearchTestCase.randomIntBetween(-1, Integer.MAX_VALUE));
            }
        }
        switch (OpenSearchTestCase.randomInt(2)) {
            case 0: {
                builder.storedFields();
                break;
            }
            case 1: {
                builder.storedField("_none_");
                break;
            }
            case 2: {
                int fieldsSize = OpenSearchTestCase.randomInt(25);
                ArrayList<String> fields = new ArrayList<String>(fieldsSize);
                for (i = 0; i < fieldsSize; ++i) {
                    fields.add(OpenSearchTestCase.randomAlphaOfLengthBetween(5, 50));
                }
                builder.storedFields(fields);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (OpenSearchTestCase.randomBoolean()) {
            int numFields = OpenSearchTestCase.randomInt(5);
            for (int i2 = 0; i2 < numFields; ++i2) {
                builder.fetchField(OpenSearchTestCase.randomAlphaOfLengthBetween(5, 10));
            }
        }
        if (OpenSearchTestCase.randomBoolean()) {
            int scriptFieldsSize = OpenSearchTestCase.randomInt(25);
            for (int i3 = 0; i3 < scriptFieldsSize; ++i3) {
                if (OpenSearchTestCase.randomBoolean()) {
                    builder.scriptField(OpenSearchTestCase.randomAlphaOfLengthBetween(5, 50), OpenSearchTestCase.mockScript("foo"), OpenSearchTestCase.randomBoolean());
                    continue;
                }
                builder.scriptField(OpenSearchTestCase.randomAlphaOfLengthBetween(5, 50), OpenSearchTestCase.mockScript("foo"));
            }
        }
        if (OpenSearchTestCase.randomBoolean()) {
            FetchSourceContext fetchSourceContext;
            int branch = OpenSearchTestCase.randomInt(5);
            String[] includes = new String[OpenSearchTestCase.randomIntBetween(0, 20)];
            for (int i4 = 0; i4 < includes.length; ++i4) {
                includes[i4] = OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20);
            }
            String[] excludes = new String[OpenSearchTestCase.randomIntBetween(0, 20)];
            for (int i5 = 0; i5 < excludes.length; ++i5) {
                excludes[i5] = OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20);
            }
            switch (branch) {
                case 0: {
                    fetchSourceContext = new FetchSourceContext(OpenSearchTestCase.randomBoolean());
                    break;
                }
                case 1: {
                    fetchSourceContext = new FetchSourceContext(true, includes, excludes);
                    break;
                }
                case 2: {
                    fetchSourceContext = new FetchSourceContext(true, new String[]{OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20)}, new String[]{OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20)});
                    break;
                }
                case 3: {
                    fetchSourceContext = new FetchSourceContext(true, includes, excludes);
                    break;
                }
                case 4: {
                    fetchSourceContext = new FetchSourceContext(true, includes, null);
                    break;
                }
                case 5: {
                    fetchSourceContext = new FetchSourceContext(true, new String[]{OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20)}, null);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            builder.fetchSource(fetchSourceContext);
        }
        if (OpenSearchTestCase.randomBoolean()) {
            int size = OpenSearchTestCase.randomIntBetween(0, 20);
            ArrayList<String> statsGroups = new ArrayList<String>(size);
            for (i = 0; i < size; ++i) {
                statsGroups.add(OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20));
            }
            builder.stats(statsGroups);
        }
        if (OpenSearchTestCase.randomBoolean()) {
            int indexBoostSize = OpenSearchTestCase.randomIntBetween(1, 10);
            for (int i6 = 0; i6 < indexBoostSize; ++i6) {
                builder.indexBoost(OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20), OpenSearchTestCase.randomFloat() * 10.0f);
            }
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.query((QueryBuilder)QueryBuilders.termQuery((String)OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20), (String)OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20)));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.postFilter((QueryBuilder)QueryBuilders.termQuery((String)OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20), (String)OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20)));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            int numSorts = OpenSearchTestCase.randomIntBetween(1, 5);
            block41: for (int i7 = 0; i7 < numSorts; ++i7) {
                int branch = OpenSearchTestCase.randomInt(5);
                switch (branch) {
                    case 0: {
                        builder.sort(SortBuilders.fieldSort((String)OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20)).order(OpenSearchTestCase.randomFrom(SortOrder.values())));
                        continue block41;
                    }
                    case 1: {
                        builder.sort(SortBuilders.geoDistanceSort((String)OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20), (String[])new String[]{AbstractQueryTestCase.randomGeohash(1, 12)}).order(OpenSearchTestCase.randomFrom(SortOrder.values())));
                        continue block41;
                    }
                    case 2: {
                        builder.sort(SortBuilders.scoreSort().order(OpenSearchTestCase.randomFrom(SortOrder.values())));
                        continue block41;
                    }
                    case 3: {
                        builder.sort(SortBuilders.scriptSort((Script)new Script(ScriptType.INLINE, "painless", "foo", Collections.emptyMap()), (ScriptSortBuilder.ScriptSortType)ScriptSortBuilder.ScriptSortType.NUMBER).order(OpenSearchTestCase.randomFrom(SortOrder.values())));
                        continue block41;
                    }
                    case 4: {
                        builder.sort(OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20));
                        continue block41;
                    }
                    case 5: {
                        builder.sort(OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20), OpenSearchTestCase.randomFrom(SortOrder.values()));
                    }
                }
            }
        }
        if (OpenSearchTestCase.randomBoolean()) {
            int numSearchFrom = OpenSearchTestCase.randomIntBetween(1, 5);
            try {
                XContentBuilder jsonBuilder = XContentFactory.jsonBuilder();
                jsonBuilder.startObject();
                jsonBuilder.startArray("search_from");
                block42: for (i = 0; i < numSearchFrom; ++i) {
                    int branch = OpenSearchTestCase.randomInt(8);
                    switch (branch) {
                        case 0: {
                            jsonBuilder.value(OpenSearchTestCase.randomInt());
                            continue block42;
                        }
                        case 1: {
                            jsonBuilder.value(OpenSearchTestCase.randomFloat());
                            continue block42;
                        }
                        case 2: {
                            jsonBuilder.value(OpenSearchTestCase.randomLong());
                            continue block42;
                        }
                        case 3: {
                            jsonBuilder.value(OpenSearchTestCase.randomDouble());
                            continue block42;
                        }
                        case 4: {
                            jsonBuilder.value(OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20));
                            continue block42;
                        }
                        case 5: {
                            jsonBuilder.value(OpenSearchTestCase.randomBoolean());
                            continue block42;
                        }
                        case 6: {
                            jsonBuilder.value(OpenSearchTestCase.randomByte());
                            continue block42;
                        }
                        case 7: {
                            jsonBuilder.value(OpenSearchTestCase.randomShort());
                            continue block42;
                        }
                        case 8: {
                            jsonBuilder.value((Object)new Text(OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20)));
                        }
                    }
                }
                jsonBuilder.endArray();
                jsonBuilder.endObject();
                XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)BytesReference.bytes((XContentBuilder)jsonBuilder).streamInput());
                parser.nextToken();
                parser.nextToken();
                parser.nextToken();
                builder.searchAfter(SearchAfterBuilder.fromXContent((XContentParser)parser).getSortValues());
            }
            catch (IOException e) {
                throw new RuntimeException("Error building search_from", e);
            }
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.highlighter(randomHighlightBuilder.get());
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.suggest(randomSuggestBuilder.get());
        }
        if (OpenSearchTestCase.randomBoolean()) {
            int numRescores = OpenSearchTestCase.randomIntBetween(1, 5);
            for (int i8 = 0; i8 < numRescores; ++i8) {
                builder.addRescorer(randomRescoreBuilder.get());
            }
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.aggregation((AggregationBuilder)AggregationBuilders.avg((String)OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20)).field("foo"));
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.ext(randomExtBuilders.get());
        }
        if (OpenSearchTestCase.randomBoolean()) {
            String field = OpenSearchTestCase.randomBoolean() ? null : OpenSearchTestCase.randomAlphaOfLengthBetween(5, 20);
            int max = OpenSearchTestCase.between(2, 1000);
            int id = OpenSearchTestCase.randomInt(max - 1);
            if (field == null) {
                builder.slice(new SliceBuilder(id, max));
            } else {
                builder.slice(new SliceBuilder(field, id, max));
            }
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.collapse(randomCollapseBuilder.get());
        }
        if (OpenSearchTestCase.randomBoolean()) {
            PointInTimeBuilder pit = new PointInTimeBuilder(OpenSearchTestCase.randomAlphaOfLengthBetween(3, 10));
            if (OpenSearchTestCase.randomBoolean()) {
                pit.setKeepAlive(TimeValue.timeValueMinutes((long)OpenSearchTestCase.randomIntBetween(1, 60)));
            }
            builder.pointInTimeBuilder(pit);
        }
        if (OpenSearchTestCase.randomBoolean()) {
            builder.searchPipelineSource(new HashMap());
        }
        return builder;
    }
}

