/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories.blobstore;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.lucene.util.SameThreadExecutorService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.mockito.Mockito;
import org.opensearch.Version;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateApplier;
import org.opensearch.cluster.ClusterStateTaskConfig;
import org.opensearch.cluster.ClusterStateUpdateTask;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.RepositoriesMetadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterApplierService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.BlobStore;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexModule;
import org.opensearch.repositories.IndexId;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.RepositoryData;
import org.opensearch.repositories.ShardGenerations;
import org.opensearch.repositories.blobstore.BlobStoreRepository;
import org.opensearch.snapshots.SnapshotId;
import org.opensearch.snapshots.SnapshotInfo;
import org.opensearch.snapshots.SnapshotMissingException;
import org.opensearch.test.InternalTestCluster;
import org.opensearch.test.OpenSearchTestCase;
import org.opensearch.threadpool.ThreadPool;

public final class BlobStoreTestUtil {
    public static void assertRepoConsistency(InternalTestCluster testCluster, String repoName) {
        BlobStoreRepository repo = (BlobStoreRepository)testCluster.getCurrentClusterManagerNodeInstance(RepositoriesService.class).repository(repoName);
        BlobStoreTestUtil.assertConsistency(repo, repo.threadPool().executor("generic"));
    }

    public static void assertConsistency(BlobStoreRepository repository, Executor executor) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        executor.execute((Runnable)ActionRunnable.supply((ActionListener)listener, () -> {
            try {
                RepositoryData repositoryData;
                long latestGen;
                BlobContainer blobContainer = repository.blobContainer();
                try (DataInputStream inputStream = new DataInputStream(blobContainer.readBlob("index.latest"));){
                    latestGen = inputStream.readLong();
                }
                catch (NoSuchFileException e) {
                    throw new AssertionError((Object)("Could not find index.latest blob for repo [" + String.valueOf(repository) + "]"));
                }
                BlobStoreTestUtil.assertIndexGenerations(blobContainer, latestGen);
                try (InputStream blob = blobContainer.readBlob("index-" + latestGen);
                     XContentParser parser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, blob);){
                    repositoryData = RepositoryData.snapshotsFromXContent((XContentParser)parser, (long)latestGen, (boolean)false);
                }
                BlobStoreTestUtil.assertIndexUUIDs(repository, repositoryData);
                BlobStoreTestUtil.assertSnapshotUUIDs(repository, repositoryData);
                BlobStoreTestUtil.assertShardIndexGenerations(repository, blobContainer, repositoryData);
                return null;
            }
            catch (AssertionError e) {
                return e;
            }
        }));
        AssertionError err = (AssertionError)listener.actionGet(TimeValue.timeValueMinutes((long)1L));
        if (err != null) {
            throw new AssertionError(err);
        }
    }

    private static void assertIndexGenerations(BlobContainer repoRoot, long latestGen) throws IOException {
        long[] indexGenerations = repoRoot.listBlobsByPrefix("index-").keySet().stream().map(s -> s.replace("index-", "")).mapToLong(Long::parseLong).sorted().toArray();
        Assert.assertEquals((long)latestGen, (long)indexGenerations[indexGenerations.length - 1]);
        Assert.assertTrue((indexGenerations.length <= 2 ? 1 : 0) != 0);
    }

    private static void assertShardIndexGenerations(BlobStoreRepository repository, BlobContainer repoRoot, RepositoryData repositoryData) throws IOException {
        ShardGenerations shardGenerations = repositoryData.shardGenerations();
        BlobContainer indicesContainer = (BlobContainer)repoRoot.children().get("indices");
        for (IndexId index : shardGenerations.indices()) {
            List gens = shardGenerations.getGens(index);
            if (gens.isEmpty()) continue;
            BlobContainer indexContainer = (BlobContainer)indicesContainer.children().get(index.getId());
            Map shardContainers = indexContainer.children();
            if (BlobStoreTestUtil.isRemoteSnapshot(repository, repositoryData, index)) {
                Assert.assertThat((Object)shardContainers, (Matcher)Matchers.anEmptyMap());
                continue;
            }
            for (int i = 0; i < gens.size(); ++i) {
                String generation = (String)gens.get(i);
                Assert.assertThat((Object)generation, (Matcher)Matchers.not((Object)"_deleted"));
                if (generation == null || generation.equals("_new")) continue;
                String shardId = Integer.toString(i);
                Assert.assertThat((Object)shardContainers, (Matcher)Matchers.hasKey((Object)shardId));
                Assert.assertThat((Object)((BlobContainer)shardContainers.get(shardId)).listBlobsByPrefix("index-"), (Matcher)Matchers.hasKey((Object)("index-" + generation)));
            }
        }
    }

    private static void assertIndexUUIDs(BlobStoreRepository repository, RepositoryData repositoryData) throws IOException {
        List<String> expectedIndexUUIDs = repositoryData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toList());
        BlobContainer indicesContainer = (BlobContainer)repository.blobContainer().children().get("indices");
        List<String> foundIndexUUIDs = indicesContainer == null ? Collections.emptyList() : indicesContainer.children().keySet().stream().filter(s -> !s.startsWith("extra")).collect(Collectors.toList());
        Assert.assertThat(foundIndexUUIDs, (Matcher)Matchers.containsInAnyOrder((Object[])expectedIndexUUIDs.toArray(Strings.EMPTY_ARRAY)));
        for (String indexId : foundIndexUUIDs) {
            Set indexMetaGenerationsFound = ((BlobContainer)indicesContainer.children().get(indexId)).listBlobsByPrefix("meta-").keySet().stream().map(p -> p.replace("meta-", "").replace(".dat", "")).collect(Collectors.toSet());
            HashSet<String> indexMetaGenerationsExpected = new HashSet<String>();
            IndexId idx = repositoryData.getIndices().values().stream().filter(i -> i.getId().equals(indexId)).findFirst().get();
            for (SnapshotId snapshotId : repositoryData.getSnapshots(idx)) {
                indexMetaGenerationsExpected.add(repositoryData.indexMetaDataGenerations().indexMetaBlobId(snapshotId, idx));
            }
            Assert.assertTrue((boolean)indexMetaGenerationsFound.containsAll(indexMetaGenerationsExpected));
        }
    }

    private static void assertSnapshotUUIDs(BlobStoreRepository repository, RepositoryData repositoryData) throws IOException {
        BlobContainer repoRoot = repository.blobContainer();
        Collection snapshotIds = repositoryData.getSnapshotIds();
        List<String> expectedSnapshotUUIDs = snapshotIds.stream().map(SnapshotId::getUUID).collect(Collectors.toList());
        HashSet foundSnapshotUUIDs = new HashSet();
        for (String prefix : new String[]{"snap-", "shallow-snap-"}) {
            foundSnapshotUUIDs.addAll(repoRoot.listBlobs().keySet().stream().filter(p -> p.startsWith(prefix)).map(p -> p.replace(prefix, "").replace(".dat", "")).collect(Collectors.toSet()));
        }
        Assert.assertThat(foundSnapshotUUIDs, (Matcher)Matchers.containsInAnyOrder((Object[])expectedSnapshotUUIDs.toArray(Strings.EMPTY_ARRAY)));
        BlobContainer indicesContainer = (BlobContainer)repository.getBlobContainer().children().get("indices");
        Map indices = indicesContainer == null ? Collections.emptyMap() : indicesContainer.children();
        HashMap<IndexId, Integer> maxShardCountsExpected = new HashMap<IndexId, Integer>();
        HashMap<IndexId, Integer> maxShardCountsSeen = new HashMap<IndexId, Integer>();
        for (SnapshotId snapshotId : snapshotIds) {
            SnapshotInfo snapshotInfo = repository.getSnapshotInfo(snapshotId);
            for (String index : snapshotInfo.indices()) {
                IndexId indexId2 = repositoryData.resolveIndexId(index);
                Assert.assertThat((Object)indices, (Matcher)Matchers.hasKey((Object)indexId2.getId()));
                BlobContainer indexContainer = (BlobContainer)indices.get(indexId2.getId());
                Assert.assertThat((Object)indexContainer.listBlobs(), (Matcher)Matchers.hasKey((Object)String.format(Locale.ROOT, "meta-%s.dat", repositoryData.indexMetaDataGenerations().indexMetaBlobId(snapshotId, indexId2))));
                IndexMetadata indexMetadata = repository.getSnapshotIndexMetaData(repositoryData, snapshotId, indexId2);
                for (Map.Entry entry : indexContainer.children().entrySet()) {
                    if (((String)entry.getKey()).startsWith("extra")) continue;
                    int shardId = Integer.parseInt((String)entry.getKey());
                    int shardCount = indexMetadata.getNumberOfShards();
                    maxShardCountsExpected.compute(indexId2, (i, existing) -> existing == null || existing < shardCount ? shardCount : existing);
                    BlobContainer shardContainer = (BlobContainer)entry.getValue();
                    if (shardContainer.listBlobs().keySet().stream().anyMatch(blob -> !blob.startsWith("extra"))) {
                        int impliedCount = shardId - 1;
                        maxShardCountsSeen.compute(indexId2, (i, existing) -> existing == null || existing < impliedCount ? impliedCount : existing);
                    }
                    if (shardId >= shardCount || !snapshotInfo.shardFailures().stream().noneMatch(shardFailure -> shardFailure.index().equals(index) && shardFailure.shardId() == shardId)) continue;
                    Map shardPathContents = shardContainer.listBlobs();
                    Assert.assertTrue((shardPathContents.containsKey(String.format(Locale.ROOT, "shallow-snap-%s.dat", snapshotId.getUUID())) || shardPathContents.containsKey(String.format(Locale.ROOT, "snap-%s.dat", snapshotId.getUUID())) ? 1 : 0) != 0);
                    Assert.assertThat((Object)shardPathContents.keySet().stream().filter(name -> name.startsWith("index-")).count(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(2L)));
                }
            }
        }
        maxShardCountsSeen.forEach((indexId, count) -> Assert.assertThat((String)("Found unreferenced shard paths for index [" + String.valueOf(indexId) + "]"), (Object)count, (Matcher)Matchers.lessThanOrEqualTo((Comparable)((Integer)maxShardCountsExpected.get(indexId)))));
    }

    public static long createDanglingIndex(BlobStoreRepository repository, String name, Set<String> files) throws InterruptedException, ExecutionException {
        PlainActionFuture future = PlainActionFuture.newFuture();
        AtomicLong totalSize = new AtomicLong();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.run((ActionListener)future, () -> {
            BlobStore blobStore = repository.blobStore();
            BlobContainer container = blobStore.blobContainer(repository.basePath().add("indices").add(name));
            for (String file : files) {
                int size = OpenSearchTestCase.randomIntBetween(0, 10);
                totalSize.addAndGet(size);
                container.writeBlob(file, (InputStream)new ByteArrayInputStream(new byte[size]), (long)size, false);
            }
        }));
        future.get();
        return totalSize.get();
    }

    public static void assertCorruptionVisible(BlobStoreRepository repository, Map<String, Set<String>> indexToFiles) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> {
            BlobStore blobStore = repository.blobStore();
            for (String index : indexToFiles.keySet()) {
                if (!blobStore.blobContainer(repository.basePath().add("indices")).children().containsKey(index)) {
                    return false;
                }
                for (String file : (Set)indexToFiles.get(index)) {
                    try {
                        InputStream ignored = blobStore.blobContainer(repository.basePath().add("indices").add(index)).readBlob(file);
                        if (ignored == null) continue;
                        ignored.close();
                    }
                    catch (NoSuchFileException e) {
                        return false;
                    }
                }
            }
            return true;
        }));
        Assert.assertTrue((boolean)((Boolean)future.actionGet()));
    }

    public static void assertBlobsByPrefix(BlobStoreRepository repository, BlobPath path, String prefix, Map<String, BlobMetadata> blobs) {
        PlainActionFuture future = PlainActionFuture.newFuture();
        repository.threadPool().generic().execute((Runnable)ActionRunnable.supply((ActionListener)future, () -> repository.blobStore().blobContainer(path).listBlobsByPrefix(prefix)));
        Map foundBlobs = (Map)future.actionGet();
        if (blobs.isEmpty()) {
            Assert.assertThat(foundBlobs.keySet(), (Matcher)Matchers.empty());
        } else {
            Assert.assertThat(foundBlobs.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])blobs.keySet().toArray(Strings.EMPTY_ARRAY)));
            for (Map.Entry entry : foundBlobs.entrySet()) {
                Assert.assertEquals((long)((BlobMetadata)entry.getValue()).length(), (long)blobs.get(entry.getKey()).length());
            }
        }
    }

    public static ClusterService mockClusterService() {
        return BlobStoreTestUtil.mockClusterService(ClusterState.EMPTY_STATE);
    }

    public static ClusterService mockClusterService(RepositoryMetadata metadata) {
        return BlobStoreTestUtil.mockClusterService(ClusterState.builder((ClusterState)ClusterState.EMPTY_STATE).metadata(Metadata.builder().putCustom("repositories", (Metadata.Custom)new RepositoriesMetadata(Collections.singletonList(metadata))).build()).build());
    }

    private static ClusterService mockClusterService(ClusterState initialState) {
        ThreadPool threadPool = (ThreadPool)Mockito.mock(ThreadPool.class);
        Mockito.when((Object)threadPool.executor("snapshot")).thenReturn((Object)new SameThreadExecutorService());
        Mockito.when((Object)threadPool.generic()).thenReturn((Object)new SameThreadExecutorService());
        Mockito.when((Object)threadPool.info("snapshot")).thenReturn((Object)new ThreadPool.Info("snapshot", ThreadPool.ThreadPoolType.FIXED, OpenSearchTestCase.randomIntBetween(1, 10)));
        ClusterService clusterService = (ClusterService)Mockito.mock(ClusterService.class);
        ClusterApplierService clusterApplierService = (ClusterApplierService)Mockito.mock(ClusterApplierService.class);
        Mockito.when((Object)clusterService.getClusterApplierService()).thenReturn((Object)clusterApplierService);
        DiscoveryNode localNode = new DiscoveryNode("", OpenSearchTestCase.buildNewFakeTransportAddress(), Version.CURRENT);
        AtomicReference<ClusterState> currentState = new AtomicReference<ClusterState>(ClusterState.builder((ClusterState)initialState).nodes(DiscoveryNodes.builder().add(localNode).clusterManagerNodeId(localNode.getId()).localNodeId(localNode.getId()).build()).build());
        Mockito.when((Object)clusterService.state()).then(invocationOnMock -> currentState.get());
        CopyOnWriteArrayList appliers = new CopyOnWriteArrayList();
        ((ClusterService)Mockito.doAnswer(invocation -> {
            ClusterStateUpdateTask task = (ClusterStateUpdateTask)invocation.getArguments()[1];
            ClusterState current = (ClusterState)currentState.get();
            ClusterState next = task.execute(current);
            currentState.set(next);
            appliers.forEach(applier -> applier.applyClusterState(new ClusterChangedEvent((String)invocation.getArguments()[0], next, current)));
            task.clusterStateProcessed((String)invocation.getArguments()[0], current, next);
            return null;
        }).when((Object)clusterService)).submitStateUpdateTask(Mockito.anyString(), (ClusterStateTaskConfig)((ClusterStateUpdateTask)Mockito.any(ClusterStateUpdateTask.class)));
        ((ClusterService)Mockito.doAnswer(invocation -> {
            appliers.add((ClusterStateApplier)invocation.getArguments()[0]);
            return null;
        }).when((Object)clusterService)).addStateApplier((ClusterStateApplier)Mockito.any(ClusterStateApplier.class));
        Mockito.when((Object)clusterApplierService.threadPool()).thenReturn((Object)threadPool);
        return clusterService;
    }

    private static boolean isRemoteSnapshot(BlobStoreRepository repository, RepositoryData repositoryData, IndexId indexId) throws IOException {
        Collection snapshotIds = repositoryData.getSnapshotIds();
        for (SnapshotId snapshotId : snapshotIds) {
            try {
                if (!BlobStoreTestUtil.isRemoteSnapshot(repository.getSnapshotIndexMetaData(repositoryData, snapshotId, indexId))) continue;
                return true;
            }
            catch (SnapshotMissingException snapshotMissingException) {
            }
        }
        return false;
    }

    private static boolean isRemoteSnapshot(IndexMetadata metadata) {
        String storeType = metadata.getSettings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey());
        return storeType != null && storeType.equals(IndexModule.Type.REMOTE_SNAPSHOT.getSettingsKey());
    }
}

