/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NormsFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.tests.index.RandomIndexWriter;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.SetOnce;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.indices.breaker.CircuitBreakerService;
import org.opensearch.core.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.mapper.DocValueFetcher;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperParsingException;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.MapperServiceTestCase;
import org.opensearch.index.mapper.ParseContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.lookup.SearchLookup;

public abstract class MapperTestCase
extends MapperServiceTestCase {
    protected abstract void minimalMapping(XContentBuilder var1) throws IOException;

    protected void writeField(XContentBuilder builder) throws IOException {
        builder.field("field");
        this.writeFieldValue(builder);
    }

    protected abstract void writeFieldValue(XContentBuilder var1) throws IOException;

    public final void testExistsQueryMinimalMapping() throws IOException {
        MapperService mapperService = this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        this.assertExistsQuery(mapperService);
        this.assertParseMinimalWarnings();
    }

    protected void assertExistsQuery(MapperService mapperService) throws IOException {
        ParseContext.Document fields = mapperService.documentMapper().parse(this.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::writeField))).rootDoc();
        QueryShardContext queryShardContext = this.createQueryShardContext(mapperService);
        MappedFieldType fieldType = mapperService.fieldType("field");
        Query query = fieldType.existsQuery(queryShardContext);
        this.assertExistsQuery(fieldType, query, fields);
    }

    protected void assertExistsQuery(MappedFieldType fieldType, Query query, ParseContext.Document fields) {
        if (fieldType.hasDocValues()) {
            MapperTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(DocValuesFieldExistsQuery.class));
            DocValuesFieldExistsQuery fieldExistsQuery = (DocValuesFieldExistsQuery)query;
            MapperTestCase.assertEquals((Object)"field", (Object)fieldExistsQuery.getField());
            MapperTestCase.assertDocValuesField(fields, "field");
            MapperTestCase.assertNoFieldNamesField(fields);
        } else if (fieldType.getTextSearchInfo().hasNorms()) {
            MapperTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(NormsFieldExistsQuery.class));
            NormsFieldExistsQuery normsFieldExistsQuery = (NormsFieldExistsQuery)query;
            MapperTestCase.assertEquals((Object)"field", (Object)normsFieldExistsQuery.getField());
            MapperTestCase.assertHasNorms(fields, "field");
            MapperTestCase.assertNoDocValuesField(fields, "field");
            MapperTestCase.assertNoFieldNamesField(fields);
        } else {
            MapperTestCase.assertThat((Object)query, (Matcher)Matchers.instanceOf(TermQuery.class));
            TermQuery termQuery = (TermQuery)query;
            MapperTestCase.assertEquals((Object)"_field_names", (Object)termQuery.getTerm().field());
            MapperTestCase.assertEquals((Object)"field", (Object)termQuery.getTerm().text());
            MapperTestCase.assertNoDocValuesField(fields, "field");
            if (fieldType.isSearchable() || fieldType.isStored()) {
                MapperTestCase.assertNotNull((Object)fields.getField("_field_names"));
            } else {
                MapperTestCase.assertNoFieldNamesField(fields);
            }
        }
    }

    protected static void assertNoFieldNamesField(ParseContext.Document fields) {
        MapperTestCase.assertNull((Object)fields.getField("_field_names"));
    }

    protected static void assertHasNorms(ParseContext.Document doc, String field) {
        IndexableField[] fields;
        for (IndexableField indexableField : fields = doc.getFields(field)) {
            IndexableFieldType indexableFieldType = indexableField.fieldType();
            if (indexableFieldType.indexOptions() == IndexOptions.NONE) continue;
            MapperTestCase.assertFalse((boolean)indexableFieldType.omitNorms());
            return;
        }
        MapperTestCase.fail((String)("field [" + field + "] should be indexed but it isn't"));
    }

    protected static void assertDocValuesField(ParseContext.Document doc, String field) {
        IndexableField[] fields;
        for (IndexableField indexableField : fields = doc.getFields(field)) {
            if (indexableField.fieldType().docValuesType().equals((Object)DocValuesType.NONE)) continue;
            return;
        }
        MapperTestCase.fail((String)("doc_values not present for field [" + field + "]"));
    }

    protected static void assertNoDocValuesField(ParseContext.Document doc, String field) {
        IndexableField[] fields;
        for (IndexableField indexableField : fields = doc.getFields(field)) {
            MapperTestCase.assertEquals((Object)DocValuesType.NONE, (Object)indexableField.fieldType().docValuesType());
        }
    }

    public final void testEmptyName() {
        MapperParsingException e = (MapperParsingException)MapperTestCase.expectThrows(MapperParsingException.class, () -> this.createMapperService(this.mapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            b.startObject("");
            this.minimalMapping((XContentBuilder)b);
            b.endObject();
        }))));
        MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"name cannot be empty string"));
        this.assertParseMinimalWarnings();
    }

    public final void testMinimalSerializesToItself() throws IOException {
        XContentBuilder orig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper().mapping().toXContent(orig, ToXContent.EMPTY_PARAMS);
        orig.endObject();
        XContentBuilder parsedFromOrig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(orig).documentMapper().mapping().toXContent(parsedFromOrig, ToXContent.EMPTY_PARAMS);
        parsedFromOrig.endObject();
        MapperTestCase.assertEquals((Object)orig.toString(), (Object)parsedFromOrig.toString());
        this.assertParseMinimalWarnings();
    }

    public void testMinimalToMaximal() throws IOException {
        XContentBuilder orig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping))).documentMapper().mapping().toXContent(orig, INCLUDE_DEFAULTS);
        orig.endObject();
        XContentBuilder parsedFromOrig = JsonXContent.contentBuilder().startObject();
        this.createMapperService(orig).documentMapper().mapping().toXContent(parsedFromOrig, INCLUDE_DEFAULTS);
        parsedFromOrig.endObject();
        MapperTestCase.assertEquals((Object)orig.toString(), (Object)parsedFromOrig.toString());
        this.assertParseMaximalWarnings();
    }

    protected void assertParseMinimalWarnings() {
    }

    protected void assertParseMaximalWarnings() {
    }

    protected boolean supportsMeta() {
        return true;
    }

    protected void metaMapping(XContentBuilder b) throws IOException {
        this.minimalMapping(b);
    }

    public void testMeta() throws IOException {
        MapperTestCase.assumeTrue((String)"Field doesn't support meta", (boolean)this.supportsMeta());
        XContentBuilder mapping = this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.metaMapping((XContentBuilder)b);
            b.field("meta", Collections.singletonMap("foo", "bar"));
        }));
        MapperService mapperService = this.createMapperService(mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (MediaType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (MediaType)mapping.contentType()).v2());
        mapping = this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::metaMapping));
        this.merge(mapperService, mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (MediaType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (MediaType)mapping.contentType()).v2());
        mapping = this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.metaMapping((XContentBuilder)b);
            b.field("meta", Collections.singletonMap("baz", "quux"));
        }));
        this.merge(mapperService, mapping);
        MapperTestCase.assertEquals((Object)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)mapping), (boolean)false, (MediaType)mapping.contentType()).v2(), (Object)XContentHelper.convertToMap((BytesReference)mapperService.documentMapper().mappingSource().uncompressed(), (boolean)false, (MediaType)mapping.contentType()).v2());
    }

    protected String typeName() throws IOException {
        MapperService ms = this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)this::minimalMapping)));
        return ms.fieldType("field").typeName();
    }

    protected boolean supportsOrIgnoresBoost() {
        return true;
    }

    public void testDeprecatedBoost() throws IOException {
        MapperTestCase.assumeTrue((String)"Does not support [boost] parameter", (boolean)this.supportsOrIgnoresBoost());
        this.createMapperService(this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
            this.minimalMapping((XContentBuilder)b);
            b.field("boost", 2.0);
        })));
        String type = this.typeName();
        String[] warnings = new String[]{"Parameter [boost] on field [field] is deprecated and will be removed in 3.0", "Parameter [boost] has no effect on type [" + type + "] and will be removed in future"};
        this.allowedWarnings(warnings);
    }

    protected final List<?> fetchFromDocValues(MapperService mapperService, MappedFieldType ft, DocValueFormat format, Object sourceValue) throws IOException {
        BiFunction<MappedFieldType, Supplier, IndexFieldData> fieldDataLookup = (mft, lookupSource) -> mft.fielddataBuilder("test", () -> {
            throw new UnsupportedOperationException();
        }).build((IndexFieldDataCache)new IndexFieldDataCache.None(), (CircuitBreakerService)new NoneCircuitBreakerService());
        SetOnce result = new SetOnce();
        this.withLuceneIndex(mapperService, (CheckedConsumer<RandomIndexWriter, IOException>)((CheckedConsumer)iw -> iw.addDocument((Iterable)mapperService.documentMapper().parse(this.source((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> b.field(ft.name(), sourceValue)))).rootDoc())), (CheckedConsumer<IndexReader, IOException>)((CheckedConsumer)iw -> {
            SearchLookup lookup = new SearchLookup(mapperService, fieldDataLookup, -1);
            DocValueFetcher valueFetcher = new DocValueFetcher(format, lookup.doc().getForField(ft));
            IndexSearcher searcher = MapperTestCase.newSearcher((IndexReader)iw);
            LeafReaderContext context = (LeafReaderContext)searcher.getIndexReader().leaves().get(0);
            lookup.source().setSegmentAndDocument(context, 0);
            valueFetcher.setNextReader(context);
            result.set((Object)valueFetcher.fetchValues(lookup.source()));
        }));
        return (List)result.get();
    }

    protected abstract void registerParameters(ParameterChecker var1) throws IOException;

    public void testUpdates() throws IOException {
        MapperService mapperService;
        ParameterChecker checker = new ParameterChecker();
        this.registerParameters(checker);
        for (UpdateCheck updateCheck : checker.updateChecks) {
            mapperService = this.createMapperService(updateCheck.init);
            this.merge(mapperService, updateCheck.update);
            FieldMapper mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
            updateCheck.check.accept(mapper);
            this.merge(mapperService, updateCheck.update);
            mapper = (FieldMapper)mapperService.documentMapper().mappers().getMapper("field");
            updateCheck.check.accept(mapper);
        }
        for (String param : checker.conflictChecks.keySet()) {
            mapperService = this.createMapperService(checker.conflictChecks.get((Object)param).init);
            this.merge(mapperService, checker.conflictChecks.get((Object)param).init);
            Exception e = (Exception)MapperTestCase.expectThrows(IllegalArgumentException.class, (String)("No conflict when updating parameter [" + param + "]"), () -> this.merge(mapperService, checker.conflictChecks.get((Object)param).update));
            MapperTestCase.assertThat((Object)e.getMessage(), (Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)("Cannot update parameter [" + param + "]")), (Matcher)Matchers.containsString((String)("different [" + param + "]"))));
        }
        this.assertParseMaximalWarnings();
    }

    public class ParameterChecker {
        List<UpdateCheck> updateChecks = new ArrayList<UpdateCheck>();
        Map<String, ConflictCheck> conflictChecks = new HashMap<String, ConflictCheck>();

        public void registerUpdateCheck(CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.updateChecks.add(new UpdateCheck(update, check));
        }

        public void registerUpdateCheck(CheckedConsumer<XContentBuilder, IOException> init, CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.updateChecks.add(new UpdateCheck(init, update, check));
        }

        public void registerConflictCheck(String param, CheckedConsumer<XContentBuilder, IOException> update) throws IOException {
            this.conflictChecks.put(param, new ConflictCheck(MapperTestCase.this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)MapperTestCase.this::minimalMapping)), MapperTestCase.this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                MapperTestCase.this.minimalMapping((XContentBuilder)b);
                update.accept(b);
            }))));
        }

        public void registerConflictCheck(String param, XContentBuilder init, XContentBuilder update) {
            this.conflictChecks.put(param, new ConflictCheck(init, update));
        }
    }

    private class UpdateCheck {
        final XContentBuilder init;
        final XContentBuilder update;
        final Consumer<FieldMapper> check;

        private UpdateCheck(CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.init = MapperTestCase.this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)MapperTestCase.this::minimalMapping));
            this.update = MapperTestCase.this.fieldMapping((CheckedConsumer<XContentBuilder, IOException>)((CheckedConsumer)b -> {
                MapperTestCase.this.minimalMapping((XContentBuilder)b);
                update.accept(b);
            }));
            this.check = check;
        }

        private UpdateCheck(CheckedConsumer<XContentBuilder, IOException> init, CheckedConsumer<XContentBuilder, IOException> update, Consumer<FieldMapper> check) throws IOException {
            this.init = MapperTestCase.this.fieldMapping(init);
            this.update = MapperTestCase.this.fieldMapping(update);
            this.check = check;
        }
    }

    private static class ConflictCheck {
        final XContentBuilder init;
        final XContentBuilder update;

        private ConflictCheck(XContentBuilder init, XContentBuilder update) {
            this.init = init;
            this.update = update;
        }
    }
}

