/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.alias;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.opensearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.opensearch.test.OpenSearchTestCase;

public final class RandomAliasActionsGenerator {
    private RandomAliasActionsGenerator() {
    }

    public static IndicesAliasesRequest.AliasActions randomAliasAction() {
        return RandomAliasActionsGenerator.randomAliasAction(false);
    }

    public static IndicesAliasesRequest.AliasActions randomAliasAction(boolean useStringAsFilter) {
        int i;
        IndicesAliasesRequest.AliasActions action = new IndicesAliasesRequest.AliasActions(OpenSearchTestCase.randomFrom(IndicesAliasesRequest.AliasActions.Type.values()));
        if (OpenSearchTestCase.randomBoolean()) {
            action.index(OpenSearchTestCase.randomAlphaOfLength(5));
        } else {
            int numIndices = OpenSearchTestCase.randomIntBetween(1, 5);
            String[] indices = new String[numIndices];
            for (i = 0; i < numIndices; ++i) {
                indices[i] = "index-" + OpenSearchTestCase.randomAlphaOfLengthBetween(2, 5).toLowerCase(Locale.ROOT);
            }
            action.indices(indices);
        }
        if (action.actionType() != IndicesAliasesRequest.AliasActions.Type.REMOVE_INDEX) {
            if (OpenSearchTestCase.randomBoolean()) {
                action.alias(OpenSearchTestCase.randomAlphaOfLength(5));
            } else {
                int numAliases = OpenSearchTestCase.randomIntBetween(1, 5);
                String[] aliases = new String[numAliases];
                for (i = 0; i < numAliases; ++i) {
                    aliases[i] = "alias-" + OpenSearchTestCase.randomAlphaOfLengthBetween(2, 5).toLowerCase(Locale.ROOT);
                }
                action.aliases(aliases);
            }
        }
        if (action.actionType() == IndicesAliasesRequest.AliasActions.Type.ADD) {
            if (OpenSearchTestCase.randomBoolean()) {
                if (useStringAsFilter) {
                    action.filter(OpenSearchTestCase.randomAlphaOfLength(5));
                } else {
                    action.filter(RandomAliasActionsGenerator.randomMap(OpenSearchTestCase.randomInt(5)));
                }
            }
            if (OpenSearchTestCase.randomBoolean()) {
                if (OpenSearchTestCase.randomBoolean()) {
                    action.routing(RandomAliasActionsGenerator.randomRouting().toString());
                } else {
                    action.searchRouting(RandomAliasActionsGenerator.randomRouting().toString());
                    action.indexRouting(RandomAliasActionsGenerator.randomRouting().toString());
                }
            }
            if (OpenSearchTestCase.randomBoolean()) {
                action.writeIndex(Boolean.valueOf(OpenSearchTestCase.randomBoolean()));
            }
            if (OpenSearchTestCase.randomBoolean()) {
                action.isHidden(Boolean.valueOf(OpenSearchTestCase.randomBoolean()));
            }
        }
        if (action.actionType() == IndicesAliasesRequest.AliasActions.Type.REMOVE && OpenSearchTestCase.randomBoolean()) {
            action.mustExist(Boolean.valueOf(OpenSearchTestCase.randomBoolean()));
        }
        return action;
    }

    public static Map<String, Object> randomMap(int maxDepth) {
        int members = OpenSearchTestCase.between(0, 5);
        HashMap<String, Object> result = new HashMap<String, Object>(members);
        for (int i = 0; i < members; ++i) {
            Map<String, Object> value;
            switch (OpenSearchTestCase.between(0, 3)) {
                case 0: {
                    if (maxDepth > 0) {
                        value = RandomAliasActionsGenerator.randomMap(maxDepth - 1);
                        break;
                    }
                    value = OpenSearchTestCase.randomAlphaOfLength(5);
                    break;
                }
                case 1: {
                    value = OpenSearchTestCase.randomAlphaOfLength(5);
                    break;
                }
                case 2: {
                    value = OpenSearchTestCase.randomBoolean();
                    break;
                }
                case 3: {
                    value = OpenSearchTestCase.randomLong();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            result.put(OpenSearchTestCase.randomAlphaOfLength(5), value);
        }
        return result;
    }

    public static Object randomRouting() {
        return OpenSearchTestCase.randomBoolean() ? OpenSearchTestCase.randomAlphaOfLength(5) : Integer.valueOf(OpenSearchTestCase.randomInt());
    }
}

