/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.store;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.store.IndexInput;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.util.concurrent.OpenSearchThreadPoolExecutor;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.test.OpenSearchTestCase;

public class OpenSearchIndexInputTestCase
extends OpenSearchTestCase {
    private static OpenSearchThreadPoolExecutor executor;

    @BeforeClass
    public static void createExecutor() {
        String name = "TEST-" + OpenSearchIndexInputTestCase.getTestClass().getSimpleName() + "#randomReadAndSlice";
        executor = OpenSearchExecutors.newFixed((String)name, (int)10, (int)0, (ThreadFactory)OpenSearchExecutors.daemonThreadFactory((String)name), (ThreadContext)new ThreadContext(Settings.EMPTY));
    }

    @AfterClass
    public static void destroyExecutor() {
        executor.shutdown();
    }

    protected byte[] randomReadAndSlice(final IndexInput indexInput, final int length) throws IOException {
        int readPos = (int)indexInput.getFilePointer();
        byte[] output = new byte[length];
        while (readPos < length) {
            switch (OpenSearchIndexInputTestCase.randomIntBetween(0, 5)) {
                case 0: {
                    output[readPos++] = indexInput.readByte();
                    break;
                }
                case 1: {
                    int len = OpenSearchIndexInputTestCase.randomIntBetween(1, length - readPos);
                    indexInput.readBytes(output, readPos, len);
                    readPos += len;
                    break;
                }
                case 2: {
                    int len = OpenSearchIndexInputTestCase.randomIntBetween(1, length - readPos);
                    byte[] temp = new byte[len];
                    indexInput.readBytes(temp, 0, len);
                    System.arraycopy(temp, 0, output, readPos, len);
                    readPos += len;
                    break;
                }
                case 3: {
                    int len = OpenSearchIndexInputTestCase.randomIntBetween(1, length - readPos);
                    IndexInput slice = indexInput.slice("slice (" + readPos + ", " + len + ") of " + String.valueOf(indexInput), (long)readPos, (long)len);
                    byte[] temp = this.randomReadAndSlice(slice, len);
                    OpenSearchIndexInputTestCase.assertEquals((long)readPos, (long)indexInput.getFilePointer());
                    System.arraycopy(temp, 0, output, readPos, len);
                    indexInput.seek((long)(readPos += len));
                    OpenSearchIndexInputTestCase.assertEquals((long)readPos, (long)indexInput.getFilePointer());
                    break;
                }
                case 4: {
                    int lastReadPos = readPos;
                    readPos = OpenSearchIndexInputTestCase.randomIntBetween(0, length - 1);
                    indexInput.seek((long)readPos);
                    OpenSearchIndexInputTestCase.assertEquals((long)readPos, (long)indexInput.getFilePointer());
                    boolean bytesToRead = true;
                    byte[] temp = this.randomReadAndSlice(indexInput, readPos + 1);
                    System.arraycopy(temp, readPos, output, readPos, 1);
                    readPos = lastReadPos;
                    indexInput.seek((long)readPos);
                    OpenSearchIndexInputTestCase.assertEquals((long)readPos, (long)indexInput.getFilePointer());
                    break;
                }
                case 5: {
                    int cloneCount = OpenSearchIndexInputTestCase.between(1, 3);
                    final CountDownLatch startLatch = new CountDownLatch(1 + cloneCount);
                    final CountDownLatch finishLatch = new CountDownLatch(cloneCount);
                    final PlainActionFuture mainThreadResultFuture = new PlainActionFuture();
                    final int mainThreadReadStart = readPos;
                    final int mainThreadReadEnd = OpenSearchIndexInputTestCase.randomIntBetween(readPos + 1, length);
                    for (int i = 0; i < cloneCount; ++i) {
                        executor.execute((Runnable)new AbstractRunnable(){

                            public void onFailure(Exception e) {
                                throw new AssertionError((Object)e);
                            }

                            protected void doRun() throws Exception {
                                int minEnd;
                                int maxStart;
                                IndexInput clone;
                                int readStart = OpenSearchTestCase.between(0, length);
                                int readEnd = OpenSearchTestCase.between(readStart, length);
                                if (OpenSearchTestCase.randomBoolean()) {
                                    clone = indexInput.clone();
                                } else {
                                    int sliceEnd = OpenSearchTestCase.between(readEnd, length);
                                    clone = indexInput.slice("concurrent slice (0, " + sliceEnd + ") of " + String.valueOf(indexInput), 0L, (long)sliceEnd);
                                }
                                startLatch.countDown();
                                startLatch.await();
                                clone.seek((long)readStart);
                                byte[] cloneResult = OpenSearchIndexInputTestCase.this.randomReadAndSlice(clone, readEnd);
                                if (OpenSearchTestCase.randomBoolean()) {
                                    clone.close();
                                }
                                if ((maxStart = Math.max(mainThreadReadStart, readStart)) < (minEnd = Math.min(mainThreadReadEnd, readEnd))) {
                                    byte[] mainThreadResult = (byte[])mainThreadResultFuture.actionGet();
                                    int overlapLen = minEnd - maxStart;
                                    byte[] fromMainThread = new byte[overlapLen];
                                    byte[] fromClone = new byte[overlapLen];
                                    System.arraycopy(mainThreadResult, maxStart, fromMainThread, 0, overlapLen);
                                    System.arraycopy(cloneResult, maxStart, fromClone, 0, overlapLen);
                                    Assert.assertArrayEquals((byte[])fromMainThread, (byte[])fromClone);
                                }
                            }

                            public void onAfter() {
                                finishLatch.countDown();
                            }

                            public void onRejection(Exception e) {
                                startLatch.countDown();
                            }
                        });
                    }
                    try {
                        startLatch.countDown();
                        startLatch.await();
                        ActionListener.completeWith((ActionListener)mainThreadResultFuture, () -> this.randomReadAndSlice(indexInput, mainThreadReadEnd));
                        System.arraycopy(mainThreadResultFuture.actionGet(), readPos, output, readPos, mainThreadReadEnd - readPos);
                        readPos = mainThreadReadEnd;
                        finishLatch.await();
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                default: {
                    OpenSearchIndexInputTestCase.fail();
                }
            }
            OpenSearchIndexInputTestCase.assertEquals((long)readPos, (long)indexInput.getFilePointer());
        }
        OpenSearchIndexInputTestCase.assertEquals((long)length, (long)indexInput.getFilePointer());
        return output;
    }
}

