/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.coordination;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.tests.util.LuceneTestCase;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.coordination.ApplyCommitRequest;
import org.opensearch.cluster.coordination.CoordinationMetadata;
import org.opensearch.cluster.coordination.CoordinationState;
import org.opensearch.cluster.coordination.CoordinationStateRejectedException;
import org.opensearch.cluster.coordination.ElectionStrategy;
import org.opensearch.cluster.coordination.InMemoryPersistedState;
import org.opensearch.cluster.coordination.Join;
import org.opensearch.cluster.coordination.PersistedStateRegistry;
import org.opensearch.cluster.coordination.PublishRequest;
import org.opensearch.cluster.coordination.PublishResponse;
import org.opensearch.cluster.coordination.StartJoinRequest;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodeRole;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.common.UUIDs;
import org.opensearch.common.settings.Settings;
import org.opensearch.test.OpenSearchTestCase;

public class CoordinationStateTestCluster {
    final ElectionStrategy electionStrategy;
    final List<Message> messages;
    final List<ClusterNode> clusterNodes;
    final CoordinationMetadata.VotingConfiguration initialConfiguration;
    final long initialValue;

    public static ClusterState clusterState(long term, long version, DiscoveryNode localNode, CoordinationMetadata.VotingConfiguration lastCommittedConfig, CoordinationMetadata.VotingConfiguration lastAcceptedConfig, long value) {
        return CoordinationStateTestCluster.clusterState(term, version, DiscoveryNodes.builder().add(localNode).localNodeId(localNode.getId()).build(), lastCommittedConfig, lastAcceptedConfig, value);
    }

    public static ClusterState clusterState(long term, long version, DiscoveryNodes discoveryNodes, CoordinationMetadata.VotingConfiguration lastCommittedConfig, CoordinationMetadata.VotingConfiguration lastAcceptedConfig, long value) {
        return CoordinationStateTestCluster.setValue(ClusterState.builder((ClusterName)ClusterName.DEFAULT).version(version).nodes(discoveryNodes).metadata(Metadata.builder().clusterUUID(UUIDs.randomBase64UUID((Random)LuceneTestCase.random())).coordinationMetadata(CoordinationMetadata.builder().term(term).lastCommittedConfiguration(lastCommittedConfig).lastAcceptedConfiguration(lastAcceptedConfig).build())).stateUUID(UUIDs.randomBase64UUID((Random)LuceneTestCase.random())).build(), value);
    }

    public static ClusterState setValue(ClusterState clusterState, long value) {
        return ClusterState.builder((ClusterState)clusterState).metadata(Metadata.builder((Metadata)clusterState.metadata()).persistentSettings(Settings.builder().put(clusterState.metadata().persistentSettings()).put("value", value).build()).build()).build();
    }

    public static long value(ClusterState clusterState) {
        return clusterState.metadata().persistentSettings().getAsLong("value", Long.valueOf(0L));
    }

    CoordinationStateTestCluster(List<DiscoveryNode> nodes, ElectionStrategy electionStrategy) {
        this.electionStrategy = electionStrategy;
        this.messages = new ArrayList<Message>();
        this.clusterNodes = nodes.stream().map(node -> new ClusterNode((DiscoveryNode)node, electionStrategy)).collect(Collectors.toList());
        this.initialConfiguration = this.randomVotingConfig();
        this.initialValue = OpenSearchTestCase.randomLong();
    }

    void reply(Message m, Object payload) {
        this.messages.add(new Message(m.targetNode, m.sourceNode, payload));
    }

    void broadcast(DiscoveryNode sourceNode, Object payload) {
        this.messages.addAll(this.clusterNodes.stream().map(cn -> new Message(sourceNode, cn.localNode, payload)).collect(Collectors.toList()));
    }

    Optional<ClusterNode> getNode(DiscoveryNode node) {
        return this.clusterNodes.stream().filter(cn -> cn.localNode.equals((Object)node)).findFirst();
    }

    CoordinationMetadata.VotingConfiguration randomVotingConfig() {
        return new CoordinationMetadata.VotingConfiguration(OpenSearchTestCase.randomSubsetOf(OpenSearchTestCase.randomIntBetween(1, this.clusterNodes.size()), this.clusterNodes).stream().map(cn -> cn.localNode.getId()).collect(Collectors.toSet()));
    }

    void applyMessage(Message message) {
        Optional<ClusterNode> maybeNode = this.getNode(message.targetNode);
        if (!maybeNode.isPresent()) {
            throw new CoordinationStateRejectedException("node not available", new Object[0]);
        }
        Object payload = message.payload;
        if (payload instanceof StartJoinRequest) {
            this.reply(message, maybeNode.get().state.handleStartJoin((StartJoinRequest)payload));
        } else if (payload instanceof Join) {
            maybeNode.get().state.handleJoin((Join)payload);
        } else if (payload instanceof PublishRequest) {
            this.reply(message, maybeNode.get().state.handlePublishRequest((PublishRequest)payload));
        } else if (payload instanceof PublishResponse) {
            maybeNode.get().state.handlePublishResponse(message.sourceNode, (PublishResponse)payload).ifPresent(ac -> this.broadcast(message.targetNode, ac));
        } else if (payload instanceof ApplyCommitRequest) {
            maybeNode.get().state.handleCommit((ApplyCommitRequest)payload);
        } else {
            throw new AssertionError((Object)"unknown message type");
        }
    }

    void runRandomly() {
        int iterations = 10000;
        long maxTerm = 4L;
        long nextTerm = 1L;
        for (int i = 0; i < 10000; ++i) {
            try {
                if (RandomizedTest.rarely() && nextTerm < 4L) {
                    long l;
                    if (RandomizedTest.rarely()) {
                        l = OpenSearchTestCase.randomLongBetween(0L, 5L);
                    } else {
                        long l2 = nextTerm;
                        l = l2;
                        nextTerm = l2 + 1L;
                    }
                    long term = l;
                    StartJoinRequest startJoinRequest = new StartJoinRequest(OpenSearchTestCase.randomFrom(this.clusterNodes).localNode, term);
                    this.broadcast(startJoinRequest.getSourceNode(), startJoinRequest);
                } else if (RandomizedTest.rarely()) {
                    OpenSearchTestCase.randomFrom(this.clusterNodes).setInitialState(this.initialConfiguration, this.initialValue);
                } else if (RandomizedTest.rarely() && RandomizedTest.rarely()) {
                    OpenSearchTestCase.randomFrom(this.clusterNodes).reboot();
                } else if (RandomizedTest.rarely()) {
                    List clusterManangerNodes = this.clusterNodes.stream().filter(cn -> cn.state.electionWon()).collect(Collectors.toList());
                    if (!clusterManangerNodes.isEmpty()) {
                        ClusterNode clusterNode = (ClusterNode)OpenSearchTestCase.randomFrom(clusterManangerNodes);
                        long term = RandomizedTest.rarely() ? OpenSearchTestCase.randomLongBetween(0L, 5L) : clusterNode.state.getCurrentTerm();
                        long version = RandomizedTest.rarely() ? (long)OpenSearchTestCase.randomIntBetween(0, 5) : clusterNode.state.getLastPublishedVersion() + 1L;
                        CoordinationMetadata.VotingConfiguration acceptedConfig = RandomizedTest.rarely() ? this.randomVotingConfig() : clusterNode.state.getLastAcceptedConfiguration();
                        PublishRequest publishRequest = clusterNode.state.handleClientValue(CoordinationStateTestCluster.clusterState(term, version, clusterNode.localNode, clusterNode.state.getLastCommittedConfiguration(), acceptedConfig, OpenSearchTestCase.randomLong()));
                        this.broadcast(clusterNode.localNode, publishRequest);
                    }
                } else if (!this.messages.isEmpty()) {
                    this.applyMessage(OpenSearchTestCase.randomFrom(this.messages));
                }
                this.clusterNodes.forEach(cn -> cn.state.invariant());
                continue;
            }
            catch (CoordinationStateRejectedException coordinationStateRejectedException) {
                // empty catch block
            }
        }
        this.invariant();
    }

    void invariant() {
        this.messages.stream().filter(m -> m.payload instanceof PublishRequest).collect(Collectors.groupingBy(m -> ((PublishRequest)m.payload).getAcceptedState().term())).forEach((term, publishMessages) -> {
            Set<DiscoveryNode> clusterManagersForTerm = publishMessages.stream().collect(Collectors.groupingBy(m -> m.sourceNode)).keySet();
            Assert.assertThat((String)("Multiple cluster-managers " + String.valueOf(clusterManagersForTerm) + " for term " + term), clusterManagersForTerm, (Matcher)Matchers.hasSize((int)1));
        });
        this.messages.stream().filter(m -> m.payload instanceof PublishRequest).map(m -> ((PublishRequest)m.payload).getAcceptedState()).collect(Collectors.groupingBy(ClusterState::term)).forEach((term, clusterStates) -> clusterStates.stream().collect(Collectors.groupingBy(ClusterState::version)).forEach((version, clusterStates1) -> {
            Set<String> clusterStateUUIDsForTermAndVersion = clusterStates1.stream().collect(Collectors.groupingBy(ClusterState::stateUUID)).keySet();
            Assert.assertThat((String)("Multiple cluster states " + String.valueOf(clusterStates1) + " for term " + term + " and version " + version), clusterStateUUIDsForTermAndVersion, (Matcher)Matchers.hasSize((int)1));
            Set<Long> clusterStateValuesForTermAndVersion = clusterStates1.stream().collect(Collectors.groupingBy(CoordinationStateTestCluster::value)).keySet();
            Assert.assertThat((String)("Multiple cluster states " + String.valueOf(clusterStates1) + " for term " + term + " and version " + version), clusterStateValuesForTermAndVersion, (Matcher)Matchers.hasSize((int)1));
        }));
    }

    static class Message {
        final DiscoveryNode sourceNode;
        final DiscoveryNode targetNode;
        final Object payload;

        Message(DiscoveryNode sourceNode, DiscoveryNode targetNode, Object payload) {
            this.sourceNode = sourceNode;
            this.targetNode = targetNode;
            this.payload = payload;
        }
    }

    static class ClusterNode {
        private final ElectionStrategy electionStrategy;
        DiscoveryNode localNode;
        CoordinationState.PersistedState persistedState;
        PersistedStateRegistry persistedStateRegistry;
        CoordinationState state;

        ClusterNode(DiscoveryNode localNode, ElectionStrategy electionStrategy) {
            this.localNode = localNode;
            this.persistedState = new InMemoryPersistedState(0L, CoordinationStateTestCluster.clusterState(0L, 0L, localNode, CoordinationMetadata.VotingConfiguration.EMPTY_CONFIG, CoordinationMetadata.VotingConfiguration.EMPTY_CONFIG, 0L));
            this.persistedStateRegistry = new PersistedStateRegistry();
            this.persistedStateRegistry.addPersistedState(PersistedStateRegistry.PersistedStateType.LOCAL, this.persistedState);
            this.electionStrategy = electionStrategy;
            this.state = new CoordinationState(localNode, this.persistedStateRegistry, electionStrategy, Settings.EMPTY);
        }

        void reboot() {
            if (!this.localNode.isClusterManagerNode() && RandomizedTest.rarely()) {
                CoordinationMetadata.VotingConfiguration votingConfiguration = this.persistedState.getLastAcceptedState().getLastAcceptedConfiguration().isEmpty() ? CoordinationMetadata.VotingConfiguration.EMPTY_CONFIG : CoordinationMetadata.VotingConfiguration.MUST_JOIN_ELECTED_CLUSTER_MANAGER;
                this.persistedState = new InMemoryPersistedState(0L, CoordinationStateTestCluster.clusterState(0L, 0L, this.localNode, votingConfiguration, votingConfiguration, 0L));
            }
            HashSet<DiscoveryNodeRole> roles = new HashSet<DiscoveryNodeRole>(this.localNode.getRoles());
            if (OpenSearchTestCase.randomBoolean()) {
                if (roles.contains(DiscoveryNodeRole.CLUSTER_MANAGER_ROLE)) {
                    roles.remove(DiscoveryNodeRole.CLUSTER_MANAGER_ROLE);
                } else {
                    roles.add(DiscoveryNodeRole.CLUSTER_MANAGER_ROLE);
                }
            }
            this.localNode = new DiscoveryNode(this.localNode.getName(), this.localNode.getId(), UUIDs.randomBase64UUID((Random)LuceneTestCase.random()), this.localNode.getHostName(), this.localNode.getHostAddress(), this.localNode.getAddress(), this.localNode.getAttributes(), roles, this.localNode.getVersion());
            this.state = new CoordinationState(this.localNode, this.persistedStateRegistry, this.electionStrategy, Settings.EMPTY);
        }

        void setInitialState(CoordinationMetadata.VotingConfiguration initialConfig, long initialValue) {
            ClusterState.Builder builder = ClusterState.builder((ClusterState)this.state.getLastAcceptedState());
            builder.metadata(Metadata.builder().coordinationMetadata(CoordinationMetadata.builder().lastAcceptedConfiguration(initialConfig).lastCommittedConfiguration(initialConfig).build()));
            this.state.setInitialState(CoordinationStateTestCluster.setValue(builder.build(), initialValue));
        }
    }
}

