/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.percolator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.opensearch.Version;
import org.opensearch.common.document.DocumentField;
import org.opensearch.common.lucene.search.Queries;
import org.opensearch.percolator.PercolateQuery;
import org.opensearch.percolator.PercolatorHighlightSubFetchPhase;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;

final class PercolatorMatchedSlotSubFetchPhase
implements FetchSubPhase {
    static final String FIELD_NAME_PREFIX = "_percolator_document_slot";

    PercolatorMatchedSlotSubFetchPhase() {
    }

    public FetchSubPhaseProcessor getProcessor(FetchContext fetchContext) throws IOException {
        final ArrayList<PercolateContext> percolateContexts = new ArrayList<PercolateContext>();
        List<PercolateQuery> percolateQueries = PercolatorHighlightSubFetchPhase.locatePercolatorQuery(fetchContext.query());
        boolean singlePercolateQuery = percolateQueries.size() == 1;
        for (PercolateQuery pq : percolateQueries) {
            percolateContexts.add(new PercolateContext(pq, singlePercolateQuery));
        }
        if (percolateContexts.isEmpty()) {
            return null;
        }
        return new FetchSubPhaseProcessor(){
            LeafReaderContext ctx;

            public void setNextReader(LeafReaderContext readerContext) {
                this.ctx = readerContext;
            }

            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                for (PercolateContext pc : percolateContexts) {
                    String fieldName = pc.fieldName();
                    Query query = (Query)pc.percolateQuery.getQueryStore().getQueries(this.ctx).apply((Object)hitContext.docId());
                    if (query == null) continue;
                    query = pc.filterNestedDocs(query);
                    IndexSearcher percolatorIndexSearcher = pc.percolateQuery.getPercolatorIndexSearcher();
                    int memoryIndexMaxDoc = percolatorIndexSearcher.getIndexReader().maxDoc();
                    TopFieldDocs topDocs = percolatorIndexSearcher.search(query, memoryIndexMaxDoc, new Sort(SortField.FIELD_DOC));
                    if (topDocs.totalHits.value == 0L) continue;
                    IntStream slots = PercolatorMatchedSlotSubFetchPhase.convertTopDocsToSlots((TopDocs)topDocs, pc.rootDocsBySlot);
                    hitContext.hit().setDocumentField(fieldName, new DocumentField(fieldName, slots.boxed().collect(Collectors.toList())));
                }
            }
        };
    }

    static IntStream convertTopDocsToSlots(TopDocs topDocs, int[] rootDocsBySlot) {
        IntStream stream = Arrays.stream(topDocs.scoreDocs).mapToInt(scoreDoc -> scoreDoc.doc);
        if (rootDocsBySlot != null) {
            stream = stream.map(docId -> Arrays.binarySearch(rootDocsBySlot, docId));
        }
        return stream;
    }

    static int[] buildRootDocsSlots(BitSet rootDocs) {
        int slot = 0;
        int[] rootDocsBySlot = new int[rootDocs.cardinality()];
        BitSetIterator iterator = new BitSetIterator(rootDocs, 0L);
        int rootDocId = iterator.nextDoc();
        while (rootDocId != Integer.MAX_VALUE) {
            rootDocsBySlot[slot++] = rootDocId;
            rootDocId = iterator.nextDoc();
        }
        return rootDocsBySlot;
    }

    static class PercolateContext {
        final PercolateQuery percolateQuery;
        final boolean singlePercolateQuery;
        final int[] rootDocsBySlot;

        PercolateContext(PercolateQuery pq, boolean singlePercolateQuery) throws IOException {
            this.percolateQuery = pq;
            this.singlePercolateQuery = singlePercolateQuery;
            IndexSearcher percolatorIndexSearcher = this.percolateQuery.getPercolatorIndexSearcher();
            Query nonNestedFilter = percolatorIndexSearcher.rewrite(Queries.newNonNestedFilter((Version)Version.CURRENT));
            Weight weight = percolatorIndexSearcher.createWeight(nonNestedFilter, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer s = weight.scorer((LeafReaderContext)percolatorIndexSearcher.getIndexReader().leaves().get(0));
            int memoryIndexMaxDoc = percolatorIndexSearcher.getIndexReader().maxDoc();
            BitSet rootDocs = BitSet.of((DocIdSetIterator)s.iterator(), (int)memoryIndexMaxDoc);
            boolean hasNestedDocs = rootDocs.cardinality() != percolatorIndexSearcher.getIndexReader().numDocs();
            this.rootDocsBySlot = (int[])(hasNestedDocs ? PercolatorMatchedSlotSubFetchPhase.buildRootDocsSlots(rootDocs) : null);
        }

        String fieldName() {
            return this.singlePercolateQuery ? PercolatorMatchedSlotSubFetchPhase.FIELD_NAME_PREFIX : "_percolator_document_slot_" + this.percolateQuery.getName();
        }

        Query filterNestedDocs(Query in) {
            if (this.rootDocsBySlot != null) {
                return new BooleanQuery.Builder().add(in, BooleanClause.Occur.MUST).add(Queries.newNonNestedFilter((Version)Version.CURRENT), BooleanClause.Occur.FILTER).build();
            }
            return in;
        }
    }
}

