/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.percolator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchException;
import org.opensearch.ResourceNotFoundException;
import org.opensearch.Version;
import org.opensearch.action.ActionListener;
import org.opensearch.action.get.GetRequest;
import org.opensearch.common.ParseField;
import org.opensearch.common.bytes.BytesReference;
import org.opensearch.common.io.stream.InputStreamStreamInput;
import org.opensearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.opensearch.common.io.stream.NamedWriteableRegistry;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.xcontent.ConstructingObjectParser;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.analysis.FieldNameAnalyzer;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.fielddata.IndexFieldDataCache;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.mapper.ParsedDocument;
import org.opensearch.index.mapper.SourceToParse;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.index.query.Rewriteable;
import org.opensearch.indices.breaker.CircuitBreakerService;
import org.opensearch.indices.breaker.NoneCircuitBreakerService;
import org.opensearch.percolator.PercolateQuery;
import org.opensearch.percolator.PercolatorFieldMapper;
import org.opensearch.search.SearchService;

public class PercolateQueryBuilder
extends AbstractQueryBuilder<PercolateQueryBuilder> {
    public static final String NAME = "percolate";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ParseField.class);
    static final String DOCUMENT_TYPE_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [percolate] queries. The [document_type] should no longer be specified.";
    static final String TYPE_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [percolate] queries. The [type] of the indexed document should no longer be specified.";
    static final ParseField DOCUMENT_FIELD = new ParseField("document", new String[0]);
    static final ParseField DOCUMENTS_FIELD = new ParseField("documents", new String[0]);
    private static final ParseField NAME_FIELD = new ParseField("name", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("field", new String[0]);
    private static final ParseField DOCUMENT_TYPE_FIELD = new ParseField("document_type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_INDEX = new ParseField("index", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_TYPE = new ParseField("type", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ID = new ParseField("id", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_PREFERENCE = new ParseField("preference", new String[0]);
    private static final ParseField INDEXED_DOCUMENT_FIELD_VERSION = new ParseField("version", new String[0]);
    private final String field;
    private String name;
    @Deprecated
    private final String documentType;
    private final List<BytesReference> documents;
    private final XContentType documentXContentType;
    private final String indexedDocumentIndex;
    @Deprecated
    private final String indexedDocumentType;
    private final String indexedDocumentId;
    private final String indexedDocumentRouting;
    private final String indexedDocumentPreference;
    private final Long indexedDocumentVersion;
    private final Supplier<BytesReference> documentSupplier;
    private static final ConstructingObjectParser<PercolateQueryBuilder, Void> PARSER = new ConstructingObjectParser("percolate", args -> {
        String field = (String)args[0];
        BytesReference document = (BytesReference)args[1];
        List documents = (List)args[2];
        String indexedDocId = (String)args[3];
        String indexedDocIndex = (String)args[4];
        String indexDocRouting = (String)args[5];
        String indexDocPreference = (String)args[6];
        Long indexedDocVersion = (Long)args[7];
        String indexedDocType = (String)args[8];
        String docType = (String)args[9];
        if (indexedDocId != null) {
            return new PercolateQueryBuilder(field, docType, indexedDocIndex, indexedDocType, indexedDocId, indexDocRouting, indexDocPreference, indexedDocVersion);
        }
        if (document != null) {
            return new PercolateQueryBuilder(field, docType, Collections.singletonList(document), XContentType.JSON);
        }
        return new PercolateQueryBuilder(field, docType, documents, XContentType.JSON);
    });

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, BytesReference document) {
        this(field, documentType, Collections.singletonList(document), XContentHelper.xContentType((BytesReference)document));
    }

    public PercolateQueryBuilder(String field, BytesReference document, XContentType documentXContentType) {
        this(field, null, Collections.singletonList(document), documentXContentType);
    }

    public PercolateQueryBuilder(String field, List<BytesReference> documents, XContentType documentXContentType) {
        this(field, null, documents, documentXContentType);
    }

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, List<BytesReference> documents, XContentType documentXContentType) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (documents == null) {
            throw new IllegalArgumentException("[document] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.documents = documents;
        this.documentXContentType = Objects.requireNonNull(documentXContentType);
        this.indexedDocumentIndex = null;
        this.indexedDocumentType = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
        this.documentSupplier = null;
    }

    protected PercolateQueryBuilder(String field, String documentType, Supplier<BytesReference> documentSupplier) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.documents = Collections.emptyList();
        this.documentXContentType = null;
        this.documentSupplier = documentSupplier;
        this.indexedDocumentIndex = null;
        this.indexedDocumentType = null;
        this.indexedDocumentId = null;
        this.indexedDocumentRouting = null;
        this.indexedDocumentPreference = null;
        this.indexedDocumentVersion = null;
    }

    public PercolateQueryBuilder(String field, String indexedDocumentIndex, String indexedDocumentType, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        this(field, null, indexedDocumentIndex, indexedDocumentType, indexedDocumentId, indexedDocumentRouting, indexedDocumentPreference, indexedDocumentVersion);
    }

    @Deprecated
    public PercolateQueryBuilder(String field, String documentType, String indexedDocumentIndex, String indexedDocumentType, String indexedDocumentId, String indexedDocumentRouting, String indexedDocumentPreference, Long indexedDocumentVersion) {
        if (field == null) {
            throw new IllegalArgumentException("[field] is a required argument");
        }
        if (indexedDocumentIndex == null) {
            throw new IllegalArgumentException("[index] is a required argument");
        }
        if (indexedDocumentId == null) {
            throw new IllegalArgumentException("[id] is a required argument");
        }
        this.field = field;
        this.documentType = documentType;
        this.indexedDocumentIndex = indexedDocumentIndex;
        this.indexedDocumentType = indexedDocumentType;
        this.indexedDocumentId = indexedDocumentId;
        this.indexedDocumentRouting = indexedDocumentRouting;
        this.indexedDocumentPreference = indexedDocumentPreference;
        this.indexedDocumentVersion = indexedDocumentVersion;
        this.documents = Collections.emptyList();
        this.documentXContentType = null;
        this.documentSupplier = null;
    }

    PercolateQueryBuilder(StreamInput in) throws IOException {
        super(in);
        BytesReference document;
        this.field = in.readString();
        if (in.getVersion().onOrAfter((Version)LegacyESVersion.V_6_1_0)) {
            this.name = in.readOptionalString();
        }
        this.documentType = in.getVersion().before((Version)LegacyESVersion.V_6_0_0_beta1) ? in.readString() : in.readOptionalString();
        this.indexedDocumentIndex = in.readOptionalString();
        this.indexedDocumentType = in.readOptionalString();
        this.indexedDocumentId = in.readOptionalString();
        this.indexedDocumentRouting = in.readOptionalString();
        this.indexedDocumentPreference = in.readOptionalString();
        this.indexedDocumentVersion = in.readBoolean() ? Long.valueOf(in.readVLong()) : null;
        this.documents = in.getVersion().onOrAfter((Version)LegacyESVersion.V_6_1_0) ? in.readList(StreamInput::readBytesReference) : ((document = in.readOptionalBytesReference()) != null ? Collections.singletonList(document) : Collections.emptyList());
        this.documentXContentType = !this.documents.isEmpty() ? (XContentType)in.readEnum(XContentType.class) : null;
        this.documentSupplier = null;
    }

    public PercolateQueryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        if (this.documentSupplier != null) {
            throw new IllegalStateException("supplier must be null, can't serialize suppliers, missing a rewriteAndFetch?");
        }
        out.writeString(this.field);
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_6_1_0)) {
            out.writeOptionalString(this.name);
        }
        if (out.getVersion().before((Version)LegacyESVersion.V_6_0_0_beta1)) {
            out.writeString(this.documentType);
        } else {
            out.writeOptionalString(this.documentType);
        }
        out.writeOptionalString(this.indexedDocumentIndex);
        out.writeOptionalString(this.indexedDocumentType);
        out.writeOptionalString(this.indexedDocumentId);
        out.writeOptionalString(this.indexedDocumentRouting);
        out.writeOptionalString(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            out.writeBoolean(true);
            out.writeVLong(this.indexedDocumentVersion.longValue());
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter((Version)LegacyESVersion.V_6_1_0)) {
            out.writeVInt(this.documents.size());
            for (BytesReference document : this.documents) {
                out.writeBytesReference(document);
            }
        } else {
            if (this.documents.size() > 1) {
                throw new IllegalArgumentException("Nodes prior to 6.1.0 cannot accept multiple documents");
            }
            BytesReference doc = this.documents.isEmpty() ? null : this.documents.iterator().next();
            out.writeOptionalBytesReference(doc);
        }
        if (!this.documents.isEmpty()) {
            out.writeEnum((Enum)this.documentXContentType);
        }
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(DOCUMENT_TYPE_FIELD.getPreferredName(), this.documentType);
        builder.field(QUERY_FIELD.getPreferredName(), this.field);
        if (this.name != null) {
            builder.field(NAME_FIELD.getPreferredName(), this.name);
        }
        if (!this.documents.isEmpty()) {
            builder.startArray(DOCUMENTS_FIELD.getPreferredName());
            for (BytesReference document : this.documents) {
                XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)document);
                try {
                    parser.nextToken();
                    builder.generator().copyCurrentStructure(parser);
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            builder.endArray();
        }
        if (this.indexedDocumentIndex != null || this.indexedDocumentType != null || this.indexedDocumentId != null) {
            if (this.indexedDocumentIndex != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_INDEX.getPreferredName(), this.indexedDocumentIndex);
            }
            if (this.indexedDocumentType != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_TYPE.getPreferredName(), this.indexedDocumentType);
            }
            if (this.indexedDocumentId != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ID.getPreferredName(), this.indexedDocumentId);
            }
            if (this.indexedDocumentRouting != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_ROUTING.getPreferredName(), this.indexedDocumentRouting);
            }
            if (this.indexedDocumentPreference != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_PREFERENCE.getPreferredName(), this.indexedDocumentPreference);
            }
            if (this.indexedDocumentVersion != null) {
                builder.field(INDEXED_DOCUMENT_FIELD_VERSION.getPreferredName(), this.indexedDocumentVersion);
            }
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    private static BytesReference parseDocument(XContentParser parser) throws IOException {
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.copyCurrentStructure(parser);
            builder.flush();
            BytesReference bytesReference = BytesReference.bytes((XContentBuilder)builder);
            return bytesReference;
        }
    }

    public static PercolateQueryBuilder fromXContent(XContentParser parser) throws IOException {
        return (PercolateQueryBuilder)((Object)PARSER.parse(parser, null));
    }

    protected boolean doEquals(PercolateQueryBuilder other) {
        return Objects.equals(this.field, other.field) && Objects.equals(this.documentType, other.documentType) && Objects.equals(this.documents, other.documents) && Objects.equals(this.indexedDocumentIndex, other.indexedDocumentIndex) && Objects.equals(this.indexedDocumentType, other.indexedDocumentType) && Objects.equals(this.documentSupplier, other.documentSupplier) && Objects.equals(this.indexedDocumentId, other.indexedDocumentId);
    }

    protected int doHashCode() {
        return Objects.hash(this.field, this.documentType, this.documents, this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId, this.documentSupplier);
    }

    public String getWriteableName() {
        return NAME;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) {
        GetRequest getRequest;
        if (!this.documents.isEmpty()) {
            return this;
        }
        if (this.documentSupplier != null) {
            BytesReference source = this.documentSupplier.get();
            if (source == null) {
                return this;
            }
            PercolateQueryBuilder rewritten = new PercolateQueryBuilder(this.field, this.documentType, Collections.singletonList(source), XContentHelper.xContentType((BytesReference)source));
            if (this.name != null) {
                rewritten.setName(this.name);
            }
            return rewritten;
        }
        if (this.indexedDocumentType != null) {
            deprecationLogger.deprecate("percolate_with_type", TYPE_DEPRECATION_MESSAGE, new Object[0]);
            getRequest = new GetRequest(this.indexedDocumentIndex, this.indexedDocumentType, this.indexedDocumentId);
        } else {
            getRequest = new GetRequest(this.indexedDocumentIndex, this.indexedDocumentId);
        }
        getRequest.preference("_local");
        getRequest.routing(this.indexedDocumentRouting);
        getRequest.preference(this.indexedDocumentPreference);
        if (this.indexedDocumentVersion != null) {
            getRequest.version(this.indexedDocumentVersion.longValue());
        }
        SetOnce documentSupplier = new SetOnce();
        queryShardContext.registerAsyncAction((client, listener) -> client.get(getRequest, ActionListener.wrap(getResponse -> {
            if (!getResponse.isExists()) {
                throw new ResourceNotFoundException("indexed document [{}{}/{}] couldn't be found", new Object[]{this.indexedDocumentIndex, this.indexedDocumentType == null ? "" : "/" + this.indexedDocumentType, this.indexedDocumentId});
            }
            if (getResponse.isSourceEmpty()) {
                throw new IllegalArgumentException("indexed document [" + this.indexedDocumentIndex + (this.indexedDocumentType == null ? "" : "/" + this.indexedDocumentType) + "/" + this.indexedDocumentId + "] source disabled");
            }
            documentSupplier.set((Object)getResponse.getSourceAsBytesRef());
            listener.onResponse(null);
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))));
        PercolateQueryBuilder rewritten = new PercolateQueryBuilder(this.field, this.documentType, () -> ((SetOnce)documentSupplier).get());
        if (this.name != null) {
            rewritten.setName(this.name);
        }
        return rewritten;
    }

    protected Query doToQuery(final QueryShardContext context) throws IOException {
        boolean excludeNestedDocuments;
        IndexSearcher docSearcher;
        if (!context.allowExpensiveQueries()) {
            throw new OpenSearchException("[percolate] queries cannot be executed when '" + SearchService.ALLOW_EXPENSIVE_QUERIES.getKey() + "' is set to false.", new Object[0]);
        }
        context.nowInMillis();
        if (this.indexedDocumentIndex != null || this.indexedDocumentId != null || this.documentSupplier != null) {
            throw new IllegalStateException("query builder must be rewritten first");
        }
        if (this.documents.isEmpty()) {
            throw new IllegalStateException("no document to percolate");
        }
        MappedFieldType fieldType = context.fieldMapper(this.field);
        if (fieldType == null) {
            throw new QueryShardException(context, "field [" + this.field + "] does not exist", new Object[0]);
        }
        if (!(fieldType instanceof PercolatorFieldMapper.PercolatorFieldType)) {
            throw new QueryShardException(context, "expected field [" + this.field + "] to be of type [percolator], but is of type [" + fieldType.typeName() + "]", new Object[0]);
        }
        ArrayList<ParsedDocument> docs = new ArrayList<ParsedDocument>();
        MapperService mapperService = context.getMapperService();
        String type = mapperService.documentMapper().type();
        if (this.documentType != null) {
            deprecationLogger.deprecate("percolate_with_document_type", DOCUMENT_TYPE_DEPRECATION_MESSAGE, new Object[0]);
            if (!this.documentType.equals(type)) {
                throw new IllegalArgumentException("specified document_type [" + this.documentType + "] is not equal to the actual type [" + type + "]");
            }
        }
        DocumentMapper docMapper = mapperService.documentMapper(type);
        for (BytesReference document : this.documents) {
            docs.add(docMapper.parse(new SourceToParse(context.index().getName(), type, "_temp_id", document, this.documentXContentType)));
        }
        final FieldNameAnalyzer fieldNameAnalyzer = (FieldNameAnalyzer)docMapper.mappers().indexAnalyzer();
        DelegatingAnalyzerWrapper analyzer = new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                Analyzer analyzer = (Analyzer)fieldNameAnalyzer.analyzers().get(fieldName);
                if (analyzer != null) {
                    return analyzer;
                }
                return context.getIndexAnalyzers().getDefaultIndexAnalyzer();
            }
        };
        if (docs.size() > 1 || ((ParsedDocument)docs.get(0)).docs().size() > 1) {
            assert (docs.size() != 1 || docMapper.hasNestedObjects());
            docSearcher = PercolateQueryBuilder.createMultiDocumentSearcher((Analyzer)analyzer, docs);
            excludeNestedDocuments = docMapper.hasNestedObjects() && docs.stream().map(ParsedDocument::docs).mapToInt(List::size).anyMatch(size -> size > 1);
        } else {
            MemoryIndex memoryIndex = MemoryIndex.fromDocument((Iterable)((ParsedDocument)docs.get(0)).rootDoc(), (Analyzer)analyzer, (boolean)true, (boolean)false);
            docSearcher = memoryIndex.createSearcher();
            docSearcher.setQueryCache(null);
            excludeNestedDocuments = false;
        }
        PercolatorFieldMapper.PercolatorFieldType pft = (PercolatorFieldMapper.PercolatorFieldType)fieldType;
        String name = this.name != null ? this.name : pft.name();
        QueryShardContext percolateShardContext = PercolateQueryBuilder.wrap(context);
        PercolatorFieldMapper.configureContext(percolateShardContext, pft.mapUnmappedFieldsAsText);
        PercolateQuery.QueryStore queryStore = PercolateQueryBuilder.createStore(pft.queryBuilderField, percolateShardContext);
        return pft.percolateQuery(name, queryStore, this.documents, docSearcher, excludeNestedDocuments, context.indexVersionCreated());
    }

    public String getField() {
        return this.field;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public List<BytesReference> getDocuments() {
        return this.documents;
    }

    XContentType getXContentType() {
        return this.documentXContentType;
    }

    public String getQueryName() {
        return this.name;
    }

    static IndexSearcher createMultiDocumentSearcher(Analyzer analyzer, Collection<ParsedDocument> docs) {
        IndexSearcher indexSearcher;
        ByteBuffersDirectory directory = new ByteBuffersDirectory();
        IndexWriter indexWriter = new IndexWriter((Directory)directory, new IndexWriterConfig(analyzer));
        try {
            Iterable iterable = () -> docs.stream().map(ParsedDocument::docs).flatMap(Collection::stream).iterator();
            indexWriter.addDocuments(iterable);
            DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)indexWriter);
            assert (directoryReader.leaves().size() == 1) : "Expected single leaf, but got [" + directoryReader.leaves().size() + "]";
            IndexSearcher slowSearcher = new IndexSearcher((IndexReader)directoryReader);
            slowSearcher.setQueryCache(null);
            indexSearcher = slowSearcher;
        }
        catch (Throwable throwable) {
            try {
                try {
                    indexWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OpenSearchException("Failed to create index for percolator with nested document ", (Throwable)e, new Object[0]);
            }
        }
        indexWriter.close();
        return indexSearcher;
    }

    static PercolateQuery.QueryStore createStore(MappedFieldType queryBuilderFieldType, QueryShardContext context) {
        Version indexVersion = context.indexVersionCreated();
        NamedWriteableRegistry registry = context.getWriteableRegistry();
        return ctx -> {
            LeafReader leafReader = ctx.reader();
            BinaryDocValues binaryDocValues = leafReader.getBinaryDocValues(queryBuilderFieldType.name());
            if (binaryDocValues == null) {
                return docId -> null;
            }
            if (indexVersion.onOrAfter((Version)LegacyESVersion.V_6_0_0_beta2)) {
                return docId -> {
                    if (binaryDocValues.advanceExact(docId.intValue())) {
                        BytesRef qbSource = binaryDocValues.binaryValue();
                        try (ByteArrayInputStream in = new ByteArrayInputStream(qbSource.bytes, qbSource.offset, qbSource.length);){
                            Query query;
                            try (NamedWriteableAwareStreamInput input = new NamedWriteableAwareStreamInput((StreamInput)new InputStreamStreamInput((InputStream)in, (long)qbSource.length), registry);){
                                input.setVersion(indexVersion);
                                int numValues = input.readVInt();
                                assert (numValues == 1);
                                int valueLength = input.readVInt();
                                assert (valueLength > 0);
                                QueryBuilder queryBuilder = (QueryBuilder)input.readNamedWriteable(QueryBuilder.class);
                                assert (((InputStream)in).read() == -1);
                                queryBuilder = (QueryBuilder)Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)context);
                                query = queryBuilder.toQuery(context);
                            }
                            return query;
                        }
                    }
                    return null;
                };
            }
            return docId -> {
                if (binaryDocValues.advanceExact(docId.intValue())) {
                    BytesRef qbSource = binaryDocValues.binaryValue();
                    if (qbSource.length > 0) {
                        XContent xContent = PercolatorFieldMapper.QUERY_BUILDER_CONTENT_TYPE.xContent();
                        try (XContentParser sourceParser = xContent.createParser(context.getXContentRegistry(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, qbSource.bytes, qbSource.offset, qbSource.length);){
                            QueryBuilder queryBuilder = PercolatorFieldMapper.parseQueryBuilder(sourceParser, sourceParser.getTokenLocation());
                            queryBuilder = (QueryBuilder)Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)context);
                            Query query = queryBuilder.toQuery(context);
                            return query;
                        }
                    }
                    return null;
                }
                return null;
            };
        };
    }

    static QueryShardContext wrap(final QueryShardContext shardContext) {
        return new QueryShardContext(shardContext){

            public IndexReader getIndexReader() {
                return null;
            }

            public BitSetProducer bitsetFilter(Query query) {
                return context -> {
                    IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
                    IndexSearcher searcher = new IndexSearcher(topLevelContext);
                    searcher.setQueryCache(null);
                    Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
                    Scorer s = weight.scorer(context);
                    if (s != null) {
                        return new BitDocIdSet(BitSet.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc())).bits();
                    }
                    return null;
                };
            }

            public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
                IndexFieldData.Builder builder = fieldType.fielddataBuilder(shardContext.getFullyQualifiedIndex().getName(), () -> ((QueryShardContext)shardContext).lookup());
                IndexFieldDataCache.None cache = new IndexFieldDataCache.None();
                NoneCircuitBreakerService circuitBreaker = new NoneCircuitBreakerService();
                return (IFD)builder.build((IndexFieldDataCache)cache, (CircuitBreakerService)circuitBreaker);
            }
        };
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), QUERY_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PercolateQueryBuilder.parseDocument(p), DOCUMENT_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PercolateQueryBuilder.parseDocument(p), DOCUMENTS_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_INDEX);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_ROUTING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_PREFERENCE);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_VERSION);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), INDEXED_DOCUMENT_FIELD_TYPE);
        PARSER.declareStringOrNull(ConstructingObjectParser.optionalConstructorArg(), DOCUMENT_TYPE_FIELD);
        PARSER.declareString(PercolateQueryBuilder::setName, NAME_FIELD);
        PARSER.declareString(AbstractQueryBuilder::queryName, AbstractQueryBuilder.NAME_FIELD);
        PARSER.declareFloat(AbstractQueryBuilder::boost, BOOST_FIELD);
        PARSER.declareRequiredFieldSet(new String[]{DOCUMENT_FIELD.getPreferredName(), DOCUMENTS_FIELD.getPreferredName(), INDEXED_DOCUMENT_FIELD_ID.getPreferredName()});
        PARSER.declareExclusiveFieldSet(new String[]{DOCUMENT_FIELD.getPreferredName(), DOCUMENTS_FIELD.getPreferredName(), INDEXED_DOCUMENT_FIELD_ID.getPreferredName()});
    }
}

