/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent;

import java.util.Locale;
import java.util.Map;
import org.opensearch.common.xcontent.cbor.CborXContent;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.common.xcontent.smile.SmileXContent;
import org.opensearch.common.xcontent.yaml.YamlXContent;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeParser;
import org.opensearch.core.xcontent.XContent;

public enum XContentType implements MediaType
{
    JSON(0){

        public String mediaTypeWithoutParameters() {
            return "application/json";
        }

        public String mediaType() {
            return "application/json; charset=UTF-8";
        }

        public String subtype() {
            return "json";
        }

        public XContent xContent() {
            return JsonXContent.jsonXContent;
        }
    }
    ,
    SMILE(1){

        public String mediaTypeWithoutParameters() {
            return "application/smile";
        }

        public String subtype() {
            return "smile";
        }

        public XContent xContent() {
            return SmileXContent.smileXContent;
        }
    }
    ,
    YAML(2){

        public String mediaTypeWithoutParameters() {
            return "application/yaml";
        }

        public String subtype() {
            return "yaml";
        }

        public XContent xContent() {
            return YamlXContent.yamlXContent;
        }
    }
    ,
    CBOR(3){

        public String mediaTypeWithoutParameters() {
            return "application/cbor";
        }

        public String subtype() {
            return "cbor";
        }

        public XContent xContent() {
            return CborXContent.cborXContent;
        }
    };

    private static final MediaTypeParser<XContentType> MEDIA_TYPE_PARSER;
    private int index;

    public static MediaTypeParser getMediaTypeParser() {
        return MEDIA_TYPE_PARSER;
    }

    public static XContentType fromFormat(String mediaType) {
        return (XContentType)MEDIA_TYPE_PARSER.fromFormat(mediaType);
    }

    public static XContentType fromMediaType(String mediaTypeHeaderValue) {
        mediaTypeHeaderValue = XContentType.removeVersionInMediaType(mediaTypeHeaderValue);
        return (XContentType)MEDIA_TYPE_PARSER.fromMediaType(mediaTypeHeaderValue);
    }

    private static String removeVersionInMediaType(String mediaType) {
        if (mediaType != null && (mediaType = mediaType.toLowerCase(Locale.ROOT)).contains("vnd.opensearch")) {
            return mediaType.replaceAll("vnd.opensearch\\+", "").replaceAll("\\s*;\\s*compatible-with=\\d+", "");
        }
        return mediaType;
    }

    private XContentType(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public String type() {
        return "application";
    }

    public String format() {
        return this.subtype();
    }

    public static XContentType fromMediaType(MediaType mediaType) {
        if (mediaType instanceof XContentType) {
            return (XContentType)mediaType;
        }
        return mediaType != null ? (XContentType)MEDIA_TYPE_PARSER.fromMediaType(mediaType.mediaTypeWithoutParameters()) : null;
    }

    static {
        MEDIA_TYPE_PARSER = new MediaTypeParser((MediaType[])XContentType.values(), Map.of("application/*", JSON, "application/x-ndjson", JSON));
    }
}

