/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.nio;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opensearch.nio.ChannelFactory;
import org.opensearch.nio.EventHandler;
import org.opensearch.nio.NioGroup;
import org.opensearch.nio.NioSelector;
import org.opensearch.nio.NioServerSocketChannel;
import org.opensearch.nio.NioSocketChannel;
import org.opensearch.nio.RoundRobinSupplier;
import org.opensearch.nio.utils.ExceptionsHelper;

public class NioSelectorGroup
implements NioGroup {
    private final List<NioSelector> dedicatedAcceptors;
    private final RoundRobinSupplier<NioSelector> acceptorSupplier;
    private final List<NioSelector> selectors;
    private final RoundRobinSupplier<NioSelector> selectorSupplier;
    private final AtomicBoolean isOpen = new AtomicBoolean(true);

    public NioSelectorGroup(ThreadFactory threadFactory, int selectorCount, Function<Supplier<NioSelector>, EventHandler> eventHandlerFunction) throws IOException {
        this(null, 0, threadFactory, selectorCount, eventHandlerFunction);
    }

    public NioSelectorGroup(ThreadFactory acceptorThreadFactory, int dedicatedAcceptorCount, ThreadFactory selectorThreadFactory, int selectorCount, Function<Supplier<NioSelector>, EventHandler> eventHandlerFunction) throws IOException {
        this.dedicatedAcceptors = new ArrayList<NioSelector>(dedicatedAcceptorCount);
        this.selectors = new ArrayList<NioSelector>(selectorCount);
        try {
            ArrayList suppliersToSet = new ArrayList(selectorCount);
            for (int i = 0; i < selectorCount; ++i) {
                RoundRobinSupplier roundRobinSupplier = new RoundRobinSupplier();
                suppliersToSet.add(roundRobinSupplier);
                NioSelector selector = new NioSelector(eventHandlerFunction.apply(roundRobinSupplier));
                this.selectors.add(selector);
            }
            for (RoundRobinSupplier roundRobinSupplier : suppliersToSet) {
                roundRobinSupplier.setSelectors(this.selectors.toArray(new NioSelector[0]));
                assert (roundRobinSupplier.count() == this.selectors.size()) : "Supplier should have same count as selector list.";
            }
            for (int i = 0; i < dedicatedAcceptorCount; ++i) {
                RoundRobinSupplier<NioSelector> roundRobinSupplier = new RoundRobinSupplier<NioSelector>(this.selectors.toArray(new NioSelector[0]));
                NioSelector acceptor = new NioSelector(eventHandlerFunction.apply(roundRobinSupplier));
                this.dedicatedAcceptors.add(acceptor);
            }
            this.acceptorSupplier = dedicatedAcceptorCount != 0 ? new RoundRobinSupplier<NioSelector>(this.dedicatedAcceptors.toArray(new NioSelector[0])) : new RoundRobinSupplier<NioSelector>(this.selectors.toArray(new NioSelector[0]));
            this.selectorSupplier = new RoundRobinSupplier<NioSelector>(this.selectors.toArray(new NioSelector[0]));
            assert (selectorCount == this.selectors.size()) : "We need to have created all the selectors at this point.";
            assert (dedicatedAcceptorCount == this.dedicatedAcceptors.size()) : "We need to have created all the acceptors at this point.";
            NioSelectorGroup.startSelectors(this.selectors, selectorThreadFactory);
            NioSelectorGroup.startSelectors(this.dedicatedAcceptors, acceptorThreadFactory);
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
    }

    @Override
    public <S extends NioServerSocketChannel> S bindServerChannel(InetSocketAddress address, ChannelFactory<S, ?> factory) throws IOException {
        this.ensureOpen();
        return factory.openNioServerSocketChannel(address, this.acceptorSupplier);
    }

    @Override
    public <S extends NioSocketChannel> S openChannel(InetSocketAddress address, ChannelFactory<?, S> factory) throws IOException {
        this.ensureOpen();
        return factory.openNioChannel(address, this.selectorSupplier);
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen.compareAndSet(true, false)) {
            List toClose = Stream.concat(this.dedicatedAcceptors.stream(), this.selectors.stream()).collect(Collectors.toList());
            ArrayList<IOException> closingExceptions = new ArrayList<IOException>();
            for (NioSelector selector : toClose) {
                try {
                    selector.close();
                }
                catch (IOException e) {
                    closingExceptions.add(e);
                }
            }
            ExceptionsHelper.rethrowAndSuppress(closingExceptions);
        }
    }

    private static void startSelectors(Iterable<NioSelector> selectors, ThreadFactory threadFactory) {
        for (NioSelector selector : selectors) {
            if (selector.isRunning()) continue;
            threadFactory.newThread(selector::runLoop).start();
            try {
                selector.isRunningFuture().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Interrupted while waiting for selector to start.", e);
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                Objects.requireNonNull(throwable);
                Throwable throwable2 = throwable;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RuntimeException.class}, (Object)throwable2, n)) {
                    case 0: {
                        RuntimeException re = (RuntimeException)throwable2;
                        throw re;
                    }
                }
                throw new RuntimeException("Exception during selector start.", e);
            }
        }
    }

    private void ensureOpen() {
        if (!this.isOpen.get()) {
            throw new IllegalStateException("NioGroup is closed.");
        }
    }
}

