/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.nio;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.function.Supplier;
import org.opensearch.nio.Config;
import org.opensearch.nio.NioChannel;
import org.opensearch.nio.NioSelector;
import org.opensearch.nio.NioServerSocketChannel;
import org.opensearch.nio.NioSocketChannel;

public abstract class ChannelFactory<ServerSocket extends NioServerSocketChannel, Socket extends NioSocketChannel> {
    private final boolean tcpNoDelay;
    private final boolean tcpKeepAlive;
    private final int tcpKeepIdle;
    private final int tcpKeepInterval;
    private final int tcpKeepCount;
    private final boolean tcpReuseAddress;
    private final int tcpSendBufferSize;
    private final int tcpReceiveBufferSize;
    private final RawChannelFactory rawChannelFactory;

    protected ChannelFactory(boolean tcpNoDelay, boolean tcpKeepAlive, int tcpKeepIdle, int tcpKeepInterval, int tcpKeepCount, boolean tcpReuseAddress, int tcpSendBufferSize, int tcpReceiveBufferSize) {
        this(tcpNoDelay, tcpKeepAlive, tcpKeepIdle, tcpKeepInterval, tcpKeepCount, tcpReuseAddress, tcpSendBufferSize, tcpReceiveBufferSize, new RawChannelFactory());
    }

    protected ChannelFactory(boolean tcpNoDelay, boolean tcpKeepAlive, int tcpKeepIdle, int tcpKeepInterval, int tcpKeepCount, boolean tcpReuseAddress, int tcpSendBufferSize, int tcpReceiveBufferSize, RawChannelFactory rawChannelFactory) {
        this.tcpNoDelay = tcpNoDelay;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpKeepIdle = tcpKeepIdle;
        this.tcpKeepInterval = tcpKeepInterval;
        this.tcpKeepCount = tcpKeepCount;
        this.tcpReuseAddress = tcpReuseAddress;
        this.tcpSendBufferSize = tcpSendBufferSize;
        this.tcpReceiveBufferSize = tcpReceiveBufferSize;
        this.rawChannelFactory = rawChannelFactory;
    }

    public Socket openNioChannel(InetSocketAddress remoteAddress, Supplier<NioSelector> supplier) throws IOException {
        SocketChannel rawChannel = this.rawChannelFactory.openNioChannel();
        this.setNonBlocking(rawChannel);
        NioSelector selector = supplier.get();
        Socket channel = this.internalCreateChannel(selector, rawChannel, this.createSocketConfig(remoteAddress, false));
        this.scheduleChannel(channel, selector);
        return channel;
    }

    public Socket acceptNioChannel(SocketChannel rawChannel, Supplier<NioSelector> supplier) throws IOException {
        this.setNonBlocking(rawChannel);
        NioSelector selector = supplier.get();
        InetSocketAddress remoteAddress = this.getRemoteAddress(rawChannel);
        Socket channel = this.internalCreateChannel(selector, rawChannel, this.createSocketConfig(remoteAddress, true));
        this.scheduleChannel(channel, selector);
        return channel;
    }

    public ServerSocket openNioServerSocketChannel(InetSocketAddress localAddress, Supplier<NioSelector> supplier) throws IOException {
        ServerSocketChannel rawChannel = this.rawChannelFactory.openNioServerSocketChannel();
        this.setNonBlocking(rawChannel);
        NioSelector selector = supplier.get();
        Config.ServerSocket config = new Config.ServerSocket(this.tcpReuseAddress, localAddress);
        ServerSocket serverChannel = this.internalCreateServerChannel(selector, rawChannel, config);
        this.scheduleServerChannel(serverChannel, selector);
        return serverChannel;
    }

    public abstract Socket createChannel(NioSelector var1, SocketChannel var2, Config.Socket var3) throws IOException;

    public abstract ServerSocket createServerChannel(NioSelector var1, ServerSocketChannel var2, Config.ServerSocket var3) throws IOException;

    protected InetSocketAddress getRemoteAddress(SocketChannel rawChannel) throws IOException {
        InetSocketAddress remoteAddress = (InetSocketAddress)rawChannel.socket().getRemoteSocketAddress();
        if (remoteAddress == null) {
            throw new IOException("Accepted socket does not have remote address");
        }
        return remoteAddress;
    }

    private Socket internalCreateChannel(NioSelector selector, SocketChannel rawChannel, Config.Socket config) throws IOException {
        try {
            Socket channel = this.createChannel(selector, rawChannel, config);
            assert (((NioSocketChannel)channel).getContext() != null) : "channel context should have been set on channel";
            return channel;
        }
        catch (UncheckedIOException e) {
            IOException cause = e.getCause();
            ChannelFactory.closeRawChannel(rawChannel, cause);
            throw cause;
        }
        catch (Exception e) {
            ChannelFactory.closeRawChannel(rawChannel, e);
            throw e;
        }
    }

    private ServerSocket internalCreateServerChannel(NioSelector selector, ServerSocketChannel rawChannel, Config.ServerSocket config) throws IOException {
        try {
            return this.createServerChannel(selector, rawChannel, config);
        }
        catch (Exception e) {
            ChannelFactory.closeRawChannel(rawChannel, e);
            throw e;
        }
    }

    private void scheduleChannel(Socket channel, NioSelector selector) {
        try {
            selector.scheduleForRegistration((NioChannel)channel);
        }
        catch (IllegalStateException e) {
            ChannelFactory.closeRawChannel(((NioSocketChannel)channel).getRawChannel(), e);
            throw e;
        }
    }

    private void scheduleServerChannel(ServerSocket channel, NioSelector selector) {
        try {
            selector.scheduleForRegistration((NioChannel)channel);
        }
        catch (IllegalStateException e) {
            ChannelFactory.closeRawChannel(((NioServerSocketChannel)channel).getRawChannel(), e);
            throw e;
        }
    }

    private void setNonBlocking(AbstractSelectableChannel rawChannel) throws IOException {
        try {
            rawChannel.configureBlocking(false);
        }
        catch (IOException e) {
            ChannelFactory.closeRawChannel(rawChannel, e);
            throw e;
        }
    }

    private static void closeRawChannel(Closeable c, Exception e) {
        try {
            c.close();
        }
        catch (IOException closeException) {
            e.addSuppressed(closeException);
        }
    }

    private Config.Socket createSocketConfig(InetSocketAddress remoteAddress, boolean isAccepted) {
        return new Config.Socket(this.tcpNoDelay, this.tcpKeepAlive, this.tcpKeepIdle, this.tcpKeepInterval, this.tcpKeepCount, this.tcpReuseAddress, this.tcpSendBufferSize, this.tcpReceiveBufferSize, remoteAddress, isAccepted);
    }

    public static class RawChannelFactory {
        SocketChannel openNioChannel() throws IOException {
            return SocketChannel.open();
        }

        ServerSocketChannel openNioServerSocketChannel() throws IOException {
            return ServerSocketChannel.open();
        }
    }
}

