/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.nio;

import java.util.Comparator;
import java.util.PriorityQueue;

public class TaskScheduler {
    private final PriorityQueue<DelayedTask> tasks = new PriorityQueue<DelayedTask>(Comparator.comparingLong(rec$ -> DelayedTask.access$400((DelayedTask)rec$)));

    public Runnable scheduleAtRelativeTime(Runnable task, long relativeNanos) {
        DelayedTask delayedTask = new DelayedTask(relativeNanos, task);
        this.tasks.offer(delayedTask);
        return delayedTask;
    }

    public Runnable pollTask(long relativeNanos) {
        DelayedTask task;
        while ((task = this.tasks.peek()) != null) {
            if (relativeNanos - task.deadline >= 0L) {
                this.tasks.remove();
                if (task.cancelled) continue;
                return task.runnable;
            }
            return null;
        }
        return null;
    }

    long nanosUntilNextTask(long relativeNanos) {
        DelayedTask nextTask = this.tasks.peek();
        if (nextTask == null) {
            return Long.MAX_VALUE;
        }
        return Math.max(nextTask.deadline - relativeNanos, 0L);
    }

    private static class DelayedTask
    implements Runnable {
        private final long deadline;
        private final Runnable runnable;
        private boolean cancelled = false;

        private DelayedTask(long deadline, Runnable runnable) {
            this.deadline = deadline;
            this.runnable = runnable;
        }

        private long getDeadline() {
            return this.deadline;
        }

        @Override
        public void run() {
            this.cancelled = true;
        }
    }
}

