/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gradle.transform;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.gradle.api.logging.Logging;
import org.opensearch.gradle.transform.UnpackTransform;
import org.opensearch.gradle.util.PermissionUtils;

public abstract class SymbolicLinkPreservingUntarTransform
implements UnpackTransform {
    private static final Path CURRENT_DIR_PATH = Paths.get(".", new String[0]);

    @Override
    public void unpack(File tarFile, File targetDir) throws IOException {
        Logging.getLogger(SymbolicLinkPreservingUntarTransform.class).info("Unpacking " + tarFile.getName() + " using " + SymbolicLinkPreservingUntarTransform.class.getSimpleName() + ".");
        Function<String, Path> pathModifier = this.pathResolver();
        try (FileInputStream fis = new FileInputStream(tarFile);
             GzipCompressorInputStream gzip = new GzipCompressorInputStream((InputStream)fis);
             TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)gzip);){
            Path destinationPath = targetDir.toPath();
            TarArchiveEntry entry = tar.getNextTarEntry();
            while (entry != null) {
                Path relativePath = pathModifier.apply(entry.getName());
                if (relativePath == null || relativePath.getFileName().equals(CURRENT_DIR_PATH)) {
                    entry = tar.getNextTarEntry();
                    continue;
                }
                Path destination = destinationPath.resolve(relativePath);
                Path parent = destination.getParent();
                if (!Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                if (entry.isDirectory()) {
                    Files.createDirectory(destination, new FileAttribute[0]);
                } else if (entry.isSymbolicLink()) {
                    Files.createSymbolicLink(destination, Paths.get(entry.getLinkName(), new String[0]), new FileAttribute[0]);
                } else {
                    Files.createFile(destination, new FileAttribute[0]);
                    try (FileOutputStream fos = new FileOutputStream(destination.toFile());){
                        tar.transferTo((OutputStream)fos);
                    }
                }
                if (!entry.isSymbolicLink()) {
                    PermissionUtils.chmod(destination, entry.getMode());
                }
                entry = tar.getNextTarEntry();
            }
        }
    }
}

